/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.core.services.XMLAttribute;
import de.upb.pga3.panda2.core.services.XMLElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMLNode
extends XMLElement {
    public String tag;
    XMLNode parent = null;
    ArrayList<XMLNode> children = null;
    Map<String, XMLAttribute<?>> attributes = null;

    public XMLNode(String tag, String ns, XMLNode parent) {
        this(tag, ns, parent, true);
    }

    public XMLNode(String tag, String ns, XMLNode parent, boolean added) {
        super(ns, added);
        this.tag = tag;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public String getTag() {
        return this.tag;
    }

    public boolean addSiblingBefore(XMLNode sibling) {
        if (this.parent != null) {
            this.parent.addChild(sibling, this.parent.getChildren().indexOf(this));
            return true;
        }
        return false;
    }

    public boolean addSiblingAfter(XMLNode sibling) {
        if (this.parent != null) {
            this.parent.addChild(sibling, this.parent.getChildren().indexOf(this) + 1);
            return true;
        }
        return false;
    }

    public XMLNode addChild(XMLNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        return this;
    }

    public XMLNode addChild(XMLNode child, int index) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(index, child);
        return this;
    }

    public List<XMLNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return new ArrayList<XMLNode>(this.children);
    }

    public List<XMLNode> getChildrenWithTag(String tag) {
        if (this.children == null) {
            return Collections.emptyList();
        }
        ArrayList<XMLNode> children = new ArrayList<XMLNode>();
        for (XMLNode child : this.children) {
            if (!child.getTag().equals(tag)) continue;
            children.add(child);
        }
        return children;
    }

    public Map<String, XMLAttribute<?>> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return new HashMap(this.attributes);
    }

    public boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    public XMLAttribute<?> getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public void addAttribute(XMLAttribute<?> attr) {
        if (attr == null) {
            throw new NullPointerException("XMLAttribute is null");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attr.getName(), attr);
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public void setParent(XMLNode parent) {
        this.parent = parent;
    }
}

