/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.IntentFilter;
import de.upb.pga3.panda2.core.services.ARSCParser;
import de.upb.pga3.panda2.core.services.CertParser;
import de.upb.pga3.panda2.core.services.ManifestXMLParser;
import de.upb.pga3.panda2.core.services.XMLLayoutParser;
import de.upb.pga3.panda2.core.services.XMLParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class A3XMLParser
implements XMLParser {
    private static final A3XMLParser INSTANCE = new A3XMLParser();
    private ManifestXMLParser mManifestParser;
    private CertParser mCertificateParser;
    private XMLLayoutParser layoutParser;
    private ARSCParser arscParser;

    private A3XMLParser() {
    }

    public static XMLParser getInstance() {
        return INSTANCE;
    }

    @Override
    public void fetchData(String inAPKPath) {
        this.mManifestParser = new ManifestXMLParser(inAPKPath);
        this.mCertificateParser = new CertParser(inAPKPath);
        this.layoutParser = new XMLLayoutParser(A3XMLParser.getInstance().getManifestInformation().getPackage(), inAPKPath, A3XMLParser.getInstance().getLstActivities());
        this.arscParser = new ARSCParser();
        try {
            this.arscParser.parse(inAPKPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, String> getRequiredPermissions() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getRequiredPermissions();
        }
        return null;
    }

    @Override
    public String getFingerprint() {
        return this.mCertificateParser.getMd5Fingerprint();
    }

    @Override
    public ManifestInfo getManifestInformation() {
        if (this.mManifestParser != null) {
            ManifestInfo manifestinfo = this.mManifestParser.getManifestInfo();
            manifestinfo.setIntentFilters(this.getIntentFilters());
            return manifestinfo;
        }
        return null;
    }

    @Override
    public Map<String, String> getContentProviderURIs() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getContentProviderURIs();
        }
        return null;
    }

    @Override
    public List<IntentFilter> getIntentFilters() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getIntentFilters();
        }
        return null;
    }

    @Override
    public String getAppName() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getAppName();
        }
        return null;
    }

    @Override
    public List<String> getUsesPermission() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getUsesPermission();
        }
        return null;
    }

    @Override
    public List<String> getLstActivities() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getLstActivities();
        }
        return null;
    }

    @Override
    public List<String> getLstProviders() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getLstProviders();
        }
        return null;
    }

    @Override
    public List<String> getLstReceivers() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getLstReceivers();
        }
        return null;
    }

    @Override
    public List<String> getLstServices() {
        if (this.mManifestParser != null) {
            return this.mManifestParser.getLstServices();
        }
        return null;
    }

    @Override
    public XMLLayoutParser getLayoutParser() {
        return this.layoutParser;
    }

    @Override
    public ARSCParser getArscParser() {
        return this.arscParser;
    }
}

