/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.datastructures;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.datastructures.IntentFilter;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.IntentInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.util.Chain;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class EnhancedInput
implements Input {
    private final transient Map<Unit, Body> unitToBodyMap = new HashMap<Unit, Body>();
    private final Map<String, String> unitToPkgStrMap = new HashMap<String, String>();
    private final transient MultiMap<Object, Permission> permissionMap = new HashMultiMap<Object, Permission>();
    private final transient MultiMap<SootClass, String> androidComponents = new HashMultiMap<SootClass, String>();
    private final List<String> androidComponentsByName = new ArrayList<String>();
    private final transient List<Object> maybeMore = new ArrayList<Object>();
    private transient Map<String, Collection<IntentInformation>> intentMap = new HashMap<String, Collection<IntentInformation>>();
    private transient Scene scene;
    private final String appName;
    private ManifestInfo appManifestInfo;

    public EnhancedInput(String appName, ManifestInfo appManifestInfo) {
        this.appName = appName;
        this.appManifestInfo = appManifestInfo;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public void mapUnitToBody(Unit u, Body b) {
        this.unitToBodyMap.put(u, b);
    }

    public Body getBodyForUnit(Unit u) {
        return this.unitToBodyMap.get(u);
    }

    public void mapUnitByStrToPkgStr(String uStr, String pkgStr) {
        this.unitToPkgStrMap.put(uStr, pkgStr);
    }

    public String getPkgStrForUnit(Unit u) {
        return this.unitToPkgStrMap.get(u);
    }

    public void addPermission(Permission p) {
        this.addPermissionTo(this, p);
    }

    public void addPermissionTo(Object codeObject, Permission p) {
        if (codeObject instanceof Body) {
            this.permissionMap.put(((Body)codeObject).getMethod(), p);
        } else {
            this.permissionMap.put(codeObject, p);
        }
    }

    public void setAsAndroidComponent(SootClass c) {
        this.setAsAndroidComponent(c, new HashSet<String>());
    }

    public void setAsAndroidComponent(SootClass c, Set<String> contentProviderURLs) {
        if (this.scene.containsClass(c.getName())) {
            if (contentProviderURLs == null || contentProviderURLs.isEmpty()) {
                this.androidComponents.put(c, null);
            } else {
                this.androidComponents.putAll(c, contentProviderURLs);
            }
        } else {
            throw new IllegalArgumentException("The given class is not part of the Android App!");
        }
        this.androidComponentsByName.add(c.getName());
    }

    public boolean isAndroidComponent(SootClass c) {
        return this.androidComponents.containsKey(c);
    }

    public boolean isAndroidComponent(String className) {
        return this.androidComponentsByName.contains(className);
    }

    public Collection<SootClass> getAndroidComponents() {
        return Collections.unmodifiableCollection(this.androidComponents.keySet());
    }

    public String getAppName() {
        return this.appName;
    }

    public Collection<Permission> getPermissions(Object obj) {
        return this.permissionMap.get(obj);
    }

    public Collection<Permission> getPermissionsFor(Unit u) {
        return this.permissionMap.get(u);
    }

    public Collection<Permission> getPermissionsFor(SootMethod m) {
        return this.permissionMap.get(m);
    }

    public Collection<Permission> getPermissionsFor(Body b) {
        return this.permissionMap.get(b.getMethod());
    }

    public Collection<Permission> getPermissionsFor(SootField f) {
        return this.permissionMap.get(f);
    }

    public Collection<Permission> getPermissionsFor(SootClass c) {
        return this.permissionMap.get(c);
    }

    public Collection<Permission> getPermissions() {
        return this.permissionMap.get(this);
    }

    public SootClass[] getAppClasses() {
        Chain<SootClass> sootClasses = this.scene.getApplicationClasses();
        return sootClasses.toArray(new SootClass[0]);
    }

    public SootMethod[] getAppEntryPoints() {
        return this.scene.getEntryPoints().toArray(new SootMethod[0]);
    }

    public List<Object> getChildren(Object obj) {
        if (obj instanceof Unit) {
            return null;
        }
        if (obj instanceof SootMethod) {
            ArrayList<Object> tempLst = new ArrayList<Object>();
            if (!((SootMethod)obj).getDeclaringClass().isInterface()) {
                try {
                    tempLst.addAll(((SootMethod)obj).retrieveActiveBody().getUnits());
                    return tempLst;
                }
                catch (RuntimeException e) {
                    if (!e.getMessage().contains("No method source set for method")) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }
            return null;
        }
        if (obj instanceof Body) {
            ArrayList<Object> tempLst = new ArrayList<Object>();
            tempLst.addAll(((Body)obj).getUnits());
            return tempLst;
        }
        if (obj instanceof SootClass) {
            ArrayList<Object> tempLst = new ArrayList<Object>();
            tempLst.addAll(((SootClass)obj).getMethods());
            return tempLst;
        }
        if (obj instanceof EnhancedInput) {
            return new ArrayList<Object>(Arrays.asList(this.getAppClasses()));
        }
        return null;
    }

    public SootClass getComponentByName(String inComponentName) {
        for (SootClass component : this.getAndroidComponents()) {
            if (!component.getName().equals(inComponentName)) continue;
            return component;
        }
        return null;
    }

    public void addToMaybeMoreList(Object item) {
        this.maybeMore.add(item);
    }

    public List<Object> getMaybeMoreList() {
        return this.maybeMore;
    }

    public Map<String, Collection<IntentInformation>> getIntents() {
        return this.intentMap;
    }

    public Collection<IntentInformation> getIntent(String classNameOrActionString) {
        return this.intentMap.get(classNameOrActionString);
    }

    public void addIntent(IntentInformation inIntent) {
        String classNameOrActionString = inIntent.getClassNameOrActionString();
        Collection<IntentInformation> currentList = this.intentMap.get(classNameOrActionString);
        this.intentMap.remove(classNameOrActionString);
        if (currentList == null) {
            currentList = new ArrayList<IntentInformation>();
        }
        currentList.add(inIntent);
        this.intentMap.put(classNameOrActionString, currentList);
    }

    public void addIntents(Collection<IntentInformation> inIntents) {
        for (IntentInformation intent : inIntents) {
            String classNameOrActionString = intent.getClassNameOrActionString();
            Collection<IntentInformation> currentList = this.intentMap.get(classNameOrActionString);
            this.intentMap.remove(classNameOrActionString);
            if (currentList == null) {
                currentList = new ArrayList<IntentInformation>();
            }
            currentList.addAll(inIntents);
            this.intentMap.put(classNameOrActionString, currentList);
        }
    }

    public List<IntentFilter> getIntentFilters() {
        return this.appManifestInfo.getIntentFilters();
    }

    public void setIntentFilters(List<IntentFilter> intentFilters) {
        this.appManifestInfo.setIntentFilters(intentFilters);
    }

    public void setAppManifestInfo(ManifestInfo appManifestInfo) {
        this.appManifestInfo = appManifestInfo;
    }

    public ManifestInfo getAppManifestInfo() {
        return this.appManifestInfo;
    }

    public String toString() {
        int i = 0;
        String str = String.valueOf(i) + ": " + this.getAppName() + "\n";
        ++i;
        SootClass[] sootClassArray = this.getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass sc = sootClassArray[n2];
            str = String.valueOf(str) + i + ": " + "- " + sc.toString() + "\n";
            ++i;
            for (SootMethod sm : sc.getMethods()) {
                if (sc.isInterface() || sm.retrieveActiveBody() == null || !sm.isDeclared()) continue;
                str = String.valueOf(str) + i + ": " + " - " + sm.toString() + "\n";
                ++i;
                for (Unit u : sm.retrieveActiveBody().getUnits()) {
                    str = String.valueOf(str) + i + ": " + "  - " + u.toString() + "\n";
                    ++i;
                }
            }
            ++n2;
        }
        return str;
    }
}

