/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core;

import de.upb.pga3.panda2.core.AnalysisProcedure;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class Analysis {
    private final boolean aggregates;
    private AnalysisResult prevRes;
    private final Path apk;
    private final AnalysisProcedure ap;
    private List<AnalysisResult> subResults;

    public Analysis(Path apkFile, AnalysisResult prevRes, AnalysisProcedure aProc) {
        if (aProc == null) {
            throw new IllegalArgumentException("The AnalysisProcedure must not be null!");
        }
        this.prevRes = prevRes;
        this.apk = apkFile;
        this.ap = aProc;
        this.aggregates = apkFile == null;
    }

    public void provideSubResults(List<AnalysisResult> results) {
        this.subResults = results;
    }

    public boolean aggregates() {
        return this.aggregates;
    }

    public AnalysisResult doAnalysis() {
        if (this.aggregates) {
            if (this.subResults != null && this.subResults.size() > 0) {
                return this.ap.doAggregationAnalysis(this.subResults, this.prevRes);
            }
            throw new UnsupportedOperationException("A list of subresults has not been provided beforehand or given list is empty!");
        }
        if (this.apk != null && Files.exists(this.apk, new LinkOption[0]) && !Files.isDirectory(this.apk, new LinkOption[0])) {
            return this.ap.doInitialAnalysis(this.apk, this.prevRes);
        }
        throw new UnsupportedOperationException("An apk was not provided or the provided apk does not exist or is not a file!");
    }

    public AnalysisResult getPreviousAnalysisResult() {
        return this.prevRes;
    }

    public void setPreviousAnalysisResult(AnalysisResult prevResult) {
        this.prevRes = prevResult;
    }
}

