/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.core;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.AppIdentifier;
import de.upb.pga3.panda2.client.core.ConfigManager;
import de.upb.pga3.panda2.client.core.ResultLoader;
import de.upb.pga3.panda2.client.core.ResultStorer;
import de.upb.pga3.panda2.client.core.UserInput;
import de.upb.pga3.panda2.client.core.datastructures.LevelSpecificMode;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;
import de.upb.pga3.panda2.core.Analysis;
import de.upb.pga3.panda2.core.AnalysisFactory;
import de.upb.pga3.panda2.core.AnalysisRunner;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.DetailLevelLvl1;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2b.DetailLevelLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ExtraAnalysisInputLvl2b;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Client {
    static final Logger LOGGER = LogManager.getLogger(Client.class);
    private UserInput userInput = new UserInput();
    private AppIdentifier appIdentifier;
    private List<Analysis> analysisList;
    private AnalysisResult analysisResult;
    private ResultLoader resultLoader;
    private boolean isComparisonMode = false;

    public UserInput getUserInput() {
        return this.userInput;
    }

    public void setUserInput(UserInput userInput) {
        this.userInput = userInput;
    }

    public AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    public ResultLoader getResultLoader() {
        return this.resultLoader;
    }

    public boolean isComparisonMode() {
        return this.isComparisonMode;
    }

    public void setComparisonMode(boolean isComparisonMode) {
        this.isComparisonMode = isComparisonMode;
    }

    public UIMessage compareApp() {
        UIMessage comparisonUIMessage = null;
        try {
            UIMessage uiMessage = this.validateInput();
            if (uiMessage != null && !uiMessage.getType().equals((Object)UIMessageType.ERROR)) {
                this.appIdentifier = new AppIdentifier();
                comparisonUIMessage = this.userInput.getPreviousAnalysisResult() != null ? this.appIdentifier.compareAppWithPreviousResult(this.userInput.getInitialInputAPKFiles().get(0), this.userInput.getPreviousAnalysisResult()) : this.appIdentifier.compareAppWithPreviousResult(this.userInput.getInitialInputAPKFiles().get(0), this.userInput.getPreviousAnalysisResultFile());
            } else {
                comparisonUIMessage = new UIMessage(UIMessageType.ERROR, "Unable to validate the User Input");
            }
        }
        catch (Exception ex) {
            comparisonUIMessage = new UIMessage(UIMessageType.ERROR, ex.getMessage());
        }
        return comparisonUIMessage;
    }

    public UIMessage performAnalysis() {
        UIMessage uiMessage = null;
        try {
            boolean isValidate;
            if (!this.isComparisonMode()) {
                uiMessage = this.validateInput();
            }
            boolean bl = isValidate = uiMessage != null && !uiMessage.getType().equals((Object)UIMessageType.ERROR);
            if (isValidate || this.isComparisonMode) {
                this.createAnalysis();
                this.runAnalysis();
                uiMessage = this.analysisResult != null ? new UIMessage(UIMessageType.INFO, "Fetched the analysis result successfully") : new UIMessage(UIMessageType.ERROR, "Unable to fetch the analysis result");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.debug("Unexpected error during analysis: ", (Throwable)ex);
            uiMessage = new UIMessage(UIMessageType.ERROR, "Unable to fetch the analysis result");
        }
        return uiMessage;
    }

    public UIMessage saveResult() {
        return ResultStorer.storeResult(this.analysisResult, this.userInput.getFilePath());
    }

    public abstract String filterTextViewResult(DetailLevel var1, List<String> var2);

    public abstract String filterGraphicalViewResult(DetailLevel var1, List<String> var2);

    public String showUIMessages(UIMessage uiMessage) {
        String stringMessage = null;
        if (uiMessage != null) {
            stringMessage = uiMessage.getBody();
        }
        return stringMessage;
    }

    public String showMessages(Message resultMessage) {
        String stringMessage = null;
        if (resultMessage != null) {
            stringMessage = resultMessage.getBody();
        }
        return stringMessage;
    }

    private UIMessage validateInput() {
        UIMessage uiMessage = null;
        try {
            this.userInput.createAPKFilesForInitialInput();
            if (this.isComparisonMode) {
                this.userInput.createPreviousAnalysisResultFile();
                String fileExtension = Client.getFileExtension(this.userInput.getPreviousAnalysisResultFile());
                if (fileExtension.equalsIgnoreCase("pa2")) {
                    this.userInput.setPreviousAnalysisResult(this.loadPreviousAnalysisResult());
                }
            }
            if (AnalysisRegistry.getInstance().getName(this.userInput.getLevel()).equals("Permission Usage (Inter App - Level 2b)")) {
                this.userInput.createAPKFilesForNonNativeApps();
            }
            uiMessage = ConfigManager.validateInput(this.userInput);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            uiMessage = new UIMessage(UIMessageType.ERROR, ex.getMessage());
        }
        return uiMessage;
    }

    private AnalysisResult loadPreviousAnalysisResult() {
        return ResultLoader.loadPreviousAnalysisResult(this.userInput.getSelectedComparisonInput());
    }

    public void viewPreviousAnalysisResult() {
        this.analysisResult = ResultLoader.loadPreviousAnalysisResult(this.userInput.getFilePath());
    }

    private void createAnalysis() {
        AnalysisFactory analysisFactory;
        AnalysisResult previousAnalysisResult = this.userInput.getPreviousAnalysisResult();
        List<File> apkFiles = this.userInput.getInitialInputAPKFiles();
        File apkFile = apkFiles.get(0);
        File prevResultFile = this.userInput.getPreviousAnalysisResultFile();
        String name = AnalysisRegistry.getInstance().getName(this.userInput.getLevel());
        if (this.userInput.getLevelSpecificMode() != null) {
            ExtraAnalysisInputLvl2b extraInput = new ExtraAnalysisInputLvl2b(this.userInput.getLevelSpecificMode().equals((Object)LevelSpecificMode.ALL));
            analysisFactory = AnalysisRegistry.getInstance().getFactory(name, apkFile, previousAnalysisResult, prevResultFile, this.userInput.getNonNativeAPKFiles(), extraInput);
        } else {
            analysisFactory = AnalysisRegistry.getInstance().getFactory(name, apkFile, previousAnalysisResult, prevResultFile, this.userInput.getNonNativeAPKFiles(), null);
        }
        this.analysisList = analysisFactory.createAnalysis();
    }

    private void runAnalysis() {
        AnalysisRunner analysisRunner = new AnalysisRunner();
        this.analysisResult = analysisRunner.analyze(this.analysisList);
    }

    public List<String> getResultFilters() {
        return this.analysisResult.getFilters();
    }

    public List<String> getDetailLevels() {
        ArrayList<String> detailLevels = new ArrayList<String>();
        List<DetailLevel> detailLevelList = this.analysisResult.getDetailLevels();
        for (DetailLevel detailLevel : detailLevelList) {
            detailLevels.add(detailLevel.toString());
        }
        return detailLevels;
    }

    public DetailLevel getDefaultDetailLevel() {
        Enum detailLevel = null;
        detailLevel = this.analysisResult instanceof AnalysisResultLvl1 ? DetailLevelLvl1.APP : (this.analysisResult instanceof AnalysisResultLvl2a ? AnalysisResultLvl2a.DetailLevelLvl2a.RES_TO_RES : DetailLevelLvl2b.APP);
        return detailLevel;
    }

    public DetailLevel getDetailLevelFromString(String selectedDetailLevel) {
        Enum selectedDetailLvl = null;
        selectedDetailLvl = this.analysisResult instanceof AnalysisResultLvl1 ? DetailLevelLvl1.valueOf(selectedDetailLevel.toUpperCase()) : (this.analysisResult instanceof AnalysisResultLvl2a ? AnalysisResultLvl2a.DetailLevelLvl2a.valueOf(selectedDetailLevel.toUpperCase()) : DetailLevelLvl2b.valueOf(selectedDetailLevel.toUpperCase()));
        return selectedDetailLvl;
    }

    public List<Message> getMessages() {
        return this.analysisResult.getMessages();
    }

    public static void print(String msg) {
        System.out.println(msg);
    }

    private static String getFileExtension(File file) {
        String fName = file.getName();
        if (fName.lastIndexOf(".") != -1 && fName.lastIndexOf(".") != 0) {
            return fName.substring(fName.lastIndexOf(".") + 1);
        }
        return "";
    }
}

