/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Comparator;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.util.Assert;

public class OrderComparator
implements Comparator<Class<?>> {
    private static final Comparator<Class<?>> INSTANCE = new OrderComparator();

    public static Comparator<Class<?>> getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Class<?> lhs, Class<?> rhs) {
        Order lhsOrder = Assert.requireNonNull(lhs, "lhs").getAnnotation(Order.class);
        Order rhsOrder = Assert.requireNonNull(rhs, "rhs").getAnnotation(Order.class);
        if (lhsOrder == null && rhsOrder == null) {
            return 0;
        }
        if (rhsOrder == null) {
            return -1;
        }
        if (lhsOrder == null) {
            return 1;
        }
        return Integer.signum(rhsOrder.value() - lhsOrder.value());
    }
}

