/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.RouteInfo;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.DnsServerRepository;
import java.util.Arrays;

public class NetlinkTracker
extends BaseNetworkObserver {
    private static final boolean DBG;
    private final String TAG;
    private final Callback mCallback;
    private DnsServerRepository mDnsServerRepository;
    private final String mInterfaceName;
    private final LinkProperties mLinkProperties;

    public NetlinkTracker(String string2, Callback callback) {
        this.TAG = "NetlinkTracker/" + string2;
        this.mInterfaceName = string2;
        this.mCallback = callback;
        this.mLinkProperties = new LinkProperties();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
        this.mDnsServerRepository = new DnsServerRepository();
    }

    private void maybeLog(String string2, Object object) {
    }

    private void maybeLog(String string2, String string3, LinkAddress linkAddress) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addressRemoved(String string2, LinkAddress linkAddress) {
        if (!this.mInterfaceName.equals(string2)) return;
        this.maybeLog("addressRemoved", string2, linkAddress);
        // MONITORENTER : this
        boolean bl = this.mLinkProperties.removeLinkAddress(linkAddress);
        // MONITOREXIT : this
        if (!bl) return;
        this.mCallback.update();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addressUpdated(String string2, LinkAddress linkAddress) {
        if (!this.mInterfaceName.equals(string2)) return;
        this.maybeLog("addressUpdated", string2, linkAddress);
        // MONITORENTER : this
        boolean bl = this.mLinkProperties.addLinkAddress(linkAddress);
        // MONITOREXIT : this
        if (!bl) return;
        this.mCallback.update();
    }

    public void clearLinkProperties() {
        synchronized (this) {
            this.mDnsServerRepository = new DnsServerRepository();
            this.mLinkProperties.clear();
            this.mLinkProperties.setInterfaceName(this.mInterfaceName);
            return;
        }
    }

    public LinkProperties getLinkProperties() {
        synchronized (this) {
            LinkProperties linkProperties = new LinkProperties(this.mLinkProperties);
            return linkProperties;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void interfaceDnsServerInfo(String string2, long l, String[] stringArray) {
        if (this.mInterfaceName.equals(string2)) {
            this.maybeLog("interfaceDnsServerInfo", Arrays.toString(stringArray));
            if (this.mDnsServerRepository.addServers(l, stringArray)) {
                synchronized (this) {
                    this.mDnsServerRepository.setDnsServersOn(this.mLinkProperties);
                }
                this.mCallback.update();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void routeRemoved(RouteInfo routeInfo) {
        if (!this.mInterfaceName.equals(routeInfo.getInterface())) return;
        this.maybeLog("routeRemoved", routeInfo);
        // MONITORENTER : this
        boolean bl = this.mLinkProperties.removeRoute(routeInfo);
        // MONITOREXIT : this
        if (!bl) return;
        this.mCallback.update();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void routeUpdated(RouteInfo routeInfo) {
        if (!this.mInterfaceName.equals(routeInfo.getInterface())) return;
        this.maybeLog("routeUpdated", routeInfo);
        // MONITORENTER : this
        boolean bl = this.mLinkProperties.addRoute(routeInfo);
        // MONITOREXIT : this
        if (!bl) return;
        this.mCallback.update();
    }

    public static interface Callback {
        public void update();
    }
}

