/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.os.SystemProperties;
import android.util.Log;
import android.util.Slog;
import dalvik.system.SocketTagger;
import java.io.FileDescriptor;
import java.net.SocketException;

public final class NetworkManagementSocketTagger
extends SocketTagger {
    private static final boolean LOGD = false;
    public static final String PROP_QTAGUID_ENABLED = "net.qtaguid_enabled";
    private static final String TAG = "NetworkManagementSocketTagger";
    private static ThreadLocal<SocketTags> threadSocketTags = new ThreadLocal<SocketTags>(){

        @Override
        protected SocketTags initialValue() {
            return new SocketTags();
        }
    };

    public static int getThreadSocketStatsTag() {
        return NetworkManagementSocketTagger.threadSocketTags.get().statsTag;
    }

    public static void install() {
        SocketTagger.set((SocketTagger)new NetworkManagementSocketTagger());
    }

    public static int kernelToTag(String string2) {
        int n = string2.length();
        int n2 = 0;
        if (n > 10) {
            n2 = Long.decode(string2.substring(0, n - 8)).intValue();
        }
        return n2;
    }

    private static native int native_deleteTagData(int var0, int var1);

    private static native int native_setCounterSet(int var0, int var1);

    private static native int native_tagSocketFd(FileDescriptor var0, int var1, int var2);

    private static native int native_untagSocketFd(FileDescriptor var0);

    public static void resetKernelUidStats(int n) {
        int n2;
        if (SystemProperties.getBoolean(PROP_QTAGUID_ENABLED, false) && (n2 = NetworkManagementSocketTagger.native_deleteTagData(0, n)) < 0) {
            Slog.w(TAG, "problem clearing counters for uid " + n + " : errno " + n2);
        }
    }

    public static void setKernelCounterSet(int n, int n2) {
        int n3;
        if (SystemProperties.getBoolean(PROP_QTAGUID_ENABLED, false) && (n3 = NetworkManagementSocketTagger.native_setCounterSet(n2, n)) < 0) {
            Log.w(TAG, "setKernelCountSet(" + n + ", " + n2 + ") failed with errno " + n3);
        }
    }

    public static void setThreadSocketStatsTag(int n) {
        NetworkManagementSocketTagger.threadSocketTags.get().statsTag = n;
    }

    public static void setThreadSocketStatsUid(int n) {
        NetworkManagementSocketTagger.threadSocketTags.get().statsUid = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void tagSocketFd(FileDescriptor fileDescriptor, int n, int n2) {
        int n3;
        if (n == -1 && n2 == -1 || !SystemProperties.getBoolean(PROP_QTAGUID_ENABLED, false) || (n3 = NetworkManagementSocketTagger.native_tagSocketFd(fileDescriptor, n, n2)) >= 0) {
            return;
        }
        Log.i(TAG, "tagSocketFd(" + fileDescriptor.getInt$() + ", " + n + ", " + n2 + ") failed with errno" + n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void unTagSocketFd(FileDescriptor fileDescriptor) {
        int n;
        SocketTags socketTags = threadSocketTags.get();
        if (socketTags.statsTag == -1 && socketTags.statsUid == -1 || !SystemProperties.getBoolean(PROP_QTAGUID_ENABLED, false) || (n = NetworkManagementSocketTagger.native_untagSocketFd(fileDescriptor)) >= 0) {
            return;
        }
        Log.w(TAG, "untagSocket(" + fileDescriptor.getInt$() + ") failed with errno " + n);
    }

    public void tag(FileDescriptor fileDescriptor) throws SocketException {
        SocketTags socketTags = threadSocketTags.get();
        this.tagSocketFd(fileDescriptor, socketTags.statsTag, socketTags.statsUid);
    }

    public void untag(FileDescriptor fileDescriptor) throws SocketException {
        this.unTagSocketFd(fileDescriptor);
    }

    public static class SocketTags {
        public int statsTag = -1;
        public int statsUid = -1;
    }
}

