/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.FloatMath;
import android.util.Log;
import java.util.ArrayList;

public class PointCloud {
    private static final int INNER_POINTS = 8;
    private static final float MAX_POINT_SIZE = 4.0f;
    private static final float MIN_POINT_SIZE = 2.0f;
    private static final float PI = (float)Math.PI;
    private static final String TAG = "PointCloud";
    GlowManager glowManager;
    private float mCenterX;
    private float mCenterY;
    private Drawable mDrawable;
    private float mOuterRadius;
    private Paint mPaint;
    private ArrayList<Point> mPointCloud = new ArrayList();
    private float mScale = 1.0f;
    WaveManager waveManager = new WaveManager();

    public PointCloud(Drawable drawable2) {
        this.glowManager = new GlowManager();
        this.mPaint = new Paint();
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setColor(Color.rgb(255, 255, 255));
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mDrawable = drawable2;
        if (this.mDrawable != null) {
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        }
    }

    private static float hypot(float f, float f2) {
        return FloatMath.sqrt(f * f + f2 * f2);
    }

    private float interp(float f, float f2, float f3) {
        return f + f3 * (f2 - f);
    }

    private static float max(float f, float f2) {
        if (f > f2) {
            return f;
        }
        return f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        ArrayList<Point> arrayList = this.mPointCloud;
        canvas.save(1);
        canvas.scale(this.mScale, this.mScale, this.mCenterX, this.mCenterY);
        int n = 0;
        while (true) {
            if (n >= arrayList.size()) {
                canvas.restore();
                return;
            }
            Point point = arrayList.get(n);
            float f = this.interp(4.0f, 2.0f, point.radius / this.mOuterRadius);
            float f2 = point.x + this.mCenterX;
            float f3 = point.y + this.mCenterY;
            int n2 = this.getAlphaForPoint(point);
            if (n2 != 0) {
                if (this.mDrawable != null) {
                    canvas.save(1);
                    float f4 = 0.5f * (float)this.mDrawable.getIntrinsicWidth();
                    float f5 = 0.5f * (float)this.mDrawable.getIntrinsicHeight();
                    float f6 = f / 4.0f;
                    canvas.scale(f6, f6, f2, f3);
                    canvas.translate(f2 - f4, f3 - f5);
                    this.mDrawable.setAlpha(n2);
                    this.mDrawable.draw(canvas);
                    canvas.restore();
                } else {
                    this.mPaint.setAlpha(n2);
                    canvas.drawCircle(f2, f3, f, this.mPaint);
                }
            }
            ++n;
        }
    }

    public int getAlphaForPoint(Point point) {
        float f = PointCloud.hypot(this.glowManager.x - point.x, this.glowManager.y - point.y);
        float f2 = f - this.glowManager.radius;
        float f3 = f2 == 0.0f ? 0 : (f2 < 0.0f ? -1 : 1);
        float f4 = 0.0f;
        if (f3 < 0) {
            float f5 = FloatMath.cos(0.7853982f * f / this.glowManager.radius);
            f4 = this.glowManager.alpha * PointCloud.max(0.0f, (float)Math.pow(f5, 10.0));
        }
        float f6 = PointCloud.hypot(point.x, point.y);
        float f7 = f6 - 2.0f * this.waveManager.radius;
        float f8 = f7 == 0.0f ? 0 : (f7 < 0.0f ? -1 : 1);
        float f9 = 0.0f;
        if (f8 < 0) {
            float f10 = FloatMath.cos(1.5707964f * (f6 - this.waveManager.radius) / this.waveManager.radius);
            f9 = this.waveManager.alpha * PointCloud.max(0.0f, (float)Math.pow(f10, 6.0));
        }
        return (int)(255.0f * PointCloud.max(f4, f9));
    }

    public float getScale() {
        return this.mScale;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void makePointCloud(float f, float f2) {
        if (f == 0.0f) {
            Log.w(TAG, "Must specify an inner radius");
            return;
        }
        this.mOuterRadius = f2;
        this.mPointCloud.clear();
        float f3 = f2 - f;
        float f4 = (float)Math.PI * 2 * f / 8.0f;
        int n = Math.round(f3 / f4);
        float f5 = f3 / (float)n;
        float f6 = f;
        int n2 = 0;
        while (n2 <= n) {
            int n3 = (int)((float)Math.PI * 2 * f6 / f4);
            float f7 = 1.5707964f;
            float f8 = (float)Math.PI * 2 / (float)n3;
            for (int i = 0; i < n3; f7 += f8, ++i) {
                float f9 = f6 * FloatMath.cos(f7);
                float f10 = f6 * FloatMath.sin(f7);
                ArrayList<Point> arrayList = this.mPointCloud;
                Point point = new Point(f9, f10, f6);
                arrayList.add(point);
            }
            ++n2;
            f6 += f5;
        }
        return;
    }

    public void setCenter(float f, float f2) {
        this.mCenterX = f;
        this.mCenterY = f2;
    }

    public void setScale(float f) {
        this.mScale = f;
    }

    public class GlowManager {
        private float alpha = 0.0f;
        private float radius = 0.0f;
        private float x;
        private float y;

        public float getAlpha() {
            return this.alpha;
        }

        public float getRadius() {
            return this.radius;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public void setRadius(float f) {
            this.radius = f;
        }

        public void setX(float f) {
            this.x = f;
        }

        public void setY(float f) {
            this.y = f;
        }
    }

    class Point {
        float radius;
        float x;
        float y;

        public Point(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.radius = f3;
        }
    }

    public class WaveManager {
        private float alpha = 0.0f;
        private float radius = 50.0f;

        public float getAlpha() {
            return this.alpha;
        }

        public float getRadius() {
            return this.radius;
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public void setRadius(float f) {
            this.radius = f;
        }
    }
}

