/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.animation.TimeInterpolator;

class Ease {
    private static final float DOMAIN = 1.0f;
    private static final float DURATION = 1.0f;
    private static final float START;

    Ease() {
    }

    static class Cubic {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float f) {
                float f2 = f / 1.0f;
                return 0.0f + f2 * (f2 * (1.0f * f2));
            }
        };
        public static final TimeInterpolator easeInOut;
        public static final TimeInterpolator easeOut;

        static {
            easeOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    float f2 = f / 1.0f - 1.0f;
                    return 0.0f + 1.0f * (1.0f + f2 * (f2 * f2));
                }
            };
            easeInOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    float f2 = f / 0.5f;
                    if (f2 < 1.0f) {
                        return 0.0f + f2 * (f2 * (0.5f * f2));
                    }
                    float f3 = f2 - 2.0f;
                    return 0.0f + 0.5f * (2.0f + f3 * (f3 * f3));
                }
            };
        }

        Cubic() {
        }
    }

    static class Linear {
        public static final TimeInterpolator easeNone = new TimeInterpolator(){

            @Override
            public float getInterpolation(float f) {
                return f;
            }
        };

        Linear() {
        }
    }

    static class Quad {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float f) {
                float f2 = f / 1.0f;
                return 0.0f + f2 * (1.0f * f2);
            }
        };
        public static final TimeInterpolator easeInOut;
        public static final TimeInterpolator easeOut;

        static {
            easeOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    float f2 = f / 1.0f;
                    return 0.0f + -1.0f * f2 * (f2 - 2.0f);
                }
            };
            easeInOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    float f2 = f / 0.5f;
                    if (f2 < 1.0f) {
                        return 0.0f + f2 * (0.5f * f2);
                    }
                    float f3 = f2 - 1.0f;
                    return 0.0f + -0.5f * (f3 * (f3 - 2.0f) - 1.0f);
                }
            };
        }

        Quad() {
        }
    }

    static class Quart {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float f) {
                float f2 = f / 1.0f;
                return 0.0f + f2 * (f2 * (f2 * (1.0f * f2)));
            }
        };
        public static final TimeInterpolator easeInOut;
        public static final TimeInterpolator easeOut;

        static {
            easeOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    float f2 = f / 1.0f - 1.0f;
                    return 0.0f + -1.0f * (f2 * (f2 * (f2 * f2)) - 1.0f);
                }
            };
            easeInOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    float f2 = f / 0.5f;
                    if (f2 < 1.0f) {
                        return 0.0f + f2 * (f2 * (f2 * (0.5f * f2)));
                    }
                    float f3 = f2 - 2.0f;
                    return 0.0f + -0.5f * (f3 * (f3 * (f3 * f3)) - 2.0f);
                }
            };
        }

        Quart() {
        }
    }

    static class Quint {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float f) {
                float f2 = f / 1.0f;
                return 0.0f + f2 * (f2 * (f2 * (f2 * (1.0f * f2))));
            }
        };
        public static final TimeInterpolator easeInOut;
        public static final TimeInterpolator easeOut;

        static {
            easeOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    float f2 = f / 1.0f - 1.0f;
                    return 0.0f + 1.0f * (1.0f + f2 * (f2 * (f2 * (f2 * f2))));
                }
            };
            easeInOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    float f2 = f / 0.5f;
                    if (f2 < 1.0f) {
                        return 0.0f + f2 * (f2 * (f2 * (f2 * (0.5f * f2))));
                    }
                    float f3 = f2 - 2.0f;
                    return 0.0f + 0.5f * (2.0f + f3 * (f3 * (f3 * (f3 * f3))));
                }
            };
        }

        Quint() {
        }
    }

    static class Sine {
        public static final TimeInterpolator easeIn = new TimeInterpolator(){

            @Override
            public float getInterpolation(float f) {
                return 0.0f + (1.0f + -1.0f * (float)Math.cos(1.5707963267948966 * (double)(f / 1.0f)));
            }
        };
        public static final TimeInterpolator easeInOut;
        public static final TimeInterpolator easeOut;

        static {
            easeOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    return 0.0f + 1.0f * (float)Math.sin(1.5707963267948966 * (double)(f / 1.0f));
                }
            };
            easeInOut = new TimeInterpolator(){

                @Override
                public float getInterpolation(float f) {
                    return 0.0f + -0.5f * ((float)Math.cos(Math.PI * (double)f / 1.0) - 1.0f);
                }
            };
        }

        Sine() {
        }
    }
}

