/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.hardware.input.InputManager;
import android.os.SystemProperties;
import android.util.Log;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManagerPolicy;
import java.util.ArrayList;

public class PointerLocationView
extends View
implements InputManager.InputDeviceListener,
WindowManagerPolicy.PointerEventListener {
    private static final String ALT_STRATEGY_PROPERY_KEY = "debug.velocitytracker.alt";
    private static final String TAG = "Pointer";
    private final int ESTIMATE_FUTURE_POINTS;
    private final float ESTIMATE_INTERVAL;
    private final int ESTIMATE_PAST_POINTS;
    private int mActivePointerId;
    private final VelocityTracker mAltVelocity;
    private boolean mCurDown;
    private int mCurNumPointers;
    private final Paint mCurrentPointPaint;
    private int mHeaderBottom;
    private final InputManager mIm;
    private int mMaxNumPointers;
    private final Paint mPaint;
    private final Paint mPathPaint;
    private final ArrayList<PointerState> mPointers;
    private boolean mPrintCoords = true;
    private RectF mReusableOvalRect;
    private final Paint mTargetPaint;
    private final MotionEvent.PointerCoords mTempCoords;
    private final FasterStringBuilder mText;
    private final Paint mTextBackgroundPaint;
    private final Paint mTextLevelPaint;
    private final Paint.FontMetricsInt mTextMetrics = new Paint.FontMetricsInt();
    private final Paint mTextPaint;
    private final ViewConfiguration mVC;
    private final VelocityTracker mVelocity;

    public PointerLocationView(Context context) {
        super(context);
        this.ESTIMATE_PAST_POINTS = 4;
        this.ESTIMATE_FUTURE_POINTS = 2;
        this.ESTIMATE_INTERVAL = 0.02f;
        this.mPointers = new ArrayList();
        this.mTempCoords = new MotionEvent.PointerCoords();
        this.mText = new FasterStringBuilder();
        this.mReusableOvalRect = new RectF();
        this.setFocusableInTouchMode(true);
        this.mIm = (InputManager)context.getSystemService("input");
        this.mVC = ViewConfiguration.get(context);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(10.0f * this.getResources().getDisplayMetrics().density);
        this.mTextPaint.setARGB(255, 0, 0, 0);
        this.mTextBackgroundPaint = new Paint();
        this.mTextBackgroundPaint.setAntiAlias(false);
        this.mTextBackgroundPaint.setARGB(128, 255, 255, 255);
        this.mTextLevelPaint = new Paint();
        this.mTextLevelPaint.setAntiAlias(false);
        this.mTextLevelPaint.setARGB(192, 255, 0, 0);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setARGB(255, 255, 255, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f);
        this.mCurrentPointPaint = new Paint();
        this.mCurrentPointPaint.setAntiAlias(true);
        this.mCurrentPointPaint.setARGB(255, 255, 0, 0);
        this.mCurrentPointPaint.setStyle(Paint.Style.STROKE);
        this.mCurrentPointPaint.setStrokeWidth(2.0f);
        this.mTargetPaint = new Paint();
        this.mTargetPaint.setAntiAlias(false);
        this.mTargetPaint.setARGB(255, 0, 0, 192);
        this.mPathPaint = new Paint();
        this.mPathPaint.setAntiAlias(false);
        this.mPathPaint.setARGB(255, 0, 96, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(1.0f);
        PointerState pointerState = new PointerState();
        this.mPointers.add(pointerState);
        this.mActivePointerId = 0;
        this.mVelocity = VelocityTracker.obtain();
        String string2 = SystemProperties.get(ALT_STRATEGY_PROPERY_KEY);
        if (string2.length() != 0) {
            Log.d(TAG, "Comparing default velocity tracker strategy with " + string2);
            this.mAltVelocity = VelocityTracker.obtain(string2);
            return;
        }
        this.mAltVelocity = null;
    }

    private void drawOval(Canvas canvas, float f, float f2, float f3, float f4, float f5, Paint paint) {
        canvas.save(1);
        canvas.rotate((float)((double)(180.0f * f5) / Math.PI), f, f2);
        this.mReusableOvalRect.left = f - f4 / 2.0f;
        this.mReusableOvalRect.right = f + f4 / 2.0f;
        this.mReusableOvalRect.top = f2 - f3 / 2.0f;
        this.mReusableOvalRect.bottom = f2 + f3 / 2.0f;
        canvas.drawOval(this.mReusableOvalRect, paint);
        canvas.restore();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void logCoords(String string2, int n, int n2, MotionEvent.PointerCoords pointerCoords, int n3, MotionEvent motionEvent) {
        String string3;
        int n4 = motionEvent.getToolType(n2);
        int n5 = motionEvent.getButtonState();
        switch (n & 0xFF) {
            default: {
                string3 = Integer.toString(n);
                break;
            }
            case 0: {
                string3 = "DOWN";
                break;
            }
            case 1: {
                string3 = "UP";
                break;
            }
            case 2: {
                string3 = "MOVE";
                break;
            }
            case 3: {
                string3 = "CANCEL";
                break;
            }
            case 4: {
                string3 = "OUTSIDE";
                break;
            }
            case 5: {
                if (n2 == (0xFF00 & n) >> 8) {
                    string3 = "DOWN";
                    break;
                }
                string3 = "MOVE";
                break;
            }
            case 6: {
                if (n2 == (0xFF00 & n) >> 8) {
                    string3 = "UP";
                    break;
                }
                string3 = "MOVE";
                break;
            }
            case 7: {
                string3 = "HOVER MOVE";
                break;
            }
            case 9: {
                string3 = "HOVER ENTER";
                break;
            }
            case 10: {
                string3 = "HOVER EXIT";
                break;
            }
            case 8: {
                string3 = "SCROLL";
            }
        }
        Log.i(TAG, this.mText.clear().append(string2).append(" id ").append(n3 + 1).append(": ").append(string3).append(" (").append(pointerCoords.x, 3).append(", ").append(pointerCoords.y, 3).append(") Pressure=").append(pointerCoords.pressure, 3).append(" Size=").append(pointerCoords.size, 3).append(" TouchMajor=").append(pointerCoords.touchMajor, 3).append(" TouchMinor=").append(pointerCoords.touchMinor, 3).append(" ToolMajor=").append(pointerCoords.toolMajor, 3).append(" ToolMinor=").append(pointerCoords.toolMinor, 3).append(" Orientation=").append((float)((double)(180.0f * pointerCoords.orientation) / Math.PI), 1).append("deg").append(" Tilt=").append((float)((double)(180.0f * pointerCoords.getAxisValue(25)) / Math.PI), 1).append("deg").append(" Distance=").append(pointerCoords.getAxisValue(24), 1).append(" VScroll=").append(pointerCoords.getAxisValue(9), 1).append(" HScroll=").append(pointerCoords.getAxisValue(10), 1).append(" BoundingBox=[(").append(motionEvent.getAxisValue(32), 3).append(", ").append(motionEvent.getAxisValue(33), 3).append(")").append(", (").append(motionEvent.getAxisValue(34), 3).append(", ").append(motionEvent.getAxisValue(35), 3).append(")]").append(" ToolType=").append(MotionEvent.toolTypeToString(n4)).append(" ButtonState=").append(MotionEvent.buttonStateToString(n5)).toString());
    }

    private void logInputDeviceState(int n, String string2) {
        InputDevice inputDevice = this.mIm.getInputDevice(n);
        if (inputDevice != null) {
            Log.i(TAG, string2 + ": " + inputDevice);
            return;
        }
        Log.i(TAG, string2 + ": " + n);
    }

    private void logInputDevices() {
        int[] nArray = InputDevice.getDeviceIds();
        for (int i = 0; i < nArray.length; ++i) {
            this.logInputDeviceState(nArray[i], "Device Enumerated");
        }
    }

    private void logMotionEvent(String string2, MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        int n2 = motionEvent.getHistorySize();
        int n3 = motionEvent.getPointerCount();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = motionEvent.getPointerId(j);
                motionEvent.getHistoricalPointerCoords(j, i, this.mTempCoords);
                this.logCoords(string2, n, j, this.mTempCoords, n4, motionEvent);
            }
        }
        for (int i = 0; i < n3; ++i) {
            int n5 = motionEvent.getPointerId(i);
            motionEvent.getPointerCoords(i, this.mTempCoords);
            this.logCoords(string2, n, i, this.mTempCoords, n5, motionEvent);
        }
    }

    private static boolean shouldLogKey(int n) {
        switch (n) {
            default: {
                if (!KeyEvent.isGamepadButton(n) && !KeyEvent.isModifierKey(n)) break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIm.registerInputDeviceListener(this, this.getHandler());
        this.logInputDevices();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIm.unregisterInputDeviceListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        int n = this.getWidth();
        int n2 = n / 7;
        int n3 = 1 + -this.mTextMetrics.ascent;
        int n4 = this.mHeaderBottom;
        int n5 = this.mPointers.size();
        if (this.mActivePointerId >= 0) {
            PointerState pointerState = this.mPointers.get(this.mActivePointerId);
            canvas.drawRect(0.0f, 0.0f, n2 - 1, n4, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("P: ").append(this.mCurNumPointers).append(" / ").append(this.mMaxNumPointers).toString(), 1.0f, n3, this.mTextPaint);
            int n6 = pointerState.mTraceCount;
            if (this.mCurDown && pointerState.mCurDown || n6 == 0) {
                canvas.drawRect(n2, 0.0f, -1 + n2 * 2, n4, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("X: ").append(((PointerState)pointerState).mCoords.x, 1).toString(), n2 + 1, n3, this.mTextPaint);
                canvas.drawRect(n2 * 2, 0.0f, -1 + n2 * 3, n4, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("Y: ").append(((PointerState)pointerState).mCoords.y, 1).toString(), 1 + n2 * 2, n3, this.mTextPaint);
            } else {
                float f = pointerState.mTraceX[n6 - 1] - pointerState.mTraceX[0];
                float f2 = pointerState.mTraceY[n6 - 1] - pointerState.mTraceY[0];
                float f3 = n2;
                float f4 = -1 + n2 * 2;
                float f5 = n4;
                Paint paint = Math.abs(f) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint;
                canvas.drawRect(f3, 0.0f, f4, f5, paint);
                canvas.drawText(this.mText.clear().append("dX: ").append(f, 1).toString(), n2 + 1, n3, this.mTextPaint);
                float f6 = n2 * 2;
                float f7 = -1 + n2 * 3;
                float f8 = n4;
                Paint paint2 = Math.abs(f2) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint;
                canvas.drawRect(f6, 0.0f, f7, f8, paint2);
                canvas.drawText(this.mText.clear().append("dY: ").append(f2, 1).toString(), 1 + n2 * 2, n3, this.mTextPaint);
            }
            canvas.drawRect(n2 * 3, 0.0f, -1 + n2 * 4, n4, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("Xv: ").append(pointerState.mXVelocity, 3).toString(), 1 + n2 * 3, n3, this.mTextPaint);
            canvas.drawRect(n2 * 4, 0.0f, -1 + n2 * 5, n4, this.mTextBackgroundPaint);
            canvas.drawText(this.mText.clear().append("Yv: ").append(pointerState.mYVelocity, 3).toString(), 1 + n2 * 4, n3, this.mTextPaint);
            canvas.drawRect(n2 * 5, 0.0f, -1 + n2 * 6, n4, this.mTextBackgroundPaint);
            canvas.drawRect(n2 * 5, 0.0f, (float)(n2 * 5) + ((PointerState)pointerState).mCoords.pressure * (float)n2 - 1.0f, n4, this.mTextLevelPaint);
            canvas.drawText(this.mText.clear().append("Prs: ").append(((PointerState)pointerState).mCoords.pressure, 2).toString(), 1 + n2 * 5, n3, this.mTextPaint);
            canvas.drawRect(n2 * 6, 0.0f, n, n4, this.mTextBackgroundPaint);
            canvas.drawRect(n2 * 6, 0.0f, (float)(n2 * 6) + ((PointerState)pointerState).mCoords.size * (float)n2 - 1.0f, n4, this.mTextLevelPaint);
            canvas.drawText(this.mText.clear().append("Size: ").append(((PointerState)pointerState).mCoords.size, 2).toString(), 1 + n2 * 6, n3, this.mTextPaint);
        }
        int n7 = 0;
        while (n7 < n5) {
            PointerState pointerState = this.mPointers.get(n7);
            int n8 = pointerState.mTraceCount;
            float f = 0.0f;
            float f9 = 0.0f;
            boolean bl = false;
            boolean bl2 = false;
            this.mPaint.setARGB(255, 128, 255, 255);
            for (int i = 0; i < n8; ++i) {
                float f10 = pointerState.mTraceX[i];
                float f11 = pointerState.mTraceY[i];
                if (Float.isNaN(f10)) {
                    bl = false;
                    continue;
                }
                if (bl) {
                    canvas.drawLine(f, f9, f10, f11, this.mPathPaint);
                    Paint paint = pointerState.mTraceCurrent[i] ? this.mCurrentPointPaint : this.mPaint;
                    canvas.drawPoint(f, f9, paint);
                    bl2 = true;
                }
                f = f10;
                f9 = f11;
                bl = true;
            }
            if (bl2) {
                this.mPaint.setARGB(128, 128, 0, 128);
                float f12 = pointerState.mEstimator.estimateX(-0.08f);
                float f13 = pointerState.mEstimator.estimateY(-0.08f);
                for (int i = -3; i <= 2; ++i) {
                    float f14 = pointerState.mEstimator.estimateX(0.02f * (float)i);
                    float f15 = pointerState.mEstimator.estimateY(0.02f * (float)i);
                    canvas.drawLine(f12, f13, f14, f15, this.mPaint);
                    f12 = f14;
                    f13 = f15;
                }
                this.mPaint.setARGB(255, 255, 64, 128);
                float f16 = 16.0f * pointerState.mXVelocity;
                float f17 = 16.0f * pointerState.mYVelocity;
                float f18 = f + f16;
                float f19 = f9 + f17;
                Paint paint = this.mPaint;
                canvas.drawLine(f, f9, f18, f19, paint);
                if (this.mAltVelocity != null) {
                    this.mPaint.setARGB(128, 0, 128, 128);
                    float f20 = pointerState.mAltEstimator.estimateX(-0.08f);
                    float f21 = pointerState.mAltEstimator.estimateY(-0.08f);
                    for (int i = -3; i <= 2; ++i) {
                        float f22 = pointerState.mAltEstimator.estimateX(0.02f * (float)i);
                        float f23 = pointerState.mAltEstimator.estimateY(0.02f * (float)i);
                        canvas.drawLine(f20, f21, f22, f23, this.mPaint);
                        f20 = f22;
                        f21 = f23;
                    }
                    this.mPaint.setARGB(255, 64, 255, 128);
                    float f24 = 16.0f * pointerState.mAltXVelocity;
                    float f25 = 16.0f * pointerState.mAltYVelocity;
                    float f26 = f + f24;
                    float f27 = f9 + f25;
                    Paint paint3 = this.mPaint;
                    canvas.drawLine(f, f9, f26, f27, paint3);
                }
            }
            if (this.mCurDown && pointerState.mCurDown) {
                canvas.drawLine(0.0f, ((PointerState)pointerState).mCoords.y, this.getWidth(), ((PointerState)pointerState).mCoords.y, this.mTargetPaint);
                canvas.drawLine(((PointerState)pointerState).mCoords.x, 0.0f, ((PointerState)pointerState).mCoords.x, this.getHeight(), this.mTargetPaint);
                int n9 = (int)(255.0f * ((PointerState)pointerState).mCoords.pressure);
                this.mPaint.setARGB(255, n9, 255, 255 - n9);
                canvas.drawPoint(((PointerState)pointerState).mCoords.x, ((PointerState)pointerState).mCoords.y, this.mPaint);
                this.mPaint.setARGB(255, n9, 255 - n9, 128);
                this.drawOval(canvas, ((PointerState)pointerState).mCoords.x, ((PointerState)pointerState).mCoords.y, ((PointerState)pointerState).mCoords.touchMajor, ((PointerState)pointerState).mCoords.touchMinor, ((PointerState)pointerState).mCoords.orientation, this.mPaint);
                this.mPaint.setARGB(255, n9, 128, 255 - n9);
                this.drawOval(canvas, ((PointerState)pointerState).mCoords.x, ((PointerState)pointerState).mCoords.y, ((PointerState)pointerState).mCoords.toolMajor, ((PointerState)pointerState).mCoords.toolMinor, ((PointerState)pointerState).mCoords.orientation, this.mPaint);
                float f28 = 0.7f * ((PointerState)pointerState).mCoords.toolMajor;
                if (f28 < 20.0f) {
                    f28 = 20.0f;
                }
                this.mPaint.setARGB(255, n9, 255, 0);
                float f29 = (float)(Math.sin(((PointerState)pointerState).mCoords.orientation) * (double)f28);
                float f30 = (float)(-Math.cos(((PointerState)pointerState).mCoords.orientation) * (double)f28);
                if (pointerState.mToolType == 2 || pointerState.mToolType == 4) {
                    canvas.drawLine(((PointerState)pointerState).mCoords.x, ((PointerState)pointerState).mCoords.y, f29 + ((PointerState)pointerState).mCoords.x, f30 + ((PointerState)pointerState).mCoords.y, this.mPaint);
                } else {
                    canvas.drawLine(((PointerState)pointerState).mCoords.x - f29, ((PointerState)pointerState).mCoords.y - f30, f29 + ((PointerState)pointerState).mCoords.x, f30 + ((PointerState)pointerState).mCoords.y, this.mPaint);
                }
                float f31 = (float)Math.sin(pointerState.mCoords.getAxisValue(25));
                canvas.drawCircle(((PointerState)pointerState).mCoords.x + f29 * f31, ((PointerState)pointerState).mCoords.y + f30 * f31, 3.0f, this.mPaint);
                if (pointerState.mHasBoundingBox) {
                    canvas.drawRect(pointerState.mBoundingLeft, pointerState.mBoundingTop, pointerState.mBoundingRight, pointerState.mBoundingBottom, this.mPaint);
                }
            }
            ++n7;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        int n = motionEvent.getSource();
        if ((n & 2) != 0) {
            this.onPointerEvent(motionEvent);
            return true;
        }
        if ((n & 0x10) != 0) {
            this.logMotionEvent("Joystick", motionEvent);
            return true;
        }
        if ((n & 8) != 0) {
            this.logMotionEvent("Position", motionEvent);
            return true;
        }
        this.logMotionEvent("Generic", motionEvent);
        return true;
    }

    @Override
    public void onInputDeviceAdded(int n) {
        this.logInputDeviceState(n, "Device Added");
    }

    @Override
    public void onInputDeviceChanged(int n) {
        this.logInputDeviceState(n, "Device Changed");
    }

    @Override
    public void onInputDeviceRemoved(int n) {
        this.logInputDeviceState(n, "Device Removed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!PointerLocationView.shouldLogKey(n)) return super.onKeyDown(n, keyEvent);
        int n2 = keyEvent.getRepeatCount();
        if (n2 == 0) {
            Log.i(TAG, "Key Down: " + keyEvent);
            return true;
        }
        Log.i(TAG, "Key Repeat #" + n2 + ": " + keyEvent);
        return true;
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (PointerLocationView.shouldLogKey(n)) {
            Log.i(TAG, "Key Up: " + keyEvent);
            return true;
        }
        return super.onKeyUp(n, keyEvent);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        this.mTextPaint.getFontMetricsInt(this.mTextMetrics);
        this.mHeaderBottom = 2 + (-this.mTextMetrics.ascent + this.mTextMetrics.descent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onPointerEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        int n2 = this.mPointers.size();
        if (n == 0 || (n & 0xFF) == 5) {
            int n3 = (0xFF00 & n) >> 8;
            if (n == 0) {
                for (int i = 0; i < n2; ++i) {
                    PointerState pointerState = this.mPointers.get(i);
                    pointerState.clearTrace();
                    PointerState.access$102(pointerState, false);
                }
                this.mCurDown = true;
                this.mCurNumPointers = 0;
                this.mMaxNumPointers = 0;
                this.mVelocity.clear();
                if (this.mAltVelocity != null) {
                    this.mAltVelocity.clear();
                }
            }
            this.mCurNumPointers = 1 + this.mCurNumPointers;
            if (this.mMaxNumPointers < this.mCurNumPointers) {
                this.mMaxNumPointers = this.mCurNumPointers;
            }
            int n4 = motionEvent.getPointerId(n3);
            while (n2 <= n4) {
                PointerState pointerState = new PointerState();
                this.mPointers.add(pointerState);
                ++n2;
            }
            if (this.mActivePointerId < 0 || !this.mPointers.get(this.mActivePointerId).mCurDown) {
                this.mActivePointerId = n4;
            }
            PointerState pointerState = this.mPointers.get(n4);
            PointerState.access$102(pointerState, true);
            InputDevice inputDevice = InputDevice.getDevice(motionEvent.getDeviceId());
            boolean bl = inputDevice != null && inputDevice.getMotionRange(32) != null;
            PointerState.access$1302(pointerState, bl);
        }
        int n5 = motionEvent.getPointerCount();
        this.mVelocity.addMovement(motionEvent);
        this.mVelocity.computeCurrentVelocity(1);
        if (this.mAltVelocity != null) {
            this.mAltVelocity.addMovement(motionEvent);
            this.mAltVelocity.computeCurrentVelocity(1);
        }
        int n6 = motionEvent.getHistorySize();
        int n7 = 0;
        while (true) {
            if (n7 >= n6) break;
            for (int i = 0; i < n5; ++i) {
                int n8 = motionEvent.getPointerId(i);
                PointerState pointerState = this.mCurDown ? this.mPointers.get(n8) : null;
                MotionEvent.PointerCoords pointerCoords = pointerState != null ? pointerState.mCoords : this.mTempCoords;
                motionEvent.getHistoricalPointerCoords(i, n7, pointerCoords);
                if (this.mPrintCoords) {
                    this.logCoords(TAG, n, i, pointerCoords, n8, motionEvent);
                }
                if (pointerState == null) continue;
                pointerState.addTrace(pointerCoords.x, pointerCoords.y, false);
            }
            ++n7;
        }
        for (int i = 0; i < n5; ++i) {
            int n9 = motionEvent.getPointerId(i);
            PointerState pointerState = this.mCurDown ? this.mPointers.get(n9) : null;
            MotionEvent.PointerCoords pointerCoords = pointerState != null ? pointerState.mCoords : this.mTempCoords;
            motionEvent.getPointerCoords(i, pointerCoords);
            if (this.mPrintCoords) {
                this.logCoords(TAG, n, i, pointerCoords, n9, motionEvent);
            }
            if (pointerState == null) continue;
            pointerState.addTrace(pointerCoords.x, pointerCoords.y, true);
            PointerState.access$502(pointerState, this.mVelocity.getXVelocity(n9));
            PointerState.access$602(pointerState, this.mVelocity.getYVelocity(n9));
            this.mVelocity.getEstimator(n9, pointerState.mEstimator);
            if (this.mAltVelocity != null) {
                PointerState.access$1002(pointerState, this.mAltVelocity.getXVelocity(n9));
                PointerState.access$1102(pointerState, this.mAltVelocity.getYVelocity(n9));
                this.mAltVelocity.getEstimator(n9, pointerState.mAltEstimator);
            }
            PointerState.access$1202(pointerState, motionEvent.getToolType(i));
            if (!pointerState.mHasBoundingBox) continue;
            PointerState.access$1402(pointerState, motionEvent.getAxisValue(32, i));
            PointerState.access$1502(pointerState, motionEvent.getAxisValue(33, i));
            PointerState.access$1602(pointerState, motionEvent.getAxisValue(34, i));
            PointerState.access$1702(pointerState, motionEvent.getAxisValue(35, i));
        }
        if (n == 1 || n == 3 || (n & 0xFF) == 6) {
            int n10 = (0xFF00 & n) >> 8;
            int n11 = motionEvent.getPointerId(n10);
            PointerState pointerState = this.mPointers.get(n11);
            PointerState.access$102(pointerState, false);
            if (n == 1 || n == 3) {
                this.mCurDown = false;
                this.mCurNumPointers = 0;
            } else {
                this.mCurNumPointers = -1 + this.mCurNumPointers;
                if (this.mActivePointerId == n11) {
                    int n12 = n10 == 0 ? 1 : 0;
                    this.mActivePointerId = motionEvent.getPointerId(n12);
                }
                pointerState.addTrace(Float.NaN, Float.NaN, false);
            }
        }
        this.invalidate();
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.onPointerEvent(motionEvent);
        if (motionEvent.getAction() == 0 && !this.isFocused()) {
            this.requestFocus();
        }
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        this.logMotionEvent("Trackball", motionEvent);
        return true;
    }

    public void setPrintCoords(boolean bl) {
        this.mPrintCoords = bl;
    }

    private static final class FasterStringBuilder {
        private char[] mChars = new char[64];
        private int mLength;

        private int reserve(int n) {
            int n2 = this.mLength;
            int n3 = n + this.mLength;
            char[] cArray = this.mChars;
            int n4 = cArray.length;
            if (n3 > n4) {
                char[] cArray2 = new char[n4 * 2];
                System.arraycopy((char[])cArray, (int)0, (char[])cArray2, (int)0, (int)n2);
                this.mChars = cArray2;
            }
            return n2;
        }

        public FasterStringBuilder append(float f, int n) {
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                n2 *= 10;
            }
            float f2 = (float)(Math.rint(f * (float)n2) / (double)n2);
            this.append((int)f2);
            if (n != 0) {
                this.append(".");
                float f3 = Math.abs(f2);
                this.append((int)((float)((double)f3 - Math.floor(f3)) * (float)n2), n);
            }
            return this;
        }

        public FasterStringBuilder append(int n) {
            return this.append(n, 0);
        }

        /*
         * Enabled aggressive block sorting
         */
        public FasterStringBuilder append(int n, int n2) {
            int n3;
            boolean bl = n < 0;
            if (bl && (n = -n) < 0) {
                this.append("-2147483648");
                return this;
            }
            int n4 = this.reserve(11);
            char[] cArray = this.mChars;
            if (n == 0) {
                int cfr_ignored_0 = n4 + 1;
                cArray[n4] = 48;
                this.mLength = 1 + this.mLength;
                return this;
            }
            if (bl) {
                int n5 = n4 + 1;
                cArray[n4] = 45;
                n4 = n5;
            }
            int n6 = 10;
            int n7 = n4;
            for (n3 = 1000000000; n < n3; n3 /= 10) {
                if (--n6 >= n2) continue;
                int n8 = n7 + 1;
                cArray[n7] = 48;
                n7 = n8;
            }
            do {
                int n9 = n7;
                int n10 = n / n3;
                n -= n10 * n3;
                n7 = n9 + 1;
                cArray[n9] = (char)(n10 + 48);
            } while ((n3 /= 10) != 0);
            this.mLength = n7;
            return this;
        }

        public FasterStringBuilder append(String string2) {
            int n = string2.length();
            int n2 = this.reserve(n);
            string2.getChars(0, n, this.mChars, n2);
            this.mLength = n + this.mLength;
            return this;
        }

        public FasterStringBuilder clear() {
            this.mLength = 0;
            return this;
        }

        public String toString() {
            return new String(this.mChars, 0, this.mLength);
        }
    }

    public static class PointerState {
        private VelocityTracker.Estimator mAltEstimator;
        private float mAltXVelocity;
        private float mAltYVelocity;
        private float mBoundingBottom;
        private float mBoundingLeft;
        private float mBoundingRight;
        private float mBoundingTop;
        private MotionEvent.PointerCoords mCoords;
        private boolean mCurDown;
        private VelocityTracker.Estimator mEstimator;
        private boolean mHasBoundingBox;
        private int mToolType;
        private int mTraceCount;
        private boolean[] mTraceCurrent;
        private float[] mTraceX = new float[32];
        private float[] mTraceY = new float[32];
        private float mXVelocity;
        private float mYVelocity;

        public PointerState() {
            this.mTraceCurrent = new boolean[32];
            this.mCoords = new MotionEvent.PointerCoords();
            this.mEstimator = new VelocityTracker.Estimator();
            this.mAltEstimator = new VelocityTracker.Estimator();
        }

        static /* synthetic */ float access$1002(PointerState pointerState, float f) {
            pointerState.mAltXVelocity = f;
            return f;
        }

        static /* synthetic */ boolean access$102(PointerState pointerState, boolean bl) {
            pointerState.mCurDown = bl;
            return bl;
        }

        static /* synthetic */ float access$1102(PointerState pointerState, float f) {
            pointerState.mAltYVelocity = f;
            return f;
        }

        static /* synthetic */ int access$1202(PointerState pointerState, int n) {
            pointerState.mToolType = n;
            return n;
        }

        static /* synthetic */ boolean access$1302(PointerState pointerState, boolean bl) {
            pointerState.mHasBoundingBox = bl;
            return bl;
        }

        static /* synthetic */ float access$1402(PointerState pointerState, float f) {
            pointerState.mBoundingLeft = f;
            return f;
        }

        static /* synthetic */ float access$1502(PointerState pointerState, float f) {
            pointerState.mBoundingTop = f;
            return f;
        }

        static /* synthetic */ float access$1602(PointerState pointerState, float f) {
            pointerState.mBoundingRight = f;
            return f;
        }

        static /* synthetic */ float access$1702(PointerState pointerState, float f) {
            pointerState.mBoundingBottom = f;
            return f;
        }

        static /* synthetic */ float access$502(PointerState pointerState, float f) {
            pointerState.mXVelocity = f;
            return f;
        }

        static /* synthetic */ float access$602(PointerState pointerState, float f) {
            pointerState.mYVelocity = f;
            return f;
        }

        public void addTrace(float f, float f2, boolean bl) {
            int n = this.mTraceX.length;
            if (this.mTraceCount == n) {
                int n2 = n * 2;
                float[] fArray = new float[n2];
                System.arraycopy((float[])this.mTraceX, (int)0, (float[])fArray, (int)0, (int)this.mTraceCount);
                this.mTraceX = fArray;
                float[] fArray2 = new float[n2];
                System.arraycopy((float[])this.mTraceY, (int)0, (float[])fArray2, (int)0, (int)this.mTraceCount);
                this.mTraceY = fArray2;
                boolean[] blArray = new boolean[n2];
                System.arraycopy((boolean[])this.mTraceCurrent, (int)0, (boolean[])blArray, (int)0, (int)this.mTraceCount);
                this.mTraceCurrent = blArray;
            }
            this.mTraceX[this.mTraceCount] = f;
            this.mTraceY[this.mTraceCount] = f2;
            this.mTraceCurrent[this.mTraceCount] = bl;
            this.mTraceCount = 1 + this.mTraceCount;
        }

        public void clearTrace() {
            this.mTraceCount = 0;
        }
    }
}

