/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.R;
import com.android.internal.widget.LockPatternUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class LockPatternView
extends View {
    private static final int ASPECT_LOCK_HEIGHT = 2;
    private static final int ASPECT_LOCK_WIDTH = 1;
    private static final int ASPECT_SQUARE = 0;
    private static final float DRAG_THRESHHOLD = 0.0f;
    private static final int MILLIS_PER_CIRCLE_ANIMATING = 700;
    private static final boolean PROFILE_DRAWING;
    private TypedArray a;
    private long mAnimatingPeriodStart;
    private int mAspect;
    private final CellState[][] mCellStates;
    private final Path mCurrentPath;
    private final int mDotSize;
    private final int mDotSizeActivated;
    private boolean mDrawingProfilingStarted = false;
    private boolean mEnableHapticFeedback;
    private int mErrorColor;
    private Interpolator mFastOutSlowInInterpolator;
    private float mHitFactor;
    private float mInProgressX;
    private float mInProgressY;
    private boolean mInStealthMode;
    private boolean mInputEnabled;
    private final Rect mInvalidate;
    private Interpolator mLinearOutSlowInInterpolator;
    private OnPatternListener mOnPatternListener;
    private int mPModeColor;
    private int mPModeHintLockStatus;
    private Paint mPaint = new Paint();
    private Paint mPathPaint = new Paint();
    private final int mPathWidth;
    private ArrayList<Cell> mPattern = new ArrayList(9);
    private DisplayMode mPatternDisplayMode;
    private boolean[][] mPatternDrawLookup;
    private boolean mPatternInProgress;
    private boolean mPrivateMode;
    private int mRegularColor;
    private float mSquareHeight;
    private float mSquareWidth;
    private int mSuccessColor;
    private final Rect mTmpInvalidateRect;

    public LockPatternView(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LockPatternView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int[] nArray = new int[]{3, 3};
        this.mPatternDrawLookup = (boolean[][])Array.newInstance(Boolean.TYPE, nArray);
        this.mInProgressX = -1.0f;
        this.mInProgressY = -1.0f;
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.mPrivateMode = false;
        this.mInputEnabled = true;
        this.mInStealthMode = false;
        this.mEnableHapticFeedback = true;
        this.mPatternInProgress = false;
        this.mHitFactor = 0.6f;
        this.mCurrentPath = new Path();
        this.mInvalidate = new Rect();
        this.mTmpInvalidateRect = new Rect();
        this.a = context.obtainStyledAttributes(attributeSet, R.styleable.LockPatternView);
        String string2 = this.a.getString(0);
        this.mAspect = "square".equals(string2) ? 0 : ("lock_width".equals(string2) ? 1 : ("lock_height".equals(string2) ? 2 : 0));
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mRegularColor = this.getResources().getColor(17170506);
        this.mErrorColor = this.getResources().getColor(17170508);
        this.mSuccessColor = this.getResources().getColor(17170507);
        this.mPModeColor = -16777216 + Settings.Global.getInt(this.mContext.getContentResolver(), "user_snapview_settings_hint_color", -3260917);
        this.mPModeHintLockStatus = Settings.Global.getInt(this.mContext.getContentResolver(), "user_snapview_settings_hint_lock", 0);
        this.mRegularColor = this.a.getColor(2, this.mRegularColor);
        this.mErrorColor = this.a.getColor(3, this.mErrorColor);
        this.mSuccessColor = this.a.getColor(4, this.mSuccessColor);
        int n = this.a.getColor(1, this.mRegularColor);
        this.mPathPaint.setColor(n);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPathWidth = this.getResources().getDimensionPixelSize(17105049);
        this.mPathPaint.setStrokeWidth(this.mPathWidth);
        this.mDotSize = this.getResources().getDimensionPixelSize(17105050);
        this.mDotSizeActivated = this.getResources().getDimensionPixelSize(17105051);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mCellStates = (CellState[][])Array.newInstance(CellState.class, 3, 3);
        int n2 = 0;
        while (true) {
            if (n2 >= 3) {
                this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
                this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
                return;
            }
            for (int i = 0; i < 3; ++i) {
                this.mCellStates[n2][i] = new CellState();
                this.mCellStates[n2][i].size = this.mDotSize;
            }
            ++n2;
        }
    }

    private void addCellToPattern(Cell cell) {
        this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        this.mPattern.add(cell);
        if (!this.mInStealthMode) {
            this.startCellActivatedAnimation(cell);
        }
        this.notifyCellAdded();
    }

    private float calculateLastSegmentAlpha(float f, float f2, float f3, float f4) {
        float f5 = f - f3;
        float f6 = f2 - f4;
        return Math.min(1.0f, Math.max(0.0f, 4.0f * ((float)Math.sqrt(f5 * f5 + f6 * f6) / this.mSquareWidth - 0.3f)));
    }

    private void cancelLineAnimations() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                CellState cellState = this.mCellStates[i][j];
                if (cellState.lineAnimator == null) continue;
                cellState.lineAnimator.cancel();
                cellState.lineEndX = Float.MIN_VALUE;
                cellState.lineEndY = Float.MIN_VALUE;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Cell checkForNewHit(float f, float f2) {
        int n;
        int n2 = this.getRowHit(f2);
        if (n2 < 0 || (n = this.getColumnHit(f)) < 0 || this.mPatternDrawLookup[n2][n]) {
            return null;
        }
        return Cell.of(n2, n);
    }

    private void clearPatternDrawLookup() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mPatternDrawLookup[i][j] = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Cell detectAndAddHit(float f, float f2) {
        int n = -1;
        Cell cell = this.checkForNewHit(f, f2);
        if (cell == null) return null;
        ArrayList<Cell> arrayList = this.mPattern;
        boolean bl = arrayList.isEmpty();
        Cell cell2 = null;
        if (!bl) {
            Cell cell3 = arrayList.get(-1 + arrayList.size());
            int n2 = cell.row - cell3.row;
            int n3 = cell.column - cell3.column;
            int n4 = cell3.row;
            int n5 = cell3.column;
            if (Math.abs(n2) == 2 && Math.abs(n3) != 1) {
                int n6 = cell3.row;
                int n7 = n2 > 0 ? 1 : n;
                n4 = n6 + n7;
            }
            if (Math.abs(n3) == 2 && Math.abs(n2) != 1) {
                int n8 = cell3.column;
                if (n3 > 0) {
                    n = 1;
                }
                n5 = n8 + n;
            }
            cell2 = Cell.of(n4, n5);
        }
        if (cell2 != null && !this.mPatternDrawLookup[cell2.row][cell2.column]) {
            this.addCellToPattern(cell2);
        }
        this.addCellToPattern(cell);
        if (this.mEnableHapticFeedback) {
            this.performHapticFeedback(1, 3);
        }
        return cell;
    }

    private void drawCircle(Canvas canvas, float f, float f2, float f3, boolean bl, float f4) {
        this.mPaint.setColor(this.getCurrentColor(bl));
        this.mPaint.setAlpha((int)(255.0f * f4));
        canvas.drawCircle(f, f2, f3 / 2.0f, this.mPaint);
    }

    private float getCenterXForColumn(int n) {
        return (float)this.mPaddingLeft + (float)n * this.mSquareWidth + this.mSquareWidth / 2.0f;
    }

    private float getCenterYForRow(int n) {
        return (float)this.mPaddingTop + (float)n * this.mSquareHeight + this.mSquareHeight / 2.0f;
    }

    private int getColumnHit(float f) {
        float f2 = this.mSquareWidth;
        float f3 = f2 * this.mHitFactor;
        float f4 = (float)this.mPaddingLeft + (f2 - f3) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float f5 = f4 + f2 * (float)i;
            if (!(f >= f5) || !(f <= f5 + f3)) continue;
            return i;
        }
        return -1;
    }

    private int getCurrentColor(boolean bl) {
        if (!bl || this.mInStealthMode || this.mPatternInProgress) {
            if (this.mPrivateMode && (this.mPModeHintLockStatus == 0 || this.mPModeHintLockStatus == 1)) {
                return this.mPModeColor;
            }
            return this.mRegularColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Wrong) {
            return this.mErrorColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Correct || this.mPatternDisplayMode == DisplayMode.Animate) {
            if (this.mPrivateMode && (this.mPModeHintLockStatus == 0 || this.mPModeHintLockStatus == 1)) {
                return this.mPModeColor;
            }
            return this.mSuccessColor;
        }
        throw new IllegalStateException("unknown display mode " + (Object)((Object)this.mPatternDisplayMode));
    }

    private int getRowHit(float f) {
        float f2 = this.mSquareHeight;
        float f3 = f2 * this.mHitFactor;
        float f4 = (float)this.mPaddingTop + (f2 - f3) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float f5 = f4 + f2 * (float)i;
            if (!(f >= f5) || !(f <= f5 + f3)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleActionDown(MotionEvent motionEvent) {
        this.resetPattern();
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        Cell cell = this.detectAndAddHit(f, f2);
        if (cell != null) {
            this.mPatternInProgress = true;
            this.mPatternDisplayMode = DisplayMode.Correct;
            this.notifyPatternStarted();
        } else if (this.mPatternInProgress) {
            this.mPatternInProgress = false;
            this.notifyPatternCleared();
        }
        if (cell != null) {
            float f3 = this.getCenterXForColumn(cell.column);
            float f4 = this.getCenterYForRow(cell.row);
            float f5 = this.mSquareWidth / 2.0f;
            float f6 = this.mSquareHeight / 2.0f;
            this.invalidate((int)(f3 - f5), (int)(f4 - f6), (int)(f3 + f5), (int)(f4 + f6));
        }
        this.mInProgressX = f;
        this.mInProgressY = f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleActionMove(MotionEvent motionEvent) {
        float f = this.mPathWidth;
        int n = motionEvent.getHistorySize();
        this.mTmpInvalidateRect.setEmpty();
        boolean bl = false;
        for (int i = 0; i < n + 1; ++i) {
            float f2 = i < n ? motionEvent.getHistoricalX(i) : motionEvent.getX();
            float f3 = i < n ? motionEvent.getHistoricalY(i) : motionEvent.getY();
            Cell cell = this.detectAndAddHit(f2, f3);
            int n2 = this.mPattern.size();
            if (cell != null && n2 == 1) {
                this.mPatternInProgress = true;
                this.notifyPatternStarted();
            }
            float f4 = Math.abs(f2 - this.mInProgressX);
            float f5 = Math.abs(f3 - this.mInProgressY);
            if (f4 > 0.0f || f5 > 0.0f) {
                bl = true;
            }
            if (!this.mPatternInProgress || n2 <= 0) continue;
            Cell cell2 = this.mPattern.get(n2 - 1);
            float f6 = this.getCenterXForColumn(cell2.column);
            float f7 = this.getCenterYForRow(cell2.row);
            float f8 = Math.min(f6, f2) - f;
            float f9 = f + Math.max(f6, f2);
            float f10 = Math.min(f7, f3) - f;
            float f11 = f + Math.max(f7, f3);
            if (cell != null) {
                float f12 = 0.5f * this.mSquareWidth;
                float f13 = 0.5f * this.mSquareHeight;
                float f14 = this.getCenterXForColumn(cell.column);
                float f15 = this.getCenterYForRow(cell.row);
                f8 = Math.min(f14 - f12, f8);
                f9 = Math.max(f14 + f12, f9);
                f10 = Math.min(f15 - f13, f10);
                f11 = Math.max(f15 + f13, f11);
            }
            this.mTmpInvalidateRect.union(Math.round(f8), Math.round(f10), Math.round(f9), Math.round(f11));
        }
        this.mInProgressX = motionEvent.getX();
        this.mInProgressY = motionEvent.getY();
        if (bl) {
            this.mInvalidate.union(this.mTmpInvalidateRect);
            this.invalidate(this.mInvalidate);
            this.mInvalidate.set(this.mTmpInvalidateRect);
        }
    }

    private void handleActionUp(MotionEvent motionEvent) {
        if (!this.mPattern.isEmpty()) {
            this.mPatternInProgress = false;
            this.cancelLineAnimations();
            this.notifyPatternDetected();
            this.invalidate();
        }
    }

    private void notifyCellAdded() {
        this.sendAccessEvent(17040296);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCellAdded(this.mPattern);
        }
    }

    private void notifyPatternCleared() {
        this.sendAccessEvent(17040295);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCleared();
        }
    }

    private void notifyPatternDetected() {
        this.sendAccessEvent(17040297);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternDetected(this.mPattern);
        }
    }

    private void notifyPatternStarted() {
        this.sendAccessEvent(17040294);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternStart();
        }
    }

    private void resetPattern() {
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.invalidate();
    }

    private int resolveMeasured(int n, int n2) {
        int n3 = View.MeasureSpec.getSize(n);
        switch (View.MeasureSpec.getMode(n)) {
            default: {
                return n3;
            }
            case 0: {
                return n2;
            }
            case -2147483648: 
        }
        return Math.max(n3, n2);
    }

    private void sendAccessEvent(int n) {
        this.announceForAccessibility(this.mContext.getString(n));
    }

    private void startCellActivatedAnimation(Cell cell) {
        final CellState cellState = this.mCellStates[cell.row][cell.column];
        this.startSizeAnimation(this.mDotSize, this.mDotSizeActivated, 96L, this.mLinearOutSlowInInterpolator, cellState, new Runnable(){

            @Override
            public void run() {
                LockPatternView.this.startSizeAnimation(LockPatternView.this.mDotSizeActivated, LockPatternView.this.mDotSize, 192L, LockPatternView.this.mFastOutSlowInInterpolator, cellState, null);
            }
        });
        this.startLineEndAnimation(cellState, this.mInProgressX, this.mInProgressY, this.getCenterXForColumn(cell.column), this.getCenterYForRow(cell.row));
    }

    private void startLineEndAnimation(final CellState cellState, final float f, final float f2, final float f3, final float f4) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f5 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                cellState.lineEndX = (1.0f - f5) * f + f5 * f3;
                cellState.lineEndY = (1.0f - f5) * f2 + f5 * f4;
                LockPatternView.this.invalidate();
            }
        });
        valueAnimator.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                cellState.lineAnimator = null;
            }
        });
        valueAnimator.setInterpolator(this.mFastOutSlowInInterpolator);
        valueAnimator.setDuration(100L);
        valueAnimator.start();
        cellState.lineAnimator = valueAnimator;
    }

    private void startSizeAnimation(float f, float f2, long l, Interpolator interpolator2, final CellState cellState, final Runnable runnable) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(f, f2);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                cellState.size = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                LockPatternView.this.invalidate();
            }
        });
        if (runnable != null) {
            valueAnimator.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animator2) {
                    runnable.run();
                }
            });
        }
        valueAnimator.setInterpolator(interpolator2);
        valueAnimator.setDuration(l);
        valueAnimator.start();
    }

    public void clearPattern() {
        this.resetPattern();
    }

    public void disableInput() {
        this.mInputEnabled = false;
    }

    public void enableInput() {
        this.mInputEnabled = true;
    }

    public CellState[][] getCellStates() {
        return this.mCellStates;
    }

    public boolean isInStealthMode() {
        return this.mInStealthMode;
    }

    public boolean isTactileFeedbackEnabled() {
        return this.mEnableHapticFeedback;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        ArrayList<Cell> arrayList = this.mPattern;
        int n = arrayList.size();
        boolean[][] blArray = this.mPatternDrawLookup;
        if (this.mPatternDisplayMode == DisplayMode.Animate) {
            int n2 = 700 * (n + 1);
            int n3 = (int)(SystemClock.elapsedRealtime() - this.mAnimatingPeriodStart) % n2;
            int n4 = n3 / 700;
            this.clearPatternDrawLookup();
            for (int i = 0; i < n4; ++i) {
                Cell cell = arrayList.get(i);
                blArray[cell.getRow()][cell.getColumn()] = true;
            }
            boolean bl = n4 > 0 && n4 < n;
            if (bl) {
                float f = (float)(n3 % 700) / 700.0f;
                Cell cell = arrayList.get(n4 - 1);
                float f2 = this.getCenterXForColumn(cell.column);
                float f3 = this.getCenterYForRow(cell.row);
                Cell cell2 = arrayList.get(n4);
                float f4 = f * (this.getCenterXForColumn(cell2.column) - f2);
                float f5 = f * (this.getCenterYForRow(cell2.row) - f3);
                this.mInProgressX = f2 + f4;
                this.mInProgressY = f3 + f5;
            }
            this.invalidate();
        }
        Path path = this.mCurrentPath;
        path.rewind();
        for (int i = 0; i < 3; ++i) {
            float f = this.getCenterYForRow(i);
            for (int j = 0; j < 3; ++j) {
                CellState cellState = this.mCellStates[i][j];
                float f6 = this.getCenterXForColumn(j);
                float f7 = cellState.size * cellState.scale;
                float f8 = cellState.translateY;
                this.drawCircle(canvas, (int)f6, f8 + (float)((int)f), f7, blArray[i][j], cellState.alpha);
            }
        }
        if (this.mInStealthMode) return;
        boolean bl = true;
        if (!bl) return;
        this.mPathPaint.setColor(this.getCurrentColor(true));
        boolean bl2 = false;
        float f = 0.0f;
        float f9 = 0.0f;
        int n5 = 0;
        while (true) {
            Cell cell;
            block14: {
                block13: {
                    if (n5 >= n) break block13;
                    cell = arrayList.get(n5);
                    if (blArray[cell.row][cell.column]) break block14;
                }
                if (!this.mPatternInProgress) {
                    if (this.mPatternDisplayMode != DisplayMode.Animate) return;
                }
                if (!bl2) return;
                path.rewind();
                path.moveTo(f, f9);
                path.lineTo(this.mInProgressX, this.mInProgressY);
                this.mPathPaint.setAlpha((int)(255.0f * this.calculateLastSegmentAlpha(this.mInProgressX, this.mInProgressY, f, f9)));
                canvas.drawPath(path, this.mPathPaint);
                return;
            }
            bl2 = true;
            float f10 = this.getCenterXForColumn(cell.column);
            float f11 = this.getCenterYForRow(cell.row);
            if (n5 != 0) {
                CellState cellState = this.mCellStates[cell.row][cell.column];
                path.rewind();
                path.moveTo(f, f9);
                if (cellState.lineEndX != Float.MIN_VALUE && cellState.lineEndY != Float.MIN_VALUE) {
                    path.lineTo(cellState.lineEndX, cellState.lineEndY);
                } else {
                    path.lineTo(f10, f11);
                }
                canvas.drawPath(path, this.mPathPaint);
            }
            f = f10;
            f9 = f11;
            ++n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int n = motionEvent.getAction();
            switch (n) {
                case 9: {
                    motionEvent.setAction(0);
                    break;
                }
                case 7: {
                    motionEvent.setAction(2);
                    break;
                }
                case 10: {
                    motionEvent.setAction(1);
                    break;
                }
            }
            this.onTouchEvent(motionEvent);
            motionEvent.setAction(n);
        }
        return super.onHoverEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = this.getSuggestedMinimumWidth();
        int n4 = this.getSuggestedMinimumHeight();
        int n5 = this.resolveMeasured(n, n3);
        int n6 = this.resolveMeasured(n2, n4);
        switch (this.mAspect) {
            case 0: {
                n5 = n6 = Math.min(n5, n6);
                break;
            }
            case 1: {
                n6 = Math.min(n5, n6);
                break;
            }
            case 2: {
                n5 = Math.min(n5, n6);
                break;
            }
        }
        this.setMeasuredDimension(n5, n6);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setPattern(DisplayMode.Correct, LockPatternUtils.stringToPattern(savedState.getSerializedPattern()));
        this.mPatternDisplayMode = DisplayMode.values()[savedState.getDisplayMode()];
        this.mInputEnabled = savedState.isInputEnabled();
        this.mInStealthMode = savedState.isInStealthMode();
        this.mEnableHapticFeedback = savedState.isTactileFeedbackEnabled();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return new SavedState(super.onSaveInstanceState(), LockPatternUtils.patternToString(this.mPattern), this.mPatternDisplayMode.ordinal(), this.mInputEnabled, this.mInStealthMode, this.mEnableHapticFeedback);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.mSquareWidth = (float)(n - this.mPaddingLeft - this.mPaddingRight) / 3.0f;
        this.mSquareHeight = (float)(n2 - this.mPaddingTop - this.mPaddingBottom) / 3.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = true;
        if (!this.mInputEnabled) return false;
        if (!this.isEnabled()) {
            return false;
        }
        switch (motionEvent.getAction()) {
            default: {
                return false;
            }
            case 0: {
                this.handleActionDown(motionEvent);
                return bl;
            }
            case 1: {
                this.handleActionUp(motionEvent);
                return bl;
            }
            case 2: {
                this.handleActionMove(motionEvent);
                return bl;
            }
            case 3: 
        }
        if (!this.mPatternInProgress) return bl;
        this.mPatternInProgress = false;
        this.resetPattern();
        this.notifyPatternCleared();
        return bl;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.mPatternDisplayMode = displayMode;
        if (displayMode == DisplayMode.Animate) {
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = SystemClock.elapsedRealtime();
            Cell cell = this.mPattern.get(0);
            this.mInProgressX = this.getCenterXForColumn(cell.getColumn());
            this.mInProgressY = this.getCenterYForRow(cell.getRow());
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    public void setInStealthMode(boolean bl) {
        this.mInStealthMode = bl;
    }

    public void setOnPatternListener(OnPatternListener onPatternListener) {
        this.mOnPatternListener = onPatternListener;
    }

    public void setPathColor(boolean bl) {
        this.mPrivateMode = bl;
        if (bl) {
            if (this.mPModeHintLockStatus == 0 || this.mPModeHintLockStatus == 1) {
                int n = this.a.getColor(1, this.mPModeColor);
                this.mPathPaint.setColor(n);
            }
            return;
        }
        int n = this.a.getColor(1, this.mRegularColor);
        this.mPathPaint.setColor(n);
    }

    public void setPattern(DisplayMode displayMode, List<Cell> list) {
        this.mPattern.clear();
        this.mPattern.addAll(list);
        this.clearPatternDrawLookup();
        for (Cell cell : list) {
            this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        }
        this.setDisplayMode(displayMode);
    }

    public void setTactileFeedbackEnabled(boolean bl) {
        this.mEnableHapticFeedback = bl;
    }

    public static class Cell {
        static Cell[][] sCells = (Cell[][])Array.newInstance(Cell.class, 3, 3);
        int column;
        int row;

        static {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Cell.sCells[i][j] = new Cell(i, j);
                }
            }
        }

        private Cell(int n, int n2) {
            Cell.checkRange(n, n2);
            this.row = n;
            this.column = n2;
        }

        private static void checkRange(int n, int n2) {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException("row must be in range 0-2");
            }
            if (n2 < 0 || n2 > 2) {
                throw new IllegalArgumentException("column must be in range 0-2");
            }
        }

        public static Cell of(int n, int n2) {
            synchronized (Cell.class) {
                Cell.checkRange(n, n2);
                Cell cell = sCells[n][n2];
                return cell;
            }
        }

        public int getColumn() {
            return this.column;
        }

        public int getRow() {
            return this.row;
        }

        public String toString() {
            return "(row=" + this.row + ",clmn=" + this.column + ")";
        }
    }

    public static class CellState {
        public float alpha = 1.0f;
        public ValueAnimator lineAnimator;
        public float lineEndX = Float.MIN_VALUE;
        public float lineEndY = Float.MIN_VALUE;
        public float scale = 1.0f;
        public float size;
        public float translateY = 0.0f;
    }

    public static final class DisplayMode
    extends Enum<DisplayMode> {
        private static final /* synthetic */ DisplayMode[] $VALUES;
        public static final /* enum */ DisplayMode Animate;
        public static final /* enum */ DisplayMode Correct;
        public static final /* enum */ DisplayMode Wrong;

        static {
            Correct = new DisplayMode();
            Animate = new DisplayMode();
            Wrong = new DisplayMode();
            DisplayMode[] displayModeArray = new DisplayMode[]{Correct, Animate, Wrong};
            $VALUES = displayModeArray;
        }

        public static DisplayMode valueOf(String string2) {
            return Enum.valueOf(DisplayMode.class, string2);
        }

        public static DisplayMode[] values() {
            return (DisplayMode[])$VALUES.clone();
        }
    }

    public static interface OnPatternListener {
        public void onPatternCellAdded(List<Cell> var1);

        public void onPatternCleared();

        public void onPatternDetected(List<Cell> var1);

        public void onPatternStart();
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private final int mDisplayMode;
        private final boolean mInStealthMode;
        private final boolean mInputEnabled;
        private final String mSerializedPattern;
        private final boolean mTactileFeedbackEnabled;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.mSerializedPattern = parcel.readString();
            this.mDisplayMode = parcel.readInt();
            this.mInputEnabled = (Boolean)parcel.readValue(null);
            this.mInStealthMode = (Boolean)parcel.readValue(null);
            this.mTactileFeedbackEnabled = (Boolean)parcel.readValue(null);
        }

        private SavedState(Parcelable parcelable, String string2, int n, boolean bl, boolean bl2, boolean bl3) {
            super(parcelable);
            this.mSerializedPattern = string2;
            this.mDisplayMode = n;
            this.mInputEnabled = bl;
            this.mInStealthMode = bl2;
            this.mTactileFeedbackEnabled = bl3;
        }

        public int getDisplayMode() {
            return this.mDisplayMode;
        }

        public String getSerializedPattern() {
            return this.mSerializedPattern;
        }

        public boolean isInStealthMode() {
            return this.mInStealthMode;
        }

        public boolean isInputEnabled() {
            return this.mInputEnabled;
        }

        public boolean isTactileFeedbackEnabled() {
            return this.mTactileFeedbackEnabled;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeString(this.mSerializedPattern);
            parcel.writeInt(this.mDisplayMode);
            parcel.writeValue(this.mInputEnabled);
            parcel.writeValue(this.mInStealthMode);
            parcel.writeValue(this.mTactileFeedbackEnabled);
        }
    }
}

