/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.admin.DevicePolicyManager;
import android.app.trust.TrustManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.IWindowManager;
import android.widget.Button;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternUtilsCache;
import com.android.internal.widget.LockPatternView;
import com.google.android.collect.Lists;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LockPatternUtils {
    public static final String BIOMETRIC_WEAK_EVER_CHOSEN_KEY = "lockscreen.biometricweakeverchosen";
    private static final boolean DEBUG = false;
    public static final String DISABLE_LOCKSCREEN_KEY = "lockscreen.disabled";
    private static final String ENABLED_TRUST_AGENTS = "lockscreen.enabledtrustagents";
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static final int FAILED_ATTEMPTS_BEFORE_WIPE_GRACE = 5;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    public static final int FLAG_BIOMETRIC_WEAK_LIVELINESS = 1;
    public static final int ID_DEFAULT_STATUS_WIDGET = -2;
    public static final String KEYGUARD_SHOW_APPWIDGET = "showappwidget";
    public static final String KEYGUARD_SHOW_SECURITY_CHALLENGE = "showsecuritychallenge";
    public static final String KEYGUARD_SHOW_USER_SWITCHER = "showuserswitcher";
    public static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    public static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static final String LOCKSCREEN_BIOMETRIC_WEAK_FALLBACK = "lockscreen.biometric_weak_fallback";
    public static final String LOCKSCREEN_OPTIONS = "lockscreen.options";
    public static final String LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS = "lockscreen.power_button_instantly_locks";
    public static final String LOCKSCREEN_WIDGETS_ENABLED = "lockscreen.widgets_enabled";
    public static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    private static final String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
    private static final String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
    public static final int MAX_ALLOWED_SEQUENCE = 3;
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 4;
    public static final String PASSWORD_HISTORY_KEY = "lockscreen.passwordhistory";
    public static final String PASSWORD_TYPE_ALTERNATE_KEY = "lockscreen.password_type_alternate";
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    public static final String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    private static final String TAG = "LockPatternUtils";
    private static volatile int sCurrentUserId = -10000;
    private final ContentResolver mContentResolver;
    private final Context mContext;
    private DevicePolicyManager mDevicePolicyManager;
    private ILockSettings mLockSettingsService;
    private final boolean mMultiUserMode;

    /*
     * Enabled aggressive block sorting
     */
    public LockPatternUtils(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        boolean bl = context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0;
        this.mMultiUserMode = bl;
    }

    private static int categoryChar(char c) {
        if ('a' <= c && c <= 'z') {
            return 0;
        }
        if ('A' <= c && c <= 'Z') {
            return 1;
        }
        if ('0' <= c && c <= '9') {
            return 2;
        }
        return 3;
    }

    private static String combineStrings(int[] nArray, String string2) {
        int n;
        int n2 = nArray.length;
        switch (n2) {
            default: {
                n = 0;
                int n3 = string2.length();
                String[] stringArray = new String[nArray.length];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = Integer.toString(nArray[i]);
                    n += stringArray[i].length();
                    if (i >= n2 - 1) continue;
                    n += n3;
                }
                break;
            }
            case 0: {
                return "";
            }
            case 1: {
                return Integer.toString(nArray[0]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(nArray[i]);
            if (i >= n2 - 1) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int computePasswordQuality(String string2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string2.charAt(i))) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl2 && bl) {
            return 327680;
        }
        if (bl2) {
            return 262144;
        }
        if (!bl) {
            return 0;
        }
        if (LockPatternUtils.maxLengthSequence(string2) > 3) {
            return 131072;
        }
        return 196608;
    }

    private void finishBiometricWeak() {
        this.setBoolean(BIOMETRIC_WEAK_EVER_CHOSEN_KEY, true);
        Intent intent = new Intent();
        intent.setClassName("com.android.facelock", "com.android.facelock.SetupEndScreen");
        this.mContext.startActivity(intent);
    }

    private int[] getAppWidgets(int n) {
        String string2 = Settings.Secure.getStringForUser(this.mContentResolver, "lock_screen_appwidget_ids", n);
        if (string2 != null && string2.length() > 0) {
            String[] stringArray = string2.split(",");
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                try {
                    nArray[i] = Integer.decode(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    Log.d(TAG, "Error when parsing widget id " + string3);
                    nArray = null;
                    break;
                }
            }
            return nArray;
        }
        return new int[0];
    }

    private boolean getBoolean(String string2, boolean bl) {
        return this.getBoolean(string2, bl, this.getCurrentOrCallingUserId());
    }

    private boolean getBoolean(String string2, boolean bl, int n) {
        try {
            boolean bl2 = this.getLockSettings().getBoolean(string2, bl, n);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return bl;
        }
    }

    private int getCurrentOrCallingUserId() {
        if (this.mMultiUserMode) {
            return this.getCurrentUser();
        }
        return UserHandle.getCallingUserId();
    }

    private ILockSettings getLockSettings() {
        if (this.mLockSettingsService == null) {
            this.mLockSettingsService = LockPatternUtilsCache.getInstance(ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings")));
        }
        return this.mLockSettingsService;
    }

    private long getLong(String string2, long l) {
        try {
            long l2 = this.getLockSettings().getLong(string2, l, this.getCurrentOrCallingUserId());
            return l2;
        }
        catch (RemoteException remoteException) {
            return l;
        }
    }

    private long getLong(String string2, long l, int n) {
        try {
            long l2 = this.getLockSettings().getLong(string2, l, n);
            return l2;
        }
        catch (RemoteException remoteException) {
            return l;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSalt(int n) {
        long l = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L, n);
        if (l != 0L) return Long.toHexString(l);
        try {
            l = SecureRandom.getInstance("SHA1PRNG").nextLong();
            this.setLong(LOCK_PASSWORD_SALT_KEY, l, n);
            Log.v(TAG, "Initialized lock password salt for user: " + n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Couldn't get SecureRandom number", noSuchAlgorithmException);
        }
        return Long.toHexString(l);
    }

    private String getString(String string2) {
        return this.getString(string2, this.getCurrentOrCallingUserId());
    }

    private String getString(String string2, int n) {
        try {
            String string3 = this.getLockSettings().getString(string2, null, n);
            return string3;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private TelecomManager getTelecommManager() {
        return (TelecomManager)this.mContext.getSystemService("telecom");
    }

    private TrustManager getTrustManager() {
        TrustManager trustManager = (TrustManager)this.mContext.getSystemService("trust");
        if (trustManager == null) {
            Log.e(TAG, "Can't get TrustManagerService: is it running?", new IllegalStateException("Stack trace:"));
        }
        return trustManager;
    }

    public static boolean isDeviceEncrypted() {
        IMountService iMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        try {
            int n;
            return iMountService.getEncryptionState() != 1 && (n = iMountService.getPasswordType()) != 1;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error getting encryption state", remoteException);
            return true;
        }
    }

    public static boolean isDeviceEncryptionEnabled() {
        return "encrypted".equalsIgnoreCase(SystemProperties.get("ro.crypto.state", "unsupported"));
    }

    public static boolean isSafeModeEnabled() {
        try {
            boolean bl = IWindowManager.Stub.asInterface(ServiceManager.getService("window")).isSafeModeEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private static int maxDiffCategory(int n) {
        if (n == 0 || n == 1) {
            return 1;
        }
        if (n == 2) {
            return 10;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int maxLengthSequence(String string2) {
        if (string2.length() == 0) {
            return 0;
        }
        char c = string2.charAt(0);
        int n = LockPatternUtils.categoryChar(c);
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n5 < string2.length()) {
            char c2 = string2.charAt(n5);
            int n6 = LockPatternUtils.categoryChar(c2);
            int n7 = c2 - c;
            if (n6 != n || Math.abs(n7) > LockPatternUtils.maxDiffCategory(n)) {
                n3 = Math.max(n3, n5 - n4);
                n4 = n5;
                bl = false;
                n = n6;
            } else {
                if (bl && n7 != n2) {
                    n3 = Math.max(n3, n5 - n4);
                    n4 = n5 - 1;
                }
                n2 = n7;
                bl = true;
            }
            c = c2;
            ++n5;
        }
        return Math.max(n3, string2.length() - n4);
    }

    private void onAfterChangingPassword() {
        this.getTrustManager().reportEnabledTrustAgentsChanged(this.getCurrentOrCallingUserId());
    }

    public static byte[] patternToHash(List<LockPatternView.Cell> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            LockPatternView.Cell cell = list.get(i);
            byArray[i] = (byte)(3 * cell.getRow() + cell.getColumn());
        }
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA-1").digest(byArray);
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return byArray;
        }
    }

    public static String patternToString(List<LockPatternView.Cell> list) {
        if (list == null) {
            return "";
        }
        int n = list.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            LockPatternView.Cell cell = list.get(i);
            byArray[i] = (byte)(3 * cell.getRow() + cell.getColumn());
        }
        return new String(byArray);
    }

    private void setBoolean(String string2, boolean bl) {
        this.setBoolean(string2, bl, this.getCurrentOrCallingUserId());
    }

    private void setBoolean(String string2, boolean bl, int n) {
        try {
            this.getLockSettings().setBoolean(string2, bl, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Couldn't write boolean " + string2 + remoteException);
            return;
        }
    }

    private void setLong(String string2, long l) {
        this.setLong(string2, l, this.getCurrentOrCallingUserId());
    }

    private void setLong(String string2, long l, int n) {
        try {
            this.getLockSettings().setLong(string2, l, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Couldn't write long " + string2 + remoteException);
            return;
        }
    }

    private void setString(String string2, String string3, int n) {
        try {
            this.getLockSettings().setString(string2, string3, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Couldn't write string " + string2 + remoteException);
            return;
        }
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        ArrayList<LockPatternView.Cell> arrayList = Lists.newArrayList();
        byte[] byArray = string2.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            arrayList.add(LockPatternView.Cell.of(by / 3, by % 3));
        }
        return arrayList;
    }

    private static String toHex(byte[] byArray) {
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string3 = string2 + "0123456789ABCDEF".charAt(0xF & byArray[i] >> 4);
            string2 = string3 + "0123456789ABCDEF".charAt(0xF & byArray[i]);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateCryptoUserInfo() {
        int n = this.getCurrentOrCallingUserId();
        if (n != 0) {
            return;
        }
        String string2 = this.isOwnerInfoEnabled() ? this.getOwnerInfo(n) : "";
        IBinder iBinder = ServiceManager.getService("mount");
        if (iBinder == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IMountService iMountService = IMountService.Stub.asInterface(iBinder);
        try {
            Log.d(TAG, "Setting owner info");
            iMountService.setField("OwnerInfo", string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error changing user info", remoteException);
            return;
        }
    }

    private void updateEncryptionPassword(final int n, final String string2) {
        if (!LockPatternUtils.isDeviceEncryptionEnabled()) {
            return;
        }
        final IBinder iBinder = ServiceManager.getService("mount");
        if (iBinder == null) {
            Log.e(TAG, "Could not find the mount service to update the encryption password");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected Void doInBackground(Void ... voidArray) {
                IMountService iMountService = IMountService.Stub.asInterface(iBinder);
                try {
                    iMountService.changeEncryptionPassword(n, string2);
                    return null;
                }
                catch (RemoteException remoteException) {
                    Log.e(LockPatternUtils.TAG, "Error changing encryption password", remoteException);
                    return null;
                }
            }
        }.execute(new Void[0]);
    }

    private void writeAppWidgets(int[] nArray) {
        Settings.Secure.putStringForUser(this.mContentResolver, "lock_screen_appwidget_ids", LockPatternUtils.combineStrings(nArray, ","), -2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addAppWidget(int n, int n2) {
        int[] nArray = this.getAppWidgets();
        if (nArray == null || n2 < 0 || n2 > nArray.length) {
            return false;
        }
        int[] nArray2 = new int[1 + nArray.length];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= nArray2.length) {
                this.writeAppWidgets(nArray2);
                return true;
            }
            if (n2 == n3) {
                nArray2[n3] = n;
                ++n3;
            }
            if (n3 < nArray2.length) {
                nArray2[n3] = nArray[n4];
                ++n4;
            }
            ++n3;
        }
    }

    public boolean checkPassword(String string2) {
        int n = this.getCurrentOrCallingUserId();
        try {
            boolean bl = this.getLockSettings().checkPassword(string2, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return true;
        }
    }

    public boolean checkPasswordByUserId(String string2, int n) {
        try {
            boolean bl = this.getLockSettings().checkPasswordByUserId(string2, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkPasswordHistory(String string2) {
        int n;
        int n2;
        String string3;
        String string4;
        block5: {
            block4: {
                string4 = new String(this.passwordToHash(string2, this.getCurrentOrCallingUserId()));
                string3 = this.getString(PASSWORD_HISTORY_KEY);
                if (string3 == null) break block4;
                n2 = string4.length();
                n = this.getRequestedPasswordHistoryLength();
                if (n != 0) break block5;
            }
            return false;
        }
        int n3 = -1 + (n + n2 * n);
        if (string3.length() > n3) {
            string3 = string3.substring(0, n3);
        }
        return string3.contains(string4);
    }

    public boolean checkPattern(List<LockPatternView.Cell> list) {
        int n = this.getCurrentOrCallingUserId();
        try {
            boolean bl = this.getLockSettings().checkPattern(LockPatternUtils.patternToString(list), n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return true;
        }
    }

    public boolean checkPatternByUserId(List<LockPatternView.Cell> list, int n) {
        try {
            boolean bl = this.getLockSettings().checkPatternByUserId(LockPatternUtils.patternToString(list), n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return true;
        }
    }

    public boolean checkVoldPassword() {
        int n = this.getCurrentOrCallingUserId();
        try {
            boolean bl = this.getLockSettings().checkVoldPassword(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void clearCache() {
        try {
            this.getLockSettings().clearCache();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Couldn't clearCache " + remoteException);
            return;
        }
    }

    public void clearEncryptionPassword() {
        this.updateEncryptionPassword(1, null);
    }

    public void clearLock(boolean bl) {
        if (!bl) {
            this.deleteGallery();
        }
        this.saveLockPassword(null, 65536);
        this.setLockPatternEnabled(false);
        this.saveLockPattern(null);
        this.setLong(PASSWORD_TYPE_KEY, 0L);
        this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L);
        this.onAfterChangingPassword();
    }

    public void clearLockByUserId(boolean bl, int n) {
        if (!bl) {
            this.deleteGallery();
        }
        this.saveLockPassword(null, 65536, false, n);
        this.setLockPatternEnabledByUserId(false, n);
        this.saveLockPatternByUserId(null, false, n);
        this.setLong(PASSWORD_TYPE_KEY, 0L, n);
        this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L, n);
        this.getTrustManager().reportEnabledTrustAgentsChanged(n);
    }

    void deleteGallery() {
        if (this.usingBiometricWeak()) {
            Intent intent = new Intent().setAction("com.android.facelock.DELETE_GALLERY");
            intent.putExtra("deleteGallery", true);
            this.mContext.sendBroadcast(intent);
        }
    }

    public void deleteTempGallery() {
        Intent intent = new Intent().setAction("com.android.facelock.DELETE_GALLERY");
        intent.putExtra("deleteTempGallery", true);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getActivePasswordQuality() {
        switch ((int)this.getLong(PASSWORD_TYPE_KEY, 65536L)) {
            case 65536: {
                if (!this.isLockPatternEnabled()) return 0;
                return 65536;
            }
            case 32768: {
                if (!this.isBiometricWeakInstalled()) return 0;
                return 32768;
            }
            case 131072: {
                if (!this.isLockPasswordEnabled()) return 0;
                return 131072;
            }
            case 196608: {
                if (!this.isLockPasswordEnabled()) return 0;
                return 196608;
            }
            case 262144: {
                if (!this.isLockPasswordEnabled()) return 0;
                return 262144;
            }
            case 327680: {
                if (!this.isLockPasswordEnabled()) return 0;
                return 327680;
            }
            default: {
                return 0;
            }
            case 393216: 
        }
        if (!this.isLockPasswordEnabled()) return 0;
        return 393216;
    }

    public int[] getAppWidgets() {
        return this.getAppWidgets(-2);
    }

    public int getCurrentUser() {
        if (sCurrentUserId != -10000) {
            return sCurrentUserId;
        }
        try {
            int n = ActivityManagerNative.getDefault().getCurrentUser().id;
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    public List<ComponentName> getEnabledTrustAgents() {
        return this.getEnabledTrustAgents(this.getCurrentOrCallingUserId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ComponentName> getEnabledTrustAgents(int n) {
        String string2 = this.getString(ENABLED_TRUST_AGENTS, n);
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        String[] stringArray = string2.split(",");
        ArrayList<ComponentName> arrayList = new ArrayList<ComponentName>(stringArray.length);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringArray[n3];
            if (!TextUtils.isEmpty(string3)) {
                arrayList.add(ComponentName.unflattenFromString(string3));
            }
            ++n3;
        }
        return arrayList;
    }

    public int getFallbackAppWidgetId() {
        return Settings.Secure.getIntForUser(this.mContentResolver, "lock_screen_fallback_appwidget_id", 0, -2);
    }

    public int getKeyguardStoredPasswordQuality() {
        return this.getKeyguardStoredPasswordQuality(this.getCurrentOrCallingUserId());
    }

    public int getKeyguardStoredPasswordQuality(int n) {
        int n2 = (int)this.getLong(PASSWORD_TYPE_KEY, 0L, n);
        if (n2 == 32768) {
            n2 = (int)this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L, n);
        }
        return n2;
    }

    public long getLockoutAttemptDeadline() {
        long l;
        long l2 = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L);
        if (l2 < (l = SystemClock.elapsedRealtime()) || l2 > 30000L + l) {
            l2 = 0L;
        }
        return l2;
    }

    public AlarmManager.AlarmClockInfo getNextAlarm() {
        return ((AlarmManager)this.mContext.getSystemService("alarm")).getNextAlarmClock(-2);
    }

    public String getOwnerInfo(int n) {
        return this.getString(LOCK_SCREEN_OWNER_INFO);
    }

    public boolean getPowerButtonInstantlyLocks() {
        return this.getBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, true);
    }

    public int getRequestedMinimumPasswordLength() {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordHistoryLength() {
        return this.getDevicePolicyManager().getPasswordHistoryLength(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordLength() {
        return this.getDevicePolicyManager().getPasswordLength(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordLengthByUserId(int n) {
        return this.getDevicePolicyManager().getPasswordLength(null, n);
    }

    public int getRequestedPasswordMinimumLetters() {
        return this.getDevicePolicyManager().getPasswordMinimumLetters(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumLowerCase() {
        return this.getDevicePolicyManager().getPasswordMinimumLowerCase(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumNonLetter() {
        return this.getDevicePolicyManager().getPasswordMinimumNonLetter(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumNumeric() {
        return this.getDevicePolicyManager().getPasswordMinimumNumeric(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumSymbols() {
        return this.getDevicePolicyManager().getPasswordMinimumSymbols(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordMinimumUpperCase() {
        return this.getDevicePolicyManager().getPasswordMinimumUpperCase(null, this.getCurrentOrCallingUserId());
    }

    public int getRequestedPasswordQuality() {
        return this.getDevicePolicyManager().getPasswordQuality(null, this.getCurrentOrCallingUserId());
    }

    public boolean getSimplePasswordEnabled() {
        return this.getDevicePolicyManager().getSimplePasswordEnabled(null);
    }

    public boolean getWidgetsEnabled() {
        return this.getWidgetsEnabled(this.getCurrentOrCallingUserId());
    }

    public boolean getWidgetsEnabled(int n) {
        return this.getBoolean(LOCKSCREEN_WIDGETS_ENABLED, false, n);
    }

    public boolean hasWidgetsEnabledInKeyguard(int n) {
        int[] nArray = this.getAppWidgets(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isBiometricWeakEverChosen() {
        return this.getBoolean(BIOMETRIC_WEAK_EVER_CHOSEN_KEY, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBiometricWeakInstalled() {
        block3: {
            PackageManager packageManager = this.mContext.getPackageManager();
            try {
                packageManager.getPackageInfo("com.android.facelock", 1);
                if (packageManager.hasSystemFeature("android.hardware.camera.front")) break block3;
                return false;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
        }
        if (this.getDevicePolicyManager().getCameraDisabled(null, this.getCurrentOrCallingUserId())) return false;
        return false;
    }

    public boolean isBiometricWeakLivelinessEnabled() {
        return (1L & this.getLong("lock_biometric_weak_flags", 0L)) != 0L;
    }

    public boolean isCredentialRequiredToDecrypt(boolean bl) {
        int n = Settings.Global.getInt(this.mContentResolver, "require_password_to_decrypt", -1);
        if (n == -1) {
            return bl;
        }
        return n != 0;
    }

    public boolean isEmergencyCallCapable() {
        return this.mContext.getResources().getBoolean(17956931);
    }

    public boolean isEmergencyCallEnabledWhileSimLocked() {
        return this.mContext.getResources().getBoolean(17956918);
    }

    public boolean isInCall() {
        return this.getTelecommManager().isInCall();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLockPasswordEnabled() {
        long l = this.getLong(PASSWORD_TYPE_KEY, 0L);
        long l2 = this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L);
        boolean bl = l == 262144L || l == 131072L || l == 196608L || l == 327680L || l == 393216L;
        boolean bl2 = l2 == 262144L || l2 == 131072L || l2 == 196608L || l2 == 327680L || l2 == 393216L;
        return this.savedPasswordExists() && (bl || this.usingBiometricWeak() && bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLockPatternEnabled() {
        boolean bl;
        if (this.getLong(PASSWORD_TYPE_ALTERNATE_KEY, 0L) == 65536L) {
            bl = true;
            return this.getBoolean("lock_pattern_autolock", false) && (this.getLong(PASSWORD_TYPE_KEY, 0L) == 65536L || this.usingBiometricWeak() && bl);
        }
        bl = false;
        return this.getBoolean("lock_pattern_autolock", false) && (this.getLong(PASSWORD_TYPE_KEY, 0L) == 65536L || this.usingBiometricWeak() && bl);
    }

    public boolean isLockScreenDisabled() {
        if (!this.isSecure() && this.getLong(DISABLE_LOCKSCREEN_KEY, 0L) != 0L) {
            List<UserInfo> list = UserManager.get(this.mContext).getUsers(true);
            int n = list.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!list.get(i).supportsSwitchTo()) continue;
                ++n2;
            }
            return n2 < 2;
        }
        return false;
    }

    public boolean isOwnerInfoEnabled() {
        return this.getBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, false);
    }

    public boolean isOwnerUser() {
        return this.getCurrentOrCallingUserId() == 0;
    }

    public boolean isPatternEverChosen() {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY, false);
    }

    public boolean isPatternEverChosenByUserId(int n) {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY, false, n);
    }

    public boolean isPermanentlyLocked() {
        return this.getBoolean(LOCKOUT_PERMANENT_KEY, false);
    }

    public boolean isPukUnlockScreenEnable() {
        return this.mContext.getResources().getBoolean(17956917);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isSecure() {
        long l = this.getKeyguardStoredPasswordQuality();
        boolean bl = l == 65536L;
        boolean bl2 = l == 131072L || l == 196608L || l == 262144L || l == 327680L || l == 393216L;
        return bl && this.isLockPatternEnabled() && this.savedPatternExists() || bl2 && this.savedPasswordExists();
    }

    public boolean isTactileFeedbackEnabled() {
        return Settings.System.getIntForUser(this.mContentResolver, "haptic_feedback_enabled", 1, -2) != 0;
    }

    public boolean isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern", false);
    }

    public byte[] passwordToHash(String string2, int n) {
        byte[] byArray;
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        try {
            byArray = (string2 + this.getSalt(n)).getBytes();
            string3 = "SHA-1";
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w(TAG, "Failed to encode string because of missing algorithm: " + string3);
            return null;
        }
        byte[] byArray2 = MessageDigest.getInstance(string3).digest(byArray);
        string3 = "MD5";
        byte[] byArray3 = MessageDigest.getInstance(string3).digest(byArray);
        byte[] byArray4 = (LockPatternUtils.toHex(byArray2) + LockPatternUtils.toHex(byArray3)).getBytes();
        return byArray4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean removeAppWidget(int n) {
        int[] nArray = this.getAppWidgets();
        if (nArray.length != 0) {
            int[] nArray2 = new int[-1 + nArray.length];
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n2 >= nArray.length) {
                    this.writeAppWidgets(nArray2);
                    return true;
                }
                if (nArray[n2] != n) {
                    if (n3 >= nArray2.length) break;
                    nArray2[n3] = nArray[n2];
                    ++n3;
                }
                ++n2;
            }
        }
        return false;
    }

    public void removeUser(int n) {
        try {
            this.getLockSettings().removeUser(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Couldn't remove lock settings for user " + n);
            return;
        }
    }

    public void reportFailedPasswordAttempt() {
        int n = this.getCurrentOrCallingUserId();
        this.getDevicePolicyManager().reportFailedPasswordAttempt(n);
        this.getTrustManager().reportUnlockAttempt(false, n);
        this.getTrustManager().reportRequireCredentialEntry(n);
    }

    public void reportSuccessfulPasswordAttempt() {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt(this.getCurrentOrCallingUserId());
        this.getTrustManager().reportUnlockAttempt(true, this.getCurrentOrCallingUserId());
    }

    public void requireCredentialEntry(int n) {
        this.getTrustManager().reportRequireCredentialEntry(n);
    }

    public void resumeCall() {
        this.getTelecommManager().showInCallScreen(false);
    }

    public void saveLockPassword(String string2, int n) {
        this.saveLockPassword(string2, n, false, this.getCurrentOrCallingUserId());
    }

    public void saveLockPassword(String string2, int n, boolean bl) {
        this.saveLockPassword(string2, n, bl, this.getCurrentOrCallingUserId());
    }

    public void saveLockPassword(String string2, int n, boolean bl, int n2) {
        this.saveLockPassword(string2, n, bl, true, n2);
    }

    public void saveLockPassword(String string2, int n, boolean bl, boolean bl2) {
        this.saveLockPassword(string2, n, bl, bl2, this.getCurrentOrCallingUserId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLockPassword(String var1_1, int var2_2, boolean var3_3, boolean var4_4, int var5_5) {
        block26: {
            block27: {
                block23: {
                    block25: {
                        block24: {
                            block22: {
                                try {
                                    var8_6 = this.getDevicePolicyManager();
                                    if (!TextUtils.isEmpty(var1_1)) {
                                        this.getLockSettings().setLockPassword(var1_1, var5_5);
                                        var9_7 = LockPatternUtils.computePasswordQuality(var1_1);
                                        if (var5_5 != 0 || !LockPatternUtils.isDeviceEncryptionEnabled()) break block22;
                                        if (this.isCredentialRequiredToDecrypt(true)) break block23;
                                        this.clearEncryptionPassword();
                                    }
                                    ** GOTO lbl83
                                }
                                catch (RemoteException var6_20) {
                                    Log.e("LockPatternUtils", "Unable to save lock password " + var6_20);
                                    return;
                                }
                            }
lbl16:
                            // 2 sources

                            while (!var3_3) {
                                this.deleteGallery();
                                this.setLong("lockscreen.password_type", Math.max(var2_2, var9_7), var5_5);
                                if (var9_7 == 0) ** GOTO lbl76
                                var15_11 = 0;
                                var16_12 = 0;
                                var17_13 = 0;
                                var18_14 = 0;
                                var19_15 = 0;
                                var20_16 = 0;
                                var21_17 = 0;
lbl27:
                                // 2 sources

                                while (true) {
                                    var22_18 = var1_1.length();
                                    if (var21_17 < var22_18) {
                                        var23_19 = var1_1.charAt(var21_17);
                                        if (var23_19 < 'A' || var23_19 > 'Z') break block24;
                                        ++var15_11;
                                        ++var16_12;
                                        break block25;
                                    }
                                    ** GOTO lbl-1000
                                    break;
                                }
                            }
                            ** GOTO lbl78
lbl37:
                            // 2 sources

                            while (true) {
                                this.updateEncryptionPassword(var26_10, var1_1);
                                ** GOTO lbl16
                                break;
                            }
lbl40:
                            // 1 sources

                            while (true) {
                                var24_8 = false;
lbl42:
                                // 2 sources

                                while (var9_7 != 196608) {
                                    var25_9 = false;
lbl44:
                                    // 2 sources

                                    while (!var24_8 && !var25_9) {
                                        var26_10 = 0;
                                        ** GOTO lbl37
                                    }
                                    break block26;
                                }
                                break block27;
                                break;
                            }
                        }
                        if (var23_19 >= 'a' && var23_19 <= 'z') {
                            ++var15_11;
                            ++var17_13;
                            break block25;
                        } else if (var23_19 >= '0' && var23_19 <= '9') {
                            ++var18_14;
                            ++var20_16;
                            break block25;
                        } else {
                            ++var19_15;
                            ++var20_16;
                        }
                        break block25;
lbl-1000:
                        // 1 sources

                        {
                            var8_6.setActivePasswordState(Math.max(var2_2, var9_7), var1_1.length(), var15_11, var16_12, var17_13, var18_14, var19_15, var20_16, var4_4, var5_5);
lbl62:
                            // 3 sources

                            while (true) {
                                var10_21 = this.getString("lockscreen.passwordhistory", var5_5);
                                if (var10_21 == null) {
                                    var10_21 = new String();
                                }
                                if ((var11_22 = this.getRequestedPasswordHistoryLength()) == 0) {
                                    var14_23 = "";
                                } else {
                                    var12_24 = this.passwordToHash(var1_1, var5_5);
                                    var13_25 = new String(var12_24) + "," + var10_21;
                                    var14_23 = var13_25.substring(0, Math.min(-1 + (var11_22 + var11_22 * var12_24.length), var13_25.length()));
                                }
                                this.setString("lockscreen.passwordhistory", var14_23, var5_5);
lbl73:
                                // 2 sources

                                while (true) {
                                    this.onAfterChangingPassword();
                                    return;
                                }
                                break;
                            }
lbl76:
                            // 1 sources

                            var8_6.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, true, var5_5);
                            ** GOTO lbl62
lbl78:
                            // 1 sources

                            this.setLong("lockscreen.password_type", 32768L, var5_5);
                            this.setLong("lockscreen.password_type_alternate", Math.max(var2_2, var9_7), var5_5);
                            this.finishBiometricWeak();
                            var8_6.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, true, var5_5);
                            ** continue;
lbl83:
                            // 1 sources

                            this.getLockSettings().setLockPassword(null, var5_5);
                            if (var5_5 == 0) {
                                this.updateEncryptionPassword(1, null);
                            }
                            var8_6.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, var5_5);
                            ** continue;
                        }
                    }
                    ++var21_17;
                    ** while (true)
                }
                ** while (var9_7 != 131072)
lbl93:
                // 1 sources

                var24_8 = true;
                ** GOTO lbl42
            }
            var25_9 = true;
            ** GOTO lbl44
        }
        var26_10 = 3;
        ** while (true)
    }

    public void saveLockPattern(List<LockPatternView.Cell> list) {
        this.saveLockPattern(list, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLockPattern(List<LockPatternView.Cell> list, boolean bl) {
        block9: {
            DevicePolicyManager devicePolicyManager;
            int n;
            block8: {
                try {
                    n = this.getCurrentOrCallingUserId();
                    this.getLockSettings().setLockPattern(LockPatternUtils.patternToString(list), n);
                    devicePolicyManager = this.getDevicePolicyManager();
                    if (list == null) break block8;
                    if (n == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                        if (!this.isCredentialRequiredToDecrypt(true)) {
                            this.clearEncryptionPassword();
                        } else {
                            this.updateEncryptionPassword(2, LockPatternUtils.patternToString(list));
                        }
                    }
                    this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true);
                    if (!bl) {
                        this.deleteGallery();
                        this.setLong(PASSWORD_TYPE_KEY, 65536L);
                        devicePolicyManager.setActivePasswordState(65536, list.size(), 0, 0, 0, 0, 0, 0, n);
                        break block9;
                    } else {
                        this.setLong(PASSWORD_TYPE_KEY, 32768L);
                        this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, 65536L);
                        this.finishBiometricWeak();
                        devicePolicyManager.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, n);
                    }
                    break block9;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "Couldn't save lock pattern " + remoteException);
                    return;
                }
            }
            devicePolicyManager.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, n);
        }
        this.onAfterChangingPassword();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLockPatternByUserId(List<LockPatternView.Cell> list, boolean bl, int n) {
        block9: {
            DevicePolicyManager devicePolicyManager;
            block8: {
                try {
                    this.getLockSettings().setLockPattern(LockPatternUtils.patternToString(list), n);
                    devicePolicyManager = this.getDevicePolicyManager();
                    if (list == null) break block8;
                    if (n == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                        if (!this.isCredentialRequiredToDecrypt(true)) {
                            this.clearEncryptionPassword();
                        } else {
                            this.updateEncryptionPassword(2, LockPatternUtils.patternToString(list));
                        }
                    }
                    this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true, n);
                    if (!bl) {
                        this.deleteGallery();
                        this.setLong(PASSWORD_TYPE_KEY, 65536L, n);
                        devicePolicyManager.setActivePasswordState(65536, list.size(), 0, 0, 0, 0, 0, 0, n);
                        break block9;
                    } else {
                        this.setLong(PASSWORD_TYPE_KEY, 32768L, n);
                        this.setLong(PASSWORD_TYPE_ALTERNATE_KEY, 65536L, n);
                        this.finishBiometricWeak();
                        devicePolicyManager.setActivePasswordState(32768, 0, 0, 0, 0, 0, 0, 0, n);
                    }
                    break block9;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "Couldn't save lock pattern " + remoteException);
                    return;
                }
            }
            devicePolicyManager.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, n);
        }
        this.onAfterChangingPassword();
    }

    public boolean savedPasswordExists() {
        try {
            boolean bl = this.getLockSettings().havePassword(this.getCurrentOrCallingUserId());
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean savedPatternExists() {
        try {
            boolean bl = this.getLockSettings().havePattern(this.getCurrentOrCallingUserId());
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBiometricWeakLivelinessEnabled(boolean bl) {
        long l = this.getLong("lock_biometric_weak_flags", 0L);
        long l2 = bl ? l | 1L : l & 0xFFFFFFFFFFFFFFFEL;
        this.setLong("lock_biometric_weak_flags", l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCredentialRequiredToDecrypt(boolean bl) {
        if (this.getCurrentUser() != 0) {
            Log.w(TAG, "Only device owner may call setCredentialRequiredForDecrypt()");
            return;
        }
        ContentResolver contentResolver = this.mContext.getContentResolver();
        int n = bl ? 1 : 0;
        Settings.Global.putInt(contentResolver, "require_password_to_decrypt", n);
    }

    public void setCurrentUser(int n) {
        sCurrentUserId = n;
    }

    public void setEnabledTrustAgents(Collection<ComponentName> collection) {
        this.setEnabledTrustAgents(collection, this.getCurrentOrCallingUserId());
    }

    public void setEnabledTrustAgents(Collection<ComponentName> collection, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ComponentName componentName : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(componentName.flattenToShortString());
        }
        this.setString(ENABLED_TRUST_AGENTS, stringBuilder.toString(), n);
        this.getTrustManager().reportEnabledTrustAgentsChanged(this.getCurrentOrCallingUserId());
    }

    public void setLockPatternEnabled(boolean bl) {
        this.setBoolean("lock_pattern_autolock", bl);
    }

    public void setLockPatternEnabledByUserId(boolean bl, int n) {
        this.setBoolean("lock_pattern_autolock", bl, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLockScreenDisabled(boolean bl) {
        long l = bl ? 1L : 0L;
        this.setLong(DISABLE_LOCKSCREEN_KEY, l);
    }

    public long setLockoutAttemptDeadline() {
        long l = 30000L + SystemClock.elapsedRealtime();
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, l);
        return l;
    }

    public void setOwnerInfo(String string2, int n) {
        this.setString(LOCK_SCREEN_OWNER_INFO, string2, n);
        this.updateCryptoUserInfo();
    }

    public void setOwnerInfoEnabled(boolean bl) {
        this.setBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, bl);
        this.updateCryptoUserInfo();
    }

    public void setPermanentlyLocked(boolean bl) {
        this.setBoolean(LOCKOUT_PERMANENT_KEY, bl);
    }

    public void setPowerButtonInstantlyLocks(boolean bl) {
        this.setBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVisiblePatternEnabled(boolean bl) {
        this.setBoolean("lock_pattern_visible_pattern", bl);
        if (this.getCurrentOrCallingUserId() != 0) {
            return;
        }
        IBinder iBinder = ServiceManager.getService("mount");
        if (iBinder == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IMountService iMountService = IMountService.Stub.asInterface(iBinder);
        String string2 = bl ? "1" : "0";
        try {
            iMountService.setField("PatternVisible", string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error changing pattern visible state", remoteException);
            return;
        }
    }

    public void setVisiblePatternEnabledByUserId(boolean bl, int n) {
        this.setBoolean("lock_pattern_visible_pattern", bl, n);
    }

    public void setWidgetsEnabled(boolean bl) {
        this.setWidgetsEnabled(bl, this.getCurrentOrCallingUserId());
    }

    public void setWidgetsEnabled(boolean bl, int n) {
        this.setBoolean(LOCKSCREEN_WIDGETS_ENABLED, bl, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateEmergencyCallButtonState(Button button, boolean bl, boolean bl2) {
        int n;
        block2: {
            block1: {
                block0: {
                    if (!this.isEmergencyCallCapable() || !bl) break block0;
                    button.setVisibility(0);
                    if (!this.isInCall()) break block1;
                    n = 17040246;
                    int n2 = bl2 ? 17301636 : 0;
                    button.setCompoundDrawablesWithIntrinsicBounds(n2, 0, 0, 0);
                    break block2;
                }
                button.setVisibility(8);
                return;
            }
            n = 17040245;
            int n3 = bl2 ? 17302593 : 0;
            button.setCompoundDrawablesWithIntrinsicBounds(n3, 0, 0, 0);
        }
        button.setText(n);
    }

    public boolean usingBiometricWeak() {
        return (int)this.getLong(PASSWORD_TYPE_KEY, 0L) == 32768;
    }

    public void writeFallbackAppWidgetId(int n) {
        Settings.Secure.putIntForUser(this.mContentResolver, "lock_screen_fallback_appwidget_id", n, -2);
    }
}

