/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import com.android.internal.view.menu.ListMenuItemView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;

public class MenuPopupHelper
implements AdapterView.OnItemClickListener,
View.OnKeyListener,
ViewTreeObserver.OnGlobalLayoutListener,
PopupWindow.OnDismissListener,
View.OnAttachStateChangeListener,
MenuPresenter {
    static final int ITEM_LAYOUT = 17367207;
    private static final String TAG = "MenuPopupHelper";
    private final MenuAdapter mAdapter;
    private View mAnchorView;
    private int mContentWidth;
    private final Context mContext;
    private int mDropDownGravity = 0;
    boolean mForceShowIcon;
    private boolean mHasContentWidth;
    private final LayoutInflater mInflater;
    private ViewGroup mMeasureParent;
    private final MenuBuilder mMenu;
    private final boolean mOverflowOnly;
    private ListPopupWindow mPopup;
    private final int mPopupMaxWidth;
    private final int mPopupStyleAttr;
    private MenuPresenter.Callback mPresenterCallback;
    private ViewTreeObserver mTreeObserver;

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder) {
        this(context, menuBuilder, null, false, 0x1010300);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder, View view) {
        this(context, menuBuilder, view, false, 0x1010300);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder, View view, boolean bl, int n) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from(context);
        this.mMenu = menuBuilder;
        this.mAdapter = new MenuAdapter(this.mMenu);
        this.mOverflowOnly = bl;
        this.mPopupStyleAttr = n;
        Resources resources = context.getResources();
        this.mPopupMaxWidth = Math.max(resources.getDisplayMetrics().widthPixels / 2, resources.getDimensionPixelSize(17104905));
        this.mAnchorView = view;
        menuBuilder.addMenuPresenter(this, context);
    }

    private int measureContentWidth() {
        int n = 0;
        View view = null;
        int n2 = 0;
        MenuAdapter menuAdapter = this.mAdapter;
        int n3 = View.MeasureSpec.makeMeasureSpec(0, 0);
        int n4 = View.MeasureSpec.makeMeasureSpec(0, 0);
        int n5 = menuAdapter.getCount();
        int n6 = 0;
        while (true) {
            int n7;
            block8: {
                block7: {
                    if (n6 >= n5) break block7;
                    int n8 = menuAdapter.getItemViewType(n6);
                    if (n8 != n2) {
                        n2 = n8;
                        view = null;
                    }
                    if (this.mMeasureParent == null) {
                        this.mMeasureParent = new FrameLayout(this.mContext);
                    }
                    view = menuAdapter.getView(n6, view, this.mMeasureParent);
                    view.measure(n3, n4);
                    n7 = view.getMeasuredWidth();
                    if (n7 < this.mPopupMaxWidth) break block8;
                    n = this.mPopupMaxWidth;
                }
                return n;
            }
            if (n7 > n) {
                n = n7;
            }
            ++n6;
        }
    }

    @Override
    public boolean collapseItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
        return false;
    }

    public void dismiss() {
        if (this.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    @Override
    public boolean expandItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
        return false;
    }

    @Override
    public boolean flagActionItems() {
        return false;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public MenuView getMenuView(ViewGroup viewGroup) {
        throw new UnsupportedOperationException("MenuPopupHelpers manage their own views");
    }

    public ListPopupWindow getPopup() {
        return this.mPopup;
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
    }

    public boolean isShowing() {
        return this.mPopup != null && this.mPopup.isShowing();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        block3: {
            block2: {
                if (menuBuilder != this.mMenu) break block2;
                this.dismiss();
                if (this.mPresenterCallback != null) break block3;
            }
            return;
        }
        this.mPresenterCallback.onCloseMenu(menuBuilder, bl);
    }

    @Override
    public void onDismiss() {
        this.mPopup = null;
        this.mMenu.close();
        if (this.mTreeObserver != null) {
            if (!this.mTreeObserver.isAlive()) {
                this.mTreeObserver = this.mAnchorView.getViewTreeObserver();
            }
            this.mTreeObserver.removeGlobalOnLayoutListener(this);
            this.mTreeObserver = null;
        }
        this.mAnchorView.removeOnAttachStateChangeListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onGlobalLayout() {
        if (!this.isShowing()) return;
        View view = this.mAnchorView;
        if (view == null || !view.isShown()) {
            this.dismiss();
            return;
        } else {
            if (!this.isShowing()) return;
            this.mPopup.show();
            return;
        }
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        MenuAdapter menuAdapter = this.mAdapter;
        menuAdapter.mAdapterMenu.performItemAction(menuAdapter.getItem(n), 0);
    }

    @Override
    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        if (keyEvent.getAction() == 1 && n == 82) {
            this.dismiss();
            return true;
        }
        return false;
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return null;
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        block5: {
            if (!subMenuBuilder.hasVisibleItems()) break block5;
            MenuPopupHelper menuPopupHelper = new MenuPopupHelper(this.mContext, subMenuBuilder, this.mAnchorView);
            menuPopupHelper.setCallback(this.mPresenterCallback);
            int n = subMenuBuilder.size();
            int n2 = 0;
            while (true) {
                block7: {
                    boolean bl;
                    block6: {
                        bl = false;
                        if (n2 >= n) break block6;
                        MenuItem menuItem = subMenuBuilder.getItem(n2);
                        if (!menuItem.isVisible() || menuItem.getIcon() == null) break block7;
                        bl = true;
                    }
                    menuPopupHelper.setForceShowIcon(bl);
                    if (!menuPopupHelper.tryShow()) break;
                    if (this.mPresenterCallback != null) {
                        this.mPresenterCallback.onOpenSubMenu(subMenuBuilder);
                    }
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void onViewAttachedToWindow(View view) {
    }

    @Override
    public void onViewDetachedFromWindow(View view) {
        if (this.mTreeObserver != null) {
            if (!this.mTreeObserver.isAlive()) {
                this.mTreeObserver = view.getViewTreeObserver();
            }
            this.mTreeObserver.removeGlobalOnLayoutListener(this);
        }
        view.removeOnAttachStateChangeListener(this);
    }

    public void setAnchorView(View view) {
        this.mAnchorView = view;
    }

    @Override
    public void setCallback(MenuPresenter.Callback callback) {
        this.mPresenterCallback = callback;
    }

    public void setForceShowIcon(boolean bl) {
        this.mForceShowIcon = bl;
    }

    public void setGravity(int n) {
        this.mDropDownGravity = n;
    }

    public void show() {
        if (!this.tryShow()) {
            throw new IllegalStateException("MenuPopupHelper cannot be used without an anchor");
        }
    }

    public boolean tryShow() {
        this.mPopup = new ListPopupWindow(this.mContext, null, this.mPopupStyleAttr);
        this.mPopup.setOnDismissListener(this);
        this.mPopup.setOnItemClickListener(this);
        this.mPopup.setAdapter(this.mAdapter);
        this.mPopup.setModal(true);
        View view = this.mAnchorView;
        if (view != null) {
            ViewTreeObserver viewTreeObserver = this.mTreeObserver;
            boolean bl = false;
            if (viewTreeObserver == null) {
                bl = true;
            }
            this.mTreeObserver = view.getViewTreeObserver();
            if (bl) {
                this.mTreeObserver.addOnGlobalLayoutListener(this);
            }
            view.addOnAttachStateChangeListener(this);
            this.mPopup.setAnchorView(view);
            this.mPopup.setDropDownGravity(this.mDropDownGravity);
            if (!this.mHasContentWidth) {
                this.mContentWidth = this.measureContentWidth();
                this.mHasContentWidth = true;
            }
            this.mPopup.setContentWidth(this.mContentWidth);
            this.mPopup.setInputMethodMode(2);
            this.mPopup.show();
            this.mPopup.getListView().setOnKeyListener(this);
            return true;
        }
        return false;
    }

    @Override
    public void updateMenuView(boolean bl) {
        this.mHasContentWidth = false;
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private class MenuAdapter
    extends BaseAdapter {
        private MenuBuilder mAdapterMenu;
        private int mExpandedIndex = -1;

        public MenuAdapter(MenuBuilder menuBuilder) {
            this.mAdapterMenu = menuBuilder;
            this.findExpandedIndex();
        }

        void findExpandedIndex() {
            MenuItemImpl menuItemImpl = MenuPopupHelper.this.mMenu.getExpandedItem();
            if (menuItemImpl != null) {
                ArrayList<MenuItemImpl> arrayList = MenuPopupHelper.this.mMenu.getNonActionItems();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    if (arrayList.get(i) != menuItemImpl) continue;
                    this.mExpandedIndex = i;
                    return;
                }
            }
            this.mExpandedIndex = -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int getCount() {
            ArrayList<MenuItemImpl> arrayList = MenuPopupHelper.this.mOverflowOnly ? this.mAdapterMenu.getNonActionItems() : this.mAdapterMenu.getVisibleItems();
            if (this.mExpandedIndex < 0) {
                return arrayList.size();
            }
            return -1 + arrayList.size();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public MenuItemImpl getItem(int n) {
            ArrayList<MenuItemImpl> arrayList = MenuPopupHelper.this.mOverflowOnly ? this.mAdapterMenu.getNonActionItems() : this.mAdapterMenu.getVisibleItems();
            if (this.mExpandedIndex >= 0 && n >= this.mExpandedIndex) {
                ++n;
            }
            return arrayList.get(n);
        }

        @Override
        public long getItemId(int n) {
            return n;
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            if (view == null) {
                view = MenuPopupHelper.this.mInflater.inflate(17367207, viewGroup, false);
            }
            MenuView.ItemView itemView = (MenuView.ItemView)((Object)view);
            if (MenuPopupHelper.this.mForceShowIcon) {
                ((ListMenuItemView)view).setForceShowIcon(true);
            }
            itemView.initialize(this.getItem(n), 0);
            return view;
        }

        @Override
        public void notifyDataSetChanged() {
            this.findExpandedIndex();
            super.notifyDataSetChanged();
        }
    }
}

