/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewDebug;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public final class IconMenuItemView
extends TextView
implements MenuView.ItemView {
    private static final int NO_ALPHA = 255;
    private static String sPrependShortcutLabel;
    private float mDisabledAlpha;
    private Drawable mIcon;
    private IconMenuView mIconMenuView;
    private MenuItemImpl mItemData;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private Rect mPositionIconAvailable = new Rect();
    private Rect mPositionIconOutput = new Rect();
    private String mShortcutCaption;
    private boolean mShortcutCaptionMode;
    private int mTextAppearance;
    private Context mTextAppearanceContext;

    public IconMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public IconMenuItemView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public IconMenuItemView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        if (sPrependShortcutLabel == null) {
            sPrependShortcutLabel = this.getResources().getString(17040432);
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MenuView, n, n2);
        this.mDisabledAlpha = typedArray.getFloat(6, 0.8f);
        this.mTextAppearance = typedArray.getResourceId(1, -1);
        this.mTextAppearanceContext = context;
        typedArray.recycle();
    }

    private void positionIcon() {
        if (this.mIcon == null) {
            return;
        }
        Rect rect = this.mPositionIconOutput;
        this.getLineBounds(0, rect);
        this.mPositionIconAvailable.set(0, 0, this.getWidth(), rect.top);
        int n = this.getLayoutDirection();
        Gravity.apply(8388627, this.mIcon.getIntrinsicWidth(), this.mIcon.getIntrinsicHeight(), this.mPositionIconAvailable, this.mPositionIconOutput, n);
        this.mIcon.setBounds(this.mPositionIconOutput);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mItemData != null && this.mIcon != null) {
            boolean bl = !this.mItemData.isEnabled() && (this.isPressed() || !this.isFocused());
            Drawable drawable2 = this.mIcon;
            int n = bl ? (int)(255.0f * this.mDisabledAlpha) : 255;
            drawable2.setAlpha(n);
        }
    }

    @Override
    @ViewDebug.CapturedViewProperty(retrieveReturn=true)
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    IconMenuView.LayoutParams getTextAppropriateLayoutParams() {
        IconMenuView.LayoutParams layoutParams = (IconMenuView.LayoutParams)this.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new IconMenuView.LayoutParams(-1, -1);
        }
        layoutParams.desiredWidth = (int)Layout.getDesiredWidth(this.getText(), this.getPaint());
        return layoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        this.mItemData = menuItemImpl;
        this.initialize(menuItemImpl.getTitleForItemView(this), menuItemImpl.getIcon());
        int n2 = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n2);
        this.setEnabled(menuItemImpl.isEnabled());
    }

    void initialize(CharSequence charSequence, Drawable drawable2) {
        this.setClickable(true);
        this.setFocusable(true);
        if (this.mTextAppearance != -1) {
            this.setTextAppearance(this.mTextAppearanceContext, this.mTextAppearance);
        }
        this.setTitle(charSequence);
        this.setIcon(drawable2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.positionIcon();
    }

    @Override
    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        super.onTextChanged(charSequence, n, n2, n3);
        this.setLayoutParams(this.getTextAppropriateLayoutParams());
    }

    @Override
    public boolean performClick() {
        if (super.performClick()) {
            return true;
        }
        if (this.mItemInvoker != null && this.mItemInvoker.invokeItem(this.mItemData)) {
            this.playSoundEffect(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean prefersCondensedTitle() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCaptionMode(boolean bl) {
        if (this.mItemData == null) {
            return;
        }
        boolean bl2 = bl && this.mItemData.shouldShowShortcut();
        this.mShortcutCaptionMode = bl2;
        CharSequence charSequence = this.mItemData.getTitleForItemView(this);
        if (this.mShortcutCaptionMode) {
            if (this.mShortcutCaption == null) {
                this.mShortcutCaption = this.mItemData.getShortcutLabel();
            }
            charSequence = this.mShortcutCaption;
        }
        this.setText(charSequence);
    }

    @Override
    public void setCheckable(boolean bl) {
    }

    @Override
    public void setChecked(boolean bl) {
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (drawable2 != null) {
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            this.setCompoundDrawables(null, drawable2, null, null);
            this.setGravity(81);
            this.requestLayout();
            return;
        }
        this.setCompoundDrawables(null, null, null, null);
        this.setGravity(17);
    }

    void setIconMenuView(IconMenuView iconMenuView) {
        this.mIconMenuView = iconMenuView;
    }

    public void setItemData(MenuItemImpl menuItemImpl) {
        this.mItemData = menuItemImpl;
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        this.mItemInvoker = itemInvoker;
    }

    @Override
    public void setShortcut(boolean bl, char c) {
        if (this.mShortcutCaptionMode) {
            this.mShortcutCaption = null;
            this.setCaptionMode(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setTitle(CharSequence charSequence) {
        if (this.mShortcutCaptionMode) {
            this.setCaptionMode(true);
            return;
        } else {
            if (charSequence == null) return;
            this.setText(charSequence);
            return;
        }
    }

    @Override
    public void setVisibility(int n) {
        super.setVisibility(n);
        if (this.mIconMenuView != null) {
            this.mIconMenuView.markStaleChildren();
        }
    }

    @Override
    public boolean showsIcon() {
        return true;
    }
}

