/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.InputChannel;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;

public interface IInputMethod
extends IInterface {
    public void attachToken(IBinder var1) throws RemoteException;

    public void bindInput(InputBinding var1) throws RemoteException;

    public void changeInputMethodSubtype(InputMethodSubtype var1) throws RemoteException;

    public void createSession(InputChannel var1, IInputSessionCallback var2) throws RemoteException;

    public void hideSoftInput(int var1, ResultReceiver var2) throws RemoteException;

    public void restartInput(IInputContext var1, EditorInfo var2) throws RemoteException;

    public void revokeSession(IInputMethodSession var1) throws RemoteException;

    public void setSessionEnabled(IInputMethodSession var1, boolean var2) throws RemoteException;

    public void showSoftInput(int var1, ResultReceiver var2) throws RemoteException;

    public void startInput(IInputContext var1, EditorInfo var2) throws RemoteException;

    public void unbindInput() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethod {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputMethod";
        static final int TRANSACTION_attachToken = 1;
        static final int TRANSACTION_bindInput = 2;
        static final int TRANSACTION_changeInputMethodSubtype = 11;
        static final int TRANSACTION_createSession = 6;
        static final int TRANSACTION_hideSoftInput = 10;
        static final int TRANSACTION_restartInput = 5;
        static final int TRANSACTION_revokeSession = 8;
        static final int TRANSACTION_setSessionEnabled = 7;
        static final int TRANSACTION_showSoftInput = 9;
        static final int TRANSACTION_startInput = 4;
        static final int TRANSACTION_unbindInput = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputMethod asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IInputMethod) {
                return (IInputMethod)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.attachToken(parcel.readStrongBinder());
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputBinding inputBinding = parcel.readInt() != 0 ? InputBinding.CREATOR.createFromParcel(parcel) : null;
                    this.bindInput(inputBinding);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unbindInput();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputContext iInputContext = IInputContext.Stub.asInterface(parcel.readStrongBinder());
                    EditorInfo editorInfo = parcel.readInt() != 0 ? EditorInfo.CREATOR.createFromParcel(parcel) : null;
                    this.startInput(iInputContext, editorInfo);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputContext iInputContext = IInputContext.Stub.asInterface(parcel.readStrongBinder());
                    EditorInfo editorInfo = parcel.readInt() != 0 ? EditorInfo.CREATOR.createFromParcel(parcel) : null;
                    this.restartInput(iInputContext, editorInfo);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputChannel inputChannel = parcel.readInt() != 0 ? InputChannel.CREATOR.createFromParcel(parcel) : null;
                    this.createSession(inputChannel, IInputSessionCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodSession iInputMethodSession = IInputMethodSession.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = parcel.readInt() != 0;
                    this.setSessionEnabled(iInputMethodSession, bl);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.revokeSession(IInputMethodSession.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    ResultReceiver resultReceiver = parcel.readInt() != 0 ? ResultReceiver.CREATOR.createFromParcel(parcel) : null;
                    this.showSoftInput(n3, resultReceiver);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    ResultReceiver resultReceiver = parcel.readInt() != 0 ? ResultReceiver.CREATOR.createFromParcel(parcel) : null;
                    this.hideSoftInput(n4, resultReceiver);
                    return true;
                }
                case 11: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            InputMethodSubtype inputMethodSubtype = parcel.readInt() != 0 ? InputMethodSubtype.CREATOR.createFromParcel(parcel) : null;
            this.changeInputMethodSubtype(inputMethodSubtype);
            return true;
        }

        private static class Proxy
        implements IInputMethod {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void attachToken(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void bindInput(InputBinding inputBinding) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (inputBinding != null) {
                        parcel.writeInt(1);
                        inputBinding.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void changeInputMethodSubtype(InputMethodSubtype inputMethodSubtype) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (inputMethodSubtype != null) {
                        parcel.writeInt(1);
                        inputMethodSubtype.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(11, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void createSession(InputChannel inputChannel, IInputSessionCallback iInputSessionCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (inputChannel != null) {
                        parcel.writeInt(1);
                        inputChannel.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    IBinder iBinder = null;
                    if (iInputSessionCallback != null) {
                        iBinder = iInputSessionCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void hideSoftInput(int n, ResultReceiver resultReceiver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (resultReceiver != null) {
                        parcel.writeInt(1);
                        resultReceiver.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void restartInput(IInputContext iInputContext, EditorInfo editorInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iInputContext != null) {
                        iBinder = iInputContext.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    if (editorInfo != null) {
                        parcel.writeInt(1);
                        editorInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void revokeSession(IInputMethodSession iInputMethodSession) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iInputMethodSession != null) {
                        iBinder = iInputMethodSession.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setSessionEnabled(IInputMethodSession iInputMethodSession, boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iInputMethodSession != null) {
                        iBinder = iInputMethodSession.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void showSoftInput(int n, ResultReceiver resultReceiver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (resultReceiver != null) {
                        parcel.writeInt(1);
                        resultReceiver.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void startInput(IInputContext iInputContext, EditorInfo editorInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iInputContext != null) {
                        iBinder = iInputContext.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    if (editorInfo != null) {
                        parcel.writeInt(1);
                        editorInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void unbindInput() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

