/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputContextCallback;
import java.lang.ref.WeakReference;

public class IInputConnectionWrapper
extends IInputContext.Stub {
    private static final int DO_BEGIN_BATCH_EDIT = 90;
    private static final int DO_CLEAR_META_KEY_STATES = 130;
    private static final int DO_COMMIT_COMPLETION = 55;
    private static final int DO_COMMIT_CORRECTION = 56;
    private static final int DO_COMMIT_TEXT = 50;
    private static final int DO_DELETE_SURROUNDING_TEXT = 80;
    private static final int DO_END_BATCH_EDIT = 95;
    private static final int DO_FINISH_COMPOSING_TEXT = 65;
    private static final int DO_GET_CURSOR_CAPS_MODE = 30;
    private static final int DO_GET_EXTRACTED_TEXT = 40;
    private static final int DO_GET_SELECTED_TEXT = 25;
    private static final int DO_GET_TEXT_AFTER_CURSOR = 10;
    private static final int DO_GET_TEXT_BEFORE_CURSOR = 20;
    private static final int DO_PERFORM_CONTEXT_MENU_ACTION = 59;
    private static final int DO_PERFORM_EDITOR_ACTION = 58;
    private static final int DO_PERFORM_PRIVATE_COMMAND = 120;
    private static final int DO_REPORT_FULLSCREEN_MODE = 100;
    private static final int DO_REQUEST_UPDATE_CURSOR_ANCHOR_INFO = 140;
    private static final int DO_SEND_KEY_EVENT = 70;
    private static final int DO_SET_COMPOSING_REGION = 63;
    private static final int DO_SET_COMPOSING_TEXT = 60;
    private static final int DO_SET_SELECTION = 57;
    static final String TAG = "IInputConnectionWrapper";
    private Handler mH;
    private WeakReference<InputConnection> mInputConnection;
    private Looper mMainLooper;

    public IInputConnectionWrapper(Looper looper, InputConnection inputConnection) {
        this.mInputConnection = new WeakReference<InputConnection>(inputConnection);
        this.mMainLooper = looper;
        this.mH = new MyHandler(this.mMainLooper);
    }

    @Override
    public void beginBatchEdit() {
        this.dispatchMessage(this.obtainMessage(90));
    }

    @Override
    public void clearMetaKeyStates(int n) {
        this.dispatchMessage(this.obtainMessageII(130, n, 0));
    }

    @Override
    public void commitCompletion(CompletionInfo completionInfo) {
        this.dispatchMessage(this.obtainMessageO(55, completionInfo));
    }

    @Override
    public void commitCorrection(CorrectionInfo correctionInfo) {
        this.dispatchMessage(this.obtainMessageO(56, correctionInfo));
    }

    @Override
    public void commitText(CharSequence charSequence, int n) {
        this.dispatchMessage(this.obtainMessageIO(50, n, charSequence));
    }

    @Override
    public void deleteSurroundingText(int n, int n2) {
        this.dispatchMessage(this.obtainMessageII(80, n, n2));
    }

    void dispatchMessage(Message message) {
        if (Looper.myLooper() == this.mMainLooper) {
            this.executeMessage(message);
            message.recycle();
            return;
        }
        this.mH.sendMessage(message);
    }

    @Override
    public void endBatchEdit() {
        this.dispatchMessage(this.obtainMessage(95));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void executeMessage(Message message) {
        InputConnection inputConnection;
        int n = 1;
        switch (message.what) {
            default: {
                Log.w(TAG, "Unhandled message code: " + message.what);
                return;
            }
            case 10: {
                InputConnection inputConnection2;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection2 = (InputConnection)this.mInputConnection.get();
                    if (inputConnection2 == null || !this.isActive()) {
                        Log.w(TAG, "getTextAfterCursor on inactive InputConnection");
                        someArgs.callback.setTextAfterCursor(null, someArgs.seq);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "Got RemoteException calling setTextAfterCursor", remoteException);
                    return;
                }
                {
                    someArgs.callback.setTextAfterCursor(inputConnection2.getTextAfterCursor(message.arg1, message.arg2), someArgs.seq);
                    return;
                }
            }
            case 20: {
                InputConnection inputConnection3;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection3 = (InputConnection)this.mInputConnection.get();
                    if (inputConnection3 == null || !this.isActive()) {
                        Log.w(TAG, "getTextBeforeCursor on inactive InputConnection");
                        someArgs.callback.setTextBeforeCursor(null, someArgs.seq);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "Got RemoteException calling setTextBeforeCursor", remoteException);
                    return;
                }
                {
                    someArgs.callback.setTextBeforeCursor(inputConnection3.getTextBeforeCursor(message.arg1, message.arg2), someArgs.seq);
                    return;
                }
            }
            case 25: {
                InputConnection inputConnection4;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection4 = (InputConnection)this.mInputConnection.get();
                    if (inputConnection4 == null || !this.isActive()) {
                        Log.w(TAG, "getSelectedText on inactive InputConnection");
                        someArgs.callback.setSelectedText(null, someArgs.seq);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "Got RemoteException calling setSelectedText", remoteException);
                    return;
                }
                {
                    someArgs.callback.setSelectedText(inputConnection4.getSelectedText(message.arg1), someArgs.seq);
                    return;
                }
            }
            case 30: {
                InputConnection inputConnection5;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection5 = (InputConnection)this.mInputConnection.get();
                    if (inputConnection5 == null || !this.isActive()) {
                        Log.w(TAG, "getCursorCapsMode on inactive InputConnection");
                        someArgs.callback.setCursorCapsMode(0, someArgs.seq);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "Got RemoteException calling setCursorCapsMode", remoteException);
                    return;
                }
                {
                    someArgs.callback.setCursorCapsMode(inputConnection5.getCursorCapsMode(message.arg1), someArgs.seq);
                    return;
                }
            }
            case 40: {
                InputConnection inputConnection6;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    inputConnection6 = (InputConnection)this.mInputConnection.get();
                    if (inputConnection6 == null || !this.isActive()) {
                        Log.w(TAG, "getExtractedText on inactive InputConnection");
                        someArgs.callback.setExtractedText(null, someArgs.seq);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "Got RemoteException calling setExtractedText", remoteException);
                    return;
                }
                {
                    someArgs.callback.setExtractedText(inputConnection6.getExtractedText((ExtractedTextRequest)someArgs.arg1, message.arg1), someArgs.seq);
                    return;
                }
            }
            case 50: {
                InputConnection inputConnection7 = (InputConnection)this.mInputConnection.get();
                if (inputConnection7 != null && this.isActive()) {
                    inputConnection7.commitText((CharSequence)message.obj, message.arg1);
                    return;
                }
                Log.w(TAG, "commitText on inactive InputConnection");
                return;
            }
            case 57: {
                InputConnection inputConnection8 = (InputConnection)this.mInputConnection.get();
                if (inputConnection8 != null && this.isActive()) {
                    inputConnection8.setSelection(message.arg1, message.arg2);
                    return;
                }
                Log.w(TAG, "setSelection on inactive InputConnection");
                return;
            }
            case 58: {
                InputConnection inputConnection9 = (InputConnection)this.mInputConnection.get();
                if (inputConnection9 != null && this.isActive()) {
                    inputConnection9.performEditorAction(message.arg1);
                    return;
                }
                Log.w(TAG, "performEditorAction on inactive InputConnection");
                return;
            }
            case 59: {
                InputConnection inputConnection10 = (InputConnection)this.mInputConnection.get();
                if (inputConnection10 != null && this.isActive()) {
                    inputConnection10.performContextMenuAction(message.arg1);
                    return;
                }
                Log.w(TAG, "performContextMenuAction on inactive InputConnection");
                return;
            }
            case 55: {
                InputConnection inputConnection11 = (InputConnection)this.mInputConnection.get();
                if (inputConnection11 != null && this.isActive()) {
                    inputConnection11.commitCompletion((CompletionInfo)message.obj);
                    return;
                }
                Log.w(TAG, "commitCompletion on inactive InputConnection");
                return;
            }
            case 56: {
                InputConnection inputConnection12 = (InputConnection)this.mInputConnection.get();
                if (inputConnection12 != null && this.isActive()) {
                    inputConnection12.commitCorrection((CorrectionInfo)message.obj);
                    return;
                }
                Log.w(TAG, "commitCorrection on inactive InputConnection");
                return;
            }
            case 60: {
                InputConnection inputConnection13 = (InputConnection)this.mInputConnection.get();
                if (inputConnection13 != null && this.isActive()) {
                    inputConnection13.setComposingText((CharSequence)message.obj, message.arg1);
                    return;
                }
                Log.w(TAG, "setComposingText on inactive InputConnection");
                return;
            }
            case 63: {
                InputConnection inputConnection14 = (InputConnection)this.mInputConnection.get();
                if (inputConnection14 != null && this.isActive()) {
                    inputConnection14.setComposingRegion(message.arg1, message.arg2);
                    return;
                }
                Log.w(TAG, "setComposingRegion on inactive InputConnection");
                return;
            }
            case 65: {
                InputConnection inputConnection15 = (InputConnection)this.mInputConnection.get();
                if (inputConnection15 == null) {
                    Log.w(TAG, "finishComposingText on inactive InputConnection");
                    return;
                }
                inputConnection15.finishComposingText();
                return;
            }
            case 70: {
                InputConnection inputConnection16 = (InputConnection)this.mInputConnection.get();
                if (inputConnection16 != null && this.isActive()) {
                    inputConnection16.sendKeyEvent((KeyEvent)message.obj);
                    return;
                }
                Log.w(TAG, "sendKeyEvent on inactive InputConnection");
                return;
            }
            case 130: {
                InputConnection inputConnection17 = (InputConnection)this.mInputConnection.get();
                if (inputConnection17 != null && this.isActive()) {
                    inputConnection17.clearMetaKeyStates(message.arg1);
                    return;
                }
                Log.w(TAG, "clearMetaKeyStates on inactive InputConnection");
                return;
            }
            case 80: {
                InputConnection inputConnection18 = (InputConnection)this.mInputConnection.get();
                if (inputConnection18 != null && this.isActive()) {
                    inputConnection18.deleteSurroundingText(message.arg1, message.arg2);
                    return;
                }
                Log.w(TAG, "deleteSurroundingText on inactive InputConnection");
                return;
            }
            case 90: {
                InputConnection inputConnection19 = (InputConnection)this.mInputConnection.get();
                if (inputConnection19 != null && this.isActive()) {
                    inputConnection19.beginBatchEdit();
                    return;
                }
                Log.w(TAG, "beginBatchEdit on inactive InputConnection");
                return;
            }
            case 95: {
                InputConnection inputConnection20 = (InputConnection)this.mInputConnection.get();
                if (inputConnection20 != null && this.isActive()) {
                    inputConnection20.endBatchEdit();
                    return;
                }
                Log.w(TAG, "endBatchEdit on inactive InputConnection");
                return;
            }
            case 100: {
                InputConnection inputConnection21 = (InputConnection)this.mInputConnection.get();
                if (inputConnection21 == null || !this.isActive()) {
                    Log.w(TAG, "showStatusIcon on inactive InputConnection");
                    return;
                }
                if (message.arg1 != n) {
                    n = 0;
                }
                inputConnection21.reportFullscreenMode(n != 0);
                return;
            }
            case 120: {
                InputConnection inputConnection22 = (InputConnection)this.mInputConnection.get();
                if (inputConnection22 != null && this.isActive()) {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    inputConnection22.performPrivateCommand((String)someArgs.arg1, (Bundle)someArgs.arg2);
                    return;
                }
                Log.w(TAG, "performPrivateCommand on inactive InputConnection");
                return;
            }
            case 140: 
        }
        SomeArgs someArgs = (SomeArgs)message.obj;
        try {
            inputConnection = (InputConnection)this.mInputConnection.get();
            if (inputConnection == null || !this.isActive()) {
                Log.w(TAG, "requestCursorAnchorInfo on inactive InputConnection");
                someArgs.callback.setRequestUpdateCursorAnchorInfoResult(false, someArgs.seq);
                return;
            }
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Got RemoteException calling requestCursorAnchorInfo", remoteException);
            return;
        }
        {
            someArgs.callback.setRequestUpdateCursorAnchorInfoResult(inputConnection.requestCursorUpdates(message.arg1), someArgs.seq);
            return;
        }
    }

    @Override
    public void finishComposingText() {
        this.dispatchMessage(this.obtainMessage(65));
    }

    @Override
    public void getCursorCapsMode(int n, int n2, IInputContextCallback iInputContextCallback) {
        this.dispatchMessage(this.obtainMessageISC(30, n, n2, iInputContextCallback));
    }

    @Override
    public void getExtractedText(ExtractedTextRequest extractedTextRequest, int n, int n2, IInputContextCallback iInputContextCallback) {
        this.dispatchMessage(this.obtainMessageIOSC(40, n, extractedTextRequest, n2, iInputContextCallback));
    }

    @Override
    public void getSelectedText(int n, int n2, IInputContextCallback iInputContextCallback) {
        this.dispatchMessage(this.obtainMessageISC(25, n, n2, iInputContextCallback));
    }

    @Override
    public void getTextAfterCursor(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        this.dispatchMessage(this.obtainMessageIISC(10, n, n2, n3, iInputContextCallback));
    }

    @Override
    public void getTextBeforeCursor(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        this.dispatchMessage(this.obtainMessageIISC(20, n, n2, n3, iInputContextCallback));
    }

    public boolean isActive() {
        return true;
    }

    Message obtainMessage(int n) {
        return this.mH.obtainMessage(n);
    }

    Message obtainMessageII(int n, int n2, int n3) {
        return this.mH.obtainMessage(n, n2, n3);
    }

    Message obtainMessageIISC(int n, int n2, int n3, int n4, IInputContextCallback iInputContextCallback) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.callback = iInputContextCallback;
        someArgs.seq = n4;
        return this.mH.obtainMessage(n, n2, n3, someArgs);
    }

    Message obtainMessageIO(int n, int n2, Object object) {
        return this.mH.obtainMessage(n, n2, 0, object);
    }

    Message obtainMessageIOSC(int n, int n2, Object object, int n3, IInputContextCallback iInputContextCallback) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.arg1 = object;
        someArgs.callback = iInputContextCallback;
        someArgs.seq = n3;
        return this.mH.obtainMessage(n, n2, 0, someArgs);
    }

    Message obtainMessageISC(int n, int n2, int n3, IInputContextCallback iInputContextCallback) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.callback = iInputContextCallback;
        someArgs.seq = n3;
        return this.mH.obtainMessage(n, n2, 0, someArgs);
    }

    Message obtainMessageO(int n, Object object) {
        return this.mH.obtainMessage(n, 0, 0, object);
    }

    Message obtainMessageOO(int n, Object object, Object object2) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.arg1 = object;
        someArgs.arg2 = object2;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    Message obtainMessageOSC(int n, Object object, int n2, IInputContextCallback iInputContextCallback) {
        SomeArgs someArgs = new SomeArgs();
        someArgs.arg1 = object;
        someArgs.callback = iInputContextCallback;
        someArgs.seq = n2;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    @Override
    public void performContextMenuAction(int n) {
        this.dispatchMessage(this.obtainMessageII(59, n, 0));
    }

    @Override
    public void performEditorAction(int n) {
        this.dispatchMessage(this.obtainMessageII(58, n, 0));
    }

    @Override
    public void performPrivateCommand(String string2, Bundle bundle) {
        this.dispatchMessage(this.obtainMessageOO(120, string2, bundle));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reportFullscreenMode(boolean bl) {
        int n = bl ? 1 : 0;
        this.dispatchMessage(this.obtainMessageII(100, n, 0));
    }

    @Override
    public void requestUpdateCursorAnchorInfo(int n, int n2, IInputContextCallback iInputContextCallback) {
        this.dispatchMessage(this.obtainMessageISC(140, n, n2, iInputContextCallback));
    }

    @Override
    public void sendKeyEvent(KeyEvent keyEvent) {
        this.dispatchMessage(this.obtainMessageO(70, keyEvent));
    }

    @Override
    public void setComposingRegion(int n, int n2) {
        this.dispatchMessage(this.obtainMessageII(63, n, n2));
    }

    @Override
    public void setComposingText(CharSequence charSequence, int n) {
        this.dispatchMessage(this.obtainMessageIO(60, n, charSequence));
    }

    @Override
    public void setSelection(int n, int n2) {
        this.dispatchMessage(this.obtainMessageII(57, n, n2));
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            IInputConnectionWrapper.this.executeMessage(message);
        }
    }

    static class SomeArgs {
        Object arg1;
        Object arg2;
        IInputContextCallback callback;
        int seq;

        SomeArgs() {
        }
    }
}

