/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.InputStream;
import libcore.io.Streams;

public class SizedInputStream
extends InputStream {
    private long mLength;
    private final InputStream mWrapped;

    public SizedInputStream(InputStream inputStream, long l) {
        this.mWrapped = inputStream;
        this.mLength = l;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mWrapped.close();
    }

    @Override
    public int read() throws IOException {
        return Streams.readSingleByte((InputStream)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.mLength <= 0L) {
            return -1;
        }
        if ((long)n2 > this.mLength) {
            n2 = (int)this.mLength;
        }
        if ((n3 = this.mWrapped.read(byArray, n, n2)) == -1) {
            if (this.mLength <= 0L) return n3;
            throw new IOException("Unexpected EOF; expected " + this.mLength + " more bytes");
        }
        this.mLength -= (long)n3;
        return n3;
    }
}

