/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentingPrintWriter
extends PrintWriter {
    private char[] mCurrentIndent;
    private int mCurrentLength;
    private boolean mEmptyLine = true;
    private StringBuilder mIndentBuilder = new StringBuilder();
    private final String mSingleIndent;
    private final int mWrapLength;

    public IndentingPrintWriter(Writer writer, String string2) {
        this(writer, string2, -1);
    }

    public IndentingPrintWriter(Writer writer, String string2, int n) {
        super(writer);
        this.mSingleIndent = string2;
        this.mWrapLength = n;
    }

    private void maybeWriteIndent() {
        if (this.mEmptyLine) {
            this.mEmptyLine = false;
            if (this.mIndentBuilder.length() != 0) {
                if (this.mCurrentIndent == null) {
                    this.mCurrentIndent = this.mIndentBuilder.toString().toCharArray();
                }
                super.write(this.mCurrentIndent, 0, this.mCurrentIndent.length);
            }
        }
    }

    public void decreaseIndent() {
        this.mIndentBuilder.delete(0, this.mSingleIndent.length());
        this.mCurrentIndent = null;
    }

    public void increaseIndent() {
        this.mIndentBuilder.append(this.mSingleIndent);
        this.mCurrentIndent = null;
    }

    public void printHexPair(String string2, int n) {
        this.print(string2 + "=0x" + Integer.toHexString(n) + " ");
    }

    public void printPair(String string2, Object object) {
        this.print(string2 + "=" + String.valueOf(object) + " ");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        int n3 = this.mIndentBuilder.length();
        int n4 = n + n2;
        int n5 = n;
        int n6 = n;
        while (n6 < n4) {
            int n7 = n6 + 1;
            char c = cArray[n6];
            this.mCurrentLength = 1 + this.mCurrentLength;
            if (c == '\n') {
                this.maybeWriteIndent();
                super.write(cArray, n5, n7 - n5);
                n5 = n7;
                this.mEmptyLine = true;
                this.mCurrentLength = 0;
            }
            if (this.mWrapLength > 0 && this.mCurrentLength >= this.mWrapLength - n3) {
                if (!this.mEmptyLine) {
                    super.write(10);
                    this.mEmptyLine = true;
                    this.mCurrentLength = n7 - n5;
                } else {
                    this.maybeWriteIndent();
                    super.write(cArray, n5, n7 - n5);
                    super.write(10);
                    this.mEmptyLine = true;
                    n5 = n7;
                    this.mCurrentLength = 0;
                }
            }
            n6 = n7;
        }
        if (n5 != n6) {
            this.maybeWriteIndent();
            super.write(cArray, n5, n6 - n5);
        }
    }
}

