/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;

public class ImageUtils {
    private static final int ALPHA_TOLERANCE = 50;
    private static final int COMPACT_BITMAP_SIZE = 64;
    private static final int TOLERANCE = 20;
    private int[] mTempBuffer;
    private Bitmap mTempCompactBitmap;
    private Canvas mTempCompactBitmapCanvas;
    private Paint mTempCompactBitmapPaint;
    private final Matrix mTempMatrix = new Matrix();

    private void ensureBufferSize(int n) {
        if (this.mTempBuffer == null || this.mTempBuffer.length < n) {
            this.mTempBuffer = new int[n];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isGrayscale(int n) {
        block3: {
            block2: {
                if ((0xFF & n >> 24) < 50) break block2;
                int n2 = 0xFF & n >> 16;
                int n3 = 0xFF & n >> 8;
                int n4 = n & 0xFF;
                if (Math.abs(n2 - n3) >= 20 || Math.abs(n2 - n4) >= 20 || Math.abs(n3 - n4) >= 20) break block3;
            }
            return true;
        }
        return false;
    }

    public boolean isGrayscale(Bitmap bitmap) {
        int n = bitmap.getHeight();
        int n2 = bitmap.getWidth();
        if (n > 64 || n2 > 64) {
            if (this.mTempCompactBitmap == null) {
                this.mTempCompactBitmap = Bitmap.createBitmap(64, 64, Bitmap.Config.ARGB_8888);
                this.mTempCompactBitmapCanvas = new Canvas(this.mTempCompactBitmap);
                this.mTempCompactBitmapPaint = new Paint(1);
                this.mTempCompactBitmapPaint.setFilterBitmap(true);
            }
            this.mTempMatrix.reset();
            this.mTempMatrix.setScale(64.0f / (float)n2, 64.0f / (float)n, 0.0f, 0.0f);
            this.mTempCompactBitmapCanvas.drawColor(0, PorterDuff.Mode.SRC);
            this.mTempCompactBitmapCanvas.drawBitmap(bitmap, this.mTempMatrix, this.mTempCompactBitmapPaint);
            bitmap = this.mTempCompactBitmap;
            n2 = n = 64;
        }
        int n3 = n * n2;
        this.ensureBufferSize(n3);
        int[] nArray = this.mTempBuffer;
        bitmap.getPixels(nArray, 0, n2, 0, 0, n2, n);
        for (int i = 0; i < n3; ++i) {
            if (ImageUtils.isGrayscale(this.mTempBuffer[i])) continue;
            return false;
        }
        return true;
    }
}

