/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.xmlpull.v1.XmlSerializer;

public class FastXmlSerializer
implements XmlSerializer {
    private static final int BUFFER_LEN = 8192;
    private static final String[] ESCAPE_TABLE = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};
    private static String sSpace = "                                                              ";
    private ByteBuffer mBytes;
    private CharsetEncoder mCharset;
    private boolean mInTag;
    private boolean mIndent = false;
    private boolean mLineStart = true;
    private int mNesting = 0;
    private OutputStream mOutputStream;
    private int mPos;
    private final char[] mText = new char[8192];
    private Writer mWriter;

    public FastXmlSerializer() {
        this.mBytes = ByteBuffer.allocate(8192);
    }

    private void append(char c) throws IOException {
        int n = this.mPos;
        if (n >= 8191) {
            this.flush();
            n = this.mPos;
        }
        this.mText[n] = c;
        this.mPos = n + 1;
    }

    private void append(String string2) throws IOException {
        this.append(string2, 0, string2.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void append(String string2, int n, int n2) throws IOException {
        if (n2 <= 8192) {
            int n3 = this.mPos;
            if (n3 + n2 > 8192) {
                this.flush();
                n3 = this.mPos;
            }
            string2.getChars(n, n + n2, this.mText, n3);
            this.mPos = n3 + n2;
            return;
        } else {
            int n4 = n + n2;
            while (n < n4) {
                int n5 = n + 8192;
                int n6 = n5 < n4 ? 8192 : n4 - n;
                this.append(string2, n, n6);
                n = n5;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void append(char[] cArray, int n, int n2) throws IOException {
        if (n2 <= 8192) {
            int n3 = this.mPos;
            if (n3 + n2 > 8192) {
                this.flush();
                n3 = this.mPos;
            }
            System.arraycopy((char[])cArray, (int)n, (char[])this.mText, (int)n3, (int)n2);
            this.mPos = n3 + n2;
            return;
        } else {
            int n4 = n + n2;
            while (n < n4) {
                int n5 = n + 8192;
                int n6 = n5 < n4 ? 8192 : n4 - n;
                this.append(cArray, n, n6);
                n = n5;
            }
        }
    }

    private void appendIndent(int n) throws IOException {
        int n2 = n * 4;
        if (n2 > sSpace.length()) {
            n2 = sSpace.length();
        }
        this.append(sSpace, 0, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void escapeAndAppendString(String string2) throws IOException {
        int n;
        int n2 = string2.length();
        char c = (char)ESCAPE_TABLE.length;
        String[] stringArray = ESCAPE_TABLE;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            String string3;
            char c2 = string2.charAt(n);
            if (c2 >= c || (string3 = stringArray[c2]) == null) continue;
            if (n3 < n) {
                this.append(string2, n3, n - n3);
            }
            n3 = n + 1;
            this.append(string3);
        }
        if (n3 < n) {
            this.append(string2, n3, n - n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void escapeAndAppendString(char[] cArray, int n, int n2) throws IOException {
        int n3;
        char c = (char)ESCAPE_TABLE.length;
        String[] stringArray = ESCAPE_TABLE;
        int n4 = n + n2;
        int n5 = n;
        for (n3 = n; n3 < n4; ++n3) {
            String string2;
            char c2 = cArray[n3];
            if (c2 >= c || (string2 = stringArray[c2]) == null) continue;
            if (n5 < n3) {
                this.append(cArray, n5, n3 - n5);
            }
            n5 = n3 + 1;
            this.append(string2);
        }
        if (n5 < n3) {
            this.append(cArray, n5, n3 - n5);
        }
    }

    private void flushBytes() throws IOException {
        int n = this.mBytes.position();
        if (n > 0) {
            this.mBytes.flip();
            this.mOutputStream.write(this.mBytes.array(), 0, n);
            this.mBytes.clear();
        }
    }

    @Override
    public XmlSerializer attribute(String string2, String string3, String string4) throws IOException, IllegalArgumentException, IllegalStateException {
        this.append(' ');
        if (string2 != null) {
            this.append(string2);
            this.append(':');
        }
        this.append(string3);
        this.append("=\"");
        this.escapeAndAppendString(string4);
        this.append('\"');
        this.mLineStart = false;
        return this;
    }

    @Override
    public void cdsect(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void comment(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void docdecl(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void endDocument() throws IOException, IllegalArgumentException, IllegalStateException {
        this.flush();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public XmlSerializer endTag(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mNesting = -1 + this.mNesting;
        if (this.mInTag) {
            this.append(" />\n");
        } else {
            if (this.mIndent && this.mLineStart) {
                this.appendIndent(this.mNesting);
            }
            this.append("</");
            if (string2 != null) {
                this.append(string2);
                this.append(':');
            }
            this.append(string3);
            this.append(">\n");
        }
        this.mLineStart = true;
        this.mInTag = false;
        return this;
    }

    @Override
    public void entityRef(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void flush() throws IOException {
        if (this.mPos > 0) {
            if (this.mOutputStream == null) {
                this.mWriter.write(this.mText, 0, this.mPos);
                this.mWriter.flush();
            } else {
                CharBuffer charBuffer = CharBuffer.wrap(this.mText, 0, this.mPos);
                CoderResult coderResult = this.mCharset.encode(charBuffer, this.mBytes, true);
                while (true) {
                    if (coderResult.isError()) {
                        throw new IOException(coderResult.toString());
                    }
                    if (!coderResult.isOverflow()) break;
                    this.flushBytes();
                    coderResult = this.mCharset.encode(charBuffer, this.mBytes, true);
                }
                this.flushBytes();
                this.mOutputStream.flush();
            }
            this.mPos = 0;
        }
    }

    @Override
    public int getDepth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getFeature(String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrefix(String string2, boolean bl) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ignorableWhitespace(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processingInstruction(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFeature(String string2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (string2.equals("http://xmlpull.org/v1/doc/features.html#indent-output")) {
            this.mIndent = true;
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOutput(OutputStream outputStream, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mCharset = Charset.forName(string2).newEncoder();
            this.mOutputStream = outputStream;
            return;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(string2).initCause(illegalCharsetNameException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(string2).initCause(unsupportedCharsetException);
        }
    }

    @Override
    public void setOutput(Writer writer) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mWriter = writer;
    }

    @Override
    public void setPrefix(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String string2, Object object) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startDocument(String string2, Boolean bl) throws IOException, IllegalArgumentException, IllegalStateException {
        StringBuilder stringBuilder = new StringBuilder().append("<?xml version='1.0' encoding='utf-8' standalone='");
        String string3 = bl != false ? "yes" : "no";
        this.append(stringBuilder.append(string3).append("' ?>\n").toString());
        this.mLineStart = true;
    }

    @Override
    public XmlSerializer startTag(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">\n");
        }
        if (this.mIndent) {
            this.appendIndent(this.mNesting);
        }
        this.mNesting = 1 + this.mNesting;
        this.append('<');
        if (string2 != null) {
            this.append(string2);
            this.append(':');
        }
        this.append(string3);
        this.mInTag = true;
        this.mLineStart = false;
        return this;
    }

    @Override
    public XmlSerializer text(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">");
            this.mInTag = false;
        }
        this.escapeAndAppendString(string2);
        if (this.mIndent) {
            int n = string2.length();
            boolean bl = false;
            if (n > 0) {
                char c = string2.charAt(-1 + string2.length());
                bl = false;
                if (c == '\n') {
                    bl = true;
                }
            }
            this.mLineStart = bl;
        }
        return this;
    }

    @Override
    public XmlSerializer text(char[] cArray, int n, int n2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">");
            this.mInTag = false;
        }
        this.escapeAndAppendString(cArray, n, n2);
        if (this.mIndent) {
            char c = cArray[-1 + (n + n2)];
            boolean bl = false;
            if (c == '\n') {
                bl = true;
            }
            this.mLineStart = bl;
        }
        return this;
    }
}

