/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.util.AsyncService;
import java.util.Stack;

public class AsyncChannel {
    private static final int BASE = 69632;
    public static final int CMD_CHANNEL_DISCONNECT = 69635;
    public static final int CMD_CHANNEL_DISCONNECTED = 69636;
    public static final int CMD_CHANNEL_FULLY_CONNECTED = 69634;
    public static final int CMD_CHANNEL_FULL_CONNECTION = 69633;
    public static final int CMD_CHANNEL_HALF_CONNECTED = 69632;
    private static final int CMD_TO_STRING_COUNT = 5;
    private static final boolean DBG = false;
    public static final int STATUS_BINDING_UNSUCCESSFUL = 1;
    public static final int STATUS_FULL_CONNECTION_REFUSED_ALREADY_CONNECTED = 3;
    public static final int STATUS_REMOTE_DISCONNECTION = 4;
    public static final int STATUS_SEND_UNSUCCESSFUL = 2;
    public static final int STATUS_SUCCESSFUL = 0;
    private static final String TAG = "AsyncChannel";
    private static String[] sCmdToString = new String[5];
    private AsyncChannelConnection mConnection;
    private DeathMonitor mDeathMonitor;
    private Messenger mDstMessenger;
    private Context mSrcContext;
    private Handler mSrcHandler;
    private Messenger mSrcMessenger;

    static {
        AsyncChannel.sCmdToString[0] = "CMD_CHANNEL_HALF_CONNECTED";
        AsyncChannel.sCmdToString[1] = "CMD_CHANNEL_FULL_CONNECTION";
        AsyncChannel.sCmdToString[2] = "CMD_CHANNEL_FULLY_CONNECTED";
        AsyncChannel.sCmdToString[3] = "CMD_CHANNEL_DISCONNECT";
        AsyncChannel.sCmdToString[4] = "CMD_CHANNEL_DISCONNECTED";
    }

    static /* synthetic */ Messenger access$502(AsyncChannel asyncChannel, Messenger messenger) {
        asyncChannel.mDstMessenger = messenger;
        return messenger;
    }

    protected static String cmdToString(int n) {
        int n2 = n - 69632;
        if (n2 >= 0 && n2 < sCmdToString.length) {
            return sCmdToString[n2];
        }
        return null;
    }

    private static void log(String string2) {
        Slog.d(TAG, string2);
    }

    private void replyDisconnected(int n) {
        Message message = this.mSrcHandler.obtainMessage(69636);
        message.arg1 = n;
        message.obj = this;
        message.replyTo = this.mDstMessenger;
        this.mSrcHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replyHalfConnected(int n) {
        Message message = this.mSrcHandler.obtainMessage(69632);
        message.arg1 = n;
        message.obj = this;
        message.replyTo = this.mDstMessenger;
        if (this.mConnection == null) {
            this.mDeathMonitor = new DeathMonitor();
            try {
                this.mDstMessenger.getBinder().linkToDeath(this.mDeathMonitor, 0);
            }
            catch (RemoteException remoteException) {
                this.mDeathMonitor = null;
                message.arg1 = 1;
            }
        }
        this.mSrcHandler.sendMessage(message);
    }

    public void connect(Context context, Handler handler, Handler handler2) {
        this.connect(context, handler, new Messenger(handler2));
    }

    public void connect(Context context, Handler handler, Messenger messenger) {
        this.connected(context, handler, messenger);
        this.replyHalfConnected(0);
    }

    public void connect(Context context, Handler handler, Class<?> clazz) {
        this.connect(context, handler, clazz.getPackage().getName(), clazz.getName());
    }

    public void connect(Context context, Handler handler, String string2, String string3) {
        new Thread(new 1ConnectAsync(context, handler, string2, string3)).start();
    }

    public void connect(AsyncService asyncService, Messenger messenger) {
        this.connect((Context)asyncService, asyncService.getHandler(), messenger);
    }

    public int connectSrcHandlerToPackageSync(Context context, Handler handler, String string2, String string3) {
        int n = 1;
        this.mConnection = new AsyncChannelConnection();
        this.mSrcContext = context;
        this.mSrcHandler = handler;
        this.mSrcMessenger = new Messenger(handler);
        this.mDstMessenger = null;
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setClassName(string2, string3);
        if (context.bindService(intent, this.mConnection, n)) {
            n = 0;
        }
        return n;
    }

    public int connectSync(Context context, Handler handler, Handler handler2) {
        return this.connectSync(context, handler, new Messenger(handler2));
    }

    public int connectSync(Context context, Handler handler, Messenger messenger) {
        this.connected(context, handler, messenger);
        return 0;
    }

    public void connected(Context context, Handler handler, Messenger messenger) {
        this.mSrcContext = context;
        this.mSrcHandler = handler;
        this.mSrcMessenger = new Messenger(this.mSrcHandler);
        this.mDstMessenger = messenger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        if (this.mConnection != null && this.mSrcContext != null) {
            this.mSrcContext.unbindService(this.mConnection);
            this.mConnection = null;
        }
        try {
            Message message = Message.obtain();
            message.what = 69636;
            message.replyTo = this.mSrcMessenger;
            this.mDstMessenger.send(message);
        }
        catch (Exception exception) {}
        if (this.mSrcHandler != null) {
            this.replyDisconnected(0);
            this.mSrcHandler = null;
        }
        if (this.mConnection == null && this.mDstMessenger != null && this.mDeathMonitor != null) {
            this.mDstMessenger.getBinder().unlinkToDeath(this.mDeathMonitor, 0);
            this.mDeathMonitor = null;
        }
    }

    public void disconnected() {
        this.mSrcContext = null;
        this.mSrcHandler = null;
        this.mSrcMessenger = null;
        this.mDstMessenger = null;
        this.mDeathMonitor = null;
        this.mConnection = null;
    }

    public int fullyConnectSync(Context context, Handler handler, Handler handler2) {
        int n = this.connectSync(context, handler, handler2);
        if (n == 0) {
            n = this.sendMessageSynchronously((int)69633).arg1;
        }
        return n;
    }

    public void replyToMessage(Message message, int n) {
        Message message2 = Message.obtain();
        message2.what = n;
        this.replyToMessage(message, message2);
    }

    public void replyToMessage(Message message, int n, int n2) {
        Message message2 = Message.obtain();
        message2.what = n;
        message2.arg1 = n2;
        this.replyToMessage(message, message2);
    }

    public void replyToMessage(Message message, int n, int n2, int n3) {
        Message message2 = Message.obtain();
        message2.what = n;
        message2.arg1 = n2;
        message2.arg2 = n3;
        this.replyToMessage(message, message2);
    }

    public void replyToMessage(Message message, int n, int n2, int n3, Object object) {
        Message message2 = Message.obtain();
        message2.what = n;
        message2.arg1 = n2;
        message2.arg2 = n3;
        message2.obj = object;
        this.replyToMessage(message, message2);
    }

    public void replyToMessage(Message message, int n, Object object) {
        Message message2 = Message.obtain();
        message2.what = n;
        message2.obj = object;
        this.replyToMessage(message, message2);
    }

    public void replyToMessage(Message message, Message message2) {
        try {
            message2.replyTo = this.mSrcMessenger;
            message.replyTo.send(message2);
            return;
        }
        catch (RemoteException remoteException) {
            AsyncChannel.log("TODO: handle replyToMessage RemoteException" + remoteException);
            remoteException.printStackTrace();
            return;
        }
    }

    public void sendMessage(int n) {
        Message message = Message.obtain();
        message.what = n;
        this.sendMessage(message);
    }

    public void sendMessage(int n, int n2) {
        Message message = Message.obtain();
        message.what = n;
        message.arg1 = n2;
        this.sendMessage(message);
    }

    public void sendMessage(int n, int n2, int n3) {
        Message message = Message.obtain();
        message.what = n;
        message.arg1 = n2;
        message.arg2 = n3;
        this.sendMessage(message);
    }

    public void sendMessage(int n, int n2, int n3, Object object) {
        Message message = Message.obtain();
        message.what = n;
        message.arg1 = n2;
        message.arg2 = n3;
        message.obj = object;
        this.sendMessage(message);
    }

    public void sendMessage(int n, Object object) {
        Message message = Message.obtain();
        message.what = n;
        message.obj = object;
        this.sendMessage(message);
    }

    public void sendMessage(Message message) {
        message.replyTo = this.mSrcMessenger;
        try {
            this.mDstMessenger.send(message);
            return;
        }
        catch (RemoteException remoteException) {
            this.replyDisconnected(2);
            return;
        }
    }

    public Message sendMessageSynchronously(int n) {
        Message message = Message.obtain();
        message.what = n;
        return this.sendMessageSynchronously(message);
    }

    public Message sendMessageSynchronously(int n, int n2) {
        Message message = Message.obtain();
        message.what = n;
        message.arg1 = n2;
        return this.sendMessageSynchronously(message);
    }

    public Message sendMessageSynchronously(int n, int n2, int n3) {
        Message message = Message.obtain();
        message.what = n;
        message.arg1 = n2;
        message.arg2 = n3;
        return this.sendMessageSynchronously(message);
    }

    public Message sendMessageSynchronously(int n, int n2, int n3, Object object) {
        Message message = Message.obtain();
        message.what = n;
        message.arg1 = n2;
        message.arg2 = n3;
        message.obj = object;
        return this.sendMessageSynchronously(message);
    }

    public Message sendMessageSynchronously(int n, Object object) {
        Message message = Message.obtain();
        message.what = n;
        message.obj = object;
        return this.sendMessageSynchronously(message);
    }

    public Message sendMessageSynchronously(Message message) {
        return SyncMessenger.sendMessageSynchronously(this.mDstMessenger, message);
    }

    final class 1ConnectAsync
    implements Runnable {
        String mDstClassName;
        String mDstPackageName;
        Context mSrcCtx;
        Handler mSrcHdlr;

        1ConnectAsync(Context context, Handler handler, String string2, String string3) {
            this.mSrcCtx = context;
            this.mSrcHdlr = handler;
            this.mDstPackageName = string2;
            this.mDstClassName = string3;
        }

        @Override
        public void run() {
            int n = AsyncChannel.this.connectSrcHandlerToPackageSync(this.mSrcCtx, this.mSrcHdlr, this.mDstPackageName, this.mDstClassName);
            AsyncChannel.this.replyHalfConnected(n);
        }
    }

    class AsyncChannelConnection
    implements ServiceConnection {
        AsyncChannelConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            AsyncChannel.access$502(AsyncChannel.this, new Messenger(iBinder));
            AsyncChannel.this.replyHalfConnected(0);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            AsyncChannel.this.replyDisconnected(0);
        }
    }

    private final class DeathMonitor
    implements IBinder.DeathRecipient {
        DeathMonitor() {
        }

        @Override
        public void binderDied() {
            AsyncChannel.this.replyDisconnected(4);
        }
    }

    private static class SyncMessenger {
        private static int sCount;
        private static Stack<SyncMessenger> sStack;
        private SyncHandler mHandler;
        private HandlerThread mHandlerThread;
        private Messenger mMessenger;

        static {
            sStack = new Stack();
            sCount = 0;
        }

        private SyncMessenger() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static SyncMessenger obtain() {
            Stack<SyncMessenger> stack = sStack;
            synchronized (stack) {
                if (!sStack.isEmpty()) return sStack.pop();
                SyncMessenger syncMessenger = new SyncMessenger();
                StringBuilder stringBuilder = new StringBuilder().append("SyncHandler-");
                int n = sCount;
                sCount = n + 1;
                syncMessenger.mHandlerThread = new HandlerThread(stringBuilder.append(n).toString());
                syncMessenger.mHandlerThread.start();
                syncMessenger.getClass();
                syncMessenger.mHandler = syncMessenger.new SyncHandler(syncMessenger.mHandlerThread.getLooper());
                syncMessenger.mMessenger = new Messenger(syncMessenger.mHandler);
                return syncMessenger;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void recycle() {
            Stack<SyncMessenger> stack = sStack;
            synchronized (stack) {
                sStack.push(this);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private static Message sendMessageSynchronously(Messenger messenger, Message message) {
            SyncMessenger syncMessenger = SyncMessenger.obtain();
            if (messenger != null && message != null) {
                message.replyTo = syncMessenger.mMessenger;
                Object object = syncMessenger.mHandler.mLockObject;
                // MONITORENTER : object
                messenger.send(message);
                syncMessenger.mHandler.mLockObject.wait();
                // MONITOREXIT : object
            } else {
                try {
                    SyncHandler.access$402(syncMessenger.mHandler, null);
                }
                catch (InterruptedException interruptedException) {
                    SyncHandler.access$402(syncMessenger.mHandler, null);
                }
                catch (RemoteException remoteException) {
                    SyncHandler.access$402(syncMessenger.mHandler, null);
                }
            }
            Message message2 = syncMessenger.mHandler.mResultMsg;
            syncMessenger.recycle();
            return message2;
        }

        private class SyncHandler
        extends Handler {
            private Object mLockObject;
            private Message mResultMsg;

            private SyncHandler(Looper looper) {
                super(looper);
                this.mLockObject = new Object();
            }

            static /* synthetic */ Message access$402(SyncHandler syncHandler, Message message) {
                syncHandler.mResultMsg = message;
                return message;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                this.mResultMsg = Message.obtain();
                this.mResultMsg.copyFrom(message);
                Object object = this.mLockObject;
                synchronized (object) {
                    this.mLockObject.notify();
                    return;
                }
            }
        }
    }
}

