/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.CellInfo;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.VoLteServiceState;
import com.android.internal.telephony.IPhoneStateListener;
import java.util.List;

public interface ITelephonyRegistry
extends IInterface {
    public void listen(String var1, IPhoneStateListener var2, int var3, boolean var4) throws RemoteException;

    public void listenForSubscriber(long var1, String var3, IPhoneStateListener var4, int var5, boolean var6) throws RemoteException;

    public void notifyCallForwardingChanged(boolean var1) throws RemoteException;

    public void notifyCallForwardingChangedForSubscriber(long var1, boolean var3) throws RemoteException;

    public void notifyCallState(int var1, String var2) throws RemoteException;

    public void notifyCallStateForSubscriber(long var1, int var3, String var4) throws RemoteException;

    public void notifyCellInfo(List<CellInfo> var1) throws RemoteException;

    public void notifyCellInfoForSubscriber(long var1, List<CellInfo> var3) throws RemoteException;

    public void notifyCellLocation(Bundle var1) throws RemoteException;

    public void notifyCellLocationForSubscriber(long var1, Bundle var3) throws RemoteException;

    public void notifyDataActivity(int var1) throws RemoteException;

    public void notifyDataActivityForSubscriber(long var1, int var3) throws RemoteException;

    public void notifyDataConnection(int var1, boolean var2, String var3, String var4, String var5, LinkProperties var6, NetworkCapabilities var7, int var8, boolean var9) throws RemoteException;

    public void notifyDataConnectionFailed(String var1, String var2) throws RemoteException;

    public void notifyDataConnectionFailedForSubscriber(long var1, String var3, String var4) throws RemoteException;

    public void notifyDataConnectionForSubscriber(long var1, int var3, boolean var4, String var5, String var6, String var7, LinkProperties var8, NetworkCapabilities var9, int var10, boolean var11) throws RemoteException;

    public void notifyDataConnectionRealTimeInfo(DataConnectionRealTimeInfo var1) throws RemoteException;

    public void notifyDisconnectCause(int var1, int var2) throws RemoteException;

    public void notifyMessageWaitingChangedForPhoneId(int var1, long var2, boolean var4) throws RemoteException;

    public void notifyOemHookRawEventForSubscriber(long var1, byte[] var3) throws RemoteException;

    public void notifyOtaspChanged(int var1) throws RemoteException;

    public void notifyPreciseCallState(int var1, int var2, int var3) throws RemoteException;

    public void notifyPreciseDataConnectionFailed(String var1, String var2, String var3, String var4) throws RemoteException;

    public void notifyServiceStateForPhoneId(int var1, long var2, ServiceState var4) throws RemoteException;

    public void notifySignalStrength(SignalStrength var1) throws RemoteException;

    public void notifySignalStrengthForSubscriber(long var1, SignalStrength var3) throws RemoteException;

    public void notifyVoLteServiceStateChanged(VoLteServiceState var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITelephonyRegistry {
        private static final String DESCRIPTOR = "com.android.internal.telephony.ITelephonyRegistry";
        static final int TRANSACTION_listen = 1;
        static final int TRANSACTION_listenForSubscriber = 2;
        static final int TRANSACTION_notifyCallForwardingChanged = 9;
        static final int TRANSACTION_notifyCallForwardingChangedForSubscriber = 10;
        static final int TRANSACTION_notifyCallState = 3;
        static final int TRANSACTION_notifyCallStateForSubscriber = 4;
        static final int TRANSACTION_notifyCellInfo = 20;
        static final int TRANSACTION_notifyCellInfoForSubscriber = 24;
        static final int TRANSACTION_notifyCellLocation = 17;
        static final int TRANSACTION_notifyCellLocationForSubscriber = 18;
        static final int TRANSACTION_notifyDataActivity = 11;
        static final int TRANSACTION_notifyDataActivityForSubscriber = 12;
        static final int TRANSACTION_notifyDataConnection = 13;
        static final int TRANSACTION_notifyDataConnectionFailed = 15;
        static final int TRANSACTION_notifyDataConnectionFailedForSubscriber = 16;
        static final int TRANSACTION_notifyDataConnectionForSubscriber = 14;
        static final int TRANSACTION_notifyDataConnectionRealTimeInfo = 25;
        static final int TRANSACTION_notifyDisconnectCause = 22;
        static final int TRANSACTION_notifyMessageWaitingChangedForPhoneId = 8;
        static final int TRANSACTION_notifyOemHookRawEventForSubscriber = 27;
        static final int TRANSACTION_notifyOtaspChanged = 19;
        static final int TRANSACTION_notifyPreciseCallState = 21;
        static final int TRANSACTION_notifyPreciseDataConnectionFailed = 23;
        static final int TRANSACTION_notifyServiceStateForPhoneId = 5;
        static final int TRANSACTION_notifySignalStrength = 6;
        static final int TRANSACTION_notifySignalStrengthForSubscriber = 7;
        static final int TRANSACTION_notifyVoLteServiceStateChanged = 26;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITelephonyRegistry asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ITelephonyRegistry) {
                return (ITelephonyRegistry)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    IPhoneStateListener iPhoneStateListener = IPhoneStateListener.Stub.asInterface(parcel.readStrongBinder());
                    int n3 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.listen(string2, iPhoneStateListener, n3, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    String string3 = parcel.readString();
                    IPhoneStateListener iPhoneStateListener = IPhoneStateListener.Stub.asInterface(parcel.readStrongBinder());
                    int n4 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.listenForSubscriber(l, string3, iPhoneStateListener, n4, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyCallState(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyCallStateForSubscriber(parcel.readLong(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = parcel.readInt();
                    long l = parcel.readLong();
                    ServiceState serviceState = parcel.readInt() != 0 ? ServiceState.CREATOR.createFromParcel(parcel) : null;
                    this.notifyServiceStateForPhoneId(n5, l, serviceState);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SignalStrength signalStrength = parcel.readInt() != 0 ? SignalStrength.CREATOR.createFromParcel(parcel) : null;
                    this.notifySignalStrength(signalStrength);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    SignalStrength signalStrength = parcel.readInt() != 0 ? SignalStrength.CREATOR.createFromParcel(parcel) : null;
                    this.notifySignalStrengthForSubscriber(l, signalStrength);
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = parcel.readInt();
                    long l = parcel.readLong();
                    boolean bl = parcel.readInt() != 0;
                    this.notifyMessageWaitingChangedForPhoneId(n6, l, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.notifyCallForwardingChanged(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    boolean bl = parcel.readInt() != 0;
                    this.notifyCallForwardingChangedForSubscriber(l, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyDataActivity(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyDataActivityForSubscriber(parcel.readLong(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    String string4 = parcel.readString();
                    String string5 = parcel.readString();
                    String string6 = parcel.readString();
                    LinkProperties linkProperties = parcel.readInt() != 0 ? LinkProperties.CREATOR.createFromParcel(parcel) : null;
                    NetworkCapabilities networkCapabilities = parcel.readInt() != 0 ? NetworkCapabilities.CREATOR.createFromParcel(parcel) : null;
                    int n8 = parcel.readInt();
                    boolean bl2 = parcel.readInt() != 0;
                    this.notifyDataConnection(n7, bl, string4, string5, string6, linkProperties, networkCapabilities, n8, bl2);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    int n9 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    String string7 = parcel.readString();
                    String string8 = parcel.readString();
                    String string9 = parcel.readString();
                    LinkProperties linkProperties = parcel.readInt() != 0 ? LinkProperties.CREATOR.createFromParcel(parcel) : null;
                    NetworkCapabilities networkCapabilities = parcel.readInt() != 0 ? NetworkCapabilities.CREATOR.createFromParcel(parcel) : null;
                    int n10 = parcel.readInt();
                    boolean bl3 = parcel.readInt() != 0;
                    this.notifyDataConnectionForSubscriber(l, n9, bl, string7, string8, string9, linkProperties, networkCapabilities, n10, bl3);
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyDataConnectionFailed(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyDataConnectionFailedForSubscriber(parcel.readLong(), parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.notifyCellLocation(bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.notifyCellLocationForSubscriber(l, bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyOtaspChanged(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyCellInfo(parcel.createTypedArrayList(CellInfo.CREATOR));
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyPreciseCallState(parcel.readInt(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyDisconnectCause(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyPreciseDataConnectionFailed(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyCellInfoForSubscriber(parcel.readLong(), parcel.createTypedArrayList(CellInfo.CREATOR));
                    parcel2.writeNoException();
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    DataConnectionRealTimeInfo dataConnectionRealTimeInfo = parcel.readInt() != 0 ? DataConnectionRealTimeInfo.CREATOR.createFromParcel(parcel) : null;
                    this.notifyDataConnectionRealTimeInfo(dataConnectionRealTimeInfo);
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    VoLteServiceState voLteServiceState = parcel.readInt() != 0 ? VoLteServiceState.CREATOR.createFromParcel(parcel) : null;
                    this.notifyVoLteServiceStateChanged(voLteServiceState);
                    parcel2.writeNoException();
                    return true;
                }
                case 27: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.notifyOemHookRawEventForSubscriber(parcel.readLong(), parcel.createByteArray());
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements ITelephonyRegistry {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void listen(String string2, IPhoneStateListener iPhoneStateListener, int n, boolean bl) throws RemoteException {
                int n2 = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPhoneStateListener != null ? iPhoneStateListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (!bl) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void listenForSubscriber(long l, String string2, IPhoneStateListener iPhoneStateListener, int n, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    IBinder iBinder = iPhoneStateListener != null ? iPhoneStateListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    int n2 = 0;
                    if (bl) {
                        n2 = 1;
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void notifyCallForwardingChanged(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(9, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void notifyCallForwardingChangedForSubscriber(long l, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeLong(l);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(10, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void notifyCallState(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyCallStateForSubscriber(long l, int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyCellInfo(List<CellInfo> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedList(list);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyCellInfoForSubscriber(long l, List<CellInfo> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeTypedList(list);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyCellLocation(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyCellLocationForSubscriber(long l, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyDataActivity(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyDataActivityForSubscriber(long l, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeInt(n);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyDataConnection(int n, boolean bl, String string2, String string3, String string4, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int n2, boolean bl2) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                int n3;
                block9: {
                    block8: {
                        n3 = 1;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeInt(n);
                            int n4 = bl ? n3 : 0;
                            parcel2.writeInt(n4);
                            parcel2.writeString(string2);
                            parcel2.writeString(string3);
                            parcel2.writeString(string4);
                            if (linkProperties != null) {
                                parcel2.writeInt(1);
                                linkProperties.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            if (networkCapabilities != null) {
                                parcel2.writeInt(1);
                                networkCapabilities.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeInt(n2);
                            if (!bl2) break block8;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    n3 = 0;
                }
                parcel2.writeInt(n3);
                this.mRemote.transact(13, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            @Override
            public void notifyDataConnectionFailed(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyDataConnectionFailedForSubscriber(long l, String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyDataConnectionForSubscriber(long l, int n, boolean bl, String string2, String string3, String string4, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int n2, boolean bl2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeInt(n);
                    int n3 = bl ? 1 : 0;
                    parcel.writeInt(n3);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    if (linkProperties != null) {
                        parcel.writeInt(1);
                        linkProperties.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (networkCapabilities != null) {
                        parcel.writeInt(1);
                        networkCapabilities.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    int n4 = bl2 ? 1 : 0;
                    parcel.writeInt(n4);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyDataConnectionRealTimeInfo(DataConnectionRealTimeInfo dataConnectionRealTimeInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (dataConnectionRealTimeInfo != null) {
                        parcel.writeInt(1);
                        dataConnectionRealTimeInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyDisconnectCause(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyMessageWaitingChangedForPhoneId(int n, long l, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    parcel2.writeLong(l);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(8, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void notifyOemHookRawEventForSubscriber(long l, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyOtaspChanged(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyPreciseCallState(int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void notifyPreciseDataConnectionFailed(String string2, String string3, String string4, String string5) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    parcel.writeString(string5);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyServiceStateForPhoneId(int n, long l, ServiceState serviceState) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    if (serviceState != null) {
                        parcel.writeInt(1);
                        serviceState.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifySignalStrength(SignalStrength signalStrength) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (signalStrength != null) {
                        parcel.writeInt(1);
                        signalStrength.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifySignalStrengthForSubscriber(long l, SignalStrength signalStrength) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    if (signalStrength != null) {
                        parcel.writeInt(1);
                        signalStrength.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyVoLteServiceStateChanged(VoLteServiceState voLteServiceState) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (voLteServiceState != null) {
                        parcel.writeInt(1);
                        voLteServiceState.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

