/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.ddm.DdmRegister;
import android.os.Build;
import android.os.Debug;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Slog;
import com.android.internal.logging.AndroidConfig;
import com.android.internal.os.AndroidPrintStream;
import com.android.internal.os.ZygoteInit;
import com.android.server.NetworkManagementSocketTagger;
import dalvik.system.VMRuntime;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TimeZone;
import java.util.logging.LogManager;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public class RuntimeInit {
    private static final boolean DEBUG = false;
    private static final String TAG = "AndroidRuntime";
    private static boolean initialized;
    private static IBinder mApplicationObject;
    private static volatile boolean mCrashing;

    static {
        mCrashing = false;
        DdmRegister.registerHandlers();
    }

    private static int Clog_e(String string2, String string3, Throwable throwable) {
        return Log.println_native(4, 6, string2, string3 + '\n' + Log.getStackTraceString(throwable));
    }

    static /* synthetic */ boolean access$002(boolean bl) {
        mCrashing = bl;
        return bl;
    }

    private static void applicationInit(int n, String[] stringArray, ClassLoader classLoader) throws ZygoteInit.MethodAndArgsCaller {
        Arguments arguments;
        RuntimeInit.nativeSetExitWithoutCleanup(true);
        VMRuntime.getRuntime().setTargetHeapUtilization(0.75f);
        VMRuntime.getRuntime().setTargetSdkVersion(n);
        try {
            arguments = new Arguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Slog.e(TAG, illegalArgumentException.getMessage());
            return;
        }
        RuntimeInit.invokeStaticMain(arguments.startClass, arguments.startArgs, classLoader);
    }

    private static final void commonInit() {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        TimezoneGetter.setInstance((TimezoneGetter)new TimezoneGetter(){

            public String getId() {
                return SystemProperties.get("persist.sys.timezone");
            }
        });
        TimeZone.setDefault(null);
        LogManager.getLogManager().reset();
        new AndroidConfig();
        System.setProperty("http.agent", RuntimeInit.getDefaultUserAgent());
        NetworkManagementSocketTagger.install();
        if (SystemProperties.get("ro.kernel.android.tracing").equals("1")) {
            Slog.i(TAG, "NOTE: emulator trace profiling enabled");
            Debug.enableEmulatorTraceOutput();
        }
        initialized = true;
    }

    public static final IBinder getApplicationObject() {
        return mApplicationObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getDefaultUserAgent() {
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("Dalvik/");
        stringBuilder.append(System.getProperty("java.vm.version"));
        stringBuilder.append(" (Linux; U; Android ");
        String string4 = Build.VERSION.RELEASE;
        if (string4.length() <= 0) {
            string4 = "1.0";
        }
        stringBuilder.append(string4);
        if ("REL".equals(Build.VERSION.CODENAME) && (string3 = Build.MODEL).length() > 0) {
            stringBuilder.append("; ");
            stringBuilder.append(string3);
        }
        if ((string2 = Build.ID).length() > 0) {
            stringBuilder.append(" Build/");
            stringBuilder.append(string2);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static void invokeStaticMain(String string2, String[] stringArray, ClassLoader classLoader) throws ZygoteInit.MethodAndArgsCaller {
        Method method;
        Class<?> clazz;
        try {
            clazz = Class.forName(string2, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Missing class when invoking static main " + string2, classNotFoundException);
        }
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Missing static main on " + string2, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("Problem getting static main on " + string2, securityException);
        }
        int n = method.getModifiers();
        if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) {
            throw new RuntimeException("Main method is not public and static on " + string2);
        }
        throw new ZygoteInit.MethodAndArgsCaller(method, stringArray);
    }

    public static final void main(String[] stringArray) {
        if (stringArray.length == 2 && stringArray[1].equals("application")) {
            RuntimeInit.redirectLogStreams();
        }
        RuntimeInit.commonInit();
        RuntimeInit.nativeFinishInit();
    }

    private static final native void nativeFinishInit();

    private static final native void nativeSetExitWithoutCleanup(boolean var0);

    private static final native void nativeZygoteInit();

    public static void redirectLogStreams() {
        System.out.close();
        System.setOut(new AndroidPrintStream(4, "System.out"));
        System.err.close();
        System.setErr(new AndroidPrintStream(5, "System.err"));
    }

    public static final void setApplicationObject(IBinder iBinder) {
        mApplicationObject = iBinder;
    }

    public static void wrapperInit(int n, String[] stringArray) throws ZygoteInit.MethodAndArgsCaller {
        RuntimeInit.applicationInit(n, stringArray, null);
    }

    public static void wtf(String string2, Throwable throwable, boolean bl) {
        try {
            if (ActivityManagerNative.getDefault().handleApplicationWtf(mApplicationObject, string2, bl, new ApplicationErrorReport.CrashInfo(throwable))) {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
            return;
        }
        catch (Throwable throwable2) {
            Slog.e(TAG, "Error reporting WTF", throwable2);
            Slog.e(TAG, "Original WTF:", throwable);
            return;
        }
    }

    public static final void zygoteInit(int n, String[] stringArray, ClassLoader classLoader) throws ZygoteInit.MethodAndArgsCaller {
        RuntimeInit.redirectLogStreams();
        RuntimeInit.commonInit();
        RuntimeInit.nativeZygoteInit();
        RuntimeInit.applicationInit(n, stringArray, classLoader);
    }

    static class Arguments {
        String[] startArgs;
        String startClass;

        Arguments(String[] stringArray) throws IllegalArgumentException {
            this.parseArgs(stringArray);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseArgs(String[] stringArray) throws IllegalArgumentException {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                String string2 = stringArray[n];
                if (string2.equals("--")) {
                    ++n;
                    break;
                }
                if (!string2.startsWith("--")) break;
            }
            if (n == stringArray.length) {
                throw new IllegalArgumentException("Missing classname argument to RuntimeInit!");
            }
            int n2 = n + 1;
            this.startClass = stringArray[n];
            this.startArgs = new String[stringArray.length - n2];
            System.arraycopy(stringArray, n2, this.startArgs, 0, this.startArgs.length);
        }
    }

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            block12: {
                boolean bl = mCrashing;
                if (!bl) break block12;
                Process.killProcess(Process.myPid());
                System.exit(10);
                return;
            }
            try {
                RuntimeInit.access$002(true);
                if (mApplicationObject == null) {
                    RuntimeInit.Clog_e(RuntimeInit.TAG, "*** FATAL EXCEPTION IN SYSTEM PROCESS: " + thread.getName(), throwable);
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("FATAL EXCEPTION: ").append(thread.getName()).append("\n");
                    String string2 = ActivityThread.currentProcessName();
                    if (string2 != null) {
                        stringBuilder.append("Process: ").append(string2).append(", ");
                    }
                    stringBuilder.append("PID: ").append(Process.myPid());
                    RuntimeInit.Clog_e(RuntimeInit.TAG, stringBuilder.toString(), throwable);
                }
                ActivityManagerNative.getDefault().handleApplicationCrash(mApplicationObject, new ApplicationErrorReport.CrashInfo(throwable));
                return;
            }
            catch (Throwable throwable2) {
                try {
                    RuntimeInit.Clog_e(RuntimeInit.TAG, "Error reporting crash", throwable2);
                    return;
                }
                catch (Throwable throwable3) {
                    return;
                }
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        }
    }
}

