/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.UserHandle;
import com.android.internal.os.BackgroundThread;
import java.util.HashSet;

public abstract class PackageMonitor
extends BroadcastReceiver {
    public static final int PACKAGE_PERMANENT_CHANGE = 3;
    public static final int PACKAGE_TEMPORARY_CHANGE = 2;
    public static final int PACKAGE_UNCHANGED = 0;
    public static final int PACKAGE_UPDATING = 1;
    static final IntentFilter sExternalFilt;
    static final IntentFilter sNonDataFilt;
    static final IntentFilter sPackageFilt;
    String[] mAppearingPackages;
    int mChangeType;
    int mChangeUserId = -10000;
    String[] mDisappearingPackages;
    String[] mModifiedPackages;
    Context mRegisteredContext;
    Handler mRegisteredHandler;
    boolean mSomePackagesChanged;
    String[] mTempArray;
    final HashSet<String> mUpdatingPackages = new HashSet();

    static {
        sPackageFilt = new IntentFilter();
        sNonDataFilt = new IntentFilter();
        sExternalFilt = new IntentFilter();
        sPackageFilt.addAction("android.intent.action.PACKAGE_ADDED");
        sPackageFilt.addAction("android.intent.action.PACKAGE_REMOVED");
        sPackageFilt.addAction("android.intent.action.PACKAGE_CHANGED");
        sPackageFilt.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        sPackageFilt.addAction("android.intent.action.PACKAGE_RESTARTED");
        sPackageFilt.addAction("android.intent.action.UID_REMOVED");
        sPackageFilt.addDataScheme("package");
        sNonDataFilt.addAction("android.intent.action.UID_REMOVED");
        sNonDataFilt.addAction("android.intent.action.USER_STOPPED");
        sExternalFilt.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sExternalFilt.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
    }

    public PackageMonitor() {
        this.mTempArray = new String[1];
    }

    public boolean anyPackagesAppearing() {
        return this.mAppearingPackages != null;
    }

    public boolean anyPackagesDisappearing() {
        return this.mDisappearingPackages != null;
    }

    public boolean didSomePackagesChange() {
        return this.mSomePackagesChanged;
    }

    public int getChangingUserId() {
        return this.mChangeUserId;
    }

    String getPackageName(Intent intent) {
        Uri uri = intent.getData();
        if (uri != null) {
            return uri.getSchemeSpecificPart();
        }
        return null;
    }

    public Handler getRegisteredHandler() {
        return this.mRegisteredHandler;
    }

    public int isPackageAppearing(String string2) {
        if (this.mAppearingPackages != null) {
            for (int i = -1 + this.mAppearingPackages.length; i >= 0; --i) {
                if (!string2.equals(this.mAppearingPackages[i])) continue;
                return this.mChangeType;
            }
        }
        return 0;
    }

    public int isPackageDisappearing(String string2) {
        if (this.mDisappearingPackages != null) {
            for (int i = -1 + this.mDisappearingPackages.length; i >= 0; --i) {
                if (!string2.equals(this.mDisappearingPackages[i])) continue;
                return this.mChangeType;
            }
        }
        return 0;
    }

    public boolean isPackageModified(String string2) {
        if (this.mModifiedPackages != null) {
            for (int i = -1 + this.mModifiedPackages.length; i >= 0; --i) {
                if (!string2.equals(this.mModifiedPackages[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isPackageUpdating(String string2) {
        HashSet<String> hashSet = this.mUpdatingPackages;
        synchronized (hashSet) {
            return this.mUpdatingPackages.contains(string2);
        }
    }

    public boolean isReplacing() {
        return this.mChangeType == 1;
    }

    public void onBeginPackageChanges() {
    }

    public void onFinishPackageChanges() {
    }

    public boolean onHandleForceStop(Intent intent, String[] stringArray, int n, boolean bl) {
        return false;
    }

    public void onHandleUserStop(Intent intent, int n) {
    }

    public void onPackageAdded(String string2, int n) {
    }

    public void onPackageAppeared(String string2, int n) {
    }

    public boolean onPackageChanged(String string2, int n, String[] stringArray) {
        if (stringArray != null) {
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void onPackageDisappeared(String string2, int n) {
    }

    public void onPackageModified(String string2) {
    }

    public void onPackageRemoved(String string2, int n) {
    }

    public void onPackageRemovedAllUsers(String string2, int n) {
    }

    public void onPackageUpdateFinished(String string2, int n) {
    }

    public void onPackageUpdateStarted(String string2, int n) {
    }

    public void onPackagesAvailable(String[] stringArray) {
    }

    public void onPackagesUnavailable(String[] stringArray) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        block27: {
            String string2;
            int n;
            block34: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block26: {
                                            n = 2;
                                            this.mChangeUserId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                                            if (this.mChangeUserId == -10000) {
                                                throw new IllegalArgumentException("Intent broadcast does not contain user handle: " + intent);
                                            }
                                            this.onBeginPackageChanges();
                                            this.mAppearingPackages = null;
                                            this.mDisappearingPackages = null;
                                            this.mSomePackagesChanged = false;
                                            string2 = intent.getAction();
                                            if (!"android.intent.action.PACKAGE_ADDED".equals(string2)) break block26;
                                            String string3 = this.getPackageName(intent);
                                            int n2 = intent.getIntExtra("android.intent.extra.UID", 0);
                                            this.mSomePackagesChanged = true;
                                            if (string3 == null) break block27;
                                            this.mAppearingPackages = this.mTempArray;
                                            this.mTempArray[0] = string3;
                                            if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                                                this.mModifiedPackages = this.mTempArray;
                                                this.mChangeType = 1;
                                                this.onPackageUpdateFinished(string3, n2);
                                                this.onPackageModified(string3);
                                            } else {
                                                this.mChangeType = 3;
                                                this.onPackageAdded(string3, n2);
                                            }
                                            this.onPackageAppeared(string3, this.mChangeType);
                                            if (this.mChangeType == 1) {
                                                HashSet<String> hashSet = this.mUpdatingPackages;
                                                // MONITORENTER : hashSet
                                                this.mUpdatingPackages.remove(string3);
                                                // MONITOREXIT : hashSet
                                            }
                                            break block27;
                                        }
                                        if (!"android.intent.action.PACKAGE_REMOVED".equals(string2)) break block28;
                                        String string4 = this.getPackageName(intent);
                                        int n3 = intent.getIntExtra("android.intent.extra.UID", 0);
                                        if (string4 != null) {
                                            this.mDisappearingPackages = this.mTempArray;
                                            this.mTempArray[0] = string4;
                                            if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                                                this.mChangeType = 1;
                                                HashSet<String> hashSet = this.mUpdatingPackages;
                                                // MONITORENTER : hashSet
                                                // MONITOREXIT : hashSet
                                                this.onPackageUpdateStarted(string4, n3);
                                            } else {
                                                this.mChangeType = 3;
                                                this.mSomePackagesChanged = true;
                                                this.onPackageRemoved(string4, n3);
                                                if (intent.getBooleanExtra("android.intent.extra.REMOVED_FOR_ALL_USERS", false)) {
                                                    this.onPackageRemovedAllUsers(string4, n3);
                                                }
                                            }
                                            this.onPackageDisappeared(string4, this.mChangeType);
                                        }
                                        break block27;
                                    }
                                    if (!"android.intent.action.PACKAGE_CHANGED".equals(string2)) break block29;
                                    String string5 = this.getPackageName(intent);
                                    int n4 = intent.getIntExtra("android.intent.extra.UID", 0);
                                    String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_component_name_list");
                                    if (string5 != null) {
                                        this.mModifiedPackages = this.mTempArray;
                                        this.mTempArray[0] = string5;
                                        this.mChangeType = 3;
                                        if (this.onPackageChanged(string5, n4, stringArray)) {
                                            this.mSomePackagesChanged = true;
                                        }
                                        this.onPackageModified(string5);
                                    }
                                    break block27;
                                }
                                if (!"android.intent.action.QUERY_PACKAGE_RESTART".equals(string2)) break block30;
                                this.mDisappearingPackages = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                                this.mChangeType = n;
                                if (this.onHandleForceStop(intent, this.mDisappearingPackages, intent.getIntExtra("android.intent.extra.UID", 0), false)) {
                                    this.setResultCode(-1);
                                }
                                break block27;
                            }
                            if (!"android.intent.action.PACKAGE_RESTARTED".equals(string2)) break block31;
                            String[] stringArray = new String[]{this.getPackageName(intent)};
                            this.mDisappearingPackages = stringArray;
                            this.mChangeType = n;
                            this.onHandleForceStop(intent, this.mDisappearingPackages, intent.getIntExtra("android.intent.extra.UID", 0), true);
                            break block27;
                        }
                        if (!"android.intent.action.UID_REMOVED".equals(string2)) break block32;
                        this.onUidRemoved(intent.getIntExtra("android.intent.extra.UID", 0));
                        break block27;
                    }
                    if (!"android.intent.action.USER_STOPPED".equals(string2)) break block33;
                    if (intent.hasExtra("android.intent.extra.user_handle")) {
                        this.onHandleUserStop(intent, intent.getIntExtra("android.intent.extra.user_handle", 0));
                    }
                    break block27;
                }
                if (!"android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(string2)) break block34;
                String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                this.mAppearingPackages = stringArray;
                if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    n = 1;
                }
                this.mChangeType = n;
                this.mSomePackagesChanged = true;
                if (stringArray != null) {
                    this.onPackagesAvailable(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.onPackageAppeared(stringArray[i], this.mChangeType);
                    }
                }
                break block27;
            }
            if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(string2)) {
                String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                this.mDisappearingPackages = stringArray;
                if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    n = 1;
                }
                this.mChangeType = n;
                this.mSomePackagesChanged = true;
                if (stringArray != null) {
                    this.onPackagesUnavailable(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.onPackageDisappeared(stringArray[i], this.mChangeType);
                    }
                }
            }
        }
        if (this.mSomePackagesChanged) {
            this.onSomePackagesChanged();
        }
        this.onFinishPackageChanges();
        this.mChangeUserId = -10000;
    }

    public void onSomePackagesChanged() {
    }

    public void onUidRemoved(int n) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void register(Context context, Looper looper, UserHandle userHandle, boolean bl) {
        if (this.mRegisteredContext != null) {
            throw new IllegalStateException("Already registered");
        }
        this.mRegisteredContext = context;
        this.mRegisteredHandler = looper == null ? BackgroundThread.getHandler() : new Handler(looper);
        if (userHandle != null) {
            context.registerReceiverAsUser(this, userHandle, sPackageFilt, null, this.mRegisteredHandler);
            context.registerReceiverAsUser(this, userHandle, sNonDataFilt, null, this.mRegisteredHandler);
            if (!bl) return;
            context.registerReceiverAsUser(this, userHandle, sExternalFilt, null, this.mRegisteredHandler);
            return;
        }
        context.registerReceiver(this, sPackageFilt, null, this.mRegisteredHandler);
        context.registerReceiver(this, sNonDataFilt, null, this.mRegisteredHandler);
        if (!bl) return;
        context.registerReceiver(this, sExternalFilt, null, this.mRegisteredHandler);
    }

    public void register(Context context, Looper looper, boolean bl) {
        this.register(context, looper, null, bl);
    }

    public void unregister() {
        if (this.mRegisteredContext == null) {
            throw new IllegalStateException("Not registered");
        }
        this.mRegisteredContext.unregisterReceiver(this);
        this.mRegisteredContext = null;
    }
}

