/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.app.ProcessMap;
import com.android.internal.util.GrowingArrayUtils;
import dalvik.system.VMRuntime;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import libcore.util.EmptyArray;

public final class ProcessStats
implements Parcelable {
    public static final int ADJ_COUNT = 8;
    public static final int ADJ_MEM_FACTOR_COUNT = 4;
    public static final int ADJ_MEM_FACTOR_CRITICAL = 3;
    public static final int ADJ_MEM_FACTOR_LOW = 2;
    public static final int ADJ_MEM_FACTOR_MODERATE = 1;
    public static final int ADJ_MEM_FACTOR_NORMAL = 0;
    public static final String[] ADJ_MEM_NAMES_CSV;
    static final String[] ADJ_MEM_TAGS;
    public static final int ADJ_NOTHING = -1;
    public static final int ADJ_SCREEN_MOD = 4;
    public static final String[] ADJ_SCREEN_NAMES_CSV;
    public static final int ADJ_SCREEN_OFF = 0;
    public static final int ADJ_SCREEN_ON = 4;
    static final String[] ADJ_SCREEN_TAGS;
    public static final int[] ALL_MEM_ADJ;
    public static final int[] ALL_PROC_STATES;
    public static final int[] ALL_SCREEN_ADJ;
    public static final int[] BACKGROUND_PROC_STATES;
    static final int[] BAD_TABLE;
    public static long COMMIT_PERIOD = 0L;
    public static long COMMIT_UPTIME_PERIOD = 0L;
    public static final Parcelable.Creator<ProcessStats> CREATOR;
    static final String CSV_SEP = "\t";
    static final boolean DEBUG = false;
    static final boolean DEBUG_PARCEL = false;
    public static final int FLAG_COMPLETE = 1;
    public static final int FLAG_SHUTDOWN = 2;
    public static final int FLAG_SYSPROPS = 4;
    static final int LONGS_SIZE = 4096;
    private static final int MAGIC = 1347638355;
    public static final int[] NON_CACHED_PROC_STATES;
    static int OFFSET_ARRAY_MASK = 0;
    static int OFFSET_ARRAY_SHIFT = 0;
    static int OFFSET_INDEX_MASK = 0;
    static int OFFSET_INDEX_SHIFT = 0;
    static int OFFSET_TYPE_MASK = 0;
    static int OFFSET_TYPE_SHIFT = 0;
    private static final int PARCEL_VERSION = 18;
    static final int[] PROCESS_STATE_TO_STATE;
    public static final int PSS_AVERAGE = 2;
    public static final int PSS_COUNT = 7;
    public static final int PSS_MAXIMUM = 3;
    public static final int PSS_MINIMUM = 1;
    public static final int PSS_SAMPLE_COUNT = 0;
    public static final int PSS_USS_AVERAGE = 5;
    public static final int PSS_USS_MAXIMUM = 6;
    public static final int PSS_USS_MINIMUM = 4;
    public static final String SERVICE_NAME = "procstats";
    public static final int STATE_BACKUP = 4;
    public static final int STATE_CACHED_ACTIVITY = 11;
    public static final int STATE_CACHED_ACTIVITY_CLIENT = 12;
    public static final int STATE_CACHED_EMPTY = 13;
    public static final int STATE_COUNT = 14;
    public static final int STATE_HEAVY_WEIGHT = 5;
    public static final int STATE_HOME = 9;
    public static final int STATE_IMPORTANT_BACKGROUND = 3;
    public static final int STATE_IMPORTANT_FOREGROUND = 2;
    public static final int STATE_LAST_ACTIVITY = 10;
    static final String[] STATE_NAMES;
    public static final String[] STATE_NAMES_CSV;
    public static final int STATE_NOTHING = -1;
    public static final int STATE_PERSISTENT = 0;
    public static final int STATE_RECEIVER = 8;
    public static final int STATE_SERVICE = 6;
    public static final int STATE_SERVICE_RESTARTING = 7;
    static final String[] STATE_TAGS;
    public static final int STATE_TOP = 1;
    public static final int SYS_MEM_USAGE_CACHED_AVERAGE = 2;
    public static final int SYS_MEM_USAGE_CACHED_MAXIMUM = 3;
    public static final int SYS_MEM_USAGE_CACHED_MINIMUM = 1;
    public static final int SYS_MEM_USAGE_COUNT = 16;
    public static final int SYS_MEM_USAGE_FREE_AVERAGE = 5;
    public static final int SYS_MEM_USAGE_FREE_MAXIMUM = 6;
    public static final int SYS_MEM_USAGE_FREE_MINIMUM = 4;
    public static final int SYS_MEM_USAGE_KERNEL_AVERAGE = 11;
    public static final int SYS_MEM_USAGE_KERNEL_MAXIMUM = 12;
    public static final int SYS_MEM_USAGE_KERNEL_MINIMUM = 10;
    public static final int SYS_MEM_USAGE_NATIVE_AVERAGE = 14;
    public static final int SYS_MEM_USAGE_NATIVE_MAXIMUM = 15;
    public static final int SYS_MEM_USAGE_NATIVE_MINIMUM = 13;
    public static final int SYS_MEM_USAGE_SAMPLE_COUNT = 0;
    public static final int SYS_MEM_USAGE_ZRAM_AVERAGE = 8;
    public static final int SYS_MEM_USAGE_ZRAM_MAXIMUM = 9;
    public static final int SYS_MEM_USAGE_ZRAM_MINIMUM = 7;
    static final String TAG = "ProcessStats";
    int[] mAddLongTable;
    int mAddLongTableSize;
    ArrayMap<String, Integer> mCommonStringToIndex;
    public int mFlags;
    ArrayList<String> mIndexToCommonString;
    final ArrayList<long[]> mLongs;
    public int mMemFactor = -1;
    public final long[] mMemFactorDurations;
    int mNextLong;
    public final ProcessMap<SparseArray<PackageState>> mPackages = new ProcessMap();
    public final ProcessMap<ProcessState> mProcesses = new ProcessMap();
    public String mReadError;
    boolean mRunning;
    String mRuntime;
    public long mStartTime;
    public final long[] mSysMemUsageArgs;
    public int[] mSysMemUsageTable = null;
    public int mSysMemUsageTableSize = 0;
    public long mTimePeriodEndRealtime;
    public long mTimePeriodEndUptime;
    public long mTimePeriodStartClock;
    public String mTimePeriodStartClockStr;
    public long mTimePeriodStartRealtime;
    public long mTimePeriodStartUptime;

    static {
        COMMIT_PERIOD = 10800000L;
        COMMIT_UPTIME_PERIOD = 3600000L;
        ALL_MEM_ADJ = new int[]{0, 1, 2, 3};
        ALL_SCREEN_ADJ = new int[]{0, 4};
        NON_CACHED_PROC_STATES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        BACKGROUND_PROC_STATES = new int[]{2, 3, 4, 5, 6, 7, 8};
        PROCESS_STATE_TO_STATE = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13};
        ALL_PROC_STATES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        STATE_NAMES = new String[]{"Persist", "Top    ", "ImpFg  ", "ImpBg  ", "Backup ", "HeavyWt", "Service", "ServRst", "Receivr", "Home   ", "LastAct", "CchAct ", "CchCAct", "CchEmty"};
        ADJ_SCREEN_NAMES_CSV = new String[]{"off", "on"};
        ADJ_MEM_NAMES_CSV = new String[]{"norm", "mod", "low", "crit"};
        STATE_NAMES_CSV = new String[]{"pers", "top", "impfg", "impbg", "backup", "heavy", "service", "service-rs", "receiver", "home", "lastact", "cch-activity", "cch-aclient", "cch-empty"};
        ADJ_SCREEN_TAGS = new String[]{"0", "1"};
        ADJ_MEM_TAGS = new String[]{"n", "m", "l", "c"};
        STATE_TAGS = new String[]{"p", "t", "f", "b", "u", "w", "s", "x", "r", "h", "l", "a", "c", "e"};
        OFFSET_TYPE_SHIFT = 0;
        OFFSET_TYPE_MASK = 255;
        OFFSET_ARRAY_SHIFT = 8;
        OFFSET_ARRAY_MASK = 255;
        OFFSET_INDEX_SHIFT = 16;
        OFFSET_INDEX_MASK = 65535;
        CREATOR = new Parcelable.Creator<ProcessStats>(){

            @Override
            public ProcessStats createFromParcel(Parcel parcel) {
                return new ProcessStats(parcel);
            }

            public ProcessStats[] newArray(int n) {
                return new ProcessStats[n];
            }
        };
        BAD_TABLE = new int[0];
    }

    public ProcessStats(Parcel parcel) {
        this.mMemFactorDurations = new long[8];
        this.mSysMemUsageArgs = new long[16];
        this.mLongs = new ArrayList();
        this.reset();
        this.readFromParcel(parcel);
    }

    public ProcessStats(boolean bl) {
        this.mMemFactorDurations = new long[8];
        this.mSysMemUsageArgs = new long[16];
        this.mLongs = new ArrayList();
        this.mRunning = bl;
        this.reset();
    }

    static void addSysMemUsage(long[] lArray, int n, long[] lArray2, int n2) {
        block4: {
            long l;
            long l2;
            block3: {
                l2 = lArray[n + 0];
                l = lArray2[n2 + 0];
                if (l2 != 0L) break block3;
                lArray[n + 0] = l;
                for (int i = 1; i < 16; ++i) {
                    lArray[n + i] = lArray2[n2 + i];
                }
                break block4;
            }
            if (l <= 0L) break block4;
            lArray[n + 0] = l2 + l;
            for (int i = 1; i < 16; i += 3) {
                if (lArray[n + i] > lArray2[n2 + i]) {
                    lArray[n + i] = lArray2[n2 + i];
                }
                lArray[1 + (n + i)] = (long)(((double)lArray[1 + (n + i)] * (double)l2 + (double)lArray2[1 + (n2 + i)] * (double)l) / (double)(l2 + l));
                if (lArray[2 + (n + i)] >= lArray2[2 + (n2 + i)]) continue;
                lArray[2 + (n + i)] = lArray2[2 + (n2 + i)];
            }
        }
    }

    static int binarySearch(int[] nArray, int n, int n2) {
        int n3;
        block3: {
            int n4 = 0;
            int n5 = n - 1;
            while (n4 <= n5) {
                n3 = n4 + n5 >>> 1;
                int n6 = nArray[n3] >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                if (n6 < n2) {
                    n4 = n3 + 1;
                    continue;
                }
                if (n6 > n2) {
                    n5 = n3 - 1;
                    continue;
                }
                break block3;
            }
            n3 = ~n4;
        }
        return n3;
    }

    private void buildTimePeriodStartClockStr() {
        this.mTimePeriodStartClockStr = DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.mTimePeriodStartClock).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void computeProcessData(ProcessState processState, ProcessDataCollection processDataCollection, long l) {
        processDataCollection.totalTime = 0L;
        processDataCollection.maxUss = 0L;
        processDataCollection.avgUss = 0L;
        processDataCollection.minUss = 0L;
        processDataCollection.maxPss = 0L;
        processDataCollection.avgPss = 0L;
        processDataCollection.minPss = 0L;
        processDataCollection.numPss = 0L;
        int n = 0;
        block0: while (n < processDataCollection.screenStates.length) {
            int n2 = 0;
            while (true) {
                if (n2 < processDataCollection.memStates.length) {
                } else {
                    ++n;
                    continue block0;
                }
                for (int i = 0; i < processDataCollection.procStates.length; ++i) {
                    int n3 = 14 * (processDataCollection.screenStates[n] + processDataCollection.memStates[n2]) + processDataCollection.procStates[i];
                    processDataCollection.totalTime += processState.getDuration(n3, l);
                    long l2 = processState.getPssSampleCount(n3);
                    if (l2 <= 0L) continue;
                    long l3 = processState.getPssMinimum(n3);
                    long l4 = processState.getPssAverage(n3);
                    long l5 = processState.getPssMaximum(n3);
                    long l6 = processState.getPssUssMinimum(n3);
                    long l7 = processState.getPssUssAverage(n3);
                    long l8 = processState.getPssUssMaximum(n3);
                    if (processDataCollection.numPss == 0L) {
                        processDataCollection.minPss = l3;
                        processDataCollection.avgPss = l4;
                        processDataCollection.maxPss = l5;
                        processDataCollection.minUss = l6;
                        processDataCollection.avgUss = l7;
                        processDataCollection.maxUss = l8;
                    } else {
                        if (l3 < processDataCollection.minPss) {
                            processDataCollection.minPss = l3;
                        }
                        processDataCollection.avgPss = (long)(((double)processDataCollection.avgPss * (double)processDataCollection.numPss + (double)l4 * (double)l2) / (double)(l2 + processDataCollection.numPss));
                        if (l5 > processDataCollection.maxPss) {
                            processDataCollection.maxPss = l5;
                        }
                        if (l6 < processDataCollection.minUss) {
                            processDataCollection.minUss = l6;
                        }
                        processDataCollection.avgUss = (long)(((double)processDataCollection.avgUss * (double)processDataCollection.numPss + (double)l7 * (double)l2) / (double)(l2 + processDataCollection.numPss));
                        if (l8 > processDataCollection.maxUss) {
                            processDataCollection.maxUss = l8;
                        }
                    }
                    processDataCollection.numPss = l2 + processDataCollection.numPss;
                }
                ++n2;
            }
            break;
        }
        return;
    }

    static long computeProcessTimeLocked(ProcessState processState, int[] nArray, int[] nArray2, int[] nArray3, long l) {
        long l2 = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = 0; k < nArray3.length; ++k) {
                    l2 += processState.getDuration(14 * (nArray[i] + nArray2[j]) + nArray3[k], l);
                }
            }
        }
        processState.mTmpTotalTime = l2;
        return l2;
    }

    static void dumpAdjTimesCheckin(PrintWriter printWriter, String string2, long[] lArray, int n, long l, long l2) {
        for (int i = 0; i < 8; i += 4) {
            for (int j = 0; j < 4; ++j) {
                int n2 = j + i;
                long l3 = lArray[n2];
                if (n == n2) {
                    l3 += l2 - l;
                }
                if (l3 == 0L) continue;
                ProcessStats.printAdjTagAndValue(printWriter, n2, l3);
            }
        }
    }

    static void dumpAllProcessPssCheckin(PrintWriter printWriter, ProcessState processState) {
        for (int i = 0; i < processState.mPssTableSize; ++i) {
            int n = processState.mPssTable[i];
            int n2 = n >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
            long l = processState.mStats.getLong(n, 0);
            long l2 = processState.mStats.getLong(n, 1);
            long l3 = processState.mStats.getLong(n, 2);
            long l4 = processState.mStats.getLong(n, 3);
            long l5 = processState.mStats.getLong(n, 4);
            long l6 = processState.mStats.getLong(n, 5);
            long l7 = processState.mStats.getLong(n, 6);
            printWriter.print(',');
            ProcessStats.printProcStateTag(printWriter, n2);
            printWriter.print(':');
            printWriter.print(l);
            printWriter.print(':');
            printWriter.print(l2);
            printWriter.print(':');
            printWriter.print(l3);
            printWriter.print(':');
            printWriter.print(l4);
            printWriter.print(':');
            printWriter.print(l5);
            printWriter.print(':');
            printWriter.print(l6);
            printWriter.print(':');
            printWriter.print(l7);
        }
    }

    static void dumpAllProcessStateCheckin(PrintWriter printWriter, ProcessState processState, long l) {
        boolean bl = false;
        for (int i = 0; i < processState.mDurationsTableSize; ++i) {
            int n = processState.mDurationsTable[i];
            int n2 = n >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
            long l2 = processState.mStats.getLong(n, 0);
            if (processState.mCurState == n2) {
                bl = true;
                l2 += l - processState.mStartTime;
            }
            ProcessStats.printProcStateTagAndValue(printWriter, n2, l2);
        }
        if (!bl && processState.mCurState != -1) {
            ProcessStats.printProcStateTagAndValue(printWriter, processState.mCurState, l - processState.mStartTime);
        }
    }

    private void dumpProcessInternalLocked(PrintWriter printWriter, String string2, ProcessState processState, boolean bl) {
        if (bl) {
            printWriter.print(string2);
            printWriter.print("myID=");
            printWriter.print(Integer.toHexString(System.identityHashCode(processState)));
            printWriter.print(" mCommonProcess=");
            printWriter.print(Integer.toHexString(System.identityHashCode(processState.mCommonProcess)));
            printWriter.print(" mPackage=");
            printWriter.println(processState.mPackage);
            if (processState.mMultiPackage) {
                printWriter.print(string2);
                printWriter.print("mMultiPackage=");
                printWriter.println(processState.mMultiPackage);
            }
            if (processState != processState.mCommonProcess) {
                printWriter.print(string2);
                printWriter.print("Common Proc: ");
                printWriter.print(processState.mCommonProcess.mName);
                printWriter.print("/");
                printWriter.print(processState.mCommonProcess.mUid);
                printWriter.print(" pkg=");
                printWriter.println(processState.mCommonProcess.mPackage);
            }
        }
        if (processState.mActive) {
            printWriter.print(string2);
            printWriter.print("mActive=");
            printWriter.println(processState.mActive);
        }
        if (processState.mDead) {
            printWriter.print(string2);
            printWriter.print("mDead=");
            printWriter.println(processState.mDead);
        }
        if (processState.mNumActiveServices != 0 || processState.mNumStartedServices != 0) {
            printWriter.print(string2);
            printWriter.print("mNumActiveServices=");
            printWriter.print(processState.mNumActiveServices);
            printWriter.print(" mNumStartedServices=");
            printWriter.println(processState.mNumStartedServices);
        }
    }

    static void dumpProcessList(PrintWriter printWriter, String string2, ArrayList<ProcessState> arrayList, int[] nArray, int[] nArray2, int[] nArray3, long l) {
        String string3 = string2 + "  ";
        for (int i = -1 + arrayList.size(); i >= 0; --i) {
            ProcessState processState = arrayList.get(i);
            printWriter.print(string2);
            printWriter.print(processState.mName);
            printWriter.print(" / ");
            UserHandle.formatUid(printWriter, processState.mUid);
            printWriter.print(" (");
            printWriter.print(processState.mDurationsTableSize);
            printWriter.print(" entries)");
            printWriter.println(":");
            ProcessStats.dumpProcessState(printWriter, string3, processState, nArray, nArray2, nArray3, l);
            if (processState.mPssTableSize <= 0) continue;
            ProcessStats.dumpProcessPss(printWriter, string3, processState, nArray, nArray2, nArray3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void dumpProcessListCsv(PrintWriter printWriter, ArrayList<ProcessState> arrayList, boolean bl, int[] nArray, boolean bl2, int[] nArray2, boolean bl3, int[] nArray3, long l) {
        printWriter.print("process");
        printWriter.print(CSV_SEP);
        printWriter.print("uid");
        printWriter.print(CSV_SEP);
        printWriter.print("vers");
        Object object = bl ? nArray : null;
        Object object2 = bl2 ? nArray2 : null;
        Object object3 = bl3 ? nArray3 : null;
        ProcessStats.dumpStateHeadersCsv(printWriter, CSV_SEP, object, object2, object3);
        printWriter.println();
        int n = -1 + arrayList.size();
        while (n >= 0) {
            ProcessState processState = arrayList.get(n);
            printWriter.print(processState.mName);
            printWriter.print(CSV_SEP);
            UserHandle.formatUid(printWriter, processState.mUid);
            printWriter.print(CSV_SEP);
            printWriter.print(processState.mVersion);
            ProcessStats.dumpProcessStateCsv(printWriter, processState, bl, nArray, bl2, nArray2, bl3, nArray3, l);
            printWriter.println();
            --n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void dumpProcessPss(PrintWriter printWriter, String string2, ProcessState processState, int[] nArray, int[] nArray2, int[] nArray3) {
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        block0: while (true) {
            if (n2 >= nArray.length) {
                if (processState.mNumExcessiveWake != 0) {
                    printWriter.print(string2);
                    printWriter.print("Killed for excessive wake locks: ");
                    printWriter.print(processState.mNumExcessiveWake);
                    printWriter.println(" times");
                }
                if (processState.mNumExcessiveCpu != 0) {
                    printWriter.print(string2);
                    printWriter.print("Killed for excessive CPU use: ");
                    printWriter.print(processState.mNumExcessiveCpu);
                    printWriter.println(" times");
                }
                if (processState.mNumCachedKill != 0) {
                    printWriter.print(string2);
                    printWriter.print("Killed from cached state: ");
                    printWriter.print(processState.mNumCachedKill);
                    printWriter.print(" times from pss ");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.mMinCachedKillPss);
                    printWriter.print("-");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.mAvgCachedKillPss);
                    printWriter.print("-");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.mMaxCachedKillPss);
                    printWriter.println();
                }
                return;
            }
            int n3 = -1;
            int n4 = 0;
            while (true) {
                if (n4 < nArray2.length) {
                } else {
                    ++n2;
                    continue block0;
                }
                for (int i = 0; i < nArray3.length; ++i) {
                    int n5 = nArray[n2];
                    int n6 = nArray2[n4];
                    int n7 = 14 * (n5 + n6) + nArray3[i];
                    long l = processState.getPssSampleCount(n7);
                    if (l <= 0L) continue;
                    if (!bl) {
                        printWriter.print(string2);
                        printWriter.print("PSS/USS (");
                        printWriter.print(processState.mPssTableSize);
                        printWriter.println(" entries):");
                        bl = true;
                    }
                    printWriter.print(string2);
                    printWriter.print("  ");
                    if (nArray.length > 1) {
                        int n8 = n != n5 ? n5 : -1;
                        ProcessStats.printScreenLabel(printWriter, n8);
                        n = n5;
                    }
                    if (nArray2.length > 1) {
                        int n9 = n3 != n6 ? n6 : -1;
                        ProcessStats.printMemLabel(printWriter, n9, '/');
                        n3 = n6;
                    }
                    printWriter.print(STATE_NAMES[nArray3[i]]);
                    printWriter.print(": ");
                    printWriter.print(l);
                    printWriter.print(" samples ");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.getPssMinimum(n7));
                    printWriter.print(" ");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.getPssAverage(n7));
                    printWriter.print(" ");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.getPssMaximum(n7));
                    printWriter.print(" / ");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.getPssUssMinimum(n7));
                    printWriter.print(" ");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.getPssUssAverage(n7));
                    printWriter.print(" ");
                    ProcessStats.printSizeValue(printWriter, 1024L * processState.getPssUssMaximum(n7));
                    printWriter.println();
                }
                ++n4;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void dumpProcessState(PrintWriter printWriter, String string2, ProcessState processState, int[] nArray, int[] nArray2, int[] nArray3, long l) {
        long l2 = 0L;
        int n = -1;
        int n2 = 0;
        block0: while (true) {
            if (n2 >= nArray.length) {
                if (l2 != 0L) {
                    printWriter.print(string2);
                    if (nArray.length > 1) {
                        ProcessStats.printScreenLabel(printWriter, -1);
                    }
                    if (nArray2.length > 1) {
                        ProcessStats.printMemLabel(printWriter, -1, '/');
                    }
                    printWriter.print("TOTAL  : ");
                    TimeUtils.formatDuration(l2, printWriter);
                    printWriter.println();
                }
                return;
            }
            int n3 = -1;
            int n4 = 0;
            while (true) {
                if (n4 < nArray2.length) {
                } else {
                    ++n2;
                    continue block0;
                }
                for (int i = 0; i < nArray3.length; ++i) {
                    int n5 = nArray[n2];
                    int n6 = nArray2[n4];
                    int n7 = 14 * (n5 + n6) + nArray3[i];
                    long l3 = processState.getDuration(n7, l);
                    String string3 = "";
                    if (processState.mCurState == n7) {
                        string3 = " (running)";
                    }
                    if (l3 == 0L) continue;
                    printWriter.print(string2);
                    if (nArray.length > 1) {
                        int n8 = n != n5 ? n5 : -1;
                        ProcessStats.printScreenLabel(printWriter, n8);
                        n = n5;
                    }
                    if (nArray2.length > 1) {
                        int n9 = n3 != n6 ? n6 : -1;
                        ProcessStats.printMemLabel(printWriter, n9, '/');
                        n3 = n6;
                    }
                    printWriter.print(STATE_NAMES[nArray3[i]]);
                    printWriter.print(": ");
                    TimeUtils.formatDuration(l3, printWriter);
                    printWriter.println(string3);
                    l2 += l3;
                }
                ++n4;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    static void dumpProcessStateCsv(PrintWriter var0, ProcessState var1_1, boolean var2_2, int[] var3_3, boolean var4_4, int[] var5_5, boolean var6_6, int[] var7_7, long var8_8) {
        block32: {
            block31: {
                block30: {
                    block24: {
                        block23: {
                            block22: {
                                block20: {
                                    block21: {
                                        block19: {
                                            block25: {
                                                block26: {
                                                    block27: {
                                                        block28: {
                                                            block29: {
                                                                block18: {
                                                                    block33: {
                                                                        block35: {
                                                                            block34: {
                                                                                if (!var2_2) break block34;
                                                                                var10_9 = var3_3.length;
lbl3:
                                                                                // 2 sources

                                                                                while (var4_4) {
                                                                                    var11_10 = var5_5.length;
lbl5:
                                                                                    // 2 sources

                                                                                    while (var6_6) {
                                                                                        var12_11 = var7_7.length;
lbl7:
                                                                                        // 2 sources

                                                                                        while (true) {
                                                                                            var13_12 = 0;
lbl9:
                                                                                            // 2 sources

                                                                                            while (var13_12 < var10_9) {
                                                                                                var14_13 = 0;
lbl11:
                                                                                                // 2 sources

                                                                                                while (var14_13 < var11_10) {
                                                                                                    var15_14 = 0;
lbl13:
                                                                                                    // 2 sources

                                                                                                    while (var15_14 < var12_11) {
                                                                                                        if (!var2_2) break block18;
                                                                                                        var16_15 = var3_3[var13_12];
lbl16:
                                                                                                        // 2 sources

                                                                                                        while (var4_4) {
                                                                                                            var17_16 = var5_5[var14_13];
lbl18:
                                                                                                            // 2 sources

                                                                                                            while (var6_6) {
                                                                                                                var18_17 = var7_7[var15_14];
lbl20:
                                                                                                                // 2 sources

                                                                                                                while (var2_2) {
                                                                                                                    var19_18 = 1;
lbl22:
                                                                                                                    // 2 sources

                                                                                                                    while (var4_4) {
                                                                                                                        var20_19 = 1;
lbl24:
                                                                                                                        // 2 sources

                                                                                                                        while (var6_6) {
                                                                                                                            var21_20 = 1;
lbl26:
                                                                                                                            // 2 sources

                                                                                                                            while (true) {
                                                                                                                                var22_21 = 0L;
                                                                                                                                var24_22 = 0;
lbl29:
                                                                                                                                // 2 sources

                                                                                                                                while (var24_22 < var19_18) {
                                                                                                                                    var25_23 = 0;
lbl31:
                                                                                                                                    // 2 sources

                                                                                                                                    while (var25_23 < var20_19) {
                                                                                                                                        block14: for (var26_24 = 0; var26_24 < var21_20; ++var26_24) {
                                                                                                                                            if (!var2_2) break block19;
                                                                                                                                            var27_25 = 0;
lbl35:
                                                                                                                                            // 2 sources

                                                                                                                                            while (var4_4) {
                                                                                                                                                var28_26 = 0;
lbl37:
                                                                                                                                                // 2 sources

                                                                                                                                                while (var6_6) {
                                                                                                                                                    var29_27 = 0;
lbl39:
                                                                                                                                                    // 2 sources

                                                                                                                                                    while (true) {
                                                                                                                                                        var22_21 += var1_1.getDuration(var29_27 + (var18_17 + 14 * (var28_26 + (var17_16 + (var16_15 + var27_25)))), var8_8);
                                                                                                                                                        continue block14;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                break block20;
                                                                                                                                            }
                                                                                                                                            break block21;
                                                                                                                                        }
                                                                                                                                        break block22;
                                                                                                                                    }
                                                                                                                                    break block23;
                                                                                                                                }
                                                                                                                                break block24;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        break block25;
                                                                                                                    }
                                                                                                                    break block26;
                                                                                                                }
                                                                                                                break block27;
                                                                                                            }
                                                                                                            break block28;
                                                                                                        }
                                                                                                        break block29;
                                                                                                    }
                                                                                                    break block30;
                                                                                                }
                                                                                                break block31;
                                                                                            }
                                                                                            break block32;
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    break block33;
                                                                                }
                                                                                break block35;
                                                                            }
                                                                            var10_9 = 1;
                                                                            ** GOTO lbl3
                                                                        }
                                                                        var11_10 = 1;
                                                                        ** GOTO lbl5
                                                                    }
                                                                    var12_11 = 1;
                                                                    ** while (true)
                                                                }
                                                                var16_15 = 0;
                                                                ** GOTO lbl16
                                                            }
                                                            var17_16 = 0;
                                                            ** GOTO lbl18
                                                        }
                                                        var18_17 = 0;
                                                        ** GOTO lbl20
                                                    }
                                                    var19_18 = var3_3.length;
                                                    ** GOTO lbl22
                                                }
                                                var20_19 = var5_5.length;
                                                ** GOTO lbl24
                                            }
                                            var21_20 = var7_7.length;
                                            ** while (true)
                                        }
                                        var27_25 = var3_3[var24_22];
                                        ** GOTO lbl35
                                    }
                                    var28_26 = var5_5[var25_23];
                                    ** GOTO lbl37
                                }
                                var29_27 = var7_7[var26_24];
                                ** while (true)
                            }
                            ++var25_23;
                            ** GOTO lbl31
                        }
                        ++var24_22;
                        ** GOTO lbl29
                    }
                    var0.print("\t");
                    var0.print(var22_21);
                    ++var15_14;
                    ** GOTO lbl13
                }
                ++var14_13;
                ** GOTO lbl11
            }
            ++var13_12;
            ** GOTO lbl9
        }
    }

    static void dumpProcessSummaryDetails(PrintWriter printWriter, ProcessState processState, String string2, String string3, int[] nArray, int[] nArray2, int[] nArray3, long l, long l2, boolean bl) {
        ProcessDataCollection processDataCollection = new ProcessDataCollection(nArray, nArray2, nArray3);
        ProcessStats.computeProcessData(processState, processDataCollection, l);
        if (processDataCollection.totalTime != 0L || processDataCollection.numPss != 0L) {
            if (string2 != null) {
                printWriter.print(string2);
            }
            if (string3 != null) {
                printWriter.print(string3);
            }
            processDataCollection.print(printWriter, l2, bl);
            if (string2 != null) {
                printWriter.println();
            }
        }
    }

    static void dumpProcessSummaryLocked(PrintWriter printWriter, String string2, ArrayList<ProcessState> arrayList, int[] nArray, int[] nArray2, int[] nArray3, boolean bl, long l, long l2) {
        for (int i = -1 + arrayList.size(); i >= 0; --i) {
            ProcessState processState = arrayList.get(i);
            printWriter.print(string2);
            printWriter.print("* ");
            printWriter.print(processState.mName);
            printWriter.print(" / ");
            UserHandle.formatUid(printWriter, processState.mUid);
            printWriter.print(" / v");
            printWriter.print(processState.mVersion);
            printWriter.println(":");
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "         TOTAL: ", nArray, nArray2, nArray3, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "    Persistent: ", nArray, nArray2, new int[]{0}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "           Top: ", nArray, nArray2, new int[]{1}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "        Imp Fg: ", nArray, nArray2, new int[]{2}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "        Imp Bg: ", nArray, nArray2, new int[]{3}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "        Backup: ", nArray, nArray2, new int[]{4}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "     Heavy Wgt: ", nArray, nArray2, new int[]{5}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "       Service: ", nArray, nArray2, new int[]{6}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "    Service Rs: ", nArray, nArray2, new int[]{7}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "      Receiver: ", nArray, nArray2, new int[]{8}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "        (Home): ", nArray, nArray2, new int[]{9}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "    (Last Act): ", nArray, nArray2, new int[]{10}, l, l2, true);
            ProcessStats.dumpProcessSummaryDetails(printWriter, processState, string2, "      (Cached): ", nArray, nArray2, new int[]{11, 12, 13}, l, l2, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void dumpServiceTimeCheckin(PrintWriter printWriter, String string2, String string3, int n, int n2, String string4, ServiceState serviceState, int n3, int n4, int n5, long l, long l2) {
        if (n4 <= 0) {
            return;
        }
        printWriter.print(string2);
        printWriter.print(",");
        printWriter.print(string3);
        printWriter.print(",");
        printWriter.print(n);
        printWriter.print(",");
        printWriter.print(n2);
        printWriter.print(",");
        printWriter.print(string4);
        printWriter.print(",");
        printWriter.print(n4);
        boolean bl = false;
        for (int i = 0; i < serviceState.mDurationsTableSize; ++i) {
            int n6 = serviceState.mDurationsTable[i];
            int n7 = n6 >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
            int n8 = n7 / 4;
            if (n7 % 4 != n3) continue;
            long l3 = serviceState.mStats.getLong(n6, 0);
            if (n5 == n8) {
                bl = true;
                l3 += l2 - l;
            }
            ProcessStats.printAdjTagAndValue(printWriter, n8, l3);
        }
        if (!bl && n5 != -1) {
            ProcessStats.printAdjTagAndValue(printWriter, n5, l2 - l);
        }
        printWriter.println();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long dumpSingleServiceTime(PrintWriter printWriter, String string2, ServiceState serviceState, int n, int n2, long l, long l2) {
        long l3 = 0L;
        int n3 = -1;
        int n4 = 0;
        while (true) {
            int n5;
            if (n4 < 8) {
                n5 = -1;
            } else {
                if (l3 != 0L && printWriter != null) {
                    printWriter.print(string2);
                    printWriter.print("    TOTAL: ");
                    TimeUtils.formatDuration(l3, printWriter);
                    printWriter.println();
                }
                return l3;
            }
            for (int i = 0; i < 4; ++i) {
                int n6 = i + n4;
                long l4 = serviceState.getDuration(n, n2, l, n6, l2);
                String string3 = "";
                if (n2 == n6 && printWriter != null) {
                    string3 = " (running)";
                }
                if (l4 == 0L) continue;
                if (printWriter != null) {
                    printWriter.print(string2);
                    int n7 = n3 != n4 ? n4 : -1;
                    ProcessStats.printScreenLabel(printWriter, n7);
                    n3 = n4;
                    int n8 = n5 != i ? i : -1;
                    ProcessStats.printMemLabel(printWriter, n8, '\u0000');
                    n5 = i;
                    printWriter.print(": ");
                    TimeUtils.formatDuration(l4, printWriter);
                    printWriter.println(string3);
                }
                l3 += l4;
            }
            n4 += 4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long dumpSingleTime(PrintWriter printWriter, String string2, long[] lArray, int n, long l, long l2) {
        long l3 = 0L;
        int n2 = -1;
        int n3 = 0;
        while (true) {
            int n4;
            if (n3 < 8) {
                n4 = -1;
            } else {
                if (l3 != 0L && printWriter != null) {
                    printWriter.print(string2);
                    printWriter.print("    TOTAL: ");
                    TimeUtils.formatDuration(l3, printWriter);
                    printWriter.println();
                }
                return l3;
            }
            for (int i = 0; i < 4; ++i) {
                int n5 = i + n3;
                long l4 = lArray[n5];
                String string3 = "";
                if (n == n5) {
                    l4 += l2 - l;
                    if (printWriter != null) {
                        string3 = " (running)";
                    }
                }
                if (l4 == 0L) continue;
                if (printWriter != null) {
                    printWriter.print(string2);
                    int n6 = n2 != n3 ? n3 : -1;
                    ProcessStats.printScreenLabel(printWriter, n6);
                    n2 = n3;
                    int n7 = n4 != i ? i : -1;
                    ProcessStats.printMemLabel(printWriter, n7, '\u0000');
                    n4 = i;
                    printWriter.print(": ");
                    TimeUtils.formatDuration(l4, printWriter);
                    printWriter.println(string3);
                }
                l3 += l4;
            }
            n3 += 4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void dumpStateHeadersCsv(PrintWriter printWriter, String string2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray != null ? nArray.length : 1;
        int n2 = nArray2 != null ? nArray2.length : 1;
        int n3 = nArray3 != null ? nArray3.length : 1;
        int n4 = 0;
        while (n4 < n) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    printWriter.print(string2);
                    boolean bl = false;
                    if (nArray != null) {
                        int n5 = nArray.length;
                        bl = false;
                        if (n5 > 1) {
                            ProcessStats.printScreenLabelCsv(printWriter, nArray[n4]);
                            bl = true;
                        }
                    }
                    if (nArray2 != null && nArray2.length > 1) {
                        if (bl) {
                            printWriter.print("-");
                        }
                        ProcessStats.printMemLabelCsv(printWriter, nArray2[i]);
                        bl = true;
                    }
                    if (nArray3 == null || nArray3.length <= 1) continue;
                    if (bl) {
                        printWriter.print("-");
                    }
                    printWriter.print(STATE_NAMES_CSV[nArray3[j]]);
                }
            }
            ++n4;
        }
        return;
    }

    static void printAdjTag(PrintWriter printWriter, int n) {
        int n2 = ProcessStats.printArrayEntry(printWriter, ADJ_SCREEN_TAGS, n, 4);
        ProcessStats.printArrayEntry(printWriter, ADJ_MEM_TAGS, n2, 1);
    }

    static void printAdjTagAndValue(PrintWriter printWriter, int n, long l) {
        printWriter.print(',');
        ProcessStats.printAdjTag(printWriter, n);
        printWriter.print(':');
        printWriter.print(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int printArrayEntry(PrintWriter printWriter, String[] stringArray, int n, int n2) {
        int n3 = n / n2;
        if (n3 >= 0 && n3 < stringArray.length) {
            printWriter.print(stringArray[n3]);
            return n - n3 * n2;
        }
        printWriter.print('?');
        return n - n3 * n2;
    }

    static String printLongOffset(int n) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append("a");
        stringBuilder.append(n >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
        stringBuilder.append("i");
        stringBuilder.append(n >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK);
        stringBuilder.append("t");
        stringBuilder.append(n >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void printMemLabel(PrintWriter printWriter, int n, char c) {
        switch (n) {
            default: {
                printWriter.print("????");
                if (c == '\u0000') return;
                printWriter.print(c);
                return;
            }
            case -1: {
                printWriter.print("    ");
                if (c == '\u0000') return;
                printWriter.print(' ');
                return;
            }
            case 0: {
                printWriter.print("Norm");
                if (c == '\u0000') return;
                printWriter.print(c);
                return;
            }
            case 1: {
                printWriter.print("Mod ");
                if (c == '\u0000') return;
                printWriter.print(c);
                return;
            }
            case 2: {
                printWriter.print("Low ");
                if (c == '\u0000') return;
                printWriter.print(c);
                return;
            }
            case 3: {
                printWriter.print("Crit");
                if (c == '\u0000') return;
                printWriter.print(c);
                return;
            }
        }
    }

    public static void printMemLabelCsv(PrintWriter printWriter, int n) {
        block3: {
            block2: {
                if (n < 0) break block2;
                if (n > 3) break block3;
                printWriter.print(ADJ_MEM_NAMES_CSV[n]);
            }
            return;
        }
        printWriter.print("???");
    }

    /*
     * Enabled aggressive block sorting
     */
    static void printPercent(PrintWriter printWriter, double d) {
        double d2 = d * 100.0;
        if (d2 < 1.0) {
            Object[] objectArray = new Object[]{d2};
            printWriter.print(String.format("%.2f", objectArray));
        } else if (d2 < 10.0) {
            Object[] objectArray = new Object[]{d2};
            printWriter.print(String.format("%.1f", objectArray));
        } else {
            Object[] objectArray = new Object[]{d2};
            printWriter.print(String.format("%.0f", objectArray));
        }
        printWriter.print("%");
    }

    static void printProcStateTag(PrintWriter printWriter, int n) {
        int n2 = ProcessStats.printArrayEntry(printWriter, ADJ_SCREEN_TAGS, n, 56);
        int n3 = ProcessStats.printArrayEntry(printWriter, ADJ_MEM_TAGS, n2, 14);
        ProcessStats.printArrayEntry(printWriter, STATE_TAGS, n3, 1);
    }

    static void printProcStateTagAndValue(PrintWriter printWriter, int n, long l) {
        printWriter.print(',');
        ProcessStats.printProcStateTag(printWriter, n);
        printWriter.print(':');
        printWriter.print(l);
    }

    private static void printScreenLabel(PrintWriter printWriter, int n) {
        switch (n) {
            default: {
                printWriter.print("????/");
                return;
            }
            case -1: {
                printWriter.print("     ");
                return;
            }
            case 0: {
                printWriter.print("SOff/");
                return;
            }
            case 4: 
        }
        printWriter.print("SOn /");
    }

    public static void printScreenLabelCsv(PrintWriter printWriter, int n) {
        switch (n) {
            default: {
                printWriter.print("???");
            }
            case -1: {
                return;
            }
            case 0: {
                printWriter.print(ADJ_SCREEN_NAMES_CSV[0]);
                return;
            }
            case 4: 
        }
        printWriter.print(ADJ_SCREEN_NAMES_CSV[1]);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void printSizeValue(PrintWriter printWriter, long l) {
        String string2;
        float f = l;
        String string3 = "";
        if (f > 900.0f) {
            string3 = "KB";
            f /= 1024.0f;
        }
        if (f > 900.0f) {
            string3 = "MB";
            f /= 1024.0f;
        }
        if (f > 900.0f) {
            string3 = "GB";
            f /= 1024.0f;
        }
        if (f > 900.0f) {
            string3 = "TB";
            f /= 1024.0f;
        }
        if (f > 900.0f) {
            string3 = "PB";
            f /= 1024.0f;
        }
        if (f < 1.0f) {
            Object[] objectArray = new Object[]{Float.valueOf(f)};
            string2 = String.format("%.2f", objectArray);
        } else if (f < 10.0f) {
            Object[] objectArray = new Object[]{Float.valueOf(f)};
            string2 = String.format("%.1f", objectArray);
        } else if (f < 100.0f) {
            Object[] objectArray = new Object[]{Float.valueOf(f)};
            string2 = String.format("%.0f", objectArray);
        } else {
            Object[] objectArray = new Object[]{Float.valueOf(f)};
            string2 = String.format("%.0f", objectArray);
        }
        printWriter.print(string2);
        printWriter.print(string3);
    }

    private boolean readCheckedInt(Parcel parcel, int n, String string2) {
        int n2 = parcel.readInt();
        if (n2 != n) {
            this.mReadError = "bad " + string2 + ": " + n2;
            return false;
        }
        return true;
    }

    private String readCommonString(Parcel parcel, int n) {
        if (n <= 9) {
            return parcel.readString();
        }
        int n2 = parcel.readInt();
        if (n2 >= 0) {
            return this.mIndexToCommonString.get(n2);
        }
        int n3 = ~n2;
        String string2 = parcel.readString();
        while (this.mIndexToCommonString.size() <= n3) {
            this.mIndexToCommonString.add(null);
        }
        this.mIndexToCommonString.set(n3, string2);
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void readCompactedLongArray(Parcel parcel, int n, long[] lArray, int n2) {
        if (n <= 10) {
            parcel.readLongArray(lArray);
            return;
        }
        int n3 = lArray.length;
        if (n2 > n3) {
            throw new RuntimeException("bad array lengths: got " + n2 + " array is " + n3);
        }
        int n4 = 0;
        while (true) {
            if (n4 >= n2) {
                while (n4 < n3) {
                    lArray[n4] = 0L;
                    ++n4;
                }
                return;
            }
            int n5 = parcel.readInt();
            if (n5 >= 0) {
                lArray[n4] = n5;
            } else {
                int n6 = parcel.readInt();
                lArray[n4] = (long)(~n5) << 32 | (long)n6;
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static byte[] readFully(InputStream inputStream, int[] nArray) throws IOException {
        int n = 0;
        int n2 = inputStream.available();
        int n3 = n2 > 0 ? n2 + 1 : 16384;
        byte[] byArray = new byte[n3];
        while (true) {
            int n4;
            if ((n4 = inputStream.read(byArray, n, byArray.length - n)) < 0) {
                nArray[0] = n;
                return byArray;
            }
            if ((n += n4) < byArray.length) continue;
            byte[] byArray2 = new byte[n + 16384];
            System.arraycopy((byte[])byArray, (int)0, (byte[])byArray2, (int)0, (int)n);
            byArray = byArray2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] readTableFromParcel(Parcel parcel, String string2, String string3) {
        int n = parcel.readInt();
        if (n < 0) {
            Slog.w(TAG, "Ignoring existing stats; bad " + string3 + " table size: " + n);
            return BAD_TABLE;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = parcel.readInt();
            if (!this.validateLongOffset(nArray[n2])) {
                Slog.w(TAG, "Ignoring existing stats; bad " + string3 + " table entry: " + ProcessStats.printLongOffset(nArray[n2]));
                return null;
            }
            ++n2;
        }
        return nArray;
    }

    private void resetCommon() {
        long l;
        long l2;
        this.mTimePeriodStartClock = System.currentTimeMillis();
        this.buildTimePeriodStartClockStr();
        this.mTimePeriodEndRealtime = l2 = SystemClock.elapsedRealtime();
        this.mTimePeriodStartRealtime = l2;
        this.mTimePeriodEndUptime = l = SystemClock.uptimeMillis();
        this.mTimePeriodStartUptime = l;
        this.mLongs.clear();
        this.mLongs.add(new long[4096]);
        this.mNextLong = 0;
        Arrays.fill(this.mMemFactorDurations, 0L);
        this.mSysMemUsageTable = null;
        this.mSysMemUsageTableSize = 0;
        this.mStartTime = 0L;
        this.mReadError = null;
        this.mFlags = 0;
        this.evaluateSystemProperties(true);
    }

    private void writeCommonString(Parcel parcel, String string2) {
        Integer n = this.mCommonStringToIndex.get(string2);
        if (n != null) {
            parcel.writeInt(n);
            return;
        }
        Integer n2 = this.mCommonStringToIndex.size();
        this.mCommonStringToIndex.put(string2, n2);
        parcel.writeInt(0xFFFFFFFF ^ n2);
        parcel.writeString(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeCompactedLongArray(Parcel parcel, long[] lArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            if (l < 0L) {
                Slog.w(TAG, "Time val negative: " + l);
                l = 0L;
            }
            if (l <= Integer.MAX_VALUE) {
                parcel.writeInt((int)l);
            } else {
                int n3 = 0xFFFFFFFF ^ (int)(Integer.MAX_VALUE & l >> 32);
                int n4 = (int)(0xFFFFFFFL & l);
                parcel.writeInt(n3);
                parcel.writeInt(n4);
            }
            ++n2;
        }
        return;
    }

    public void add(ProcessStats processStats) {
        int n;
        int n2;
        int n3;
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> arrayMap = processStats.mPackages.getMap();
        for (int i = 0; i < (n3 = arrayMap.size()); ++i) {
            int n4;
            String string2 = arrayMap.keyAt(i);
            SparseArray<SparseArray<PackageState>> sparseArray = arrayMap.valueAt(i);
            for (int j = 0; j < (n4 = sparseArray.size()); ++j) {
                int n5;
                int n6 = sparseArray.keyAt(j);
                SparseArray<PackageState> sparseArray2 = sparseArray.valueAt(j);
                for (int k = 0; k < (n5 = sparseArray2.size()); ++k) {
                    int n7 = sparseArray2.keyAt(k);
                    PackageState packageState = sparseArray2.valueAt(k);
                    int n8 = packageState.mProcesses.size();
                    int n9 = packageState.mServices.size();
                    for (int i2 = 0; i2 < n8; ++i2) {
                        ProcessState processState = packageState.mProcesses.valueAt(i2);
                        if (processState.mCommonProcess == processState) continue;
                        ProcessState processState2 = this.getProcessStateLocked(string2, n6, n7, processState.mName);
                        if (processState2.mCommonProcess == processState2) {
                            processState2.mMultiPackage = true;
                            long l = SystemClock.uptimeMillis();
                            PackageState packageState2 = this.getPackageStateLocked(string2, n6, n7);
                            processState2 = processState2.clone(processState2.mPackage, l);
                            packageState2.mProcesses.put(processState2.mName, processState2);
                        }
                        processState2.add(processState);
                    }
                    for (int i3 = 0; i3 < n9; ++i3) {
                        ServiceState serviceState = packageState.mServices.valueAt(i3);
                        this.getServiceStateLocked(string2, n6, n7, serviceState.mProcessName, serviceState.mName).add(serviceState);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> arrayMap2 = processStats.mProcesses.getMap();
        for (int i = 0; i < (n2 = arrayMap2.size()); ++i) {
            int n10;
            SparseArray<ProcessState> sparseArray = arrayMap2.valueAt(i);
            for (int j = 0; j < (n10 = sparseArray.size()); ++j) {
                int n11 = sparseArray.keyAt(j);
                ProcessState processState = sparseArray.valueAt(j);
                ProcessState processState3 = this.mProcesses.get(processState.mName, n11);
                if (processState3 == null) {
                    processState3 = new ProcessState(this, processState.mPackage, n11, processState.mVersion, processState.mName);
                    this.mProcesses.put(processState.mName, n11, processState3);
                    PackageState packageState = this.getPackageStateLocked(processState.mPackage, n11, processState.mVersion);
                    if (!packageState.mProcesses.containsKey(processState.mName)) {
                        packageState.mProcesses.put(processState.mName, processState3);
                    }
                }
                processState3.add(processState);
            }
        }
        for (int i = 0; i < 8; ++i) {
            long[] lArray = this.mMemFactorDurations;
            lArray[i] = lArray[i] + processStats.mMemFactorDurations[i];
        }
        for (int i = 0; i < (n = processStats.mSysMemUsageTableSize); ++i) {
            int n12 = processStats.mSysMemUsageTable[i];
            this.addSysMemUsage(n12 >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK, processStats.mLongs.get(n12 >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK), n12 >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK);
        }
        if (processStats.mTimePeriodStartClock < this.mTimePeriodStartClock) {
            this.mTimePeriodStartClock = processStats.mTimePeriodStartClock;
            this.mTimePeriodStartClockStr = processStats.mTimePeriodStartClockStr;
        }
        this.mTimePeriodEndRealtime += processStats.mTimePeriodEndRealtime - processStats.mTimePeriodStartRealtime;
        this.mTimePeriodEndUptime += processStats.mTimePeriodEndUptime - processStats.mTimePeriodStartUptime;
    }

    /*
     * Enabled aggressive block sorting
     */
    int addLongData(int n, int n2, int n3) {
        int n4 = this.allocLongData(n3);
        int[] nArray = this.mAddLongTable != null ? this.mAddLongTable : EmptyArray.INT;
        this.mAddLongTable = GrowingArrayUtils.insert(nArray, this.mAddLongTableSize, n, n2 | n4);
        this.mAddLongTableSize = 1 + this.mAddLongTableSize;
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    void addSysMemUsage(int n, long[] lArray, int n2) {
        int n3;
        int n4 = ProcessStats.binarySearch(this.mSysMemUsageTable, this.mSysMemUsageTableSize, n);
        if (n4 >= 0) {
            n3 = this.mSysMemUsageTable[n4];
        } else {
            this.mAddLongTable = this.mSysMemUsageTable;
            this.mAddLongTableSize = this.mSysMemUsageTableSize;
            n3 = this.addLongData(~n4, n, 16);
            this.mSysMemUsageTable = this.mAddLongTable;
            this.mSysMemUsageTableSize = this.mAddLongTableSize;
        }
        ProcessStats.addSysMemUsage(this.mLongs.get(n3 >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK), n3 >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK, lArray, n2);
    }

    public void addSysMemUsage(long l, long l2, long l3, long l4, long l5) {
        if (this.mMemFactor != -1) {
            int n = 14 * this.mMemFactor;
            this.mSysMemUsageArgs[0] = 1L;
            for (int i = 0; i < 3; ++i) {
                this.mSysMemUsageArgs[i + 1] = l;
                this.mSysMemUsageArgs[i + 4] = l2;
                this.mSysMemUsageArgs[i + 7] = l3;
                this.mSysMemUsageArgs[i + 10] = l4;
                this.mSysMemUsageArgs[i + 13] = l5;
            }
            this.addSysMemUsage(n, this.mSysMemUsageArgs, 0);
        }
    }

    int allocLongData(int n) {
        int n2 = -1 + this.mLongs.size();
        long[] lArray = this.mLongs.get(n2);
        if (n + this.mNextLong > lArray.length) {
            long[] lArray2 = new long[4096];
            this.mLongs.add(lArray2);
            ++n2;
            this.mNextLong = 0;
        }
        int n3 = n2 << OFFSET_ARRAY_SHIFT | this.mNextLong << OFFSET_INDEX_SHIFT;
        this.mNextLong = n + this.mNextLong;
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String collapseString(String string2, String string3) {
        int n;
        if (!string3.startsWith(string2)) return string3;
        int n2 = string3.length();
        if (n2 == (n = string2.length())) {
            return "";
        }
        if (n2 < n) return string3;
        if (string3.charAt(n) != '.') return string3;
        return string3.substring(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayList<ProcessState> collectProcessesLocked(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l, String string2, boolean bl) {
        ArraySet<ProcessState> arraySet = new ArraySet<ProcessState>();
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> arrayMap = this.mPackages.getMap();
        block0: for (int i = 0; i < arrayMap.size(); ++i) {
            String string3 = arrayMap.keyAt(i);
            SparseArray<SparseArray<PackageState>> sparseArray = arrayMap.valueAt(i);
            int n = 0;
            block1: while (true) {
                if (n >= sparseArray.size()) {
                    continue block0;
                }
                SparseArray<PackageState> sparseArray2 = sparseArray.valueAt(n);
                int n2 = sparseArray2.size();
                int n3 = 0;
                while (true) {
                    boolean bl2;
                    int n4;
                    PackageState packageState;
                    if (n3 < n2) {
                        packageState = sparseArray2.valueAt(n3);
                        n4 = packageState.mProcesses.size();
                        bl2 = string2 == null || string2.equals(string3);
                    } else {
                        ++n;
                        continue block1;
                    }
                    for (int j = 0; j < n4; ++j) {
                        ProcessState processState = packageState.mProcesses.valueAt(j);
                        if (!bl2 && !string2.equals(processState.mName) || bl && !processState.isInUse()) continue;
                        arraySet.add(processState.mCommonProcess);
                    }
                    ++n3;
                }
                break;
            }
        }
        ArrayList<ProcessState> arrayList = new ArrayList<ProcessState>(arraySet.size());
        int n = 0;
        while (true) {
            if (n >= arraySet.size()) {
                Collections.sort(arrayList, new Comparator<ProcessState>(){

                    @Override
                    public int compare(ProcessState processState, ProcessState processState2) {
                        if (processState.mTmpTotalTime < processState2.mTmpTotalTime) {
                            return -1;
                        }
                        if (processState.mTmpTotalTime > processState2.mTmpTotalTime) {
                            return 1;
                        }
                        return 0;
                    }
                });
                return arrayList;
            }
            ProcessState processState = (ProcessState)arraySet.valueAt(n);
            if (ProcessStats.computeProcessTimeLocked(processState, nArray, nArray2, nArray3, l) > 0L) {
                arrayList.add(processState);
                if (nArray3 != nArray4) {
                    ProcessStats.computeProcessTimeLocked(processState, nArray, nArray2, nArray4, l);
                }
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void computeTotalMemoryUse(TotalMemoryUseCollection var1_1, long var2_2) {
        var1_1.totalTime = 0L;
        for (var4_3 = 0; var4_3 < 14; ++var4_3) {
            var1_1.processStateWeight[var4_3] = 0.0;
            var1_1.processStatePss[var4_3] = 0L;
            var1_1.processStateTime[var4_3] = 0L;
            var1_1.processStateSamples[var4_3] = 0;
        }
        for (var5_4 = 0; var5_4 < 16; ++var5_4) {
            var1_1.sysMemUsage[var5_4] = 0L;
        }
        var1_1.sysMemCachedWeight = 0.0;
        var1_1.sysMemFreeWeight = 0.0;
        var1_1.sysMemZRamWeight = 0.0;
        var1_1.sysMemKernelWeight = 0.0;
        var1_1.sysMemNativeWeight = 0.0;
        var1_1.sysMemSamples = 0;
        var6_5 = new long[16];
        for (var7_6 = 0; var7_6 < this.mSysMemUsageTableSize; ++var7_6) {
            var65_7 = this.mSysMemUsageTable[var7_6];
            ProcessStats.addSysMemUsage(var6_5, 0, this.mLongs.get(var65_7 >> ProcessStats.OFFSET_ARRAY_SHIFT & ProcessStats.OFFSET_ARRAY_MASK), var65_7 >> ProcessStats.OFFSET_INDEX_SHIFT & ProcessStats.OFFSET_INDEX_MASK);
        }
        for (var8_8 = 0; var8_8 < (var9_10 = var1_1.screenStates.length); ++var8_8) {
            for (var52_11 = 0; var52_11 < (var53_12 = var1_1.memStates.length); ++var52_11) {
                var54_13 = var1_1.screenStates[var8_8] + var1_1.memStates[var52_11];
                var55_14 = var54_13 * 14;
                var56_15 = this.mMemFactorDurations[var54_13];
                if (this.mMemFactor == var54_13) {
                    var56_15 += var2_2 - this.mStartTime;
                }
                var1_1.totalTime = var56_15 + var1_1.totalTime;
                var58_16 = ProcessStats.binarySearch(this.mSysMemUsageTable, this.mSysMemUsageTableSize, var55_14);
                var59_17 = var6_5;
                var60_18 = 0;
                if (var58_16 >= 0) {
                    var61_19 = this.mSysMemUsageTable[var58_16];
                    var62_20 = this.mLongs.get(var61_19 >> ProcessStats.OFFSET_ARRAY_SHIFT & ProcessStats.OFFSET_ARRAY_MASK);
                    var63_21 = var61_19 >> ProcessStats.OFFSET_INDEX_SHIFT & ProcessStats.OFFSET_INDEX_MASK;
                    cfr_temp_0 = var62_20[var63_21 + 0] - 3L;
                    var64_9 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                    var60_18 = 0;
                    if (var64_9 >= 0) {
                        ProcessStats.addSysMemUsage(var1_1.sysMemUsage, 0, var59_17, 0);
                        var59_17 = var62_20;
                        var60_18 = var63_21;
                    }
                }
                var1_1.sysMemCachedWeight += (double)var59_17[var60_18 + 2] * (double)var56_15;
                var1_1.sysMemFreeWeight += (double)var59_17[var60_18 + 5] * (double)var56_15;
                var1_1.sysMemZRamWeight += (double)var59_17[var60_18 + 8] * (double)var56_15;
                var1_1.sysMemKernelWeight += (double)var59_17[var60_18 + 11] * (double)var56_15;
                var1_1.sysMemNativeWeight += (double)var59_17[var60_18 + 14] * (double)var56_15;
                var1_1.sysMemSamples = (int)((long)var1_1.sysMemSamples + var59_17[var60_18 + 0]);
            }
        }
        var10_22 = this.mProcesses.getMap();
        for (var11_23 = 0; var11_23 < (var12_24 = var10_22.size()); ++var11_23) {
            var13_25 = var10_22.valueAt(var11_23);
            block6: for (var14_26 = 0; var14_26 < (var15_27 = var13_25.size()); ++var14_26) {
                block33: {
                    block32: {
                        var16_28 = var13_25.valueAt(var14_26);
                        var17_29 = new PssAggr();
                        var18_30 = new PssAggr();
                        var19_31 = new PssAggr();
                        var20_32 = false;
                        block7: for (var21_33 = 0; var21_33 < var16_28.mDurationsTableSize; ++var21_33) {
                            block31: {
                                block30: {
                                    block29: {
                                        var46_54 = var16_28.mDurationsTable[var21_33] >> ProcessStats.OFFSET_TYPE_SHIFT & ProcessStats.OFFSET_TYPE_MASK;
                                        var47_55 = var46_54 % 14;
                                        var48_56 = var16_28.getPssSampleCount(var46_54);
                                        if (var48_56 <= 0L) break block29;
                                        var50_57 = var16_28.getPssAverage(var46_54);
                                        var20_32 = true;
                                        if (var47_55 > 2) break block30;
                                        var17_29.add(var50_57, var48_56);
                                    }
lbl71:
                                    // 3 sources

                                    continue block7;
                                }
                                if (var47_55 > 8) break block31;
                                var18_30.add(var50_57, var48_56);
                                ** GOTO lbl71
                            }
                            var19_31.add(var50_57, var48_56);
                            ** continue;
                        }
                        if (!var20_32) {
                            continue block6;
                        }
                        cfr_temp_1 = var17_29.samples - 3L;
                        var22_34 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
                        var23_35 = false;
                        if (var22_34 < 0) {
                            cfr_temp_2 = var18_30.samples - 0L;
                            var45_53 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
                            var23_35 = false;
                            if (var45_53 > 0) {
                                var23_35 = true;
                                var17_29.add(var18_30.pss, var18_30.samples);
                            }
                        }
                        var24_36 = (cfr_temp_3 = var17_29.samples - 3L) == 0L ? 0 : (cfr_temp_3 < 0L ? -1 : 1);
                        var25_37 = false;
                        if (var24_36 < 0) {
                            cfr_temp_4 = var19_31.samples - 0L;
                            var44_52 = cfr_temp_4 == 0L ? 0 : (cfr_temp_4 < 0L ? -1 : 1);
                            var25_37 = false;
                            if (var44_52 > 0) {
                                var25_37 = true;
                                var17_29.add(var19_31.pss, var19_31.samples);
                            }
                        }
                        var26_38 = (cfr_temp_5 = var18_30.samples - 3L) == 0L ? 0 : (cfr_temp_5 < 0L ? -1 : 1);
                        var27_39 = false;
                        if (var26_38 < 0) {
                            cfr_temp_6 = var19_31.samples - 0L;
                            var43_51 = cfr_temp_6 == 0L ? 0 : (cfr_temp_6 < 0L ? -1 : 1);
                            var27_39 = false;
                            if (var43_51 > 0) {
                                var27_39 = true;
                                var18_30.add(var19_31.pss, var19_31.samples);
                            }
                        }
                        if (var18_30.samples < 3L && !var23_35 && var17_29.samples > 0L) {
                            var18_30.add(var17_29.pss, var17_29.samples);
                        }
                        if (var19_31.samples < 3L && !var27_39 && var18_30.samples > 0L) {
                            var19_31.add(var18_30.pss, var18_30.samples);
                        }
                        if (var19_31.samples < 3L && !var25_37 && var17_29.samples > 0L) {
                            var19_31.add(var17_29.pss, var17_29.samples);
                        }
                        var28_40 = 0;
                        block10: while (true) {
                            if (var28_40 >= var16_28.mDurationsTableSize) ** continue;
                            var29_41 = var16_28.mDurationsTable[var28_40];
                            var30_42 = var29_41 >> ProcessStats.OFFSET_TYPE_SHIFT & ProcessStats.OFFSET_TYPE_MASK;
                            var31_43 = this.getLong(var29_41, 0);
                            if (var16_28.mCurState == var30_42) {
                                var31_43 += var2_2 - var16_28.mStartTime;
                            }
                            var33_44 = var30_42 % 14;
                            var34_45 = var1_1.processStateTime;
                            var34_45[var33_44] = var31_43 + var34_45[var33_44];
                            var35_46 = var16_28.getPssSampleCount(var30_42);
                            if (var35_46 <= 0L) break;
                            var37_47 = var16_28.getPssAverage(var30_42);
lbl131:
                            // 4 sources

                            while (true) {
                                var39_48 = ((double)var1_1.processStatePss[var33_44] * (double)var1_1.processStateSamples[var33_44] + (double)var37_47 * (double)var35_46) / (double)(var35_46 + (long)var1_1.processStateSamples[var33_44]);
                                var1_1.processStatePss[var33_44] = (long)var39_48;
                                var41_49 = var1_1.processStateSamples;
                                var41_49[var33_44] = (int)(var35_46 + (long)var41_49[var33_44]);
                                var42_50 = var1_1.processStateWeight;
                                var42_50[var33_44] = var42_50[var33_44] + (double)var37_47 * (double)var31_43;
                                ++var28_40;
                                continue block10;
                                break;
                            }
                            break;
                        }
                        if (var33_44 > 2) break block32;
                        var35_46 = var17_29.samples;
                        var37_47 = var17_29.pss;
                        ** GOTO lbl131
                    }
                    if (var33_44 > 8) break block33;
                    var35_46 = var18_30.samples;
                    var37_47 = var18_30.pss;
                    ** GOTO lbl131
                }
                var35_46 = var19_31.samples;
                var37_47 = var19_31.pss;
                ** continue;
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void dumpCheckinLocked(PrintWriter var1_1, String var2_2) {
        block24: {
            block23: {
                var3_3 = SystemClock.uptimeMillis();
                var5_4 = this.mPackages.getMap();
                var1_1.println("vers,5");
                var1_1.print("period,");
                var1_1.print(this.mTimePeriodStartClockStr);
                var1_1.print(",");
                var1_1.print(this.mTimePeriodStartRealtime);
                var1_1.print(",");
                if (this.mRunning) {
                    var6_5 = SystemClock.elapsedRealtime();
lbl11:
                    // 2 sources

                    while (true) {
                        var1_1.print(var6_5);
                        var8_6 = true;
                        if ((2 & this.mFlags) != 0) {
                            var1_1.print(",shutdown");
                            var8_6 = false;
                        }
                        if ((4 & this.mFlags) != 0) {
                            var1_1.print(",sysprops");
                            var8_6 = false;
                        }
                        if ((1 & this.mFlags) != 0) {
                            var1_1.print(",complete");
                            var8_6 = false;
                        }
                        if (var8_6) {
                            var1_1.print(",partial");
                        }
                        var1_1.println();
                        var1_1.print("config,");
                        var1_1.println(this.mRuntime);
                        block1: for (var9_7 = 0; var9_7 < (var10_8 = var5_4.size()); ++var9_7) {
                            var27_9 = var5_4.keyAt(var9_7);
                            if (var2_2 != null && !var2_2.equals(var27_9)) {
                                continue block1;
                            }
                            break block23;
                        }
                        break block24;
                        break;
                    }
                }
                var6_5 = this.mTimePeriodEndRealtime;
                ** while (true)
            }
            var28_10 = var5_4.valueAt(var9_7);
            var29_11 = 0;
            while (true) {
                if (var29_11 >= (var30_12 = var28_10.size())) ** continue;
                var31_13 = var28_10.keyAt(var29_11);
                var32_14 = var28_10.valueAt(var29_11);
                for (var33_15 = 0; var33_15 < (var34_16 = var32_14.size()); ++var33_15) {
                    var35_17 = var32_14.keyAt(var33_15);
                    var36_18 = var32_14.valueAt(var33_15);
                    var37_19 = var36_18.mProcesses.size();
                    var38_20 = var36_18.mServices.size();
                    for (var39_21 = 0; var39_21 < var37_19; ++var39_21) {
                        var43_25 = var36_18.mProcesses.valueAt(var39_21);
                        var1_1.print("pkgproc,");
                        var1_1.print(var27_9);
                        var1_1.print(",");
                        var1_1.print(var31_13);
                        var1_1.print(",");
                        var1_1.print(var35_17);
                        var1_1.print(",");
                        var1_1.print(this.collapseString(var27_9, var36_18.mProcesses.keyAt(var39_21)));
                        ProcessStats.dumpAllProcessStateCheckin(var1_1, var43_25, var3_3);
                        var1_1.println();
                        if (var43_25.mPssTableSize > 0) {
                            var1_1.print("pkgpss,");
                            var1_1.print(var27_9);
                            var1_1.print(",");
                            var1_1.print(var31_13);
                            var1_1.print(",");
                            var1_1.print(var35_17);
                            var1_1.print(",");
                            var1_1.print(this.collapseString(var27_9, var36_18.mProcesses.keyAt(var39_21)));
                            ProcessStats.dumpAllProcessPssCheckin(var1_1, var43_25);
                            var1_1.println();
                        }
                        if (var43_25.mNumExcessiveWake <= 0 && var43_25.mNumExcessiveCpu <= 0 && var43_25.mNumCachedKill <= 0) continue;
                        var1_1.print("pkgkills,");
                        var1_1.print(var27_9);
                        var1_1.print(",");
                        var1_1.print(var31_13);
                        var1_1.print(",");
                        var1_1.print(var35_17);
                        var1_1.print(",");
                        var1_1.print(this.collapseString(var27_9, var36_18.mProcesses.keyAt(var39_21)));
                        var1_1.print(",");
                        var1_1.print(var43_25.mNumExcessiveWake);
                        var1_1.print(",");
                        var1_1.print(var43_25.mNumExcessiveCpu);
                        var1_1.print(",");
                        var1_1.print(var43_25.mNumCachedKill);
                        var1_1.print(",");
                        var1_1.print(var43_25.mMinCachedKillPss);
                        var1_1.print(":");
                        var1_1.print(var43_25.mAvgCachedKillPss);
                        var1_1.print(":");
                        var1_1.print(var43_25.mMaxCachedKillPss);
                        var1_1.println();
                    }
                    for (var40_22 = 0; var40_22 < var38_20; ++var40_22) {
                        var41_23 = this.collapseString(var27_9, var36_18.mServices.keyAt(var40_22));
                        var42_24 = var36_18.mServices.valueAt(var40_22);
                        ProcessStats.dumpServiceTimeCheckin(var1_1, "pkgsvc-run", var27_9, var31_13, var35_17, var41_23, var42_24, 0, var42_24.mRunCount, var42_24.mRunState, var42_24.mRunStartTime, var3_3);
                        ProcessStats.dumpServiceTimeCheckin(var1_1, "pkgsvc-start", var27_9, var31_13, var35_17, var41_23, var42_24, 1, var42_24.mStartedCount, var42_24.mStartedState, var42_24.mStartedStartTime, var3_3);
                        ProcessStats.dumpServiceTimeCheckin(var1_1, "pkgsvc-bound", var27_9, var31_13, var35_17, var41_23, var42_24, 2, var42_24.mBoundCount, var42_24.mBoundState, var42_24.mBoundStartTime, var3_3);
                        ProcessStats.dumpServiceTimeCheckin(var1_1, "pkgsvc-exec", var27_9, var31_13, var35_17, var41_23, var42_24, 3, var42_24.mExecCount, var42_24.mExecState, var42_24.mExecStartTime, var3_3);
                    }
                }
                ++var29_11;
            }
        }
        var11_26 = this.mProcesses.getMap();
        for (var12_27 = 0; var12_27 < (var13_28 = var11_26.size()); ++var12_27) {
            var21_29 = var11_26.keyAt(var12_27);
            var22_30 = var11_26.valueAt(var12_27);
            for (var23_31 = 0; var23_31 < (var24_32 = var22_30.size()); ++var23_31) {
                var25_33 = var22_30.keyAt(var23_31);
                var26_34 = var22_30.valueAt(var23_31);
                if (var26_34.mDurationsTableSize > 0) {
                    var1_1.print("proc,");
                    var1_1.print(var21_29);
                    var1_1.print(",");
                    var1_1.print(var25_33);
                    ProcessStats.dumpAllProcessStateCheckin(var1_1, var26_34, var3_3);
                    var1_1.println();
                }
                if (var26_34.mPssTableSize > 0) {
                    var1_1.print("pss,");
                    var1_1.print(var21_29);
                    var1_1.print(",");
                    var1_1.print(var25_33);
                    ProcessStats.dumpAllProcessPssCheckin(var1_1, var26_34);
                    var1_1.println();
                }
                if (var26_34.mNumExcessiveWake <= 0 && var26_34.mNumExcessiveCpu <= 0 && var26_34.mNumCachedKill <= 0) continue;
                var1_1.print("kills,");
                var1_1.print(var21_29);
                var1_1.print(",");
                var1_1.print(var25_33);
                var1_1.print(",");
                var1_1.print(var26_34.mNumExcessiveWake);
                var1_1.print(",");
                var1_1.print(var26_34.mNumExcessiveCpu);
                var1_1.print(",");
                var1_1.print(var26_34.mNumCachedKill);
                var1_1.print(",");
                var1_1.print(var26_34.mMinCachedKillPss);
                var1_1.print(":");
                var1_1.print(var26_34.mAvgCachedKillPss);
                var1_1.print(":");
                var1_1.print(var26_34.mMaxCachedKillPss);
                var1_1.println();
            }
        }
        var1_1.print("total");
        ProcessStats.dumpAdjTimesCheckin(var1_1, ",", this.mMemFactorDurations, this.mMemFactor, this.mStartTime, var3_3);
        if (this.mSysMemUsageTable != null) {
            var1_1.print("sysmemusage");
            for (var16_35 = 0; var16_35 < (var17_36 = this.mSysMemUsageTableSize); ++var16_35) {
                var18_37 = this.mSysMemUsageTable[var16_35];
                var19_38 = var18_37 >> ProcessStats.OFFSET_TYPE_SHIFT & ProcessStats.OFFSET_TYPE_MASK;
                var1_1.print(",");
                ProcessStats.printProcStateTag(var1_1, var19_38);
                for (var20_39 = 0; var20_39 < 16; ++var20_39) {
                    if (var20_39 > 1) {
                        var1_1.print(":");
                    }
                    var1_1.print(this.getLong(var18_37, var20_39));
                }
            }
        }
        var1_1.println();
        var14_40 = new TotalMemoryUseCollection(ProcessStats.ALL_SCREEN_ADJ, ProcessStats.ALL_MEM_ADJ);
        this.computeTotalMemoryUse(var14_40, var3_3);
        var1_1.print("weights,");
        var1_1.print(var14_40.totalTime);
        var1_1.print(",");
        var1_1.print(var14_40.sysMemCachedWeight);
        var1_1.print(":");
        var1_1.print(var14_40.sysMemSamples);
        var1_1.print(",");
        var1_1.print(var14_40.sysMemFreeWeight);
        var1_1.print(":");
        var1_1.print(var14_40.sysMemSamples);
        var1_1.print(",");
        var1_1.print(var14_40.sysMemZRamWeight);
        var1_1.print(":");
        var1_1.print(var14_40.sysMemSamples);
        var1_1.print(",");
        var1_1.print(var14_40.sysMemKernelWeight);
        var1_1.print(":");
        var1_1.print(var14_40.sysMemSamples);
        var1_1.print(",");
        var1_1.print(var14_40.sysMemNativeWeight);
        var1_1.print(":");
        var1_1.print(var14_40.sysMemSamples);
        for (var15_41 = 0; var15_41 < 14; ++var15_41) {
            var1_1.print(",");
            var1_1.print(var14_40.processStateWeight[var15_41]);
            var1_1.print(":");
            var1_1.print(var14_40.processStateSamples[var15_41]);
        }
        var1_1.println();
    }

    void dumpFilteredSummaryLocked(PrintWriter printWriter, String string2, String string3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l, long l2, String string4, boolean bl) {
        ArrayList<ProcessState> arrayList = this.collectProcessesLocked(nArray, nArray2, nArray3, nArray4, l, string4, bl);
        if (arrayList.size() > 0) {
            if (string2 != null) {
                printWriter.println();
                printWriter.println(string2);
            }
            ProcessStats.dumpProcessSummaryLocked(printWriter, string3, arrayList, nArray, nArray2, nArray4, true, l, l2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void dumpLocked(PrintWriter var1_1, String var2_2, long var3_3, boolean var5_4, boolean var6_5, boolean var7_6) {
        var8_7 = ProcessStats.dumpSingleTime(null, null, this.mMemFactorDurations, this.mMemFactor, this.mStartTime, var3_3);
        var10_8 = this.mSysMemUsageTable;
        var11_9 = false;
        if (var10_8 != null) {
            var1_1.println("System memory usage:");
            this.dumpSysMemUsage(var1_1, "  ", ProcessStats.ALL_SCREEN_ADJ, ProcessStats.ALL_MEM_ADJ);
            var11_9 = true;
        }
        var12_10 = this.mPackages.getMap();
        var13_11 = false;
        for (var14_12 = 0; var14_12 < (var15_13 = var12_10.size()); ++var14_12) {
            var28_14 = var12_10.keyAt(var14_12);
            var29_15 = var12_10.valueAt(var14_12);
            for (var30_16 = 0; var30_16 < (var31_17 = var29_15.size()); ++var30_16) {
                var32_18 = var29_15.keyAt(var30_16);
                var33_19 = var29_15.valueAt(var30_16);
                block2: for (var34_20 = 0; var34_20 < (var35_21 = var33_19.size()); ++var34_20) {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    block49: {
                                        block48: {
                                            block47: {
                                                block45: {
                                                    block39: {
                                                        block44: {
                                                            var36_22 = var33_19.keyAt(var34_20);
                                                            var37_23 = var33_19.valueAt(var34_20);
                                                            var38_24 = var37_23.mProcesses.size();
                                                            var39_25 = var37_23.mServices.size();
                                                            if (var2_2 != null && !var2_2.equals(var28_14)) break block44;
                                                            var40_26 = true;
lbl23:
                                                            // 2 sources

                                                            while (!var40_26) {
                                                                var69_50 = 0;
lbl25:
                                                                // 2 sources

                                                                while (true) {
                                                                    var70_51 = ++var69_50;
                                                                    var71_52 = false;
                                                                    if (var70_51 < var38_24) {
                                                                        if (!var2_2.equals(var37_23.mProcesses.valueAt((int)var69_50).mName)) continue;
                                                                        var71_52 = true;
                                                                    }
                                                                    if (!var71_52) {
                                                                        continue block2;
                                                                    }
                                                                    break block39;
                                                                    break;
                                                                }
                                                            }
                                                            break block39;
                                                        }
                                                        var40_26 = false;
                                                        ** GOTO lbl23
                                                        ** continue;
                                                    }
                                                    if (var38_24 > 0 || var39_25 > 0) {
                                                        if (!var13_11) {
                                                            if (var11_9) {
                                                                var1_1.println();
                                                            }
                                                            var1_1.println("Per-Package Stats:");
                                                            var13_11 = true;
                                                            var11_9 = true;
                                                        }
                                                        var1_1.print("  * ");
                                                        var1_1.print(var28_14);
                                                        var1_1.print(" / ");
                                                        UserHandle.formatUid(var1_1, var32_18);
                                                        var1_1.print(" / v");
                                                        var1_1.print(var36_22);
                                                        var1_1.println(":");
                                                    }
                                                    if (var5_4 && !var6_5) break block45;
                                                    block6: for (var41_27 = 0; var41_27 < var38_24; ++var41_27) {
                                                        block46: {
                                                            var64_46 = var37_23.mProcesses.valueAt(var41_27);
                                                            if (!var40_26 && !var2_2.equals(var64_46.mName)) lbl-1000:
                                                            // 3 sources

                                                            {
                                                                continue block6;
                                                            }
                                                            if (!var7_6 || var64_46.isInUse()) break block46;
                                                            var1_1.print("      (Not active: ");
                                                            var1_1.print(var37_23.mProcesses.keyAt(var41_27));
                                                            var1_1.println(")");
                                                            ** GOTO lbl-1000
                                                        }
                                                        var1_1.print("      Process ");
                                                        var1_1.print(var37_23.mProcesses.keyAt(var41_27));
                                                        if (var64_46.mCommonProcess.mMultiPackage) {
                                                            var1_1.print(" (multi, ");
lbl71:
                                                            // 2 sources

                                                            while (true) {
                                                                var1_1.print(var64_46.mDurationsTableSize);
                                                                var1_1.print(" entries)");
                                                                var1_1.println(":");
                                                                ProcessStats.dumpProcessState(var1_1, "        ", var64_46, ProcessStats.ALL_SCREEN_ADJ, ProcessStats.ALL_MEM_ADJ, ProcessStats.ALL_PROC_STATES, var3_3);
                                                                ProcessStats.dumpProcessPss(var1_1, "        ", var64_46, ProcessStats.ALL_SCREEN_ADJ, ProcessStats.ALL_MEM_ADJ, ProcessStats.ALL_PROC_STATES);
                                                                this.dumpProcessInternalLocked(var1_1, "        ", var64_46, var6_5);
                                                                ** continue;
                                                                break;
                                                            }
                                                        }
                                                        var1_1.print(" (unique, ");
                                                        ** continue;
                                                    }
                                                    break block47;
                                                }
                                                var65_47 = new ArrayList<ProcessState>();
                                                block9: for (var66_48 = 0; var66_48 < var38_24; ++var66_48) {
                                                    var67_49 = var37_23.mProcesses.valueAt(var66_48);
                                                    if (!var40_26 && !var2_2.equals(var67_49.mName)) lbl-1000:
                                                    // 3 sources

                                                    {
                                                        continue block9;
                                                    }
                                                    if (var7_6 && !var67_49.isInUse()) ** GOTO lbl-1000
                                                    var65_47.add(var67_49);
                                                    ** continue;
                                                }
                                                ProcessStats.dumpProcessSummaryLocked(var1_1, "      ", var65_47, ProcessStats.ALL_SCREEN_ADJ, ProcessStats.ALL_MEM_ADJ, ProcessStats.NON_CACHED_PROC_STATES, false, var3_3, var8_7);
                                            }
                                            var42_28 = 0;
                                            block11: while (true) {
                                                if (var42_28 >= var39_25) ** continue;
                                                var43_29 = var37_23.mServices.valueAt(var42_28);
                                                if (var40_26 || var2_2.equals(var43_29.mProcessName)) break;
lbl100:
                                                // 5 sources

                                                while (true) {
                                                    ++var42_28;
                                                    continue block11;
                                                    break;
                                                }
                                                break;
                                            }
                                            if (!var7_6 || var43_29.isInUse()) break block48;
                                            var1_1.print("      (Not active: ");
                                            var1_1.print(var37_23.mServices.keyAt(var42_28));
                                            var1_1.println(")");
                                            ** GOTO lbl100
                                        }
                                        if (!var6_5) break block49;
                                        var1_1.print("      Service ");
lbl111:
                                        // 2 sources

                                        while (true) {
                                            var1_1.print(var37_23.mServices.keyAt(var42_28));
                                            var1_1.println(":");
                                            var1_1.print("        Process: ");
                                            var1_1.println(var43_29.mProcessName);
                                            var44_30 = var43_29.mRunCount;
                                            var45_31 = var43_29.mRunState;
                                            var46_32 = var43_29.mRunStartTime;
                                            if (var5_4 && !var6_5) break block40;
                                            var48_33 = true;
lbl121:
                                            // 2 sources

                                            while (true) {
                                                this.dumpServiceStats(var1_1, "        ", "          ", "    ", "Running", var43_29, var44_30, 0, var45_31, var46_32, var3_3, var8_7, var48_33);
                                                var49_34 = var43_29.mStartedCount;
                                                var50_35 = var43_29.mStartedState;
                                                var51_36 = var43_29.mStartedStartTime;
                                                if (var5_4 && !var6_5) break block41;
                                                var53_37 = true;
lbl128:
                                                // 2 sources

                                                while (true) {
                                                    this.dumpServiceStats(var1_1, "        ", "          ", "    ", "Started", var43_29, var49_34, 1, var50_35, var51_36, var3_3, var8_7, var53_37);
                                                    var54_38 = var43_29.mBoundCount;
                                                    var55_39 = var43_29.mBoundState;
                                                    var56_40 = var43_29.mBoundStartTime;
                                                    if (var5_4 && !var6_5) break block42;
                                                    var58_41 = true;
lbl135:
                                                    // 2 sources

                                                    while (true) {
                                                        this.dumpServiceStats(var1_1, "        ", "          ", "      ", "Bound", var43_29, var54_38, 2, var55_39, var56_40, var3_3, var8_7, var58_41);
                                                        var59_42 = var43_29.mExecCount;
                                                        var60_43 = var43_29.mExecState;
                                                        var61_44 = var43_29.mExecStartTime;
                                                        if (var5_4 && !var6_5) break block43;
                                                        var63_45 = true;
lbl142:
                                                        // 2 sources

                                                        while (true) {
                                                            this.dumpServiceStats(var1_1, "        ", "          ", "  ", "Executing", var43_29, var59_42, 3, var60_43, var61_44, var3_3, var8_7, var63_45);
                                                            if (!var6_5) ** GOTO lbl100
                                                            if (var43_29.mOwner != null) {
                                                                var1_1.print("        mOwner=");
                                                                var1_1.println(var43_29.mOwner);
                                                            }
                                                            if (!var43_29.mStarted && !var43_29.mRestarting) ** GOTO lbl100
                                                            var1_1.print("        mStarted=");
                                                            var1_1.print(var43_29.mStarted);
                                                            var1_1.print(" mRestarting=");
                                                            var1_1.println(var43_29.mRestarting);
                                                            ** continue;
                                                            break;
                                                        }
                                                        break;
                                                    }
                                                    break;
                                                }
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    var1_1.print("      * ");
                                    ** continue;
                                }
                                var48_33 = false;
                                ** continue;
                            }
                            var53_37 = false;
                            ** continue;
                        }
                        var58_41 = false;
                        ** continue;
                    }
                    var63_45 = false;
                    ** continue;
                }
            }
        }
        var16_53 = this.mProcesses.getMap();
        var17_54 = false;
        var18_55 = 0;
        var19_56 = 0;
        for (var20_57 = 0; var20_57 < (var21_58 = var16_53.size()); ++var20_57) {
            var22_59 = var16_53.keyAt(var20_57);
            var23_60 = var16_53.valueAt(var20_57);
            block19: for (var24_61 = 0; var24_61 < (var25_62 = var23_60.size()); ++var24_61) {
                block50: {
                    var26_63 = var23_60.keyAt(var24_61);
                    ++var19_56;
                    var27_64 = var23_60.valueAt(var24_61);
                    if (var27_64.mDurationsTableSize == 0 && var27_64.mCurState == -1 && var27_64.mPssTableSize == 0) lbl-1000:
                    // 4 sources

                    {
                        continue block19;
                    }
                    if (!var27_64.mMultiPackage || var2_2 != null && !var2_2.equals(var22_59) && !var2_2.equals(var27_64.mPackage)) ** GOTO lbl-1000
                    ++var18_55;
                    if (var11_9) {
                        var1_1.println();
                    }
                    var11_9 = true;
                    if (!var17_54) {
                        var1_1.println("Multi-Package Common Processes:");
                        var17_54 = true;
                    }
                    if (!var7_6 || var27_64.isInUse()) break block50;
                    var1_1.print("      (Not active: ");
                    var1_1.print(var22_59);
                    var1_1.println(")");
                    ** GOTO lbl-1000
                }
                var1_1.print("  * ");
                var1_1.print(var22_59);
                var1_1.print(" / ");
                UserHandle.formatUid(var1_1, var26_63);
                var1_1.print(" (");
                var1_1.print(var27_64.mDurationsTableSize);
                var1_1.print(" entries)");
                var1_1.println(":");
                ProcessStats.dumpProcessState(var1_1, "        ", var27_64, ProcessStats.ALL_SCREEN_ADJ, ProcessStats.ALL_MEM_ADJ, ProcessStats.ALL_PROC_STATES, var3_3);
                ProcessStats.dumpProcessPss(var1_1, "        ", var27_64, ProcessStats.ALL_SCREEN_ADJ, ProcessStats.ALL_MEM_ADJ, ProcessStats.ALL_PROC_STATES);
                this.dumpProcessInternalLocked(var1_1, "        ", var27_64, var6_5);
                ** continue;
            }
        }
        if (var6_5) {
            var1_1.println();
            var1_1.print("  Total procs: ");
            var1_1.print(var18_55);
            var1_1.print(" shown of ");
            var1_1.print(var19_56);
            var1_1.println(" total");
        }
        if (var11_9) {
            var1_1.println();
        }
        if (var5_4) {
            var1_1.println("Summary:");
            this.dumpSummaryLocked(var1_1, var2_2, var3_3, var7_6);
lbl224:
            // 2 sources

            while (true) {
                if (var6_5) {
                    var1_1.println();
                    var1_1.println("Internal state:");
                    var1_1.print("  Num long arrays: ");
                    var1_1.println(this.mLongs.size());
                    var1_1.print("  Next long entry: ");
                    var1_1.println(this.mNextLong);
                    var1_1.print("  mRunning=");
                    var1_1.println(this.mRunning);
                }
                return;
            }
        }
        this.dumpTotalsLocked(var1_1, var3_3);
        ** while (true)
    }

    void dumpServiceStats(PrintWriter printWriter, String string2, String string3, String string4, String string5, ServiceState serviceState, int n, int n2, int n3, long l, long l2, long l3, boolean bl) {
        block3: {
            block2: {
                if (n == 0) break block2;
                if (!bl) break block3;
                printWriter.print(string2);
                printWriter.print(string5);
                printWriter.print(" op count ");
                printWriter.print(n);
                printWriter.println(":");
                ProcessStats.dumpSingleServiceTime(printWriter, string3, serviceState, n2, n3, l, l2);
            }
            return;
        }
        long l4 = ProcessStats.dumpSingleServiceTime(null, null, serviceState, n2, n3, l, l2);
        printWriter.print(string2);
        printWriter.print(string4);
        printWriter.print(string5);
        printWriter.print(" count ");
        printWriter.print(n);
        printWriter.print(" / time ");
        ProcessStats.printPercent(printWriter, (double)l4 / (double)l3);
        printWriter.println();
    }

    public void dumpSummaryLocked(PrintWriter printWriter, String string2, long l, boolean bl) {
        long l2 = ProcessStats.dumpSingleTime(null, null, this.mMemFactorDurations, this.mMemFactor, this.mStartTime, l);
        this.dumpFilteredSummaryLocked(printWriter, null, "  ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, NON_CACHED_PROC_STATES, l, l2, string2, bl);
        printWriter.println();
        this.dumpTotalsLocked(printWriter, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dumpSysMemUsage(PrintWriter printWriter, String string2, int[] nArray, int[] nArray2) {
        int n = -1;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = -1;
            for (int i = 0; i < nArray2.length; ++i) {
                int n4 = nArray[n2];
                int n5 = nArray2[i];
                int n6 = 14 * (n4 + n5);
                long l = this.getSysMemUsageValue(n6, 0);
                if (l <= 0L) continue;
                printWriter.print(string2);
                if (nArray.length > 1) {
                    int n7 = n != n4 ? n4 : -1;
                    ProcessStats.printScreenLabel(printWriter, n7);
                    n = n4;
                }
                if (nArray2.length > 1) {
                    int n8 = n3 != n5 ? n5 : -1;
                    ProcessStats.printMemLabel(printWriter, n8, '\u0000');
                    n3 = n5;
                }
                printWriter.print(": ");
                printWriter.print(l);
                printWriter.println(" samples:");
                this.dumpSysMemUsageCategory(printWriter, string2, "  Cached", n6, 1);
                this.dumpSysMemUsageCategory(printWriter, string2, "  Free", n6, 4);
                this.dumpSysMemUsageCategory(printWriter, string2, "  ZRam", n6, 7);
                this.dumpSysMemUsageCategory(printWriter, string2, "  Kernel", n6, 10);
                this.dumpSysMemUsageCategory(printWriter, string2, "  Native", n6, 13);
            }
            ++n2;
        }
        return;
    }

    void dumpSysMemUsageCategory(PrintWriter printWriter, String string2, String string3, int n, int n2) {
        printWriter.print(string2);
        printWriter.print(string3);
        printWriter.print(": ");
        ProcessStats.printSizeValue(printWriter, 1024L * this.getSysMemUsageValue(n, n2));
        printWriter.print(" min, ");
        ProcessStats.printSizeValue(printWriter, 1024L * this.getSysMemUsageValue(n, n2 + 1));
        printWriter.print(" avg, ");
        ProcessStats.printSizeValue(printWriter, 1024L * this.getSysMemUsageValue(n, n2 + 2));
        printWriter.println(" max");
    }

    /*
     * Enabled aggressive block sorting
     */
    void dumpTotalsLocked(PrintWriter printWriter, long l) {
        printWriter.println("Run time Stats:");
        ProcessStats.dumpSingleTime(printWriter, "  ", this.mMemFactorDurations, this.mMemFactor, this.mStartTime, l);
        printWriter.println();
        printWriter.println("Memory usage:");
        TotalMemoryUseCollection totalMemoryUseCollection = new TotalMemoryUseCollection(ALL_SCREEN_ADJ, ALL_MEM_ADJ);
        this.computeTotalMemoryUse(totalMemoryUseCollection, l);
        long l2 = this.printMemoryCategory(printWriter, "  ", "Kernel ", totalMemoryUseCollection.sysMemKernelWeight, totalMemoryUseCollection.totalTime, 0L, totalMemoryUseCollection.sysMemSamples);
        long l3 = this.printMemoryCategory(printWriter, "  ", "Native ", totalMemoryUseCollection.sysMemNativeWeight, totalMemoryUseCollection.totalTime, l2, totalMemoryUseCollection.sysMemSamples);
        for (int i = 0; i < 14; ++i) {
            if (i == 7) continue;
            l3 = this.printMemoryCategory(printWriter, "  ", STATE_NAMES[i], totalMemoryUseCollection.processStateWeight[i], totalMemoryUseCollection.totalTime, l3, totalMemoryUseCollection.processStateSamples[i]);
        }
        long l4 = this.printMemoryCategory(printWriter, "  ", "Cached ", totalMemoryUseCollection.sysMemCachedWeight, totalMemoryUseCollection.totalTime, l3, totalMemoryUseCollection.sysMemSamples);
        long l5 = this.printMemoryCategory(printWriter, "  ", "Free   ", totalMemoryUseCollection.sysMemFreeWeight, totalMemoryUseCollection.totalTime, l4, totalMemoryUseCollection.sysMemSamples);
        long l6 = this.printMemoryCategory(printWriter, "  ", "Z-Ram   ", totalMemoryUseCollection.sysMemZRamWeight, totalMemoryUseCollection.totalTime, l5, totalMemoryUseCollection.sysMemSamples);
        printWriter.print("  TOTAL  : ");
        ProcessStats.printSizeValue(printWriter, l6);
        printWriter.println();
        this.printMemoryCategory(printWriter, "  ", STATE_NAMES[7], totalMemoryUseCollection.processStateWeight[7], totalMemoryUseCollection.totalTime, l6, totalMemoryUseCollection.processStateSamples[7]);
        printWriter.println();
        printWriter.print("          Start time: ");
        printWriter.print(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mTimePeriodStartClock));
        printWriter.println();
        printWriter.print("  Total elapsed time: ");
        long l7 = this.mRunning ? SystemClock.elapsedRealtime() : this.mTimePeriodEndRealtime;
        TimeUtils.formatDuration(l7 - this.mTimePeriodStartRealtime, printWriter);
        boolean bl = true;
        if ((2 & this.mFlags) != 0) {
            printWriter.print(" (shutdown)");
            bl = false;
        }
        if ((4 & this.mFlags) != 0) {
            printWriter.print(" (sysprops)");
            bl = false;
        }
        if ((1 & this.mFlags) != 0) {
            printWriter.print(" (complete)");
            bl = false;
        }
        if (bl) {
            printWriter.print(" (partial)");
        }
        printWriter.print(' ');
        printWriter.print(this.mRuntime);
        printWriter.println();
    }

    public boolean evaluateSystemProperties(boolean bl) {
        String string2 = SystemProperties.get("persist.sys.dalvik.vm.lib.2", VMRuntime.getRuntime().vmLibrary());
        boolean bl2 = Objects.equals(string2, this.mRuntime);
        boolean bl3 = false;
        if (!bl2) {
            bl3 = true;
            if (bl) {
                this.mRuntime = string2;
            }
        }
        return bl3;
    }

    long getLong(int n, int n2) {
        return this.mLongs.get(n >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK)[n2 + (n >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK)];
    }

    public PackageState getPackageStateLocked(String string2, int n, int n2) {
        PackageState packageState;
        SparseArray<PackageState> sparseArray = this.mPackages.get(string2, n);
        if (sparseArray == null) {
            sparseArray = new SparseArray();
            this.mPackages.put(string2, n, sparseArray);
        }
        if ((packageState = sparseArray.get(n2)) != null) {
            return packageState;
        }
        PackageState packageState2 = new PackageState(string2, n);
        sparseArray.put(n2, packageState2);
        return packageState2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ProcessState getProcessStateLocked(String string2, int n, int n2, String string3) {
        ProcessState processState;
        PackageState packageState = this.getPackageStateLocked(string2, n, n2);
        ProcessState processState2 = packageState.mProcesses.get(string3);
        if (processState2 != null) {
            return processState2;
        }
        ProcessState processState3 = this.mProcesses.get(string3, n);
        if (processState3 == null) {
            processState3 = new ProcessState(this, string2, n, n2, string3);
            this.mProcesses.put(string3, n, processState3);
        }
        if (!processState3.mMultiPackage) {
            if (string2.equals(processState3.mPackage) && n2 == processState3.mVersion) {
                processState = processState3;
            } else {
                processState3.mMultiPackage = true;
                long l = SystemClock.uptimeMillis();
                PackageState packageState2 = this.getPackageStateLocked(processState3.mPackage, n, processState3.mVersion);
                if (packageState2 != null) {
                    ProcessState processState4 = processState3.clone(processState3.mPackage, l);
                    packageState2.mProcesses.put(processState3.mName, processState4);
                    for (int i = -1 + packageState2.mServices.size(); i >= 0; --i) {
                        ServiceState serviceState = packageState2.mServices.valueAt(i);
                        if (serviceState.mProc != processState3) continue;
                        serviceState.mProc = processState4;
                    }
                } else {
                    Slog.w(TAG, "Cloning proc state: no package state " + processState3.mPackage + "/" + n + " for proc " + processState3.mName);
                }
                processState = new ProcessState(processState3, string2, n, n2, string3, l);
            }
        } else {
            long l = SystemClock.uptimeMillis();
            processState = new ProcessState(processState3, string2, n, n2, string3, l);
        }
        packageState.mProcesses.put(string3, processState);
        return processState;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ServiceState getServiceStateLocked(String string2, int n, int n2, String string3, String string4) {
        PackageState packageState = this.getPackageStateLocked(string2, n, n2);
        ServiceState serviceState = packageState.mServices.get(string4);
        if (serviceState != null) {
            return serviceState;
        }
        ProcessState processState = string3 != null ? this.getProcessStateLocked(string2, n, n2, string3) : null;
        ServiceState serviceState2 = new ServiceState(this, string2, string4, string3, processState);
        packageState.mServices.put(string4, serviceState2);
        return serviceState2;
    }

    long getSysMemUsageValue(int n, int n2) {
        int n3 = ProcessStats.binarySearch(this.mSysMemUsageTable, this.mSysMemUsageTableSize, n);
        if (n3 >= 0) {
            return this.getLong(this.mSysMemUsageTable[n3], n2);
        }
        return 0L;
    }

    long printMemoryCategory(PrintWriter printWriter, String string2, String string3, double d, long l, long l2, int n) {
        if (d != 0.0) {
            long l3 = (long)(1024.0 * d / (double)l);
            printWriter.print(string2);
            printWriter.print(string3);
            printWriter.print(": ");
            ProcessStats.printSizeValue(printWriter, l3);
            printWriter.print(" (");
            printWriter.print(n);
            printWriter.print(" samples)");
            printWriter.println();
            l2 += l3;
        }
        return l2;
    }

    public void read(InputStream inputStream) {
        try {
            int[] nArray = new int[1];
            byte[] byArray = ProcessStats.readFully(inputStream, nArray);
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(byArray, 0, nArray[0]);
            parcel.setDataPosition(0);
            inputStream.close();
            this.readFromParcel(parcel);
            return;
        }
        catch (IOException iOException) {
            this.mReadError = "caught exception: " + iOException;
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void readFromParcel(Parcel var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void reset() {
        this.resetCommon();
        this.mPackages.getMap().clear();
        this.mProcesses.getMap().clear();
        this.mMemFactor = -1;
        this.mStartTime = 0L;
    }

    /*
     * Unable to fully structure code
     */
    public void resetSafely() {
        this.resetCommon();
        var1_1 = SystemClock.uptimeMillis();
        var3_2 = this.mProcesses.getMap();
        for (var4_3 = -1 + var3_2.size(); var4_3 >= 0; --var4_3) {
            var26_4 = var3_2.valueAt(var4_3);
            for (var27_5 = -1 + var26_4.size(); var27_5 >= 0; --var27_5) {
                var26_4.valueAt((int)var27_5).mTmpNumInUse = 0;
            }
        }
        var5_6 = this.mPackages.getMap();
        for (var6_7 = -1 + var5_6.size(); var6_7 >= 0; --var6_7) {
            var13_8 = var5_6.valueAt(var6_7);
            for (var14_9 = -1 + var13_8.size(); var14_9 >= 0; --var14_9) {
                var16_10 = var13_8.valueAt(var14_9);
                for (var17_11 = -1 + var16_10.size(); var17_11 >= 0; --var17_11) {
                    var18_12 = var16_10.valueAt(var17_11);
                    block5: for (var19_13 = -1 + var18_12.mProcesses.size(); var19_13 >= 0; --var19_13) {
                        var23_16 = var18_12.mProcesses.valueAt(var19_13);
                        if (var23_16.isInUse()) {
                            var23_16.resetSafely(var1_1);
                            var25_17 = var23_16.mCommonProcess;
                            var25_17.mTmpNumInUse = 1 + var25_17.mTmpNumInUse;
                            var23_16.mCommonProcess.mTmpFoundSubProc = var23_16;
lbl24:
                            // 2 sources

                            continue block5;
                        }
                        var18_12.mProcesses.valueAt(var19_13).makeDead();
                        var18_12.mProcesses.removeAt(var19_13);
                        ** continue;
                    }
                    block7: for (var20_14 = -1 + var18_12.mServices.size(); var20_14 >= 0; --var20_14) {
                        var21_15 = var18_12.mServices.valueAt(var20_14);
                        if (var21_15.isInUse()) {
                            var21_15.resetSafely(var1_1);
lbl34:
                            // 2 sources

                            continue block7;
                        }
                        var18_12.mServices.removeAt(var20_14);
                        ** continue;
                    }
                    if (var18_12.mProcesses.size() > 0 || var18_12.mServices.size() > 0) continue;
                    var16_10.removeAt(var17_11);
                }
                if (var16_10.size() > 0) continue;
                var13_8.removeAt(var14_9);
            }
            if (var13_8.size() > 0) continue;
            var5_6.removeAt(var6_7);
        }
        for (var7_18 = -1 + var3_2.size(); var7_18 >= 0; --var7_18) {
            var8_19 = var3_2.valueAt(var7_18);
            block10: for (var9_20 = -1 + var8_19.size(); var9_20 >= 0; --var9_20) {
                block15: {
                    var11_21 = var8_19.valueAt(var9_20);
                    if (!var11_21.isInUse() && var11_21.mTmpNumInUse <= 0) break block15;
                    if (!var11_21.mActive && var11_21.mMultiPackage && var11_21.mTmpNumInUse == 1) {
                        var12_22.mCommonProcess = var12_22 = var11_21.mTmpFoundSubProc;
                        var8_19.setValueAt(var9_20, var12_22);
lbl57:
                        // 3 sources

                        continue block10;
                    }
                    var11_21.resetSafely(var1_1);
                    ** GOTO lbl57
                }
                var11_21.makeDead();
                var8_19.removeAt(var9_20);
                ** continue;
            }
            if (var8_19.size() > 0) continue;
            var3_2.removeAt(var7_18);
        }
        this.mStartTime = var1_1;
    }

    void setLong(int n, int n2, long l) {
        this.mLongs.get((int)(n >> ProcessStats.OFFSET_ARRAY_SHIFT & ProcessStats.OFFSET_ARRAY_MASK))[n2 + (n >> ProcessStats.OFFSET_INDEX_SHIFT & ProcessStats.OFFSET_INDEX_MASK)] = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean validateLongOffset(int n) {
        return (n >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK) < this.mLongs.size() && (n >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK) < 4096;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.writeToParcel(parcel, SystemClock.uptimeMillis(), n);
    }

    /*
     * Unable to fully structure code
     */
    public void writeToParcel(Parcel var1_1, long var2_2, int var4_3) {
        var1_1.writeInt(1347638355);
        var1_1.writeInt(18);
        var1_1.writeInt(14);
        var1_1.writeInt(8);
        var1_1.writeInt(7);
        var1_1.writeInt(16);
        var1_1.writeInt(4096);
        this.mCommonStringToIndex = new ArrayMap<K, V>(this.mProcesses.mMap.size());
        var5_4 = this.mProcesses.getMap();
        var6_5 = var5_4.size();
        for (var7_6 = 0; var7_6 < var6_5; ++var7_6) {
            var47_9 = var5_4.valueAt(var7_6);
            var48_7 = var47_9.size();
            for (var49_8 = 0; var49_8 < var48_7; ++var49_8) {
                var47_9.valueAt(var49_8).commitStateTime(var2_2);
            }
        }
        var8_10 = this.mPackages.getMap();
        var9_11 = var8_10.size();
        for (var10_12 = 0; var10_12 < var9_11; ++var10_12) {
            var35_13 = var8_10.valueAt(var10_12);
            var36_14 = var35_13.size();
            for (var37_15 = 0; var37_15 < var36_14; ++var37_15) {
                var38_16 = var35_13.valueAt(var37_15);
                var39_17 = var38_16.size();
                for (var40_18 = 0; var40_18 < var39_17; ++var40_18) {
                    var41_19 = var38_16.valueAt(var40_18);
                    var42_20 = var41_19.mProcesses.size();
                    for (var43_21 = 0; var43_21 < var42_20; ++var43_21) {
                        var46_24 = var41_19.mProcesses.valueAt(var43_21);
                        if (var46_24.mCommonProcess == var46_24) continue;
                        var46_24.commitStateTime(var2_2);
                    }
                    var44_22 = var41_19.mServices.size();
                    for (var45_23 = 0; var45_23 < var44_22; ++var45_23) {
                        var41_19.mServices.valueAt(var45_23).commitStateTime(var2_2);
                    }
                }
            }
        }
        var1_1.writeLong(this.mTimePeriodStartClock);
        var1_1.writeLong(this.mTimePeriodStartRealtime);
        var1_1.writeLong(this.mTimePeriodEndRealtime);
        var1_1.writeLong(this.mTimePeriodStartUptime);
        var1_1.writeLong(this.mTimePeriodEndUptime);
        var1_1.writeString(this.mRuntime);
        var1_1.writeInt(this.mFlags);
        var1_1.writeInt(this.mLongs.size());
        var1_1.writeInt(this.mNextLong);
        for (var11_25 = 0; var11_25 < -1 + this.mLongs.size(); ++var11_25) {
            var34_26 = this.mLongs.get(var11_25);
            this.writeCompactedLongArray(var1_1, var34_26, var34_26.length);
        }
        this.writeCompactedLongArray(var1_1, this.mLongs.get(-1 + this.mLongs.size()), this.mNextLong);
        if (this.mMemFactor != -1) {
            var32_27 = this.mMemFactorDurations;
            var33_28 = this.mMemFactor;
            var32_27[var33_28] = var32_27[var33_28] + (var2_2 - this.mStartTime);
            this.mStartTime = var2_2;
        }
        this.writeCompactedLongArray(var1_1, this.mMemFactorDurations, this.mMemFactorDurations.length);
        var1_1.writeInt(this.mSysMemUsageTableSize);
        for (var12_29 = 0; var12_29 < this.mSysMemUsageTableSize; ++var12_29) {
            var1_1.writeInt(this.mSysMemUsageTable[var12_29]);
        }
        var1_1.writeInt(var6_5);
        for (var13_30 = 0; var13_30 < var6_5; ++var13_30) {
            this.writeCommonString(var1_1, var5_4.keyAt(var13_30));
            var28_31 = var5_4.valueAt(var13_30);
            var29_32 = var28_31.size();
            var1_1.writeInt(var29_32);
            for (var30_33 = 0; var30_33 < var29_32; ++var30_33) {
                var1_1.writeInt(var28_31.keyAt(var30_33));
                var31_34 = var28_31.valueAt(var30_33);
                this.writeCommonString(var1_1, var31_34.mPackage);
                var1_1.writeInt(var31_34.mVersion);
                var31_34.writeToParcel(var1_1, var2_2);
            }
        }
        var1_1.writeInt(var9_11);
        for (var14_35 = 0; var14_35 < var9_11; ++var14_35) {
            this.writeCommonString(var1_1, var8_10.keyAt(var14_35));
            var15_36 = var8_10.valueAt(var14_35);
            var16_37 = var15_36.size();
            var1_1.writeInt(var16_37);
            for (var17_38 = 0; var17_38 < var16_37; ++var17_38) {
                var1_1.writeInt(var15_36.keyAt(var17_38));
                var18_39 = var15_36.valueAt(var17_38);
                var19_40 = var18_39.size();
                var1_1.writeInt(var19_40);
                for (var20_41 = 0; var20_41 < var19_40; ++var20_41) {
                    var1_1.writeInt(var18_39.keyAt(var20_41));
                    var21_42 = var18_39.valueAt(var20_41);
                    var22_43 = var21_42.mProcesses.size();
                    var1_1.writeInt(var22_43);
                    block14: for (var23_44 = 0; var23_44 < var22_43; ++var23_44) {
                        this.writeCommonString(var1_1, var21_42.mProcesses.keyAt(var23_44));
                        var27_48 = var21_42.mProcesses.valueAt(var23_44);
                        if (var27_48.mCommonProcess == var27_48) {
                            var1_1.writeInt(0);
lbl100:
                            // 2 sources

                            continue block14;
                        }
                        var1_1.writeInt(1);
                        var27_48.writeToParcel(var1_1, var2_2);
                        ** continue;
                    }
                    var24_45 = var21_42.mServices.size();
                    var1_1.writeInt(var24_45);
                    for (var25_46 = 0; var25_46 < var24_45; ++var25_46) {
                        var1_1.writeString(var21_42.mServices.keyAt(var25_46));
                        var26_47 = var21_42.mServices.valueAt(var25_46);
                        this.writeCommonString(var1_1, var26_47.mProcessName);
                        var26_47.writeToParcel(var1_1, var2_2);
                    }
                }
            }
        }
        this.mCommonStringToIndex = null;
    }

    public static class DurationsTable {
        public int[] mDurationsTable;
        public int mDurationsTableSize;
        public final String mName;
        public final ProcessStats mStats;

        public DurationsTable(ProcessStats processStats, String string2) {
            this.mStats = processStats;
            this.mName = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        void addDuration(int n, long l) {
            int n2;
            int n3 = ProcessStats.binarySearch(this.mDurationsTable, this.mDurationsTableSize, n);
            if (n3 >= 0) {
                n2 = this.mDurationsTable[n3];
            } else {
                this.mStats.mAddLongTable = this.mDurationsTable;
                this.mStats.mAddLongTableSize = this.mDurationsTableSize;
                n2 = this.mStats.addLongData(~n3, n, 1);
                this.mDurationsTable = this.mStats.mAddLongTable;
                this.mDurationsTableSize = this.mStats.mAddLongTableSize;
            }
            long[] lArray = this.mStats.mLongs.get(n2 >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
            int n4 = n2 >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK;
            lArray[n4] = l + lArray[n4];
        }

        void addDurations(DurationsTable durationsTable) {
            for (int i = 0; i < durationsTable.mDurationsTableSize; ++i) {
                int n = durationsTable.mDurationsTable[i];
                this.addDuration(n >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK, durationsTable.mStats.getLong(n, 0));
            }
        }

        void copyDurationsTo(DurationsTable durationsTable) {
            if (this.mDurationsTable != null) {
                this.mStats.mAddLongTable = new int[this.mDurationsTable.length];
                this.mStats.mAddLongTableSize = 0;
                for (int i = 0; i < this.mDurationsTableSize; ++i) {
                    int n = this.mDurationsTable[i];
                    int n2 = n >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                    int n3 = this.mStats.addLongData(i, n2, 1);
                    this.mStats.mAddLongTable[i] = n3 | n2;
                    this.mStats.setLong(n3, 0, this.mStats.getLong(n, 0));
                }
                durationsTable.mDurationsTable = this.mStats.mAddLongTable;
                durationsTable.mDurationsTableSize = this.mStats.mAddLongTableSize;
                return;
            }
            durationsTable.mDurationsTable = null;
            durationsTable.mDurationsTableSize = 0;
        }

        long getDuration(int n, long l) {
            int n2 = ProcessStats.binarySearch(this.mDurationsTable, this.mDurationsTableSize, n);
            if (n2 >= 0) {
                return this.mStats.getLong(this.mDurationsTable[n2], 0);
            }
            return 0L;
        }

        boolean readDurationsFromParcel(Parcel parcel) {
            this.mDurationsTable = this.mStats.readTableFromParcel(parcel, this.mName, "durations");
            if (this.mDurationsTable == BAD_TABLE) {
                return false;
            }
            int[] nArray = this.mDurationsTable;
            int n = 0;
            if (nArray != null) {
                n = this.mDurationsTable.length;
            }
            this.mDurationsTableSize = n;
            return true;
        }

        void resetDurationsSafely() {
            this.mDurationsTable = null;
            this.mDurationsTableSize = 0;
        }

        void writeDurationsToParcel(Parcel parcel) {
            parcel.writeInt(this.mDurationsTableSize);
            for (int i = 0; i < this.mDurationsTableSize; ++i) {
                parcel.writeInt(this.mDurationsTable[i]);
            }
        }
    }

    public static final class PackageState {
        public final String mPackageName;
        public final ArrayMap<String, ProcessState> mProcesses = new ArrayMap();
        public final ArrayMap<String, ServiceState> mServices = new ArrayMap();
        public final int mUid;

        public PackageState(String string2, int n) {
            this.mUid = n;
            this.mPackageName = string2;
        }
    }

    public static final class ProcessDataCollection {
        public long avgPss;
        public long avgUss;
        public long maxPss;
        public long maxUss;
        final int[] memStates;
        public long minPss;
        public long minUss;
        public long numPss;
        final int[] procStates;
        final int[] screenStates;
        public long totalTime;

        public ProcessDataCollection(int[] nArray, int[] nArray2, int[] nArray3) {
            this.screenStates = nArray;
            this.memStates = nArray2;
            this.procStates = nArray3;
        }

        void print(PrintWriter printWriter, long l, boolean bl) {
            if (this.totalTime > l) {
                printWriter.print("*");
            }
            ProcessStats.printPercent(printWriter, (double)this.totalTime / (double)l);
            if (this.numPss > 0L) {
                printWriter.print(" (");
                ProcessStats.printSizeValue(printWriter, 1024L * this.minPss);
                printWriter.print("-");
                ProcessStats.printSizeValue(printWriter, 1024L * this.avgPss);
                printWriter.print("-");
                ProcessStats.printSizeValue(printWriter, 1024L * this.maxPss);
                printWriter.print("/");
                ProcessStats.printSizeValue(printWriter, 1024L * this.minUss);
                printWriter.print("-");
                ProcessStats.printSizeValue(printWriter, 1024L * this.avgUss);
                printWriter.print("-");
                ProcessStats.printSizeValue(printWriter, 1024L * this.maxUss);
                if (bl) {
                    printWriter.print(" over ");
                    printWriter.print(this.numPss);
                }
                printWriter.print(")");
            }
        }
    }

    public static final class ProcessState
    extends DurationsTable {
        boolean mActive;
        long mAvgCachedKillPss;
        public ProcessState mCommonProcess;
        int mCurState = -1;
        boolean mDead;
        int mLastPssState = -1;
        long mLastPssTime;
        long mMaxCachedKillPss;
        long mMinCachedKillPss;
        boolean mMultiPackage;
        int mNumActiveServices;
        int mNumCachedKill;
        int mNumExcessiveCpu;
        int mNumExcessiveWake;
        int mNumStartedServices;
        public final String mPackage;
        int[] mPssTable;
        int mPssTableSize;
        long mStartTime;
        ProcessState mTmpFoundSubProc;
        int mTmpNumInUse;
        public long mTmpTotalTime;
        public final int mUid;
        public final int mVersion;

        public ProcessState(ProcessState processState, String string2, int n, int n2, String string3, long l) {
            super(processState.mStats, string3);
            this.mCommonProcess = processState;
            this.mPackage = string2;
            this.mUid = n;
            this.mVersion = n2;
            this.mCurState = processState.mCurState;
            this.mStartTime = l;
        }

        public ProcessState(ProcessStats processStats, String string2, int n, int n2, String string3) {
            super(processStats, string3);
            this.mCommonProcess = this;
            this.mPackage = string2;
            this.mUid = n;
            this.mVersion = n2;
        }

        private void addCachedKill(int n, long l, long l2, long l3) {
            if (this.mNumCachedKill <= 0) {
                this.mNumCachedKill = n;
                this.mMinCachedKillPss = l;
                this.mAvgCachedKillPss = l2;
                this.mMaxCachedKillPss = l3;
                return;
            }
            if (l < this.mMinCachedKillPss) {
                this.mMinCachedKillPss = l;
            }
            if (l3 > this.mMaxCachedKillPss) {
                this.mMaxCachedKillPss = l3;
            }
            this.mAvgCachedKillPss = (long)(((double)this.mAvgCachedKillPss * (double)this.mNumCachedKill + (double)l2) / (double)(n + this.mNumCachedKill));
            this.mNumCachedKill = n + this.mNumCachedKill;
        }

        private void ensureNotDead() {
            if (!this.mDead) {
                return;
            }
            Slog.wtfStack(ProcessStats.TAG, "ProcessState dead: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
        }

        private ProcessState pullFixedProc(ArrayMap<String, ProcessStateHolder> arrayMap, int n) {
            ProcessStateHolder processStateHolder = arrayMap.valueAt(n);
            ProcessState processState = processStateHolder.state;
            if (this.mDead && processState.mCommonProcess != processState) {
                Log.wtf(ProcessStats.TAG, "Pulling dead proc: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
                processState = this.mStats.getProcessStateLocked(processState.mPackage, processState.mUid, processState.mVersion, processState.mName);
            }
            if (processState.mMultiPackage) {
                SparseArray<PackageState> sparseArray = this.mStats.mPackages.get(arrayMap.keyAt(n), processState.mUid);
                if (sparseArray == null) {
                    throw new IllegalStateException("No existing package " + arrayMap.keyAt(n) + "/" + processState.mUid + " for multi-proc " + processState.mName);
                }
                PackageState packageState = sparseArray.get(processState.mVersion);
                if (packageState == null) {
                    throw new IllegalStateException("No existing package " + arrayMap.keyAt(n) + "/" + processState.mUid + " for multi-proc " + processState.mName + " version " + processState.mVersion);
                }
                processState = packageState.mProcesses.get(processState.mName);
                if (processState == null) {
                    throw new IllegalStateException("Didn't create per-package process " + processState.mName + " in pkg " + packageState.mPackageName + "/" + packageState.mUid);
                }
                processStateHolder.state = processState;
            }
            return processState;
        }

        void add(ProcessState processState) {
            int n;
            this.addDurations(processState);
            for (int i = 0; i < (n = processState.mPssTableSize); ++i) {
                int n2 = processState.mPssTable[i];
                this.addPss(n2 >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK, (int)processState.mStats.getLong(n2, 0), processState.mStats.getLong(n2, 1), processState.mStats.getLong(n2, 2), processState.mStats.getLong(n2, 3), processState.mStats.getLong(n2, 4), processState.mStats.getLong(n2, 5), processState.mStats.getLong(n2, 6));
            }
            this.mNumExcessiveWake += processState.mNumExcessiveWake;
            this.mNumExcessiveCpu += processState.mNumExcessiveCpu;
            if (processState.mNumCachedKill > 0) {
                this.addCachedKill(processState.mNumCachedKill, processState.mMinCachedKillPss, processState.mAvgCachedKillPss, processState.mMaxCachedKillPss);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void addPss(int n, int n2, long l, long l2, long l3, long l4, long l5, long l6) {
            int n3;
            long[] lArray;
            long l7;
            int n4;
            int n5 = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, n);
            if (n5 >= 0) {
                n4 = this.mPssTable[n5];
            } else {
                this.mStats.mAddLongTable = this.mPssTable;
                this.mStats.mAddLongTableSize = this.mPssTableSize;
                n4 = this.mStats.addLongData(~n5, n, 7);
                this.mPssTable = this.mStats.mAddLongTable;
                this.mPssTableSize = this.mStats.mAddLongTableSize;
            }
            if ((l7 = (lArray = this.mStats.mLongs.get(n4 >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK))[(n3 = n4 >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK) + 0]) == 0L) {
                lArray[n3 + 0] = n2;
                lArray[n3 + 1] = l;
                lArray[n3 + 2] = l2;
                lArray[n3 + 3] = l3;
                lArray[n3 + 4] = l4;
                lArray[n3 + 5] = l5;
                lArray[n3 + 6] = l6;
                return;
            } else {
                lArray[n3 + 0] = l7 + (long)n2;
                if (lArray[n3 + 1] > l) {
                    lArray[n3 + 1] = l;
                }
                lArray[n3 + 2] = (long)(((double)lArray[n3 + 2] * (double)l7 + (double)l2 * (double)n2) / (double)(l7 + (long)n2));
                if (lArray[n3 + 3] < l3) {
                    lArray[n3 + 3] = l3;
                }
                if (lArray[n3 + 4] > l4) {
                    lArray[n3 + 4] = l4;
                }
                lArray[n3 + 5] = (long)(((double)lArray[n3 + 5] * (double)l7 + (double)l5 * (double)n2) / (double)(l7 + (long)n2));
                if (lArray[n3 + 6] >= l6) return;
                lArray[n3 + 6] = l6;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void addPss(long l, long l2, boolean bl, ArrayMap<String, ProcessStateHolder> arrayMap) {
            this.ensureNotDead();
            if (bl || this.mLastPssState != this.mCurState || SystemClock.uptimeMillis() >= 30000L + this.mLastPssTime) {
                this.mLastPssState = this.mCurState;
                this.mLastPssTime = SystemClock.uptimeMillis();
                if (this.mCurState != -1) {
                    this.mCommonProcess.addPss(this.mCurState, 1, l, l, l, l2, l2, l2);
                    if (this.mCommonProcess.mMultiPackage && arrayMap != null) {
                        for (int i = -1 + arrayMap.size(); i >= 0; --i) {
                            this.pullFixedProc(arrayMap, i).addPss(this.mCurState, 1, l, l, l, l2, l2, l2);
                        }
                    }
                }
            }
        }

        ProcessState clone(String string2, long l) {
            ProcessState processState = new ProcessState(this, string2, this.mUid, this.mVersion, this.mName, l);
            this.copyDurationsTo(processState);
            if (this.mPssTable != null) {
                this.mStats.mAddLongTable = new int[this.mPssTable.length];
                this.mStats.mAddLongTableSize = 0;
                for (int i = 0; i < this.mPssTableSize; ++i) {
                    int n = this.mPssTable[i];
                    int n2 = n >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                    int n3 = this.mStats.addLongData(i, n2, 7);
                    this.mStats.mAddLongTable[i] = n3 | n2;
                    for (int j = 0; j < 7; ++j) {
                        this.mStats.setLong(n3, j, this.mStats.getLong(n, j));
                    }
                }
                processState.mPssTable = this.mStats.mAddLongTable;
                processState.mPssTableSize = this.mStats.mAddLongTableSize;
            }
            processState.mNumExcessiveWake = this.mNumExcessiveWake;
            processState.mNumExcessiveCpu = this.mNumExcessiveCpu;
            processState.mNumCachedKill = this.mNumCachedKill;
            processState.mMinCachedKillPss = this.mMinCachedKillPss;
            processState.mAvgCachedKillPss = this.mAvgCachedKillPss;
            processState.mMaxCachedKillPss = this.mMaxCachedKillPss;
            processState.mActive = this.mActive;
            processState.mNumActiveServices = this.mNumActiveServices;
            processState.mNumStartedServices = this.mNumStartedServices;
            return processState;
        }

        void commitStateTime(long l) {
            long l2;
            if (this.mCurState != -1 && (l2 = l - this.mStartTime) > 0L) {
                this.addDuration(this.mCurState, l2);
            }
            this.mStartTime = l;
        }

        void decActiveServices(String string2) {
            if (this.mCommonProcess != this) {
                this.mCommonProcess.decActiveServices(string2);
            }
            this.mNumActiveServices = -1 + this.mNumActiveServices;
            if (this.mNumActiveServices < 0) {
                Slog.wtfStack(ProcessStats.TAG, "Proc active services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " proc=" + this.mName + " service=" + string2);
                this.mNumActiveServices = 0;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void decStartedServices(int n, long l, String string2) {
            if (this.mCommonProcess != this) {
                this.mCommonProcess.decStartedServices(n, l, string2);
            }
            this.mNumStartedServices = -1 + this.mNumStartedServices;
            if (this.mNumStartedServices == 0 && this.mCurState % 14 == 7) {
                this.setState(-1, l);
                return;
            } else {
                if (this.mNumStartedServices >= 0) return;
                Slog.wtfStack(ProcessStats.TAG, "Proc started services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " name=" + this.mName);
                this.mNumStartedServices = 0;
                return;
            }
        }

        @Override
        long getDuration(int n, long l) {
            long l2 = super.getDuration(n, l);
            if (this.mCurState == n) {
                l2 += l - this.mStartTime;
            }
            return l2;
        }

        long getPssAverage(int n) {
            int n2 = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, n);
            if (n2 >= 0) {
                return this.mStats.getLong(this.mPssTable[n2], 2);
            }
            return 0L;
        }

        long getPssMaximum(int n) {
            int n2 = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, n);
            if (n2 >= 0) {
                return this.mStats.getLong(this.mPssTable[n2], 3);
            }
            return 0L;
        }

        long getPssMinimum(int n) {
            int n2 = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, n);
            if (n2 >= 0) {
                return this.mStats.getLong(this.mPssTable[n2], 1);
            }
            return 0L;
        }

        long getPssSampleCount(int n) {
            int n2 = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, n);
            if (n2 >= 0) {
                return this.mStats.getLong(this.mPssTable[n2], 0);
            }
            return 0L;
        }

        long getPssUssAverage(int n) {
            int n2 = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, n);
            if (n2 >= 0) {
                return this.mStats.getLong(this.mPssTable[n2], 5);
            }
            return 0L;
        }

        long getPssUssMaximum(int n) {
            int n2 = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, n);
            if (n2 >= 0) {
                return this.mStats.getLong(this.mPssTable[n2], 6);
            }
            return 0L;
        }

        long getPssUssMinimum(int n) {
            int n2 = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, n);
            if (n2 >= 0) {
                return this.mStats.getLong(this.mPssTable[n2], 4);
            }
            return 0L;
        }

        void incActiveServices(String string2) {
            if (this.mCommonProcess != this) {
                this.mCommonProcess.incActiveServices(string2);
            }
            this.mNumActiveServices = 1 + this.mNumActiveServices;
        }

        void incStartedServices(int n, long l, String string2) {
            if (this.mCommonProcess != this) {
                this.mCommonProcess.incStartedServices(n, l, string2);
            }
            this.mNumStartedServices = 1 + this.mNumStartedServices;
            if (this.mNumStartedServices == 1 && this.mCurState == -1) {
                this.setState(7 + n * 14, l);
            }
        }

        public boolean isInUse() {
            return this.mActive || this.mNumActiveServices > 0 || this.mNumStartedServices > 0 || this.mCurState != -1;
        }

        public void makeActive() {
            this.ensureNotDead();
            this.mActive = true;
        }

        void makeDead() {
            this.mDead = true;
        }

        public void makeInactive() {
            this.mActive = false;
        }

        ProcessState pullFixedProc(String string2) {
            ProcessState processState;
            if (this.mMultiPackage) {
                SparseArray<PackageState> sparseArray = this.mStats.mPackages.get(string2, this.mUid);
                if (sparseArray == null) {
                    throw new IllegalStateException("Didn't find package " + string2 + " / " + this.mUid);
                }
                PackageState packageState = sparseArray.get(this.mVersion);
                if (packageState == null) {
                    throw new IllegalStateException("Didn't find package " + string2 + " / " + this.mUid + " vers " + this.mVersion);
                }
                processState = packageState.mProcesses.get(this.mName);
                if (processState == null) {
                    throw new IllegalStateException("Didn't create per-package process " + this.mName + " in pkg " + string2 + " / " + this.mUid + " vers " + this.mVersion);
                }
            } else {
                processState = this;
            }
            return processState;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean readFromParcel(Parcel parcel, boolean bl) {
            boolean bl2 = parcel.readInt() != 0;
            if (bl) {
                this.mMultiPackage = bl2;
            }
            if (!this.readDurationsFromParcel(parcel)) {
                return false;
            }
            this.mPssTable = this.mStats.readTableFromParcel(parcel, this.mName, "pss");
            if (this.mPssTable == BAD_TABLE) return false;
            int[] nArray = this.mPssTable;
            int n = 0;
            if (nArray != null) {
                n = this.mPssTable.length;
            }
            this.mPssTableSize = n;
            this.mNumExcessiveWake = parcel.readInt();
            this.mNumExcessiveCpu = parcel.readInt();
            this.mNumCachedKill = parcel.readInt();
            if (this.mNumCachedKill > 0) {
                this.mMinCachedKillPss = parcel.readLong();
                this.mAvgCachedKillPss = parcel.readLong();
                this.mMaxCachedKillPss = parcel.readLong();
                return true;
            }
            this.mMaxCachedKillPss = 0L;
            this.mAvgCachedKillPss = 0L;
            this.mMinCachedKillPss = 0L;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void reportCachedKill(ArrayMap<String, ProcessStateHolder> arrayMap, long l) {
            this.ensureNotDead();
            this.mCommonProcess.addCachedKill(1, l, l, l);
            if (this.mCommonProcess.mMultiPackage) {
                for (int i = -1 + arrayMap.size(); i >= 0; --i) {
                    this.pullFixedProc(arrayMap, i).addCachedKill(1, l, l, l);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void reportExcessiveCpu(ArrayMap<String, ProcessStateHolder> arrayMap) {
            this.ensureNotDead();
            ProcessState processState = this.mCommonProcess;
            processState.mNumExcessiveCpu = 1 + processState.mNumExcessiveCpu;
            if (this.mCommonProcess.mMultiPackage) {
                ProcessState processState2;
                for (int n = -1 + arrayMap.size(); n >= 0; processState2.mNumExcessiveCpu = 1 + processState2.mNumExcessiveCpu, --n) {
                    processState2 = this.pullFixedProc(arrayMap, n);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void reportExcessiveWake(ArrayMap<String, ProcessStateHolder> arrayMap) {
            this.ensureNotDead();
            ProcessState processState = this.mCommonProcess;
            processState.mNumExcessiveWake = 1 + processState.mNumExcessiveWake;
            if (this.mCommonProcess.mMultiPackage) {
                ProcessState processState2;
                for (int n = -1 + arrayMap.size(); n >= 0; processState2.mNumExcessiveWake = 1 + processState2.mNumExcessiveWake, --n) {
                    processState2 = this.pullFixedProc(arrayMap, n);
                }
            }
        }

        void resetSafely(long l) {
            this.resetDurationsSafely();
            this.mStartTime = l;
            this.mLastPssState = -1;
            this.mLastPssTime = 0L;
            this.mPssTable = null;
            this.mPssTableSize = 0;
            this.mNumExcessiveWake = 0;
            this.mNumExcessiveCpu = 0;
            this.mNumCachedKill = 0;
            this.mMaxCachedKillPss = 0L;
            this.mAvgCachedKillPss = 0L;
            this.mMinCachedKillPss = 0L;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setState(int n, int n2, long l, ArrayMap<String, ProcessStateHolder> arrayMap) {
            int n3 = n < 0 ? (this.mNumStartedServices > 0 ? 7 + n2 * 14 : -1) : PROCESS_STATE_TO_STATE[n] + n2 * 14;
            this.mCommonProcess.setState(n3, l);
            if (this.mCommonProcess.mMultiPackage && arrayMap != null) {
                for (int i = -1 + arrayMap.size(); i >= 0; --i) {
                    this.pullFixedProc(arrayMap, i).setState(n3, l);
                }
            }
        }

        void setState(int n, long l) {
            this.ensureNotDead();
            if (this.mCurState != n) {
                this.commitStateTime(l);
                this.mCurState = n;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("ProcessState{").append(Integer.toHexString(System.identityHashCode(this))).append(" ").append(this.mName).append("/").append(this.mUid).append(" pkg=").append(this.mPackage);
            if (this.mMultiPackage) {
                stringBuilder.append(" (multi)");
            }
            if (this.mCommonProcess != this) {
                stringBuilder.append(" (sub)");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        void writeToParcel(Parcel parcel, long l) {
            int n = this.mMultiPackage ? 1 : 0;
            parcel.writeInt(n);
            this.writeDurationsToParcel(parcel);
            parcel.writeInt(this.mPssTableSize);
            for (int i = 0; i < this.mPssTableSize; ++i) {
                parcel.writeInt(this.mPssTable[i]);
            }
            parcel.writeInt(this.mNumExcessiveWake);
            parcel.writeInt(this.mNumExcessiveCpu);
            parcel.writeInt(this.mNumCachedKill);
            if (this.mNumCachedKill > 0) {
                parcel.writeLong(this.mMinCachedKillPss);
                parcel.writeLong(this.mAvgCachedKillPss);
                parcel.writeLong(this.mMaxCachedKillPss);
            }
        }
    }

    public static final class ProcessStateHolder {
        public final int appVersion;
        public ProcessState state;

        public ProcessStateHolder(int n) {
            this.appVersion = n;
        }
    }

    static class PssAggr {
        long pss = 0L;
        long samples = 0L;

        PssAggr() {
        }

        void add(long l, long l2) {
            this.pss = (long)((double)this.pss * (double)this.samples + (double)l * (double)l2) / (l2 + this.samples);
            this.samples = l2 + this.samples;
        }
    }

    public static final class ServiceState
    extends DurationsTable {
        public static final int SERVICE_BOUND = 2;
        static final int SERVICE_COUNT = 4;
        public static final int SERVICE_EXEC = 3;
        public static final int SERVICE_RUN = 0;
        public static final int SERVICE_STARTED = 1;
        int mBoundCount;
        long mBoundStartTime;
        public int mBoundState = -1;
        int mExecCount;
        long mExecStartTime;
        public int mExecState = -1;
        Object mOwner;
        public final String mPackage;
        ProcessState mProc;
        public final String mProcessName;
        boolean mRestarting;
        int mRunCount;
        long mRunStartTime;
        public int mRunState = -1;
        boolean mStarted;
        int mStartedCount;
        long mStartedStartTime;
        public int mStartedState = -1;

        public ServiceState(ProcessStats processStats, String string2, String string3, String string4, ProcessState processState) {
            super(processStats, string3);
            this.mPackage = string2;
            this.mProcessName = string4;
            this.mProc = processState;
        }

        private long getDuration(int n, int n2, long l, int n3, long l2) {
            long l3 = this.getDuration(n + n3 * 4, l2);
            if (n2 == n3) {
                l3 += l2 - l;
            }
            return l3;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void updateRunning(int n, long l) {
            int n2 = this.mStartedState != -1 || this.mBoundState != -1 || this.mExecState != -1 ? n : -1;
            if (this.mRunState != n2) {
                if (this.mRunState != -1) {
                    this.addDuration(0 + 4 * this.mRunState, l - this.mRunStartTime);
                } else if (n2 != -1) {
                    this.mRunCount = 1 + this.mRunCount;
                }
                this.mRunState = n2;
                this.mRunStartTime = l;
            }
        }

        void add(ServiceState serviceState) {
            this.addDurations(serviceState);
            this.mRunCount += serviceState.mRunCount;
            this.mStartedCount += serviceState.mStartedCount;
            this.mBoundCount += serviceState.mBoundCount;
            this.mExecCount += serviceState.mExecCount;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void applyNewOwner(Object object) {
            if (this.mOwner == object) return;
            if (this.mOwner == null) {
                this.mOwner = object;
                this.mProc.incActiveServices(this.mName);
                return;
            } else {
                this.mOwner = object;
                if (!this.mStarted && this.mBoundState == -1 && this.mExecState == -1) return;
                long l = SystemClock.uptimeMillis();
                if (this.mStarted) {
                    this.setStarted(false, 0, l);
                }
                if (this.mBoundState != -1) {
                    this.setBound(false, 0, l);
                }
                if (this.mExecState == -1) return;
                this.setExecuting(false, 0, l);
                return;
            }
        }

        public void clearCurrentOwner(Object object, boolean bl) {
            if (this.mOwner == object) {
                this.mProc.decActiveServices(this.mName);
                if (this.mStarted || this.mBoundState != -1 || this.mExecState != -1) {
                    long l = SystemClock.uptimeMillis();
                    if (this.mStarted) {
                        if (!bl) {
                            Slog.wtfStack(ProcessStats.TAG, "Service owner " + object + " cleared while started: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                        }
                        this.setStarted(false, 0, l);
                    }
                    if (this.mBoundState != -1) {
                        if (!bl) {
                            Slog.wtfStack(ProcessStats.TAG, "Service owner " + object + " cleared while bound: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                        }
                        this.setBound(false, 0, l);
                    }
                    if (this.mExecState != -1) {
                        if (!bl) {
                            Slog.wtfStack(ProcessStats.TAG, "Service owner " + object + " cleared while exec: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                        }
                        this.setExecuting(false, 0, l);
                    }
                }
                this.mOwner = null;
            }
        }

        void commitStateTime(long l) {
            if (this.mRunState != -1) {
                this.addDuration(0 + 4 * this.mRunState, l - this.mRunStartTime);
                this.mRunStartTime = l;
            }
            if (this.mStartedState != -1) {
                this.addDuration(1 + 4 * this.mStartedState, l - this.mStartedStartTime);
                this.mStartedStartTime = l;
            }
            if (this.mBoundState != -1) {
                this.addDuration(2 + 4 * this.mBoundState, l - this.mBoundStartTime);
                this.mBoundStartTime = l;
            }
            if (this.mExecState != -1) {
                this.addDuration(3 + 4 * this.mExecState, l - this.mExecStartTime);
                this.mExecStartTime = l;
            }
        }

        public boolean isInUse() {
            return this.mOwner != null || this.mRestarting;
        }

        public boolean isRestarting() {
            return this.mRestarting;
        }

        boolean readFromParcel(Parcel parcel) {
            if (!this.readDurationsFromParcel(parcel)) {
                return false;
            }
            this.mRunCount = parcel.readInt();
            this.mStartedCount = parcel.readInt();
            this.mBoundCount = parcel.readInt();
            this.mExecCount = parcel.readInt();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        void resetSafely(long l) {
            int n = 1;
            this.resetDurationsSafely();
            int n2 = this.mRunState != -1 ? n : 0;
            this.mRunCount = n2;
            int n3 = this.mStartedState != -1 ? n : 0;
            this.mStartedCount = n3;
            int n4 = this.mBoundState != -1 ? n : 0;
            this.mBoundCount = n4;
            if (this.mExecState == -1) {
                n = 0;
            }
            this.mExecCount = n;
            this.mExecStartTime = l;
            this.mBoundStartTime = l;
            this.mStartedStartTime = l;
            this.mRunStartTime = l;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setBound(boolean bl, int n, long l) {
            int n2;
            if (this.mOwner == null) {
                Slog.wtf(ProcessStats.TAG, "Binding service " + this + " without owner");
            }
            if (this.mBoundState != (n2 = bl ? n : -1)) {
                if (this.mBoundState != -1) {
                    this.addDuration(2 + 4 * this.mBoundState, l - this.mBoundStartTime);
                } else if (bl) {
                    this.mBoundCount = 1 + this.mBoundCount;
                }
                this.mBoundState = n2;
                this.mBoundStartTime = l;
                this.updateRunning(n, l);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setExecuting(boolean bl, int n, long l) {
            int n2;
            if (this.mOwner == null) {
                Slog.wtf(ProcessStats.TAG, "Executing service " + this + " without owner");
            }
            if (this.mExecState != (n2 = bl ? n : -1)) {
                if (this.mExecState != -1) {
                    this.addDuration(3 + 4 * this.mExecState, l - this.mExecStartTime);
                } else if (bl) {
                    this.mExecCount = 1 + this.mExecCount;
                }
                this.mExecState = n2;
                this.mExecStartTime = l;
                this.updateRunning(n, l);
            }
        }

        public void setRestarting(boolean bl, int n, long l) {
            this.mRestarting = bl;
            this.updateStartedState(n, l);
        }

        public void setStarted(boolean bl, int n, long l) {
            if (this.mOwner == null) {
                Slog.wtf(ProcessStats.TAG, "Starting service " + this + " without owner");
            }
            this.mStarted = bl;
            this.updateStartedState(n, l);
        }

        public String toString() {
            return "ServiceState{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mName + " pkg=" + this.mPackage + " proc=" + Integer.toHexString(System.identityHashCode(this)) + "}";
        }

        /*
         * Enabled aggressive block sorting
         */
        void updateStartedState(int n, long l) {
            boolean bl = this.mStartedState != -1;
            boolean bl2 = this.mStarted || this.mRestarting;
            int n2 = bl2 ? n : -1;
            if (this.mStartedState != n2) {
                if (this.mStartedState != -1) {
                    this.addDuration(1 + 4 * this.mStartedState, l - this.mStartedStartTime);
                } else if (bl2) {
                    this.mStartedCount = 1 + this.mStartedCount;
                }
                this.mStartedState = n2;
                this.mStartedStartTime = l;
                this.mProc = this.mProc.pullFixedProc(this.mPackage);
                if (bl != bl2) {
                    if (bl2) {
                        this.mProc.incStartedServices(n, l, this.mName);
                    } else {
                        this.mProc.decStartedServices(n, l, this.mName);
                    }
                }
                this.updateRunning(n, l);
            }
        }

        void writeToParcel(Parcel parcel, long l) {
            this.writeDurationsToParcel(parcel);
            parcel.writeInt(this.mRunCount);
            parcel.writeInt(this.mStartedCount);
            parcel.writeInt(this.mBoundCount);
            parcel.writeInt(this.mExecCount);
        }
    }

    public static class TotalMemoryUseCollection {
        final int[] memStates;
        public long[] processStatePss = new long[14];
        public int[] processStateSamples;
        public long[] processStateTime;
        public double[] processStateWeight = new double[14];
        final int[] screenStates;
        public double sysMemCachedWeight;
        public double sysMemFreeWeight;
        public double sysMemKernelWeight;
        public double sysMemNativeWeight;
        public int sysMemSamples;
        public long[] sysMemUsage;
        public double sysMemZRamWeight;
        public long totalTime;

        public TotalMemoryUseCollection(int[] nArray, int[] nArray2) {
            this.processStateTime = new long[14];
            this.processStateSamples = new int[14];
            this.sysMemUsage = new long[16];
            this.screenStates = nArray;
            this.memStates = nArray2;
        }
    }
}

