/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ZoomControls;

public class ZoomButtonsController
implements View.OnTouchListener {
    private static final int MSG_DISMISS_ZOOM_CONTROLS = 3;
    private static final int MSG_POST_CONFIGURATION_CHANGED = 2;
    private static final int MSG_POST_SET_VISIBLE = 4;
    private static final String TAG = "ZoomButtonsController";
    private static final int ZOOM_CONTROLS_TIMEOUT = 0;
    private static final int ZOOM_CONTROLS_TOUCH_PADDING = 20;
    private boolean mAutoDismissControls = true;
    private OnZoomListener mCallback;
    private final IntentFilter mConfigurationChangedFilter;
    private final BroadcastReceiver mConfigurationChangedReceiver;
    private final FrameLayout mContainer;
    private WindowManager.LayoutParams mContainerLayoutParams;
    private final int[] mContainerRawLocation;
    private final Context mContext;
    private ZoomControls mControls;
    private final Handler mHandler;
    private boolean mIsVisible;
    private final View mOwnerView;
    private final int[] mOwnerViewRawLocation = new int[2];
    private Runnable mPostedVisibleInitializer;
    private boolean mReleaseTouchListenerOnUp;
    private final int[] mTempIntArray;
    private final Rect mTempRect;
    private int mTouchPaddingScaledSq;
    private View mTouchTargetView;
    private final int[] mTouchTargetWindowLocation;
    private final WindowManager mWindowManager;

    static {
        ZOOM_CONTROLS_TIMEOUT = (int)ViewConfiguration.getZoomControlsTimeout();
    }

    public ZoomButtonsController(View view) {
        this.mContainerRawLocation = new int[2];
        this.mTouchTargetWindowLocation = new int[2];
        this.mTempRect = new Rect();
        this.mTempIntArray = new int[2];
        this.mConfigurationChangedFilter = new IntentFilter("android.intent.action.CONFIGURATION_CHANGED");
        this.mConfigurationChangedReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (!ZoomButtonsController.this.mIsVisible) {
                    return;
                }
                ZoomButtonsController.this.mHandler.removeMessages(2);
                ZoomButtonsController.this.mHandler.sendEmptyMessage(2);
            }
        };
        this.mHandler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 2: {
                        ZoomButtonsController.this.onPostConfigurationChanged();
                        return;
                    }
                    case 3: {
                        ZoomButtonsController.this.setVisible(false);
                        return;
                    }
                    case 4: 
                }
                if (ZoomButtonsController.this.mOwnerView.getWindowToken() == null) {
                    Log.e(ZoomButtonsController.TAG, "Cannot make the zoom controller visible if the owner view is not attached to a window.");
                    return;
                }
                ZoomButtonsController.this.setVisible(true);
            }
        };
        this.mContext = view.getContext();
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        this.mOwnerView = view;
        this.mTouchPaddingScaledSq = (int)(20.0f * this.mContext.getResources().getDisplayMetrics().density);
        this.mTouchPaddingScaledSq *= this.mTouchPaddingScaledSq;
        this.mContainer = this.createContainer();
    }

    private FrameLayout createContainer() {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(-2, -2);
        layoutParams.gravity = 0x800033;
        layoutParams.flags = 131608;
        layoutParams.height = -2;
        layoutParams.width = -1;
        layoutParams.type = 1000;
        layoutParams.format = -3;
        layoutParams.windowAnimations = 16974561;
        this.mContainerLayoutParams = layoutParams;
        Container container = new Container(this.mContext);
        container.setLayoutParams(layoutParams);
        container.setMeasureAllChildren(true);
        ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367308, (ViewGroup)container);
        this.mControls = (ZoomControls)container.findViewById(16909314);
        this.mControls.setOnZoomInClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                ZoomButtonsController.this.dismissControlsDelayed(ZOOM_CONTROLS_TIMEOUT);
                if (ZoomButtonsController.this.mCallback != null) {
                    ZoomButtonsController.this.mCallback.onZoom(true);
                }
            }
        });
        this.mControls.setOnZoomOutClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                ZoomButtonsController.this.dismissControlsDelayed(ZOOM_CONTROLS_TIMEOUT);
                if (ZoomButtonsController.this.mCallback != null) {
                    ZoomButtonsController.this.mCallback.onZoom(false);
                }
            }
        });
        return container;
    }

    private void dismissControlsDelayed(int n) {
        if (this.mAutoDismissControls) {
            this.mHandler.removeMessages(3);
            this.mHandler.sendEmptyMessageDelayed(3, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private View findViewForTouch(int n, int n2) {
        int n3 = n - this.mContainerRawLocation[0];
        int n4 = n2 - this.mContainerRawLocation[1];
        Rect rect = this.mTempRect;
        View view = null;
        int n5 = Integer.MAX_VALUE;
        int n6 = -1 + this.mContainer.getChildCount();
        while (n6 >= 0) {
            View view2 = this.mContainer.getChildAt(n6);
            if (view2.getVisibility() == 0) {
                int n7;
                view2.getHitRect(rect);
                if (rect.contains(n3, n4)) {
                    return view2;
                }
                int n8 = n3 >= rect.left && n3 <= rect.right ? 0 : Math.min(Math.abs(rect.left - n3), Math.abs(n3 - rect.right));
                int n9 = n8 * n8 + (n7 = n4 >= rect.top && n4 <= rect.bottom ? 0 : Math.min(Math.abs(rect.top - n4), Math.abs(n4 - rect.bottom))) * n7;
                if (n9 < this.mTouchPaddingScaledSq && n9 < n5) {
                    view = view2;
                    n5 = n9;
                }
            }
            --n6;
        }
        return view;
    }

    private boolean isInterestingKey(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: 
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onContainerKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.isInterestingKey(n)) {
            if (n == 4) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState dispatcherState;
                    if (this.mOwnerView == null || (dispatcherState = this.mOwnerView.getKeyDispatcherState()) == null) return true;
                    dispatcherState.startTracking(keyEvent, this);
                    return true;
                }
                if (keyEvent.getAction() != 1 || !keyEvent.isTracking() || keyEvent.isCanceled()) return false;
                this.setVisible(false);
                return true;
            }
            this.dismissControlsDelayed(ZOOM_CONTROLS_TIMEOUT);
            return false;
        }
        ViewRootImpl viewRootImpl = this.mOwnerView.getViewRootImpl();
        if (viewRootImpl == null) return true;
        viewRootImpl.dispatchInputEvent(keyEvent);
        return true;
    }

    private void onPostConfigurationChanged() {
        this.dismissControlsDelayed(ZOOM_CONTROLS_TIMEOUT);
        this.refreshPositioningVariables();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refreshPositioningVariables() {
        block3: {
            block2: {
                if (this.mOwnerView.getWindowToken() == null) break block2;
                int n = this.mOwnerView.getHeight();
                int n2 = this.mOwnerView.getWidth();
                int n3 = n - this.mContainer.getHeight();
                this.mOwnerView.getLocationOnScreen(this.mOwnerViewRawLocation);
                this.mContainerRawLocation[0] = this.mOwnerViewRawLocation[0];
                this.mContainerRawLocation[1] = n3 + this.mOwnerViewRawLocation[1];
                int[] nArray = this.mTempIntArray;
                this.mOwnerView.getLocationInWindow(nArray);
                this.mContainerLayoutParams.x = nArray[0];
                this.mContainerLayoutParams.width = n2;
                this.mContainerLayoutParams.y = n3 + nArray[1];
                if (this.mIsVisible) break block3;
            }
            return;
        }
        this.mWindowManager.updateViewLayout(this.mContainer, this.mContainerLayoutParams);
    }

    private void setTouchTargetView(View view) {
        this.mTouchTargetView = view;
        if (view != null) {
            view.getLocationInWindow(this.mTouchTargetWindowLocation);
        }
    }

    public ViewGroup getContainer() {
        return this.mContainer;
    }

    public View getZoomControls() {
        return this.mControls;
    }

    public boolean isAutoDismissed() {
        return this.mAutoDismissControls;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        View view2;
        block12: {
            block11: {
                int n = motionEvent.getAction();
                if (motionEvent.getPointerCount() > 1) break block11;
                if (this.mReleaseTouchListenerOnUp) {
                    if (n == 1 || n == 3) {
                        this.mOwnerView.setOnTouchListener(null);
                        this.setTouchTargetView(null);
                        this.mReleaseTouchListenerOnUp = false;
                    }
                    return true;
                }
                this.dismissControlsDelayed(ZOOM_CONTROLS_TIMEOUT);
                view2 = this.mTouchTargetView;
                switch (n) {
                    case 0: {
                        view2 = this.findViewForTouch((int)motionEvent.getRawX(), (int)motionEvent.getRawY());
                        this.setTouchTargetView(view2);
                    }
                    default: {
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.setTouchTargetView(null);
                    }
                }
                if (view2 != null) break block12;
            }
            return false;
        }
        int n = this.mContainerRawLocation[0] + this.mTouchTargetWindowLocation[0];
        int n2 = this.mContainerRawLocation[1] + this.mTouchTargetWindowLocation[1];
        MotionEvent motionEvent2 = MotionEvent.obtain(motionEvent);
        motionEvent2.offsetLocation(this.mOwnerViewRawLocation[0] - n, this.mOwnerViewRawLocation[1] - n2);
        float f = motionEvent2.getX();
        float f2 = motionEvent2.getY();
        if (f < 0.0f && f > -20.0f) {
            motionEvent2.offsetLocation(-f, 0.0f);
        }
        if (f2 < 0.0f && f2 > -20.0f) {
            motionEvent2.offsetLocation(0.0f, -f2);
        }
        boolean bl = view2.dispatchTouchEvent(motionEvent2);
        motionEvent2.recycle();
        return bl;
    }

    public void setAutoDismissed(boolean bl) {
        if (this.mAutoDismissControls == bl) {
            return;
        }
        this.mAutoDismissControls = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFocusable(boolean bl) {
        int n = this.mContainerLayoutParams.flags;
        if (bl) {
            WindowManager.LayoutParams layoutParams = this.mContainerLayoutParams;
            layoutParams.flags = 0xFFFFFFF7 & layoutParams.flags;
        } else {
            WindowManager.LayoutParams layoutParams = this.mContainerLayoutParams;
            layoutParams.flags = 8 | layoutParams.flags;
        }
        if (this.mContainerLayoutParams.flags != n && this.mIsVisible) {
            this.mWindowManager.updateViewLayout(this.mContainer, this.mContainerLayoutParams);
        }
    }

    public void setOnZoomListener(OnZoomListener onZoomListener) {
        this.mCallback = onZoomListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setVisible(boolean bl) {
        if (bl) {
            if (this.mOwnerView.getWindowToken() == null) {
                if (this.mHandler.hasMessages(4)) return;
                this.mHandler.sendEmptyMessage(4);
                return;
            }
            this.dismissControlsDelayed(ZOOM_CONTROLS_TIMEOUT);
        }
        if (this.mIsVisible == bl) return;
        this.mIsVisible = bl;
        if (bl) {
            if (this.mContainerLayoutParams.token == null) {
                this.mContainerLayoutParams.token = this.mOwnerView.getWindowToken();
            }
            this.mWindowManager.addView(this.mContainer, this.mContainerLayoutParams);
            if (this.mPostedVisibleInitializer == null) {
                this.mPostedVisibleInitializer = new Runnable(){

                    @Override
                    public void run() {
                        ZoomButtonsController.this.refreshPositioningVariables();
                        if (ZoomButtonsController.this.mCallback != null) {
                            ZoomButtonsController.this.mCallback.onVisibilityChanged(true);
                        }
                    }
                };
            }
            this.mHandler.post(this.mPostedVisibleInitializer);
            this.mContext.registerReceiver(this.mConfigurationChangedReceiver, this.mConfigurationChangedFilter);
            this.mOwnerView.setOnTouchListener(this);
            this.mReleaseTouchListenerOnUp = false;
            return;
        }
        if (this.mTouchTargetView != null) {
            this.mReleaseTouchListenerOnUp = true;
        } else {
            this.mOwnerView.setOnTouchListener(null);
        }
        this.mContext.unregisterReceiver(this.mConfigurationChangedReceiver);
        this.mWindowManager.removeView(this.mContainer);
        this.mHandler.removeCallbacks(this.mPostedVisibleInitializer);
        if (this.mCallback == null) return;
        this.mCallback.onVisibilityChanged(false);
    }

    public void setZoomInEnabled(boolean bl) {
        this.mControls.setIsZoomInEnabled(bl);
    }

    public void setZoomOutEnabled(boolean bl) {
        this.mControls.setIsZoomOutEnabled(bl);
    }

    public void setZoomSpeed(long l) {
        this.mControls.setZoomSpeed(l);
    }

    private class Container
    extends FrameLayout {
        public Container(Context context) {
            super(context);
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (ZoomButtonsController.this.onContainerKey(keyEvent)) {
                return true;
            }
            return super.dispatchKeyEvent(keyEvent);
        }
    }

    public static interface OnZoomListener {
        public void onVisibilityChanged(boolean var1);

        public void onZoom(boolean var1);
    }
}

