/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.SearchView;
import android.widget.TextView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;

class SuggestionsAdapter
extends ResourceCursorAdapter
implements View.OnClickListener {
    private static final boolean DBG = false;
    private static final long DELETE_KEY_POST_DELAY = 500L;
    static final int INVALID_INDEX = -1;
    private static final String LOG_TAG = "SuggestionsAdapter";
    private static final int QUERY_LIMIT = 50;
    static final int REFINE_ALL = 2;
    static final int REFINE_BY_ENTRY = 1;
    static final int REFINE_NONE;
    private boolean mClosed = false;
    private final int mCommitIconResId;
    private int mFlagsCol = -1;
    private int mIconName1Col = -1;
    private int mIconName2Col = -1;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private final Context mProviderContext;
    private int mQueryRefinement = 1;
    private final SearchManager mSearchManager = (SearchManager)this.mContext.getSystemService("search");
    private final SearchView mSearchView;
    private final SearchableInfo mSearchable;
    private int mText1Col = -1;
    private int mText2Col = -1;
    private int mText2UrlCol = -1;
    private ColorStateList mUrlColor;

    public SuggestionsAdapter(Context context, SearchView searchView, SearchableInfo searchableInfo, WeakHashMap<String, Drawable.ConstantState> weakHashMap) {
        super(context, searchView.getSuggestionRowLayout(), null, true);
        this.mSearchView = searchView;
        this.mSearchable = searchableInfo;
        this.mCommitIconResId = searchView.getSuggestionCommitIconResId();
        Context context2 = this.mSearchable.getActivityContext(this.mContext);
        this.mProviderContext = this.mSearchable.getProviderContext(this.mContext, context2);
        this.mOutsideDrawablesCache = weakHashMap;
        this.getFilter().setDelayer(new Filter.Delayer(){
            private int mPreviousLength = 0;

            @Override
            public long getPostingDelay(CharSequence charSequence) {
                long l = 0L;
                if (charSequence == null) {
                    return l;
                }
                if (charSequence.length() < this.mPreviousLength) {
                    l = 500L;
                }
                this.mPreviousLength = charSequence.length();
                return l;
            }
        });
    }

    private Drawable checkIconCache(String string2) {
        Drawable.ConstantState constantState = this.mOutsideDrawablesCache.get(string2);
        if (constantState == null) {
            return null;
        }
        return constantState.newDrawable();
    }

    private CharSequence formatUrl(CharSequence charSequence) {
        if (this.mUrlColor == null) {
            TypedValue typedValue = new TypedValue();
            this.mContext.getTheme().resolveAttribute(16843715, typedValue, true);
            this.mUrlColor = this.mContext.getResources().getColorStateList(typedValue.resourceId);
        }
        SpannableString spannableString = new SpannableString(charSequence);
        spannableString.setSpan(new TextAppearanceSpan(null, 0, 0, this.mUrlColor, null), 0, charSequence.length(), 33);
        return spannableString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getActivityIcon(ComponentName componentName) {
        ActivityInfo activityInfo;
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            activityInfo = packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w(LOG_TAG, nameNotFoundException.toString());
            return null;
        }
        int n = activityInfo.getIconResource();
        if (n == 0) {
            return null;
        }
        Drawable drawable2 = packageManager.getDrawable(componentName.getPackageName(), n, activityInfo.applicationInfo);
        if (drawable2 != null) return drawable2;
        Log.w(LOG_TAG, "Invalid icon resource " + n + " for " + componentName.flattenToShortString());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable getActivityIconWithCache(ComponentName componentName) {
        String string2 = componentName.flattenToShortString();
        if (this.mOutsideDrawablesCache.containsKey(string2)) {
            Drawable.ConstantState constantState = this.mOutsideDrawablesCache.get(string2);
            if (constantState == null) {
                return null;
            }
            return constantState.newDrawable(this.mProviderContext.getResources());
        }
        Drawable drawable2 = this.getActivityIcon(componentName);
        Drawable.ConstantState constantState = drawable2 == null ? null : drawable2.getConstantState();
        this.mOutsideDrawablesCache.put(string2, constantState);
        return drawable2;
    }

    public static String getColumnString(Cursor cursor, String string2) {
        return SuggestionsAdapter.getStringOrNull(cursor, cursor.getColumnIndex(string2));
    }

    private Drawable getDefaultIcon1(Cursor cursor) {
        Drawable drawable2 = this.getActivityIconWithCache(this.mSearchable.getSearchActivity());
        if (drawable2 != null) {
            return drawable2;
        }
        return this.mContext.getPackageManager().getDefaultActivityIcon();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable getDrawable(Uri uri) {
        InputStream inputStream;
        block13: {
            try {
                if ("android.resource".equals(uri.getScheme())) {
                    ContentResolver.OpenResourceIdResult openResourceIdResult = this.mProviderContext.getContentResolver().getResourceId(uri);
                    try {
                        return openResourceIdResult.r.getDrawable(openResourceIdResult.id, this.mContext.getTheme());
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        throw new FileNotFoundException("Resource does not exist: " + uri);
                    }
                }
                inputStream = this.mProviderContext.getContentResolver().openInputStream(uri);
                if (inputStream != null) break block13;
                throw new FileNotFoundException("Failed to open " + uri);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.w(LOG_TAG, "Icon not found: " + uri + ", " + fileNotFoundException.getMessage());
                return null;
            }
        }
        Drawable drawable2 = Drawable.createFromStream(inputStream, null);
        {
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.e(LOG_TAG, "Error closing icon stream for " + uri, iOException);
                    throw throwable;
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return drawable2;
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, "Error closing icon stream for " + uri, iOException);
            return drawable2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getDrawableFromResourceValue(String string2) {
        if (string2 == null) return null;
        if (string2.length() == 0) return null;
        if ("0".equals(string2)) {
            return null;
        }
        int n = Integer.parseInt(string2);
        String string3 = "android.resource://" + this.mProviderContext.getPackageName() + "/" + n;
        Drawable drawable2 = this.checkIconCache(string3);
        if (drawable2 != null) return drawable2;
        try {
            Drawable drawable3 = this.mProviderContext.getDrawable(n);
            this.storeInIconCache(string3, drawable3);
            return drawable3;
        }
        catch (NumberFormatException numberFormatException) {
            drawable2 = this.checkIconCache(string2);
            if (drawable2 != null) return drawable2;
            Drawable drawable4 = this.getDrawable(Uri.parse(string2));
            this.storeInIconCache(string2, drawable4);
            return drawable4;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.w(LOG_TAG, "Icon resource not found: " + string2);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getIcon1(Cursor cursor) {
        if (this.mIconName1Col == -1) {
            return null;
        }
        Drawable drawable2 = this.getDrawableFromResourceValue(cursor.getString(this.mIconName1Col));
        if (drawable2 != null) return drawable2;
        return this.getDefaultIcon1(cursor);
    }

    private Drawable getIcon2(Cursor cursor) {
        if (this.mIconName2Col == -1) {
            return null;
        }
        return this.getDrawableFromResourceValue(cursor.getString(this.mIconName2Col));
    }

    private static String getStringOrNull(Cursor cursor, int n) {
        if (n == -1) {
            return null;
        }
        try {
            String string2 = cursor.getString(n);
            return string2;
        }
        catch (Exception exception) {
            Log.e(LOG_TAG, "unexpected error retrieving valid column from cursor, did the remote process die?", exception);
            return null;
        }
    }

    private void setViewDrawable(ImageView imageView, Drawable drawable2, int n) {
        imageView.setImageDrawable(drawable2);
        if (drawable2 == null) {
            imageView.setVisibility(n);
            return;
        }
        imageView.setVisibility(0);
        drawable2.setVisible(false, false);
        drawable2.setVisible(true, false);
    }

    private void setViewText(TextView textView, CharSequence charSequence) {
        textView.setText(charSequence);
        if (TextUtils.isEmpty(charSequence)) {
            textView.setVisibility(8);
            return;
        }
        textView.setVisibility(0);
    }

    private void storeInIconCache(String string2, Drawable drawable2) {
        if (drawable2 != null) {
            this.mOutsideDrawablesCache.put(string2, drawable2.getConstantState());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSpinnerState(Cursor cursor) {
        if (cursor == null) return;
        Bundle bundle = cursor.getExtras();
        if (bundle == null) return;
        if (!bundle.getBoolean("in_progress")) return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        ChildViewCache childViewCache = (ChildViewCache)view.getTag();
        int n = this.mFlagsCol;
        int n2 = 0;
        if (n != -1) {
            n2 = cursor.getInt(this.mFlagsCol);
        }
        if (childViewCache.mText1 != null) {
            String string2 = SuggestionsAdapter.getStringOrNull(cursor, this.mText1Col);
            this.setViewText(childViewCache.mText1, string2);
        }
        if (childViewCache.mText2 != null) {
            String string3 = SuggestionsAdapter.getStringOrNull(cursor, this.mText2UrlCol);
            CharSequence charSequence = string3 != null ? this.formatUrl(string3) : SuggestionsAdapter.getStringOrNull(cursor, this.mText2Col);
            if (TextUtils.isEmpty(charSequence)) {
                if (childViewCache.mText1 != null) {
                    childViewCache.mText1.setSingleLine(false);
                    childViewCache.mText1.setMaxLines(2);
                }
            } else if (childViewCache.mText1 != null) {
                childViewCache.mText1.setSingleLine(true);
                childViewCache.mText1.setMaxLines(1);
            }
            this.setViewText(childViewCache.mText2, charSequence);
        }
        if (childViewCache.mIcon1 != null) {
            this.setViewDrawable(childViewCache.mIcon1, this.getIcon1(cursor), 4);
        }
        if (childViewCache.mIcon2 != null) {
            this.setViewDrawable(childViewCache.mIcon2, this.getIcon2(cursor), 8);
        }
        if (this.mQueryRefinement == 2 || this.mQueryRefinement == 1 && (n2 & 1) != 0) {
            childViewCache.mIconRefine.setVisibility(0);
            childViewCache.mIconRefine.setTag(childViewCache.mText1.getText());
            childViewCache.mIconRefine.setOnClickListener(this);
            return;
        }
        childViewCache.mIconRefine.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void changeCursor(Cursor cursor) {
        if (this.mClosed) {
            Log.w(LOG_TAG, "Tried to change cursor after adapter was closed.");
            if (cursor == null) return;
            cursor.close();
            return;
        }
        try {
            super.changeCursor(cursor);
            if (cursor == null) return;
            this.mText1Col = cursor.getColumnIndex("suggest_text_1");
            this.mText2Col = cursor.getColumnIndex("suggest_text_2");
            this.mText2UrlCol = cursor.getColumnIndex("suggest_text_2_url");
            this.mIconName1Col = cursor.getColumnIndex("suggest_icon_1");
            this.mIconName2Col = cursor.getColumnIndex("suggest_icon_2");
            this.mFlagsCol = cursor.getColumnIndex("suggest_flags");
            return;
        }
        catch (Exception exception) {
            Log.e(LOG_TAG, "error changing cursor and caching columns", exception);
            return;
        }
    }

    public void close() {
        this.changeCursor(null);
        this.mClosed = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence convertToString(Cursor cursor) {
        String string2;
        if (cursor == null) {
            return null;
        }
        String string3 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        if (string3 != null) return string3;
        if (this.mSearchable.shouldRewriteQueryFromData() && (string2 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) != null) {
            return string2;
        }
        if (!this.mSearchable.shouldRewriteQueryFromText()) return null;
        String string4 = SuggestionsAdapter.getColumnString(cursor, "suggest_text_1");
        if (string4 == null) return null;
        return string4;
    }

    public int getQueryRefinement() {
        return this.mQueryRefinement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        try {
            View view2 = super.getView(n, view, viewGroup);
            return view2;
        }
        catch (RuntimeException runtimeException) {
            Log.w(LOG_TAG, "Search suggestions cursor threw exception.", runtimeException);
            View view3 = this.newView(this.mContext, this.mCursor, viewGroup);
            if (view3 == null) return view3;
            ((ChildViewCache)view3.getTag()).mText1.setText(runtimeException.toString());
            return view3;
        }
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        View view = super.newView(context, cursor, viewGroup);
        view.setTag(new ChildViewCache(view));
        ((ImageView)view.findViewById(16909240)).setImageResource(this.mCommitIconResId);
        return view;
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.updateSpinnerState(this.getCursor());
    }

    @Override
    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        this.updateSpinnerState(this.getCursor());
    }

    @Override
    public void onClick(View view) {
        Object object = view.getTag();
        if (object instanceof CharSequence) {
            this.mSearchView.onQueryRefine((CharSequence)object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        String string2 = charSequence == null ? "" : charSequence.toString();
        if (this.mSearchView.getVisibility() != 0 || this.mSearchView.getWindowVisibility() != 0) return null;
        try {
            Cursor cursor = this.mSearchManager.getSuggestions(this.mSearchable, string2, 50);
            if (cursor == null) return null;
            cursor.getCount();
            return cursor;
        }
        catch (RuntimeException runtimeException) {
            Log.w(LOG_TAG, "Search suggestions query threw an exception.", runtimeException);
            return null;
        }
    }

    public void setQueryRefinement(int n) {
        this.mQueryRefinement = n;
    }

    private static final class ChildViewCache {
        public final ImageView mIcon1;
        public final ImageView mIcon2;
        public final ImageView mIconRefine;
        public final TextView mText1;
        public final TextView mText2;

        public ChildViewCache(View view) {
            this.mText1 = (TextView)view.findViewById(16908308);
            this.mText2 = (TextView)view.findViewById(16908309);
            this.mIcon1 = (ImageView)view.findViewById(16908295);
            this.mIcon2 = (ImageView)view.findViewById(16908296);
            this.mIconRefine = (ImageView)view.findViewById(16909240);
        }
    }
}

