/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TableMaskFilter;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterViewAnimator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.lang.ref.WeakReference;

@RemoteViews.RemoteView
public class StackView
extends AdapterViewAnimator {
    private static final int DEFAULT_ANIMATION_DURATION = 400;
    private static final int FRAME_PADDING = 4;
    private static final int GESTURE_NONE = 0;
    private static final int GESTURE_SLIDE_DOWN = 2;
    private static final int GESTURE_SLIDE_UP = 1;
    private static final int INVALID_POINTER = -1;
    private static final int ITEMS_SLIDE_DOWN = 1;
    private static final int ITEMS_SLIDE_UP = 0;
    private static final int MINIMUM_ANIMATION_DURATION = 50;
    private static final int MIN_TIME_BETWEEN_INTERACTION_AND_AUTOADVANCE = 5000;
    private static final long MIN_TIME_BETWEEN_SCROLLS = 100L;
    private static final int NUM_ACTIVE_VIEWS = 5;
    private static final float PERSPECTIVE_SCALE_FACTOR = 0.0f;
    private static final float PERSPECTIVE_SHIFT_FACTOR_X = 0.1f;
    private static final float PERSPECTIVE_SHIFT_FACTOR_Y = 0.1f;
    private static final float SLIDE_UP_RATIO = 0.7f;
    private static final int STACK_RELAYOUT_DURATION = 100;
    private static final float SWIPE_THRESHOLD_RATIO = 0.2f;
    private static HolographicHelper sHolographicHelper;
    private final String TAG;
    private int mActivePointerId;
    private int mClickColor;
    private ImageView mClickFeedback;
    private boolean mClickFeedbackIsValid = false;
    private boolean mFirstLayoutHappened = false;
    private int mFramePadding;
    private ImageView mHighlight;
    private float mInitialX;
    private float mInitialY;
    private long mLastInteractionTime = 0L;
    private long mLastScrollTime;
    private int mMaximumVelocity;
    private float mNewPerspectiveShiftX;
    private float mNewPerspectiveShiftY;
    private float mPerspectiveShiftX;
    private float mPerspectiveShiftY;
    private int mResOutColor;
    private int mSlideAmount;
    private int mStackMode;
    private StackSlider mStackSlider;
    private int mSwipeGestureType = 0;
    private int mSwipeThreshold;
    private final Rect mTouchRect = new Rect();
    private int mTouchSlop;
    private boolean mTransitionIsSetup = false;
    private VelocityTracker mVelocityTracker;
    private int mYVelocity = 0;
    private final Rect stackInvalidateRect = new Rect();

    public StackView(Context context) {
        this(context, null);
    }

    public StackView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843838);
    }

    public StackView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public StackView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.TAG = "StackView";
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.StackView, n, n2);
        this.mResOutColor = typedArray.getColor(0, 0);
        this.mClickColor = typedArray.getColor(1, 0);
        typedArray.recycle();
        this.initStackView();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void beginGestureIfNeeded(float f) {
        View view;
        int n;
        int n2;
        block9: {
            block8: {
                int n3 = 1;
                if ((int)Math.abs(f) <= this.mTouchSlop) return;
                if (this.mSwipeGestureType != 0) break block8;
                n2 = f < 0.0f ? n3 : 2;
                this.cancelLongPress();
                this.requestDisallowInterceptTouchEvent(n3 != 0);
                if (this.mAdapter == null) break block8;
                int n4 = this.getCount();
                int n5 = this.mStackMode == 0 ? (n2 == 2 ? 0 : n3) : (n2 == 2 ? n3 : 0);
                int n6 = this.mLoopViews && n4 == n3 && (this.mStackMode == 0 && n2 == n3 || this.mStackMode == n3 && n2 == 2) ? n3 : 0;
                int n7 = this.mLoopViews && n4 == n3 && (this.mStackMode == n3 && n2 == n3 || this.mStackMode == 0 && n2 == 2) ? n3 : 0;
                if (this.mLoopViews && n7 == 0 && n6 == 0) {
                    n = 0;
                } else if (n5 + this.mCurrentWindowStartUnbounded == -1 || n7 != 0) {
                    ++n5;
                    n = 1;
                } else {
                    n = n5 + this.mCurrentWindowStartUnbounded == n4 - 1 || n6 != 0 ? 2 : 0;
                }
                if (n != 0) {
                    n3 = 0;
                }
                this.mTransitionIsSetup = n3;
                view = this.getViewAtRelativeIndex(n5);
                if (view != null) break block9;
            }
            return;
        }
        this.setupStackSlider(view, n);
        this.mSwipeGestureType = n2;
        this.cancelHandleClick();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handlePointerUp(MotionEvent motionEvent) {
        int n = (int)(motionEvent.getY(motionEvent.findPointerIndex(this.mActivePointerId)) - this.mInitialY);
        this.mLastInteractionTime = System.currentTimeMillis();
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
            this.mYVelocity = (int)this.mVelocityTracker.getYVelocity(this.mActivePointerId);
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (n > this.mSwipeThreshold && this.mSwipeGestureType == 2 && this.mStackSlider.mMode == 0) {
            this.mSwipeGestureType = 0;
            if (this.mStackMode == 0) {
                this.showPrevious();
            } else {
                this.showNext();
            }
            this.mHighlight.bringToFront();
        } else if (n < -this.mSwipeThreshold && this.mSwipeGestureType == 1 && this.mStackSlider.mMode == 0) {
            this.mSwipeGestureType = 0;
            if (this.mStackMode == 0) {
                this.showNext();
            } else {
                this.showPrevious();
            }
            this.mHighlight.bringToFront();
        } else if (this.mSwipeGestureType == 1) {
            float f = this.mStackMode == 1 ? 1.0f : 0.0f;
            int n2 = this.mStackMode == 0 || this.mStackSlider.mMode != 0 ? Math.round(this.mStackSlider.getDurationForNeutralPosition()) : Math.round(this.mStackSlider.getDurationForOffscreenPosition());
            StackSlider stackSlider = new StackSlider(this.mStackSlider);
            PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat("YProgress", f);
            ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder(stackSlider, PropertyValuesHolder.ofFloat("XProgress", 0.0f), propertyValuesHolder);
            objectAnimator.setDuration(n2);
            objectAnimator.setInterpolator(new LinearInterpolator());
            objectAnimator.start();
        } else if (this.mSwipeGestureType == 2) {
            float f = this.mStackMode == 1 ? 0.0f : 1.0f;
            int n3 = this.mStackMode == 1 || this.mStackSlider.mMode != 0 ? Math.round(this.mStackSlider.getDurationForNeutralPosition()) : Math.round(this.mStackSlider.getDurationForOffscreenPosition());
            StackSlider stackSlider = new StackSlider(this.mStackSlider);
            PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat("YProgress", f);
            ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder(stackSlider, PropertyValuesHolder.ofFloat("XProgress", 0.0f), propertyValuesHolder);
            objectAnimator.setDuration(n3);
            objectAnimator.start();
        }
        this.mActivePointerId = -1;
        this.mSwipeGestureType = 0;
    }

    private void initStackView() {
        this.configureViewAnimator(5, 1);
        this.setStaticTransformationsEnabled(true);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.getContext());
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mActivePointerId = -1;
        this.mHighlight = new ImageView(this.getContext());
        this.mHighlight.setLayoutParams(new LayoutParams(this.mHighlight));
        this.addViewInLayout(this.mHighlight, -1, new LayoutParams(this.mHighlight));
        this.mClickFeedback = new ImageView(this.getContext());
        this.mClickFeedback.setLayoutParams(new LayoutParams(this.mClickFeedback));
        this.addViewInLayout(this.mClickFeedback, -1, new LayoutParams(this.mClickFeedback));
        this.mClickFeedback.setVisibility(4);
        this.mStackSlider = new StackSlider();
        if (sHolographicHelper == null) {
            sHolographicHelper = new HolographicHelper(this.mContext);
        }
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.mStackMode = 1;
        this.mWhichChild = -1;
        this.mFramePadding = (int)Math.ceil(4.0f * this.mContext.getResources().getDisplayMetrics().density);
    }

    private void measureChildren() {
        int n = this.getChildCount();
        int n2 = this.getMeasuredWidth();
        int n3 = this.getMeasuredHeight();
        int n4 = Math.round(0.9f * (float)n2) - this.mPaddingLeft - this.mPaddingRight;
        int n5 = Math.round(0.9f * (float)n3) - this.mPaddingTop - this.mPaddingBottom;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            view.measure(View.MeasureSpec.makeMeasureSpec(n4, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(n5, Integer.MIN_VALUE));
            if (view == this.mHighlight || view == this.mClickFeedback) continue;
            int n8 = view.getMeasuredWidth();
            int n9 = view.getMeasuredHeight();
            if (n8 > n6) {
                n6 = n8;
            }
            if (n9 <= n7) continue;
            n7 = n9;
        }
        this.mNewPerspectiveShiftX = 0.1f * (float)n2;
        this.mNewPerspectiveShiftY = 0.1f * (float)n3;
        if (n6 > 0 && n > 0 && n6 < n4) {
            this.mNewPerspectiveShiftX = n2 - n6;
        }
        if (n7 > 0 && n > 0 && n7 < n5) {
            this.mNewPerspectiveShiftY = n3 - n7;
        }
    }

    private void onLayout() {
        int n;
        if (!this.mFirstLayoutHappened) {
            this.mFirstLayoutHappened = true;
            this.updateChildTransforms();
        }
        if (this.mSlideAmount != (n = Math.round(0.7f * (float)this.getMeasuredHeight()))) {
            this.mSlideAmount = n;
            this.mSwipeThreshold = Math.round(0.2f * (float)n);
        }
        if (Float.compare(this.mPerspectiveShiftY, this.mNewPerspectiveShiftY) != 0 || Float.compare(this.mPerspectiveShiftX, this.mNewPerspectiveShiftX) != 0) {
            this.mPerspectiveShiftY = this.mNewPerspectiveShiftY;
            this.mPerspectiveShiftX = this.mNewPerspectiveShiftX;
            this.updateChildTransforms();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        block5: {
            int n;
            View view;
            int n2 = motionEvent.getActionIndex();
            if (motionEvent.getPointerId(n2) == this.mActivePointerId && (view = this.getViewAtRelativeIndex(n = this.mSwipeGestureType == 2 ? 0 : 1)) != null) {
                int n3 = 0;
                while (true) {
                    if (n3 >= motionEvent.getPointerCount()) {
                        this.handlePointerUp(motionEvent);
                        return;
                    }
                    if (n3 != n2) {
                        float f = motionEvent.getX(n3);
                        float f2 = motionEvent.getY(n3);
                        this.mTouchRect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
                        if (this.mTouchRect.contains(Math.round(f), Math.round(f2))) {
                            float f3 = motionEvent.getX(n2);
                            float f4 = motionEvent.getY(n2);
                            this.mInitialY += f2 - f4;
                            this.mInitialX += f - f3;
                            this.mActivePointerId = motionEvent.getPointerId(n3);
                            if (this.mVelocityTracker == null) break;
                            break block5;
                        }
                    }
                    ++n3;
                }
            }
            return;
        }
        this.mVelocityTracker.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void pacedScroll(boolean bl) {
        if (System.currentTimeMillis() - this.mLastScrollTime > 100L) {
            if (bl) {
                this.showPrevious();
            } else {
                this.showNext();
            }
            this.mLastScrollTime = System.currentTimeMillis();
        }
    }

    private void setupStackSlider(View view, int n) {
        this.mStackSlider.setMode(n);
        if (view != null) {
            this.mHighlight.setImageBitmap(sHolographicHelper.createResOutline(view, this.mResOutColor));
            this.mHighlight.setRotation(view.getRotation());
            this.mHighlight.setTranslationY(view.getTranslationY());
            this.mHighlight.setTranslationX(view.getTranslationX());
            this.mHighlight.bringToFront();
            view.bringToFront();
            this.mStackSlider.setView(view);
            view.setVisibility(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void transformViewAtIndex(int n, View view, boolean bl) {
        int n2;
        float f = this.mPerspectiveShiftY;
        float f2 = this.mPerspectiveShiftX;
        if (this.mStackMode == 1) {
            n2 = -1 + (this.mMaxNumActiveViews - n);
            int n3 = -1 + this.mMaxNumActiveViews;
            if (n2 == n3) {
                --n2;
            }
        } else {
            n2 = n - 1;
            if (n2 < 0) {
                ++n2;
            }
        }
        float f3 = 1.0f * (float)n2 / (float)(-2 + this.mMaxNumActiveViews);
        float f4 = 1.0f - 0.0f * (1.0f - f3);
        float f5 = f3 * f + (f4 - 1.0f) * (0.9f * (float)this.getMeasuredHeight() / 2.0f);
        float f6 = f2 * (1.0f - f3) + (1.0f - f4) * (0.9f * (float)this.getMeasuredWidth() / 2.0f);
        if (view instanceof StackFrame) {
            ((StackFrame)view).cancelTransformAnimator();
        }
        if (!bl) {
            view.setTranslationX(f6);
            view.setTranslationY(f5);
            view.setScaleX(f4);
            view.setScaleY(f4);
            return;
        }
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat("translationX", f6);
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat("translationY", f5);
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder(view, PropertyValuesHolder.ofFloat("scaleX", f4), PropertyValuesHolder.ofFloat("scaleY", f4), propertyValuesHolder2, propertyValuesHolder);
        objectAnimator.setDuration(100L);
        if (view instanceof StackFrame) {
            ((StackFrame)view).setTransformAnimator(objectAnimator);
        }
        objectAnimator.start();
    }

    private void updateChildTransforms() {
        for (int i = 0; i < this.getNumActiveViews(); ++i) {
            View view = this.getViewAtRelativeIndex(i);
            if (view == null) continue;
            this.transformViewAtIndex(i, view, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void advance() {
        long l = System.currentTimeMillis() - this.mLastInteractionTime;
        if (this.mAdapter == null || this.getCount() == 1 && this.mLoopViews || this.mSwipeGestureType != 0 || l <= 5000L) {
            return;
        }
        this.showNext();
    }

    @Override
    void applyTransformForChildAtIndex(View view, int n) {
    }

    @Override
    LayoutParams createOrReuseLayoutParams(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof LayoutParams) {
            LayoutParams layoutParams2 = (LayoutParams)layoutParams;
            layoutParams2.setHorizontalOffset(0);
            layoutParams2.setVerticalOffset(0);
            layoutParams2.width = 0;
            layoutParams2.width = 0;
            return layoutParams2;
        }
        return new LayoutParams(view);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean bl = false;
        canvas.getClipBounds(this.stackInvalidateRect);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            Rect rect;
            View view = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.horizontalOffset == 0 && layoutParams.verticalOffset == 0 || view.getAlpha() == 0.0f || view.getVisibility() != 0) {
                layoutParams.resetInvalidateRect();
            }
            if ((rect = layoutParams.getInvalidateRect()).isEmpty()) continue;
            bl = true;
            this.stackInvalidateRect.union(rect);
        }
        if (bl) {
            canvas.save(2);
            canvas.clipRect(this.stackInvalidateRect, Region.Op.UNION);
            super.dispatchDraw(canvas);
            canvas.restore();
            return;
        }
        super.dispatchDraw(canvas);
    }

    @Override
    FrameLayout getFrameForChild() {
        StackFrame stackFrame = new StackFrame(this.mContext);
        stackFrame.setPadding(this.mFramePadding, this.mFramePadding, this.mFramePadding, this.mFramePadding);
        return stackFrame;
    }

    @Override
    void hideTapFeedback(View view) {
        this.mClickFeedback.setVisibility(4);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((2 & motionEvent.getSource()) == 0) return super.onGenericMotionEvent(motionEvent);
        switch (motionEvent.getAction()) {
            default: {
                return super.onGenericMotionEvent(motionEvent);
            }
            case 8: {
                float f = motionEvent.getAxisValue(9);
                if (f < 0.0f) {
                    this.pacedScroll(false);
                    return true;
                }
                if (!(f > 0.0f)) return super.onGenericMotionEvent(motionEvent);
                this.pacedScroll(true);
                return true;
            }
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(StackView.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        int n = 1;
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(StackView.class.getName());
        if (this.getChildCount() <= n) {
            n = 0;
        }
        accessibilityNodeInfo.setScrollable(n != 0);
        if (this.isEnabled()) {
            if (this.getDisplayedChild() < -1 + this.getChildCount()) {
                accessibilityNodeInfo.addAction(4096);
            }
            if (this.getDisplayedChild() > 0) {
                accessibilityNodeInfo.addAction(8192);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        switch (0xFF & motionEvent.getAction()) {
            case 0: {
                if (this.mActivePointerId != -1) break;
                this.mInitialX = motionEvent.getX();
                this.mInitialY = motionEvent.getY();
                this.mActivePointerId = motionEvent.getPointerId(0);
                break;
            }
            case 2: {
                int n = motionEvent.findPointerIndex(this.mActivePointerId);
                if (n == -1) {
                    Log.d("StackView", "Error: No data for our primary pointer.");
                    return false;
                }
                this.beginGestureIfNeeded(motionEvent.getY(n) - this.mInitialY);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                this.mSwipeGestureType = 0;
                break;
            }
        }
        int n = this.mSwipeGestureType;
        boolean bl = false;
        if (n == 0) return bl;
        return true;
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.checkForAndHandleDataChanged();
        int n5 = this.getChildCount();
        for (int i = 0; i < n5; ++i) {
            View view = this.getChildAt(i);
            int n6 = this.mPaddingLeft + view.getMeasuredWidth();
            int n7 = this.mPaddingTop + view.getMeasuredHeight();
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            view.layout(this.mPaddingLeft + layoutParams.horizontalOffset, this.mPaddingTop + layoutParams.verticalOffset, n6 + layoutParams.horizontalOffset, n7 + layoutParams.verticalOffset);
        }
        this.onLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize(n);
        int n4 = View.MeasureSpec.getSize(n2);
        int n5 = View.MeasureSpec.getMode(n);
        int n6 = View.MeasureSpec.getMode(n2);
        boolean bl = this.mReferenceChildWidth != -1 && this.mReferenceChildHeight != -1;
        if (n6 == 0) {
            n4 = bl ? Math.round((float)this.mReferenceChildHeight * (1.0f + 1.1111112f)) + this.mPaddingTop + this.mPaddingBottom : 0;
        } else if (n6 == Integer.MIN_VALUE) {
            int n7;
            n4 = bl ? ((n7 = Math.round((float)this.mReferenceChildHeight * (1.0f + 1.1111112f)) + this.mPaddingTop + this.mPaddingBottom) <= n4 ? n7 : (n4 |= 0x1000000)) : 0;
        }
        if (n5 == 0) {
            n3 = bl ? Math.round((float)this.mReferenceChildWidth * (1.0f + 1.1111112f)) + this.mPaddingLeft + this.mPaddingRight : 0;
        } else if (n6 == Integer.MIN_VALUE) {
            int n8;
            n3 = bl ? ((n8 = this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight) <= n3 ? n8 : (n3 |= 0x1000000)) : 0;
        }
        this.setMeasuredDimension(n3, n4);
        this.measureChildren();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        int n = motionEvent.getAction();
        int n2 = motionEvent.findPointerIndex(this.mActivePointerId);
        if (n2 == -1) {
            Log.d("StackView", "Error: No data for our primary pointer.");
            return false;
        }
        float f = motionEvent.getY(n2);
        float f2 = motionEvent.getX(n2);
        float f3 = f - this.mInitialY;
        float f4 = f2 - this.mInitialX;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        switch (n & 0xFF) {
            case 2: {
                this.beginGestureIfNeeded(f3);
                float f5 = f4 / (1.0f * (float)this.mSlideAmount);
                if (this.mSwipeGestureType == 2) {
                    float f6 = 1.0f * ((f3 - 1.0f * (float)this.mTouchSlop) / (float)this.mSlideAmount);
                    if (this.mStackMode == 1) {
                        f6 = 1.0f - f6;
                    }
                    this.mStackSlider.setYProgress(1.0f - f6);
                    this.mStackSlider.setXProgress(f5);
                    return true;
                }
                if (this.mSwipeGestureType != 1) return true;
                float f7 = 1.0f * (-(f3 + 1.0f * (float)this.mTouchSlop) / (float)this.mSlideAmount);
                if (this.mStackMode == 1) {
                    f7 = 1.0f - f7;
                }
                this.mStackSlider.setYProgress(f7);
                this.mStackSlider.setXProgress(f5);
                return true;
            }
            case 1: {
                this.handlePointerUp(motionEvent);
                return true;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                return true;
            }
            case 3: {
                this.mActivePointerId = -1;
                this.mSwipeGestureType = 0;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        if (super.performAccessibilityAction(n, bundle)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (n) {
            default: {
                return false;
            }
            case 4096: {
                if (this.getDisplayedChild() < -1 + this.getChildCount()) {
                    this.showNext();
                    return true;
                }
                return false;
            }
            case 8192: 
        }
        if (this.getDisplayedChild() > 0) {
            this.showPrevious();
            return true;
        }
        return false;
    }

    @Override
    @RemotableViewMethod
    public void showNext() {
        View view;
        if (this.mSwipeGestureType != 0) {
            return;
        }
        if (!this.mTransitionIsSetup && (view = this.getViewAtRelativeIndex(1)) != null) {
            this.setupStackSlider(view, 0);
            this.mStackSlider.setYProgress(0.0f);
            this.mStackSlider.setXProgress(0.0f);
        }
        super.showNext();
    }

    @Override
    void showOnly(int n, boolean bl) {
        super.showOnly(n, bl);
        for (int i = this.mCurrentWindowEnd; i >= this.mCurrentWindowStart; --i) {
            View view;
            int n2 = this.modulo(i, this.getWindowSize());
            if ((AdapterViewAnimator.ViewAndMetaData)this.mViewsMap.get(n2) == null || (view = ((AdapterViewAnimator.ViewAndMetaData)this.mViewsMap.get((Object)Integer.valueOf((int)n2))).view) == null) continue;
            view.bringToFront();
        }
        if (this.mHighlight != null) {
            this.mHighlight.bringToFront();
        }
        this.mTransitionIsSetup = false;
        this.mClickFeedbackIsValid = false;
    }

    @Override
    @RemotableViewMethod
    public void showPrevious() {
        View view;
        if (this.mSwipeGestureType != 0) {
            return;
        }
        if (!this.mTransitionIsSetup && (view = this.getViewAtRelativeIndex(0)) != null) {
            this.setupStackSlider(view, 0);
            this.mStackSlider.setYProgress(1.0f);
            this.mStackSlider.setXProgress(0.0f);
        }
        super.showPrevious();
    }

    @Override
    void showTapFeedback(View view) {
        this.updateClickFeedback();
        this.mClickFeedback.setVisibility(0);
        this.mClickFeedback.bringToFront();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void transformViewForTransition(int n, int n2, final View view, boolean bl) {
        if (!bl) {
            ((StackFrame)view).cancelSliderAnimator();
            view.setRotationX(0.0f);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            layoutParams.setVerticalOffset(0);
            layoutParams.setHorizontalOffset(0);
        }
        if (n == -1 && n2 == -1 + this.getNumActiveViews()) {
            this.transformViewAtIndex(n2, view, false);
            view.setVisibility(0);
            view.setAlpha(1.0f);
        } else if (n == 0 && n2 == 1) {
            ((StackFrame)view).cancelSliderAnimator();
            view.setVisibility(0);
            int n3 = Math.round(this.mStackSlider.getDurationForNeutralPosition(this.mYVelocity));
            StackSlider stackSlider = new StackSlider(this.mStackSlider);
            stackSlider.setView(view);
            if (bl) {
                PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat("YProgress", 0.0f);
                ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder(stackSlider, PropertyValuesHolder.ofFloat("XProgress", 0.0f), propertyValuesHolder);
                objectAnimator.setDuration(n3);
                objectAnimator.setInterpolator(new LinearInterpolator());
                ((StackFrame)view).setSliderAnimator(objectAnimator);
                objectAnimator.start();
            } else {
                stackSlider.setYProgress(0.0f);
                stackSlider.setXProgress(0.0f);
            }
        } else if (n == 1 && n2 == 0) {
            ((StackFrame)view).cancelSliderAnimator();
            int n4 = Math.round(this.mStackSlider.getDurationForOffscreenPosition(this.mYVelocity));
            StackSlider stackSlider = new StackSlider(this.mStackSlider);
            stackSlider.setView(view);
            if (bl) {
                PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat("YProgress", 1.0f);
                ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder(stackSlider, PropertyValuesHolder.ofFloat("XProgress", 0.0f), propertyValuesHolder);
                objectAnimator.setDuration(n4);
                objectAnimator.setInterpolator(new LinearInterpolator());
                ((StackFrame)view).setSliderAnimator(objectAnimator);
                objectAnimator.start();
            } else {
                stackSlider.setYProgress(1.0f);
                stackSlider.setXProgress(0.0f);
            }
        } else if (n2 == 0) {
            view.setAlpha(0.0f);
            view.setVisibility(4);
        } else if ((n == 0 || n == 1) && n2 > 1) {
            view.setVisibility(0);
            view.setAlpha(1.0f);
            view.setRotationX(0.0f);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            layoutParams.setVerticalOffset(0);
            layoutParams.setHorizontalOffset(0);
        } else if (n == -1) {
            view.setAlpha(1.0f);
            view.setVisibility(0);
        } else if (n2 == -1) {
            if (bl) {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        view.setAlpha(0.0f);
                    }
                }, 100L);
            } else {
                view.setAlpha(0.0f);
            }
        }
        if (n2 != -1) {
            this.transformViewAtIndex(n2, view, bl);
        }
    }

    void updateClickFeedback() {
        if (!this.mClickFeedbackIsValid) {
            View view = this.getViewAtRelativeIndex(1);
            if (view != null) {
                this.mClickFeedback.setImageBitmap(sHolographicHelper.createClickOutline(view, this.mClickColor));
                this.mClickFeedback.setTranslationX(view.getTranslationX());
                this.mClickFeedback.setTranslationY(view.getTranslationY());
            }
            this.mClickFeedbackIsValid = true;
        }
    }

    private static class HolographicHelper {
        private static final int CLICK_FEEDBACK = 1;
        private static final int RES_OUT;
        private final Paint mBlurPaint;
        private final Canvas mCanvas;
        private float mDensity;
        private final Paint mErasePaint;
        private final Paint mHolographicPaint = new Paint();
        private final Matrix mIdentityMatrix;
        private BlurMaskFilter mLargeBlurMaskFilter;
        private final Canvas mMaskCanvas;
        private BlurMaskFilter mSmallBlurMaskFilter;
        private final int[] mTmpXY;

        HolographicHelper(Context context) {
            this.mErasePaint = new Paint();
            this.mBlurPaint = new Paint();
            this.mCanvas = new Canvas();
            this.mMaskCanvas = new Canvas();
            this.mTmpXY = new int[2];
            this.mIdentityMatrix = new Matrix();
            this.mDensity = context.getResources().getDisplayMetrics().density;
            this.mHolographicPaint.setFilterBitmap(true);
            this.mHolographicPaint.setMaskFilter(TableMaskFilter.CreateClipTable(0, 30));
            this.mErasePaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.mErasePaint.setFilterBitmap(true);
            this.mSmallBlurMaskFilter = new BlurMaskFilter(2.0f * this.mDensity, BlurMaskFilter.Blur.NORMAL);
            this.mLargeBlurMaskFilter = new BlurMaskFilter(4.0f * this.mDensity, BlurMaskFilter.Blur.NORMAL);
        }

        Bitmap createClickOutline(View view, int n) {
            return this.createOutline(view, 1, n);
        }

        /*
         * Enabled aggressive block sorting
         */
        Bitmap createOutline(View view, int n, int n2) {
            this.mHolographicPaint.setColor(n2);
            if (n == 0) {
                this.mBlurPaint.setMaskFilter(this.mSmallBlurMaskFilter);
            } else if (n == 1) {
                this.mBlurPaint.setMaskFilter(this.mLargeBlurMaskFilter);
            }
            if (view.getMeasuredWidth() != 0 && view.getMeasuredHeight() != 0) {
                Bitmap bitmap = Bitmap.createBitmap(view.getResources().getDisplayMetrics(), view.getMeasuredWidth(), view.getMeasuredHeight(), Bitmap.Config.ARGB_8888);
                this.mCanvas.setBitmap(bitmap);
                float f = view.getRotationX();
                float f2 = view.getRotation();
                float f3 = view.getTranslationY();
                float f4 = view.getTranslationX();
                view.setRotationX(0.0f);
                view.setRotation(0.0f);
                view.setTranslationY(0.0f);
                view.setTranslationX(0.0f);
                view.draw(this.mCanvas);
                view.setRotationX(f);
                view.setRotation(f2);
                view.setTranslationY(f3);
                view.setTranslationX(f4);
                this.drawOutline(this.mCanvas, bitmap);
                this.mCanvas.setBitmap(null);
                return bitmap;
            }
            return null;
        }

        Bitmap createResOutline(View view, int n) {
            return this.createOutline(view, 0, n);
        }

        void drawOutline(Canvas canvas, Bitmap bitmap) {
            int[] nArray = this.mTmpXY;
            Bitmap bitmap2 = bitmap.extractAlpha(this.mBlurPaint, nArray);
            this.mMaskCanvas.setBitmap(bitmap2);
            this.mMaskCanvas.drawBitmap(bitmap, -nArray[0], -nArray[1], this.mErasePaint);
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            canvas.setMatrix(this.mIdentityMatrix);
            canvas.drawBitmap(bitmap2, nArray[0], nArray[1], this.mHolographicPaint);
            this.mMaskCanvas.setBitmap(null);
            bitmap2.recycle();
        }
    }

    class LayoutParams
    extends ViewGroup.LayoutParams {
        private final Rect globalInvalidateRect;
        int horizontalOffset;
        private final Rect invalidateRect;
        private final RectF invalidateRectf;
        View mView;
        private final Rect parentRect;
        int verticalOffset;

        LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.parentRect = new Rect();
            this.invalidateRect = new Rect();
            this.invalidateRectf = new RectF();
            this.globalInvalidateRect = new Rect();
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.width = 0;
            this.height = 0;
        }

        LayoutParams(View view) {
            super(0, 0);
            this.parentRect = new Rect();
            this.invalidateRect = new Rect();
            this.invalidateRectf = new RectF();
            this.globalInvalidateRect = new Rect();
            this.width = 0;
            this.height = 0;
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.mView = view;
        }

        Rect getInvalidateRect() {
            return this.invalidateRect;
        }

        void invalidateGlobalRegion(View view, Rect rect) {
            this.globalInvalidateRect.set(rect);
            this.globalInvalidateRect.union(0, 0, StackView.this.getWidth(), StackView.this.getHeight());
            View view2 = view;
            if (view.getParent() == null || !(view.getParent() instanceof View)) {
                return;
            }
            boolean bl = true;
            this.parentRect.set(0, 0, 0, 0);
            while (view2.getParent() != null && view2.getParent() instanceof View && !this.parentRect.contains(this.globalInvalidateRect)) {
                if (!bl) {
                    this.globalInvalidateRect.offset(view2.getLeft() - view2.getScrollX(), view2.getTop() - view2.getScrollY());
                }
                view2 = (View)((Object)view2.getParent());
                this.parentRect.set(view2.getScrollX(), view2.getScrollY(), view2.getWidth() + view2.getScrollX(), view2.getHeight() + view2.getScrollY());
                view2.invalidate(this.globalInvalidateRect.left, this.globalInvalidateRect.top, this.globalInvalidateRect.right, this.globalInvalidateRect.bottom);
                bl = false;
            }
            view2.invalidate(this.globalInvalidateRect.left, this.globalInvalidateRect.top, this.globalInvalidateRect.right, this.globalInvalidateRect.bottom);
        }

        void resetInvalidateRect() {
            this.invalidateRect.set(0, 0, 0, 0);
        }

        public void setHorizontalOffset(int n) {
            this.setOffsets(n, this.verticalOffset);
        }

        public void setOffsets(int n, int n2) {
            int n3 = n - this.horizontalOffset;
            this.horizontalOffset = n;
            int n4 = n2 - this.verticalOffset;
            this.verticalOffset = n2;
            if (this.mView != null) {
                this.mView.requestLayout();
                int n5 = Math.min(n3 + this.mView.getLeft(), this.mView.getLeft());
                int n6 = Math.max(n3 + this.mView.getRight(), this.mView.getRight());
                int n7 = Math.min(n4 + this.mView.getTop(), this.mView.getTop());
                int n8 = Math.max(n4 + this.mView.getBottom(), this.mView.getBottom());
                this.invalidateRectf.set(n5, n7, n6, n8);
                float f = -this.invalidateRectf.left;
                float f2 = -this.invalidateRectf.top;
                this.invalidateRectf.offset(f, f2);
                this.mView.getMatrix().mapRect(this.invalidateRectf);
                this.invalidateRectf.offset(-f, -f2);
                this.invalidateRect.set((int)Math.floor(this.invalidateRectf.left), (int)Math.floor(this.invalidateRectf.top), (int)Math.ceil(this.invalidateRectf.right), (int)Math.ceil(this.invalidateRectf.bottom));
                this.invalidateGlobalRegion(this.mView, this.invalidateRect);
            }
        }

        public void setVerticalOffset(int n) {
            this.setOffsets(this.horizontalOffset, n);
        }
    }

    private static class StackFrame
    extends FrameLayout {
        WeakReference<ObjectAnimator> sliderAnimator;
        WeakReference<ObjectAnimator> transformAnimator;

        public StackFrame(Context context) {
            super(context);
        }

        boolean cancelSliderAnimator() {
            ObjectAnimator objectAnimator;
            if (this.sliderAnimator != null && (objectAnimator = (ObjectAnimator)this.sliderAnimator.get()) != null) {
                objectAnimator.cancel();
                return true;
            }
            return false;
        }

        boolean cancelTransformAnimator() {
            ObjectAnimator objectAnimator;
            if (this.transformAnimator != null && (objectAnimator = (ObjectAnimator)this.transformAnimator.get()) != null) {
                objectAnimator.cancel();
                return true;
            }
            return false;
        }

        void setSliderAnimator(ObjectAnimator objectAnimator) {
            this.sliderAnimator = new WeakReference<ObjectAnimator>(objectAnimator);
        }

        void setTransformAnimator(ObjectAnimator objectAnimator) {
            this.transformAnimator = new WeakReference<ObjectAnimator>(objectAnimator);
        }
    }

    private class StackSlider {
        static final int BEGINNING_OF_STACK_MODE = 1;
        static final int END_OF_STACK_MODE = 2;
        static final int NORMAL_MODE;
        int mMode = 0;
        View mView;
        float mXProgress;
        float mYProgress;

        public StackSlider() {
        }

        public StackSlider(StackSlider stackSlider) {
            this.mView = stackSlider.mView;
            this.mYProgress = stackSlider.mYProgress;
            this.mXProgress = stackSlider.mXProgress;
            this.mMode = stackSlider.mMode;
        }

        private float cubic(float f) {
            return (float)(1.0 + Math.pow(2.0f * f - 1.0f, 3.0)) / 2.0f;
        }

        /*
         * Enabled aggressive block sorting
         */
        private float getDuration(boolean bl, float f) {
            if (this.mView == null) {
                return 0.0f;
            }
            LayoutParams layoutParams = (LayoutParams)this.mView.getLayoutParams();
            float f2 = (float)Math.sqrt(Math.pow(layoutParams.horizontalOffset, 2.0) + Math.pow(layoutParams.verticalOffset, 2.0));
            float f3 = (float)Math.sqrt(Math.pow(StackView.this.mSlideAmount, 2.0) + Math.pow(0.4f * (float)StackView.this.mSlideAmount, 2.0));
            if (f == 0.0f) {
                float f4 = bl ? 1.0f - f2 / f3 : f2 / f3;
                return f4 * 400.0f;
            }
            float f5 = bl ? f2 / Math.abs(f) : (f3 - f2) / Math.abs(f);
            if (f5 < 50.0f) return this.getDuration(bl, 0.0f);
            if (!(f5 > 400.0f)) return f5;
            return this.getDuration(bl, 0.0f);
        }

        private float highlightAlphaInterpolator(float f) {
            if (f < 0.4f) {
                return 0.85f * this.cubic(f / 0.4f);
            }
            return 0.85f * this.cubic(1.0f - (f - 0.4f) / (1.0f - 0.4f));
        }

        private float rotationInterpolator(float f) {
            if (f < 0.2f) {
                return 0.0f;
            }
            return (f - 0.2f) / (1.0f - 0.2f);
        }

        private float viewAlphaInterpolator(float f) {
            if (f > 0.3f) {
                return (f - 0.3f) / (1.0f - 0.3f);
            }
            return 0.0f;
        }

        float getDurationForNeutralPosition() {
            return this.getDuration(false, 0.0f);
        }

        float getDurationForNeutralPosition(float f) {
            return this.getDuration(false, f);
        }

        float getDurationForOffscreenPosition() {
            return this.getDuration(true, 0.0f);
        }

        float getDurationForOffscreenPosition(float f) {
            return this.getDuration(true, f);
        }

        public float getXProgress() {
            return this.mXProgress;
        }

        public float getYProgress() {
            return this.mYProgress;
        }

        void setMode(int n) {
            this.mMode = n;
        }

        void setView(View view) {
            this.mView = view;
        }

        public void setXProgress(float f) {
            float f2;
            this.mXProgress = f2 = Math.max(-2.0f, Math.min(2.0f, f));
            if (this.mView == null) {
                return;
            }
            LayoutParams layoutParams = (LayoutParams)this.mView.getLayoutParams();
            LayoutParams layoutParams2 = (LayoutParams)StackView.this.mHighlight.getLayoutParams();
            float f3 = f2 * 0.2f;
            layoutParams.setHorizontalOffset(Math.round(f3 * (float)StackView.this.mSlideAmount));
            layoutParams2.setHorizontalOffset(Math.round(f3 * (float)StackView.this.mSlideAmount));
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setYProgress(float f) {
            float f2;
            this.mYProgress = f2 = Math.max(0.0f, Math.min(1.0f, f));
            if (this.mView == null) {
                return;
            }
            LayoutParams layoutParams = (LayoutParams)this.mView.getLayoutParams();
            LayoutParams layoutParams2 = (LayoutParams)StackView.this.mHighlight.getLayoutParams();
            int n = StackView.this.mStackMode == 0 ? 1 : -1;
            if (Float.compare(0.0f, this.mYProgress) != 0 && Float.compare(1.0f, this.mYProgress) != 0) {
                if (this.mView.getLayerType() == 0) {
                    this.mView.setLayerType(2, null);
                }
            } else if (this.mView.getLayerType() != 0) {
                this.mView.setLayerType(0, null);
            }
            switch (this.mMode) {
                default: {
                    return;
                }
                case 0: {
                    layoutParams.setVerticalOffset(Math.round(-f2 * (float)n * (float)StackView.this.mSlideAmount));
                    layoutParams2.setVerticalOffset(Math.round(-f2 * (float)n * (float)StackView.this.mSlideAmount));
                    StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(f2));
                    float f3 = this.viewAlphaInterpolator(1.0f - f2);
                    if (this.mView.getAlpha() == 0.0f && f3 != 0.0f && this.mView.getVisibility() != 0) {
                        this.mView.setVisibility(0);
                    } else if (f3 == 0.0f && this.mView.getAlpha() != 0.0f && this.mView.getVisibility() == 0) {
                        this.mView.setVisibility(4);
                    }
                    this.mView.setAlpha(f3);
                    this.mView.setRotationX(90.0f * (float)n * this.rotationInterpolator(f2));
                    StackView.this.mHighlight.setRotationX(90.0f * (float)n * this.rotationInterpolator(f2));
                    return;
                }
                case 2: {
                    float f4 = f2 * 0.2f;
                    layoutParams.setVerticalOffset(Math.round(f4 * (float)(-n) * (float)StackView.this.mSlideAmount));
                    layoutParams2.setVerticalOffset(Math.round(f4 * (float)(-n) * (float)StackView.this.mSlideAmount));
                    StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(f4));
                    return;
                }
                case 1: 
            }
            float f5 = 0.2f * (1.0f - f2);
            layoutParams.setVerticalOffset(Math.round(f5 * (float)n * (float)StackView.this.mSlideAmount));
            layoutParams2.setVerticalOffset(Math.round(f5 * (float)n * (float)StackView.this.mSlideAmount));
            StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(f5));
        }
    }
}

