/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.widget.ExploreByTouchHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;

class SimpleMonthView
extends View {
    private static final int DAY_SEPARATOR_WIDTH = 1;
    private static final int DEFAULT_HEIGHT = 32;
    private static final int DEFAULT_NUM_DAYS = 7;
    private static final int DEFAULT_NUM_ROWS = 6;
    private static final int DEFAULT_SELECTED_DAY = -1;
    private static final int DEFAULT_WEEK_START = 1;
    private static final int MAX_NUM_ROWS = 6;
    private static final int MIN_HEIGHT = 10;
    private static final int SELECTED_CIRCLE_ALPHA = 60;
    private static final String TAG = "SimpleMonthView";
    private static float mScale = 0.0f;
    private final Calendar mCalendar;
    private SimpleDateFormat mDayFormatter = new SimpleDateFormat("EEEEE", Locale.getDefault());
    private final Calendar mDayLabelCalendar;
    private Paint mDayNumberDisabledPaint;
    private Paint mDayNumberPaint;
    private Paint mDayNumberSelectedPaint;
    private int mDayOfWeekStart = 0;
    private String mDayOfWeekTypeface;
    private final int mDaySelectedCircleSize;
    private int mDisabledTextColor;
    private int mEnabledDayEnd = 31;
    private int mEnabledDayStart = 1;
    private final Formatter mFormatter;
    private boolean mHasToday = false;
    private boolean mLockAccessibilityDelegate;
    private final int mMiniDayNumberTextSize;
    private int mMonth;
    private Paint mMonthDayLabelPaint;
    private final int mMonthDayLabelTextSize;
    private final int mMonthHeaderSize;
    private final int mMonthLabelTextSize;
    private Paint mMonthTitlePaint;
    private String mMonthTitleTypeface;
    private int mNormalTextColor;
    private int mNumCells = this.mNumDays = 7;
    private int mNumDays;
    private int mNumRows = 6;
    private OnDayClickListener mOnDayClickListener;
    private int mPadding = 0;
    private int mRowHeight = 32;
    private int mSelectedDay = -1;
    private int mSelectedDayColor;
    private final StringBuilder mStringBuilder;
    private int mToday = -1;
    private final MonthViewTouchHelper mTouchHelper;
    private int mWeekStart = 1;
    private int mWidth;
    private int mYear;

    public SimpleMonthView(Context context) {
        this(context, null);
    }

    public SimpleMonthView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843612);
    }

    public SimpleMonthView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.mCalendar = Calendar.getInstance();
        this.mDayLabelCalendar = Calendar.getInstance();
        Resources resources = context.getResources();
        this.mDayOfWeekTypeface = resources.getString(17041012);
        this.mMonthTitleTypeface = resources.getString(17041011);
        this.mStringBuilder = new StringBuilder(50);
        this.mFormatter = new Formatter(this.mStringBuilder, Locale.getDefault());
        this.mMiniDayNumberTextSize = resources.getDimensionPixelSize(17105031);
        this.mMonthLabelTextSize = resources.getDimensionPixelSize(17105032);
        this.mMonthDayLabelTextSize = resources.getDimensionPixelSize(17105033);
        this.mMonthHeaderSize = resources.getDimensionPixelOffset(17105034);
        this.mDaySelectedCircleSize = resources.getDimensionPixelSize(17105035);
        this.mRowHeight = (resources.getDimensionPixelOffset(17105036) - this.mMonthHeaderSize) / 6;
        this.mTouchHelper = new MonthViewTouchHelper(this);
        this.setAccessibilityDelegate(this.mTouchHelper);
        this.setImportantForAccessibility(1);
        this.mLockAccessibilityDelegate = true;
        this.initView();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int calculateNumRows() {
        int n;
        int n2 = this.findDayOffset();
        int n3 = (n2 + this.mNumCells) / this.mNumDays;
        if ((n2 + this.mNumCells) % this.mNumDays > 0) {
            n = 1;
            return n + n3;
        }
        n = 0;
        return n + n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawDays(Canvas canvas) {
        int n = -1 + (this.mRowHeight + this.mMiniDayNumberTextSize) / 2 + this.mMonthHeaderSize;
        int n2 = (this.mWidth - 2 * this.mPadding) / (2 * this.mNumDays);
        int n3 = this.findDayOffset();
        int n4 = 1;
        while (n4 <= this.mNumCells) {
            int n5 = n2 * (1 + n3 * 2) + this.mPadding;
            if (this.mSelectedDay == n4) {
                canvas.drawCircle(n5, n - this.mMiniDayNumberTextSize / 3, this.mDaySelectedCircleSize, this.mDayNumberSelectedPaint);
            }
            if (this.mHasToday && this.mToday == n4) {
                this.mDayNumberPaint.setColor(this.mSelectedDayColor);
            } else {
                this.mDayNumberPaint.setColor(this.mNormalTextColor);
            }
            Paint paint = n4 < this.mEnabledDayStart || n4 > this.mEnabledDayEnd ? this.mDayNumberDisabledPaint : this.mDayNumberPaint;
            Object[] objectArray = new Object[]{n4};
            canvas.drawText(String.format("%d", objectArray), n5, n, paint);
            if (++n3 == this.mNumDays) {
                n3 = 0;
                n += this.mRowHeight;
            }
            ++n4;
        }
        return;
    }

    private void drawMonthTitle(Canvas canvas) {
        float f = (float)(this.mWidth + 2 * this.mPadding) / 2.0f;
        float f2 = (float)(this.mMonthHeaderSize - this.mMonthDayLabelTextSize) / 2.0f;
        canvas.drawText(this.getMonthAndYearString(), f, f2, this.mMonthTitlePaint);
    }

    private void drawWeekDayLabels(Canvas canvas) {
        int n = this.mMonthHeaderSize - this.mMonthDayLabelTextSize / 2;
        int n2 = (this.mWidth - 2 * this.mPadding) / (2 * this.mNumDays);
        for (int i = 0; i < this.mNumDays; ++i) {
            int n3 = (i + this.mWeekStart) % this.mNumDays;
            this.mDayLabelCalendar.set(7, n3);
            canvas.drawText(this.mDayFormatter.format(this.mDayLabelCalendar.getTime()), n2 * (1 + i * 2) + this.mPadding, n, this.mMonthDayLabelPaint);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int findDayOffset() {
        int n;
        if (this.mDayOfWeekStart < this.mWeekStart) {
            n = this.mDayOfWeekStart + this.mNumDays;
            return n - this.mWeekStart;
        }
        n = this.mDayOfWeekStart;
        return n - this.mWeekStart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getDayFromLocation(float f, float f2) {
        int n = this.mPadding;
        if (f < (float)n) return -1;
        if (f > (float)(this.mWidth - this.mPadding)) {
            return -1;
        }
        int n2 = (int)(f2 - (float)this.mMonthHeaderSize) / this.mRowHeight;
        int n3 = 1 + ((int)((f - (float)n) * (float)this.mNumDays / (float)(this.mWidth - n - this.mPadding)) - this.findDayOffset()) + n2 * this.mNumDays;
        if (n3 < 1) return -1;
        if (n3 <= this.mNumCells) return n3;
        return -1;
    }

    private static int getDaysInMonth(int n, int n2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Invalid Month");
            }
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: 
        }
        if (n2 % 4 == 0) {
            return 29;
        }
        return 28;
    }

    private String getMonthAndYearString() {
        this.mStringBuilder.setLength(0);
        long l = this.mCalendar.getTimeInMillis();
        return DateUtils.formatDateRange(this.getContext(), this.mFormatter, l, l, 52, Time.getCurrentTimezone()).toString();
    }

    private void initView() {
        this.mMonthTitlePaint = new Paint();
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setColor(this.mNormalTextColor);
        this.mMonthTitlePaint.setTextSize(this.mMonthLabelTextSize);
        this.mMonthTitlePaint.setTypeface(Typeface.create(this.mMonthTitleTypeface, 1));
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mMonthTitlePaint.setFakeBoldText(true);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setColor(this.mNormalTextColor);
        this.mMonthDayLabelPaint.setTextSize(this.mMonthDayLabelTextSize);
        this.mMonthDayLabelPaint.setTypeface(Typeface.create(this.mDayOfWeekTypeface, 0));
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setFakeBoldText(true);
        this.mDayNumberSelectedPaint = new Paint();
        this.mDayNumberSelectedPaint.setAntiAlias(true);
        this.mDayNumberSelectedPaint.setColor(this.mSelectedDayColor);
        this.mDayNumberSelectedPaint.setAlpha(60);
        this.mDayNumberSelectedPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberSelectedPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberSelectedPaint.setFakeBoldText(true);
        this.mDayNumberPaint = new Paint();
        this.mDayNumberPaint.setAntiAlias(true);
        this.mDayNumberPaint.setTextSize(this.mMiniDayNumberTextSize);
        this.mDayNumberPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberPaint.setFakeBoldText(false);
        this.mDayNumberDisabledPaint = new Paint();
        this.mDayNumberDisabledPaint.setAntiAlias(true);
        this.mDayNumberDisabledPaint.setColor(this.mDisabledTextColor);
        this.mDayNumberDisabledPaint.setTextSize(this.mMiniDayNumberTextSize);
        this.mDayNumberDisabledPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberDisabledPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberDisabledPaint.setFakeBoldText(false);
    }

    private static boolean isValidDayOfWeek(int n) {
        return n >= 1 && n <= 7;
    }

    private static boolean isValidMonth(int n) {
        return n >= 0 && n <= 11;
    }

    private void onDayClick(int n) {
        if (this.mOnDayClickListener != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.mYear, this.mMonth, n);
            this.mOnDayClickListener.onDayClick(this, calendar);
        }
        this.mTouchHelper.sendEventForVirtualView(n, 1);
    }

    private boolean sameDay(int n, Time time) {
        return this.mYear == time.year && this.mMonth == time.month && n == time.monthDay;
    }

    @Override
    public void clearAccessibilityFocus() {
        this.mTouchHelper.clearFocusedVirtualView();
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (this.mTouchHelper.dispatchHoverEvent(motionEvent)) {
            return true;
        }
        return super.dispatchHoverEvent(motionEvent);
    }

    Calendar getAccessibilityFocus() {
        int n = this.mTouchHelper.getFocusedVirtualView();
        Calendar calendar = null;
        if (n >= 0) {
            calendar = Calendar.getInstance();
            calendar.set(this.mYear, this.mMonth, n);
        }
        return calendar;
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mDayFormatter = new SimpleDateFormat("EEEEE", configuration.locale);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.drawMonthTitle(canvas);
        this.drawWeekDayLabels(canvas);
        this.drawDays(canvas);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(View.MeasureSpec.getSize(n), this.mRowHeight * this.mNumRows + this.mMonthHeaderSize);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.mWidth = n;
        this.mTouchHelper.invalidateRoot();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            default: {
                return true;
            }
            case 1: 
        }
        int n = this.getDayFromLocation(motionEvent.getX(), motionEvent.getY());
        if (n < 0) return true;
        this.onDayClick(n);
        return true;
    }

    boolean restoreAccessibilityFocus(Calendar calendar) {
        if (calendar.get(1) != this.mYear || calendar.get(2) != this.mMonth || calendar.get(5) > this.mNumCells) {
            return false;
        }
        this.mTouchHelper.setFocusedVirtualView(calendar.get(5));
        return true;
    }

    public void reuse() {
        this.mNumRows = 6;
        this.requestLayout();
    }

    @Override
    public void setAccessibilityDelegate(View.AccessibilityDelegate accessibilityDelegate) {
        if (!this.mLockAccessibilityDelegate) {
            super.setAccessibilityDelegate(accessibilityDelegate);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setMonthParams(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mRowHeight < 10) {
            this.mRowHeight = 10;
        }
        this.mSelectedDay = n;
        if (SimpleMonthView.isValidMonth(n2)) {
            this.mMonth = n2;
        }
        this.mYear = n3;
        Time time = new Time(Time.getCurrentTimezone());
        time.setToNow();
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(n4) ? n4 : this.mCalendar.getFirstDayOfWeek();
        if (n5 > 0 && n6 < 32) {
            this.mEnabledDayStart = n5;
        }
        if (n6 > 0 && n6 < 32 && n6 >= n5) {
            this.mEnabledDayEnd = n6;
        }
        this.mNumCells = SimpleMonthView.getDaysInMonth(this.mMonth, this.mYear);
        int n7 = 0;
        while (true) {
            if (n7 >= this.mNumCells) {
                this.mNumRows = this.calculateNumRows();
                this.mTouchHelper.invalidateRoot();
                return;
            }
            int n8 = n7 + 1;
            if (this.sameDay(n8, time)) {
                this.mHasToday = true;
                this.mToday = n8;
            }
            ++n7;
        }
    }

    public void setOnDayClickListener(OnDayClickListener onDayClickListener) {
        this.mOnDayClickListener = onDayClickListener;
    }

    void setTextColor(ColorStateList colorStateList) {
        Resources resources = this.getContext().getResources();
        this.mNormalTextColor = colorStateList.getColorForState(ENABLED_STATE_SET, resources.getColor(17170586));
        this.mMonthTitlePaint.setColor(this.mNormalTextColor);
        this.mMonthDayLabelPaint.setColor(this.mNormalTextColor);
        this.mDisabledTextColor = colorStateList.getColorForState(EMPTY_STATE_SET, resources.getColor(17170588));
        this.mDayNumberDisabledPaint.setColor(this.mDisabledTextColor);
        this.mSelectedDayColor = colorStateList.getColorForState(ENABLED_SELECTED_STATE_SET, resources.getColor(17170450));
        this.mDayNumberSelectedPaint.setColor(this.mSelectedDayColor);
        this.mDayNumberSelectedPaint.setAlpha(60);
    }

    private class MonthViewTouchHelper
    extends ExploreByTouchHelper {
        private static final String DATE_FORMAT = "dd MMMM yyyy";
        private final Calendar mTempCalendar;
        private final Rect mTempRect;

        public MonthViewTouchHelper(View view) {
            super(view);
            this.mTempRect = new Rect();
            this.mTempCalendar = Calendar.getInstance();
        }

        private void getItemBounds(int n, Rect rect) {
            int n2 = SimpleMonthView.this.mPadding;
            int n3 = SimpleMonthView.this.mMonthHeaderSize;
            int n4 = SimpleMonthView.this.mRowHeight;
            int n5 = (SimpleMonthView.this.mWidth - 2 * SimpleMonthView.this.mPadding) / SimpleMonthView.this.mNumDays;
            int n6 = n - 1 + SimpleMonthView.this.findDayOffset();
            int n7 = n6 / SimpleMonthView.this.mNumDays;
            int n8 = n2 + n5 * (n6 % SimpleMonthView.this.mNumDays);
            int n9 = n3 + n7 * n4;
            rect.set(n8, n9, n8 + n5, n9 + n4);
        }

        private CharSequence getItemDescription(int n) {
            this.mTempCalendar.set(SimpleMonthView.this.mYear, SimpleMonthView.this.mMonth, n);
            CharSequence charSequence = DateFormat.format((CharSequence)DATE_FORMAT, this.mTempCalendar.getTimeInMillis());
            if (n == SimpleMonthView.this.mSelectedDay) {
                charSequence = SimpleMonthView.this.getContext().getString(17041006, charSequence);
            }
            return charSequence;
        }

        public void clearFocusedVirtualView() {
            int n = this.getFocusedVirtualView();
            if (n != Integer.MIN_VALUE) {
                this.getAccessibilityNodeProvider(SimpleMonthView.this).performAction(n, 128, null);
            }
        }

        @Override
        protected int getVirtualViewAt(float f, float f2) {
            int n = SimpleMonthView.this.getDayFromLocation(f, f2);
            if (n >= 0) {
                return n;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        protected void getVisibleVirtualViews(List<Integer> list) {
            for (int i = 1; i <= SimpleMonthView.this.mNumCells; ++i) {
                list.add(i);
            }
        }

        @Override
        protected boolean onPerformActionForVirtualView(int n, int n2, Bundle bundle) {
            switch (n2) {
                default: {
                    return false;
                }
                case 16: 
            }
            SimpleMonthView.this.onDayClick(n);
            return true;
        }

        @Override
        protected void onPopulateEventForVirtualView(int n, AccessibilityEvent accessibilityEvent) {
            accessibilityEvent.setContentDescription(this.getItemDescription(n));
        }

        @Override
        protected void onPopulateNodeForVirtualView(int n, AccessibilityNodeInfo accessibilityNodeInfo) {
            this.getItemBounds(n, this.mTempRect);
            accessibilityNodeInfo.setContentDescription(this.getItemDescription(n));
            accessibilityNodeInfo.setBoundsInParent(this.mTempRect);
            accessibilityNodeInfo.addAction(16);
            if (n == SimpleMonthView.this.mSelectedDay) {
                accessibilityNodeInfo.setSelected(true);
            }
        }

        public void setFocusedVirtualView(int n) {
            this.getAccessibilityNodeProvider(SimpleMonthView.this).performAction(n, 64, null);
        }
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, Calendar var2);
    }
}

