/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Pools;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

@RemoteViews.RemoteView
public class RelativeLayout
extends ViewGroup {
    public static final int ABOVE = 2;
    public static final int ALIGN_BASELINE = 4;
    public static final int ALIGN_BOTTOM = 8;
    public static final int ALIGN_END = 19;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_PARENT_BOTTOM = 12;
    public static final int ALIGN_PARENT_END = 21;
    public static final int ALIGN_PARENT_LEFT = 9;
    public static final int ALIGN_PARENT_RIGHT = 11;
    public static final int ALIGN_PARENT_START = 20;
    public static final int ALIGN_PARENT_TOP = 10;
    public static final int ALIGN_RIGHT = 7;
    public static final int ALIGN_START = 18;
    public static final int ALIGN_TOP = 6;
    public static final int BELOW = 3;
    public static final int CENTER_HORIZONTAL = 14;
    public static final int CENTER_IN_PARENT = 13;
    public static final int CENTER_VERTICAL = 15;
    private static final int DEFAULT_WIDTH = 65536;
    public static final int END_OF = 17;
    public static final int LEFT_OF = 0;
    public static final int RIGHT_OF = 1;
    private static final int[] RULES_HORIZONTAL;
    private static final int[] RULES_VERTICAL;
    public static final int START_OF = 16;
    public static final int TRUE = -1;
    private static final int VALUE_NOT_SET = Integer.MIN_VALUE;
    private static final int VERB_COUNT = 22;
    private boolean mAllowBrokenMeasureSpecs = false;
    private View mBaselineView = null;
    private final Rect mContentBounds = new Rect();
    private boolean mDirtyHierarchy;
    private final DependencyGraph mGraph;
    private int mGravity = 0x800033;
    private boolean mHasBaselineAlignedChild;
    private int mIgnoreGravity;
    private boolean mMeasureVerticalWithPaddingMargin = false;
    private final Rect mSelfBounds = new Rect();
    private View[] mSortedHorizontalChildren;
    private View[] mSortedVerticalChildren;
    private SortedSet<View> mTopToBottomLeftToRightSet = null;

    static {
        RULES_VERTICAL = new int[]{2, 3, 4, 6, 8};
        RULES_HORIZONTAL = new int[]{0, 1, 5, 7, 16, 17, 18, 19};
    }

    public RelativeLayout(Context context) {
        this(context, null);
    }

    public RelativeLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public RelativeLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public RelativeLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mGraph = new DependencyGraph();
        this.initFromAttributes(context, attributeSet, n, n2);
        this.queryCompatibilityModes(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void alignBaseline(View view, LayoutParams layoutParams) {
        LayoutParams layoutParams2;
        int[] nArray = layoutParams.getRules(this.getLayoutDirection());
        int n = this.getRelatedViewBaseline(nArray, 4);
        if (n != -1 && (layoutParams2 = this.getRelatedViewParams(nArray, 4)) != null) {
            int n2 = n + layoutParams2.mTop;
            int n3 = view.getBaseline();
            if (n3 != -1) {
                n2 -= n3;
            }
            int n4 = layoutParams.mBottom - layoutParams.mTop;
            LayoutParams.access$402(layoutParams, n2);
            LayoutParams.access$302(layoutParams, n4 + layoutParams.mTop);
        }
        if (this.mBaselineView == null) {
            this.mBaselineView = view;
            return;
        } else {
            LayoutParams layoutParams3 = (LayoutParams)this.mBaselineView.getLayoutParams();
            if (layoutParams.mTop >= layoutParams3.mTop && (layoutParams.mTop != layoutParams3.mTop || layoutParams.mLeft >= layoutParams3.mLeft)) return;
            this.mBaselineView = view;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyHorizontalSizeRules(LayoutParams layoutParams, int n, int[] nArray) {
        LayoutParams layoutParams2;
        LayoutParams layoutParams3;
        LayoutParams layoutParams4;
        LayoutParams.access$102(layoutParams, Integer.MIN_VALUE);
        LayoutParams.access$202(layoutParams, Integer.MIN_VALUE);
        LayoutParams layoutParams5 = this.getRelatedViewParams(nArray, 0);
        if (layoutParams5 != null) {
            LayoutParams.access$202(layoutParams, layoutParams5.mLeft - (layoutParams5.leftMargin + layoutParams.rightMargin));
        } else if (layoutParams.alignWithParent && nArray[0] != 0 && n >= 0) {
            LayoutParams.access$202(layoutParams, n - this.mPaddingRight - layoutParams.rightMargin);
        }
        if ((layoutParams4 = this.getRelatedViewParams(nArray, 1)) != null) {
            LayoutParams.access$102(layoutParams, layoutParams4.mRight + (layoutParams4.rightMargin + layoutParams.leftMargin));
        } else if (layoutParams.alignWithParent && nArray[1] != 0) {
            LayoutParams.access$102(layoutParams, this.mPaddingLeft + layoutParams.leftMargin);
        }
        if ((layoutParams3 = this.getRelatedViewParams(nArray, 5)) != null) {
            LayoutParams.access$102(layoutParams, layoutParams3.mLeft + layoutParams.leftMargin);
        } else if (layoutParams.alignWithParent && nArray[5] != 0) {
            LayoutParams.access$102(layoutParams, this.mPaddingLeft + layoutParams.leftMargin);
        }
        if ((layoutParams2 = this.getRelatedViewParams(nArray, 7)) != null) {
            LayoutParams.access$202(layoutParams, layoutParams2.mRight - layoutParams.rightMargin);
        } else if (layoutParams.alignWithParent && nArray[7] != 0 && n >= 0) {
            LayoutParams.access$202(layoutParams, n - this.mPaddingRight - layoutParams.rightMargin);
        }
        if (nArray[9] != 0) {
            LayoutParams.access$102(layoutParams, this.mPaddingLeft + layoutParams.leftMargin);
        }
        if (nArray[11] != 0 && n >= 0) {
            LayoutParams.access$202(layoutParams, n - this.mPaddingRight - layoutParams.rightMargin);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyVerticalSizeRules(LayoutParams layoutParams, int n) {
        LayoutParams layoutParams2;
        LayoutParams layoutParams3;
        LayoutParams layoutParams4;
        int[] nArray = layoutParams.getRules();
        LayoutParams.access$402(layoutParams, Integer.MIN_VALUE);
        LayoutParams.access$302(layoutParams, Integer.MIN_VALUE);
        LayoutParams layoutParams5 = this.getRelatedViewParams(nArray, 2);
        if (layoutParams5 != null) {
            LayoutParams.access$302(layoutParams, layoutParams5.mTop - (layoutParams5.topMargin + layoutParams.bottomMargin));
        } else if (layoutParams.alignWithParent && nArray[2] != 0 && n >= 0) {
            LayoutParams.access$302(layoutParams, n - this.mPaddingBottom - layoutParams.bottomMargin);
        }
        if ((layoutParams4 = this.getRelatedViewParams(nArray, 3)) != null) {
            LayoutParams.access$402(layoutParams, layoutParams4.mBottom + (layoutParams4.bottomMargin + layoutParams.topMargin));
        } else if (layoutParams.alignWithParent && nArray[3] != 0) {
            LayoutParams.access$402(layoutParams, this.mPaddingTop + layoutParams.topMargin);
        }
        if ((layoutParams3 = this.getRelatedViewParams(nArray, 6)) != null) {
            LayoutParams.access$402(layoutParams, layoutParams3.mTop + layoutParams.topMargin);
        } else if (layoutParams.alignWithParent && nArray[6] != 0) {
            LayoutParams.access$402(layoutParams, this.mPaddingTop + layoutParams.topMargin);
        }
        if ((layoutParams2 = this.getRelatedViewParams(nArray, 8)) != null) {
            LayoutParams.access$302(layoutParams, layoutParams2.mBottom - layoutParams.bottomMargin);
        } else if (layoutParams.alignWithParent && nArray[8] != 0 && n >= 0) {
            LayoutParams.access$302(layoutParams, n - this.mPaddingBottom - layoutParams.bottomMargin);
        }
        if (nArray[10] != 0) {
            LayoutParams.access$402(layoutParams, this.mPaddingTop + layoutParams.topMargin);
        }
        if (nArray[12] != 0 && n >= 0) {
            LayoutParams.access$302(layoutParams, n - this.mPaddingBottom - layoutParams.bottomMargin);
        }
        if (nArray[4] != 0) {
            this.mHasBaselineAlignedChild = true;
        }
    }

    private static void centerHorizontal(View view, LayoutParams layoutParams, int n) {
        int n2 = view.getMeasuredWidth();
        int n3 = (n - n2) / 2;
        LayoutParams.access$102(layoutParams, n3);
        LayoutParams.access$202(layoutParams, n3 + n2);
    }

    private static void centerVertical(View view, LayoutParams layoutParams, int n) {
        int n2 = view.getMeasuredHeight();
        int n3 = (n - n2) / 2;
        LayoutParams.access$402(layoutParams, n3);
        LayoutParams.access$302(layoutParams, n3 + n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getChildMeasureSpec(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        if (n8 < 0 && !this.mAllowBrokenMeasureSpecs) {
            int n11;
            int n12;
            if (n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                n12 = Math.max(0, n2 - n);
                n11 = 0x40000000;
                return View.MeasureSpec.makeMeasureSpec(n12, n11);
            }
            if (n3 >= 0) {
                n12 = n3;
                n11 = 0x40000000;
                return View.MeasureSpec.makeMeasureSpec(n12, n11);
            }
            n11 = 0;
            n12 = 0;
            return View.MeasureSpec.makeMeasureSpec(n12, n11);
        }
        int n13 = n;
        int n14 = n2;
        if (n13 == Integer.MIN_VALUE) {
            n13 = n6 + n4;
        }
        if (n14 == Integer.MIN_VALUE) {
            n14 = n8 - n7 - n5;
        }
        int n15 = n14 - n13;
        if (n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
            n10 = 0x40000000;
            n9 = n15;
            return View.MeasureSpec.makeMeasureSpec(n9, n10);
        }
        if (n3 >= 0) {
            n10 = 0x40000000;
            if (n15 >= 0) {
                n9 = Math.min(n15, n3);
                return View.MeasureSpec.makeMeasureSpec(n9, n10);
            }
            n9 = n3;
            return View.MeasureSpec.makeMeasureSpec(n9, n10);
        }
        if (n3 == -1) {
            n10 = 0x40000000;
            n9 = n15;
            return View.MeasureSpec.makeMeasureSpec(n9, n10);
        }
        n10 = 0;
        n9 = 0;
        if (n3 != -2) return View.MeasureSpec.makeMeasureSpec(n9, n10);
        if (n15 >= 0) {
            n10 = Integer.MIN_VALUE;
            n9 = n15;
            return View.MeasureSpec.makeMeasureSpec(n9, n10);
        }
        n10 = 0;
        n9 = 0;
        return View.MeasureSpec.makeMeasureSpec(n9, n10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View getRelatedView(int[] nArray, int n) {
        int n2 = nArray[n];
        if (n2 == 0) return null;
        DependencyGraph.Node node = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(n2);
        if (node == null) {
            return null;
        }
        View view = node.view;
        while (view.getVisibility() == 8) {
            int[] nArray2 = ((LayoutParams)view.getLayoutParams()).getRules(view.getLayoutDirection());
            DependencyGraph.Node node2 = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(nArray2[n]);
            if (node2 == null) {
                return null;
            }
            view = node2.view;
        }
        return view;
    }

    private int getRelatedViewBaseline(int[] nArray, int n) {
        View view = this.getRelatedView(nArray, n);
        if (view != null) {
            return view.getBaseline();
        }
        return -1;
    }

    private LayoutParams getRelatedViewParams(int[] nArray, int n) {
        View view = this.getRelatedView(nArray, n);
        if (view != null && view.getLayoutParams() instanceof LayoutParams) {
            return (LayoutParams)view.getLayoutParams();
        }
        return null;
    }

    private void initFromAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.RelativeLayout, n, n2);
        this.mIgnoreGravity = typedArray.getResourceId(1, -1);
        this.mGravity = typedArray.getInt(0, this.mGravity);
        typedArray.recycle();
    }

    private void measureChild(View view, LayoutParams layoutParams, int n, int n2) {
        view.measure(this.getChildMeasureSpec(layoutParams.mLeft, layoutParams.mRight, layoutParams.width, layoutParams.leftMargin, layoutParams.rightMargin, this.mPaddingLeft, this.mPaddingRight, n), this.getChildMeasureSpec(layoutParams.mTop, layoutParams.mBottom, layoutParams.height, layoutParams.topMargin, layoutParams.bottomMargin, this.mPaddingTop, this.mPaddingBottom, n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureChildHorizontal(View view, LayoutParams layoutParams, int n, int n2) {
        int n3 = this.getChildMeasureSpec(layoutParams.mLeft, layoutParams.mRight, layoutParams.width, layoutParams.leftMargin, layoutParams.rightMargin, this.mPaddingLeft, this.mPaddingRight, n);
        int n4 = n2;
        if (this.mMeasureVerticalWithPaddingMargin) {
            n4 = Math.max(0, n2 - this.mPaddingTop - this.mPaddingBottom - layoutParams.topMargin - layoutParams.bottomMargin);
        }
        int n5 = n2 < 0 && !this.mAllowBrokenMeasureSpecs ? (layoutParams.height >= 0 ? View.MeasureSpec.makeMeasureSpec(layoutParams.height, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0)) : (layoutParams.width == -1 ? View.MeasureSpec.makeMeasureSpec(n4, 0x40000000) : View.MeasureSpec.makeMeasureSpec(n4, Integer.MIN_VALUE));
        view.measure(n3, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean positionChildHorizontal(View view, LayoutParams layoutParams, int n, boolean bl) {
        int[] nArray = layoutParams.getRules(this.getLayoutDirection());
        if (layoutParams.mLeft == Integer.MIN_VALUE && layoutParams.mRight != Integer.MIN_VALUE) {
            LayoutParams.access$102(layoutParams, layoutParams.mRight - view.getMeasuredWidth());
            return nArray[21] != 0;
        } else if (layoutParams.mLeft != Integer.MIN_VALUE && layoutParams.mRight == Integer.MIN_VALUE) {
            LayoutParams.access$202(layoutParams, layoutParams.mLeft + view.getMeasuredWidth());
            return nArray[21] != 0;
        } else {
            if (layoutParams.mLeft != Integer.MIN_VALUE || layoutParams.mRight != Integer.MIN_VALUE) return nArray[21] != 0;
            if (nArray[13] != 0 || nArray[14] != 0) {
                if (!bl) {
                    RelativeLayout.centerHorizontal(view, layoutParams, n);
                    return true;
                }
                LayoutParams.access$102(layoutParams, this.mPaddingLeft + layoutParams.leftMargin);
                LayoutParams.access$202(layoutParams, layoutParams.mLeft + view.getMeasuredWidth());
                return true;
            }
            if (this.isLayoutRtl()) {
                LayoutParams.access$202(layoutParams, n - this.mPaddingRight - layoutParams.rightMargin);
                LayoutParams.access$102(layoutParams, layoutParams.mRight - view.getMeasuredWidth());
                return nArray[21] != 0;
            } else {
                LayoutParams.access$102(layoutParams, this.mPaddingLeft + layoutParams.leftMargin);
                LayoutParams.access$202(layoutParams, layoutParams.mLeft + view.getMeasuredWidth());
            }
        }
        return nArray[21] != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean positionChildVertical(View view, LayoutParams layoutParams, int n, boolean bl) {
        int[] nArray = layoutParams.getRules();
        if (layoutParams.mTop == Integer.MIN_VALUE && layoutParams.mBottom != Integer.MIN_VALUE) {
            LayoutParams.access$402(layoutParams, layoutParams.mBottom - view.getMeasuredHeight());
            return nArray[12] != 0;
        } else if (layoutParams.mTop != Integer.MIN_VALUE && layoutParams.mBottom == Integer.MIN_VALUE) {
            LayoutParams.access$302(layoutParams, layoutParams.mTop + view.getMeasuredHeight());
            return nArray[12] != 0;
        } else {
            if (layoutParams.mTop != Integer.MIN_VALUE || layoutParams.mBottom != Integer.MIN_VALUE) return nArray[12] != 0;
            if (nArray[13] != 0 || nArray[15] != 0) {
                if (!bl) {
                    RelativeLayout.centerVertical(view, layoutParams, n);
                    return true;
                }
                LayoutParams.access$402(layoutParams, this.mPaddingTop + layoutParams.topMargin);
                LayoutParams.access$302(layoutParams, layoutParams.mTop + view.getMeasuredHeight());
                return true;
            }
            LayoutParams.access$402(layoutParams, this.mPaddingTop + layoutParams.topMargin);
            LayoutParams.access$302(layoutParams, layoutParams.mTop + view.getMeasuredHeight());
        }
        return nArray[12] != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void queryCompatibilityModes(Context context) {
        boolean bl = true;
        int n = context.getApplicationInfo().targetSdkVersion;
        boolean bl2 = n <= 17 ? bl : false;
        this.mAllowBrokenMeasureSpecs = bl2;
        if (n < 18) {
            bl = false;
        }
        this.mMeasureVerticalWithPaddingMargin = bl;
    }

    private void sortChildren() {
        int n = this.getChildCount();
        if (this.mSortedVerticalChildren == null || this.mSortedVerticalChildren.length != n) {
            this.mSortedVerticalChildren = new View[n];
        }
        if (this.mSortedHorizontalChildren == null || this.mSortedHorizontalChildren.length != n) {
            this.mSortedHorizontalChildren = new View[n];
        }
        DependencyGraph dependencyGraph = this.mGraph;
        dependencyGraph.clear();
        for (int i = 0; i < n; ++i) {
            dependencyGraph.add(this.getChildAt(i));
        }
        dependencyGraph.getSortedViews(this.mSortedVerticalChildren, RULES_VERTICAL);
        dependencyGraph.getSortedViews(this.mSortedHorizontalChildren, RULES_HORIZONTAL);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (this.mTopToBottomLeftToRightSet == null) {
            this.mTopToBottomLeftToRightSet = new TreeSet<View>(new TopToBottomLeftToRightComparator());
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.mTopToBottomLeftToRightSet.add(this.getChildAt(i));
        }
        for (View view : this.mTopToBottomLeftToRightSet) {
            if (view.getVisibility() != 0 || !view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) continue;
            this.mTopToBottomLeftToRightSet.clear();
            return true;
        }
        this.mTopToBottomLeftToRightSet.clear();
        return false;
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    public int getBaseline() {
        if (this.mBaselineView != null) {
            return this.mBaselineView.getBaseline();
        }
        return super.getBaseline();
    }

    public int getGravity() {
        return this.mGravity;
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(RelativeLayout.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(RelativeLayout.class.getName());
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        for (int i = 0; i < n5; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            view.layout(layoutParams.mLeft, layoutParams.mTop, layoutParams.mRight, layoutParams.mBottom);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        View view;
        boolean bl;
        boolean bl2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl3;
        boolean bl4;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        block46: {
            block45: {
                if (this.mDirtyHierarchy) {
                    this.mDirtyHierarchy = false;
                    this.sortChildren();
                }
                n12 = -1;
                n11 = -1;
                n10 = View.MeasureSpec.getMode(n);
                n9 = View.MeasureSpec.getMode(n2);
                int n13 = View.MeasureSpec.getSize(n);
                int n14 = View.MeasureSpec.getSize(n2);
                if (n10 != 0) {
                    n12 = n13;
                }
                if (n9 != 0) {
                    n11 = n14;
                }
                n8 = 0;
                if (n10 == 0x40000000) {
                    n8 = n12;
                }
                n7 = 0;
                if (n9 == 0x40000000) {
                    n7 = n11;
                }
                this.mHasBaselineAlignedChild = false;
                int n15 = 0x800007 & this.mGravity;
                bl4 = n15 != 0x800003 && n15 != 0;
                int n16 = 0x70 & this.mGravity;
                bl3 = n16 != 48 && n16 != 0;
                n6 = Integer.MAX_VALUE;
                n5 = Integer.MAX_VALUE;
                n4 = Integer.MIN_VALUE;
                n3 = Integer.MIN_VALUE;
                bl2 = false;
                bl = false;
                if (bl4) break block45;
                view = null;
                if (!bl3) break block46;
            }
            int n17 = this.mIgnoreGravity;
            view = null;
            if (n17 != -1) {
                view = this.findViewById(this.mIgnoreGravity);
            }
        }
        boolean bl5 = n10 != 0x40000000;
        boolean bl6 = n9 != 0x40000000;
        int n18 = this.getLayoutDirection();
        if (this.isLayoutRtl() && n12 == -1) {
            n12 = 65536;
        }
        for (View view2 : this.mSortedHorizontalChildren) {
            if (view2.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view2.getLayoutParams();
            int[] nArray = layoutParams.getRules(n18);
            this.applyHorizontalSizeRules(layoutParams, n12, nArray);
            this.measureChildHorizontal(view2, layoutParams, n12, n11);
            if (!this.positionChildHorizontal(view2, layoutParams, n12, bl5)) continue;
            bl2 = true;
        }
        View[] viewArray = this.mSortedVerticalChildren;
        int n19 = viewArray.length;
        int n20 = this.getContext().getApplicationInfo().targetSdkVersion;
        for (int i = 0; i < n19; ++i) {
            View view3 = viewArray[i];
            if (view3.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view3.getLayoutParams();
            this.applyVerticalSizeRules(layoutParams, n11);
            this.measureChild(view3, layoutParams, n12, n11);
            if (this.positionChildVertical(view3, layoutParams, n11, bl6)) {
                bl = true;
            }
            if (bl5) {
                if (this.isLayoutRtl()) {
                    if (n20 < 19) {
                        int n21 = n12 - layoutParams.mLeft;
                        n8 = Math.max(n8, n21);
                    } else {
                        int n22 = n12 - layoutParams.mLeft - layoutParams.leftMargin;
                        n8 = Math.max(n8, n22);
                    }
                } else if (n20 < 19) {
                    int n23 = layoutParams.mRight;
                    n8 = Math.max(n8, n23);
                } else {
                    int n24 = layoutParams.mRight + layoutParams.rightMargin;
                    n8 = Math.max(n8, n24);
                }
            }
            if (bl6) {
                if (n20 < 19) {
                    int n25 = layoutParams.mBottom;
                    n7 = Math.max(n7, n25);
                } else {
                    int n26 = layoutParams.mBottom + layoutParams.bottomMargin;
                    n7 = Math.max(n7, n26);
                }
            }
            if (view3 != view || bl3) {
                int n27 = layoutParams.mLeft - layoutParams.leftMargin;
                n6 = Math.min(n6, n27);
                int n28 = layoutParams.mTop - layoutParams.topMargin;
                n5 = Math.min(n5, n28);
            }
            if (view3 == view && !bl4) continue;
            int n29 = layoutParams.mRight + layoutParams.rightMargin;
            n4 = Math.max(n4, n29);
            n3 = Math.max(n3, layoutParams.mBottom + layoutParams.bottomMargin);
        }
        if (this.mHasBaselineAlignedChild) {
            for (int i = 0; i < n19; ++i) {
                View view4 = this.getChildAt(i);
                if (view4.getVisibility() == 8) continue;
                LayoutParams layoutParams = (LayoutParams)view4.getLayoutParams();
                this.alignBaseline(view4, layoutParams);
                if (view4 != view || bl3) {
                    int n30 = layoutParams.mLeft - layoutParams.leftMargin;
                    n6 = Math.min(n6, n30);
                    int n31 = layoutParams.mTop - layoutParams.topMargin;
                    n5 = Math.min(n5, n31);
                }
                if (view4 == view && !bl4) continue;
                int n32 = layoutParams.mRight + layoutParams.rightMargin;
                n4 = Math.max(n4, n32);
                n3 = Math.max(n3, layoutParams.mBottom + layoutParams.bottomMargin);
            }
        }
        if (bl5) {
            int n33 = n8 + this.mPaddingRight;
            if (this.mLayoutParams != null && this.mLayoutParams.width >= 0) {
                int n34 = this.mLayoutParams.width;
                n33 = Math.max(n33, n34);
            }
            int n35 = this.getSuggestedMinimumWidth();
            n8 = RelativeLayout.resolveSize(Math.max(n33, n35), n);
            if (bl2) {
                for (int i = 0; i < n19; ++i) {
                    View view5 = this.getChildAt(i);
                    if (view5.getVisibility() == 8) continue;
                    LayoutParams layoutParams = (LayoutParams)view5.getLayoutParams();
                    int[] nArray = layoutParams.getRules(n18);
                    if (nArray[13] != 0 || nArray[14] != 0) {
                        RelativeLayout.centerHorizontal(view5, layoutParams, n8);
                        continue;
                    }
                    if (nArray[11] == 0) continue;
                    int n36 = view5.getMeasuredWidth();
                    LayoutParams.access$102(layoutParams, n8 - this.mPaddingRight - n36);
                    LayoutParams.access$202(layoutParams, n36 + layoutParams.mLeft);
                }
            }
        }
        if (bl6) {
            int n37 = n7 + this.mPaddingBottom;
            if (this.mLayoutParams != null && this.mLayoutParams.height >= 0) {
                int n38 = this.mLayoutParams.height;
                n37 = Math.max(n37, n38);
            }
            int n39 = this.getSuggestedMinimumHeight();
            n7 = RelativeLayout.resolveSize(Math.max(n37, n39), n2);
            if (bl) {
                for (int i = 0; i < n19; ++i) {
                    View view6 = this.getChildAt(i);
                    if (view6.getVisibility() == 8) continue;
                    LayoutParams layoutParams = (LayoutParams)view6.getLayoutParams();
                    int[] nArray = layoutParams.getRules(n18);
                    if (nArray[13] != 0 || nArray[15] != 0) {
                        RelativeLayout.centerVertical(view6, layoutParams, n7);
                        continue;
                    }
                    if (nArray[12] == 0) continue;
                    int n40 = view6.getMeasuredHeight();
                    LayoutParams.access$402(layoutParams, n7 - this.mPaddingBottom - n40);
                    LayoutParams.access$302(layoutParams, n40 + layoutParams.mTop);
                }
            }
        }
        if (bl4 || bl3) {
            Rect rect = this.mSelfBounds;
            rect.set(this.mPaddingLeft, this.mPaddingTop, n8 - this.mPaddingRight, n7 - this.mPaddingBottom);
            Rect rect2 = this.mContentBounds;
            Gravity.apply(this.mGravity, n4 - n6, n3 - n5, rect, rect2, n18);
            int n41 = rect2.left - n6;
            int n42 = rect2.top - n5;
            if (n41 != 0 || n42 != 0) {
                for (int i = 0; i < n19; ++i) {
                    View view7 = this.getChildAt(i);
                    if (view7.getVisibility() == 8 || view7 == view) continue;
                    LayoutParams layoutParams = (LayoutParams)view7.getLayoutParams();
                    if (bl4) {
                        LayoutParams.access$112(layoutParams, n41);
                        LayoutParams.access$212(layoutParams, n41);
                    }
                    if (!bl3) continue;
                    LayoutParams.access$412(layoutParams, n42);
                    LayoutParams.access$312(layoutParams, n42);
                }
            }
        }
        if (this.isLayoutRtl()) {
            int n43 = n12 - n8;
            for (int i = 0; i < n19; ++i) {
                View view8 = this.getChildAt(i);
                if (view8.getVisibility() == 8) continue;
                LayoutParams layoutParams = (LayoutParams)view8.getLayoutParams();
                LayoutParams.access$120(layoutParams, n43);
                LayoutParams.access$220(layoutParams, n43);
            }
        }
        this.setMeasuredDimension(n8, n7);
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
        this.mDirtyHierarchy = true;
    }

    @RemotableViewMethod
    public void setGravity(int n) {
        if (this.mGravity != n) {
            if ((0x800007 & n) == 0) {
                n |= 0x800003;
            }
            if ((n & 0x70) == 0) {
                n |= 0x30;
            }
            this.mGravity = n;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int n) {
        int n2 = n & 0x800007;
        if ((0x800007 & this.mGravity) != n2) {
            this.mGravity = n2 | 0xFF7FFFF8 & this.mGravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setIgnoreGravity(int n) {
        this.mIgnoreGravity = n;
    }

    @RemotableViewMethod
    public void setVerticalGravity(int n) {
        int n2 = n & 0x70;
        if ((0x70 & this.mGravity) != n2) {
            this.mGravity = n2 | 0xFFFFFF8F & this.mGravity;
            this.requestLayout();
        }
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    private static class DependencyGraph {
        private SparseArray<Node> mKeyNodes;
        private ArrayList<Node> mNodes = new ArrayList();
        private ArrayDeque<Node> mRoots;

        private DependencyGraph() {
            this.mKeyNodes = new SparseArray();
            this.mRoots = new ArrayDeque();
        }

        /*
         * Enabled aggressive block sorting
         */
        private ArrayDeque<Node> findRoots(int[] nArray) {
            SparseArray<Node> sparseArray = this.mKeyNodes;
            ArrayList<Node> arrayList = this.mNodes;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Node node = arrayList.get(i);
                node.dependents.clear();
                node.dependencies.clear();
            }
            int n2 = 0;
            while (true) {
                int n3;
                int[] nArray2;
                Node node;
                if (n2 < n) {
                    node = arrayList.get(n2);
                    nArray2 = ((LayoutParams)node.view.getLayoutParams()).mRules;
                    n3 = nArray.length;
                } else {
                    ArrayDeque<Node> arrayDeque = this.mRoots;
                    arrayDeque.clear();
                    int n4 = 0;
                    while (true) {
                        if (n4 >= n) {
                            return arrayDeque;
                        }
                        Node node2 = arrayList.get(n4);
                        if (node2.dependencies.size() == 0) {
                            arrayDeque.addLast(node2);
                        }
                        ++n4;
                    }
                }
                for (int i = 0; i < n3; ++i) {
                    Node node3;
                    int n5 = nArray2[nArray[i]];
                    if (n5 <= 0 || (node3 = sparseArray.get(n5)) == null || node3 == node) continue;
                    node3.dependents.put(node, this);
                    node.dependencies.put(n5, node3);
                }
                ++n2;
            }
        }

        void add(View view) {
            int n = view.getId();
            Node node = Node.acquire(view);
            if (n != -1) {
                this.mKeyNodes.put(n, node);
            }
            this.mNodes.add(node);
        }

        void clear() {
            ArrayList<Node> arrayList = this.mNodes;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).release();
            }
            arrayList.clear();
            this.mKeyNodes.clear();
            this.mRoots.clear();
        }

        void getSortedViews(View[] viewArray, int ... nArray) {
            Node node;
            ArrayDeque<Node> arrayDeque = this.findRoots(nArray);
            int n = 0;
            while ((node = arrayDeque.pollLast()) != null) {
                View view = node.view;
                int n2 = view.getId();
                int n3 = n + 1;
                viewArray[n] = view;
                ArrayMap<Node, DependencyGraph> arrayMap = node.dependents;
                int n4 = arrayMap.size();
                for (int i = 0; i < n4; ++i) {
                    Node node2 = arrayMap.keyAt(i);
                    SparseArray<Node> sparseArray = node2.dependencies;
                    sparseArray.remove(n2);
                    if (sparseArray.size() != 0) continue;
                    arrayDeque.add(node2);
                }
                n = n3;
            }
            if (n < viewArray.length) {
                throw new IllegalStateException("Circular dependencies cannot exist in RelativeLayout");
            }
        }

        static class Node {
            private static final int POOL_LIMIT = 100;
            private static final Pools.SynchronizedPool<Node> sPool = new Pools.SynchronizedPool(100);
            final SparseArray<Node> dependencies;
            final ArrayMap<Node, DependencyGraph> dependents = new ArrayMap();
            View view;

            Node() {
                this.dependencies = new SparseArray();
            }

            static Node acquire(View view) {
                Node node = sPool.acquire();
                if (node == null) {
                    node = new Node();
                }
                node.view = view;
                return node;
            }

            void release() {
                this.view = null;
                this.dependents.clear();
                this.dependencies.clear();
                sPool.release(this);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public boolean alignWithParent;
        private int mBottom;
        private int[] mInitialRules;
        private boolean mIsRtlCompatibilityMode = false;
        private int mLeft;
        private int mRight;
        @ViewDebug.ExportedProperty(category="layout", indexMapping={@ViewDebug.IntToString(from=2, to="above"), @ViewDebug.IntToString(from=4, to="alignBaseline"), @ViewDebug.IntToString(from=8, to="alignBottom"), @ViewDebug.IntToString(from=5, to="alignLeft"), @ViewDebug.IntToString(from=12, to="alignParentBottom"), @ViewDebug.IntToString(from=9, to="alignParentLeft"), @ViewDebug.IntToString(from=11, to="alignParentRight"), @ViewDebug.IntToString(from=10, to="alignParentTop"), @ViewDebug.IntToString(from=7, to="alignRight"), @ViewDebug.IntToString(from=6, to="alignTop"), @ViewDebug.IntToString(from=3, to="below"), @ViewDebug.IntToString(from=14, to="centerHorizontal"), @ViewDebug.IntToString(from=13, to="center"), @ViewDebug.IntToString(from=15, to="centerVertical"), @ViewDebug.IntToString(from=0, to="leftOf"), @ViewDebug.IntToString(from=1, to="rightOf"), @ViewDebug.IntToString(from=18, to="alignStart"), @ViewDebug.IntToString(from=19, to="alignEnd"), @ViewDebug.IntToString(from=20, to="alignParentStart"), @ViewDebug.IntToString(from=21, to="alignParentEnd"), @ViewDebug.IntToString(from=16, to="startOf"), @ViewDebug.IntToString(from=17, to="endOf")}, mapping={@ViewDebug.IntToString(from=-1, to="true"), @ViewDebug.IntToString(from=0, to="false/NO_ID")}, resolveId=true)
        private int[] mRules = new int[22];
        private boolean mRulesChanged = false;
        private int mTop;

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.mInitialRules = new int[22];
        }

        /*
         * Enabled aggressive block sorting
         */
        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.mInitialRules = new int[22];
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.RelativeLayout_Layout);
            boolean bl = context.getApplicationInfo().targetSdkVersion < 17 || !context.getApplicationInfo().hasRtlSupport();
            this.mIsRtlCompatibilityMode = bl;
            int[] nArray = this.mRules;
            int[] nArray2 = this.mInitialRules;
            int n = typedArray.getIndexCount();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.mRulesChanged = true;
                    System.arraycopy((int[])nArray, (int)0, (int[])nArray2, (int)0, (int)22);
                    typedArray.recycle();
                    return;
                }
                int n3 = typedArray.getIndex(n2);
                switch (n3) {
                    case 16: {
                        this.alignWithParent = typedArray.getBoolean(n3, false);
                        break;
                    }
                    case 0: {
                        nArray[0] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 1: {
                        nArray[1] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 2: {
                        nArray[2] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 3: {
                        nArray[3] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 4: {
                        nArray[4] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 5: {
                        nArray[5] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 6: {
                        nArray[6] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 7: {
                        nArray[7] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 8: {
                        nArray[8] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 9: {
                        int n4 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[9] = n4;
                        break;
                    }
                    case 10: {
                        int n5 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[10] = n5;
                        break;
                    }
                    case 11: {
                        int n6 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[11] = n6;
                        break;
                    }
                    case 12: {
                        int n7 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[12] = n7;
                        break;
                    }
                    case 13: {
                        int n8 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[13] = n8;
                        break;
                    }
                    case 14: {
                        int n9 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[14] = n9;
                        break;
                    }
                    case 15: {
                        int n10 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[15] = n10;
                        break;
                    }
                    case 17: {
                        nArray[16] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 18: {
                        nArray[17] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 19: {
                        nArray[18] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 20: {
                        nArray[19] = typedArray.getResourceId(n3, 0);
                        break;
                    }
                    case 21: {
                        int n11 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[20] = n11;
                        break;
                    }
                    case 22: {
                        int n12 = typedArray.getBoolean(n3, false) ? -1 : 0;
                        nArray[21] = n12;
                        break;
                    }
                }
                ++n2;
            }
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.mInitialRules = new int[22];
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.mInitialRules = new int[22];
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.mInitialRules = new int[22];
            this.mIsRtlCompatibilityMode = layoutParams.mIsRtlCompatibilityMode;
            this.mRulesChanged = layoutParams.mRulesChanged;
            this.alignWithParent = layoutParams.alignWithParent;
            System.arraycopy((int[])layoutParams.mRules, (int)0, (int[])this.mRules, (int)0, (int)22);
            System.arraycopy((int[])layoutParams.mInitialRules, (int)0, (int[])this.mInitialRules, (int)0, (int)22);
        }

        static /* synthetic */ int access$102(LayoutParams layoutParams, int n) {
            layoutParams.mLeft = n;
            return n;
        }

        static /* synthetic */ int access$112(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mLeft = n2 = n + layoutParams.mLeft;
            return n2;
        }

        static /* synthetic */ int access$120(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mLeft = n2 = layoutParams.mLeft - n;
            return n2;
        }

        static /* synthetic */ int access$202(LayoutParams layoutParams, int n) {
            layoutParams.mRight = n;
            return n;
        }

        static /* synthetic */ int access$212(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mRight = n2 = n + layoutParams.mRight;
            return n2;
        }

        static /* synthetic */ int access$220(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mRight = n2 = layoutParams.mRight - n;
            return n2;
        }

        static /* synthetic */ int access$302(LayoutParams layoutParams, int n) {
            layoutParams.mBottom = n;
            return n;
        }

        static /* synthetic */ int access$312(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mBottom = n2 = n + layoutParams.mBottom;
            return n2;
        }

        static /* synthetic */ int access$402(LayoutParams layoutParams, int n) {
            layoutParams.mTop = n;
            return n;
        }

        static /* synthetic */ int access$412(LayoutParams layoutParams, int n) {
            int n2;
            layoutParams.mTop = n2 = n + layoutParams.mTop;
            return n2;
        }

        private boolean hasRelativeRules() {
            return this.mInitialRules[16] != 0 || this.mInitialRules[17] != 0 || this.mInitialRules[18] != 0 || this.mInitialRules[19] != 0 || this.mInitialRules[20] != 0 || this.mInitialRules[21] != 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void resolveRules(int n) {
            int n2 = 1;
            int n3 = n == n2 ? n2 : 0;
            System.arraycopy((int[])this.mInitialRules, (int)0, (int[])this.mRules, (int)0, (int)22);
            if (this.mIsRtlCompatibilityMode) {
                if (this.mRules[18] != 0) {
                    if (this.mRules[5] == 0) {
                        this.mRules[5] = this.mRules[18];
                    }
                    this.mRules[18] = 0;
                }
                if (this.mRules[19] != 0) {
                    if (this.mRules[7] == 0) {
                        this.mRules[7] = this.mRules[19];
                    }
                    this.mRules[19] = 0;
                }
                if (this.mRules[16] != 0) {
                    if (this.mRules[0] == 0) {
                        this.mRules[0] = this.mRules[16];
                    }
                    this.mRules[16] = 0;
                }
                if (this.mRules[17] != 0) {
                    if (this.mRules[n2] == 0) {
                        this.mRules[n2] = this.mRules[17];
                    }
                    this.mRules[17] = 0;
                }
                if (this.mRules[20] != 0) {
                    if (this.mRules[9] == 0) {
                        this.mRules[9] = this.mRules[20];
                    }
                    this.mRules[20] = 0;
                }
                if (this.mRules[21] != 0) {
                    if (this.mRules[11] == 0) {
                        this.mRules[11] = this.mRules[21];
                    }
                    this.mRules[21] = 0;
                }
            } else {
                if (!(this.mRules[18] == 0 && this.mRules[19] == 0 || this.mRules[5] == 0 && this.mRules[7] == 0)) {
                    this.mRules[5] = 0;
                    this.mRules[7] = 0;
                }
                if (this.mRules[18] != 0) {
                    int[] nArray = this.mRules;
                    int n4 = n3 != 0 ? 7 : 5;
                    nArray[n4] = this.mRules[18];
                    this.mRules[18] = 0;
                }
                if (this.mRules[19] != 0) {
                    int[] nArray = this.mRules;
                    int n5 = n3 != 0 ? 5 : 7;
                    nArray[n5] = this.mRules[19];
                    this.mRules[19] = 0;
                }
                if (!(this.mRules[16] == 0 && this.mRules[17] == 0 || this.mRules[0] == 0 && this.mRules[n2] == 0)) {
                    this.mRules[0] = 0;
                    this.mRules[n2] = 0;
                }
                if (this.mRules[16] != 0) {
                    int[] nArray = this.mRules;
                    int n6 = n3 != 0 ? n2 : 0;
                    nArray[n6] = this.mRules[16];
                    this.mRules[16] = 0;
                }
                if (this.mRules[17] != 0) {
                    int[] nArray = this.mRules;
                    if (n3 != 0) {
                        n2 = 0;
                    }
                    nArray[n2] = this.mRules[17];
                    this.mRules[17] = 0;
                }
                if (!(this.mRules[20] == 0 && this.mRules[21] == 0 || this.mRules[9] == 0 && this.mRules[11] == 0)) {
                    this.mRules[9] = 0;
                    this.mRules[11] = 0;
                }
                if (this.mRules[20] != 0) {
                    int[] nArray = this.mRules;
                    int n7 = n3 != 0 ? 11 : 9;
                    nArray[n7] = this.mRules[20];
                    this.mRules[20] = 0;
                }
                if (this.mRules[21] != 0) {
                    int[] nArray = this.mRules;
                    int n8 = n3 != 0 ? 9 : 11;
                    nArray[n8] = this.mRules[21];
                    this.mRules[21] = 0;
                }
            }
            this.mRulesChanged = false;
        }

        public void addRule(int n) {
            this.mRules[n] = -1;
            this.mInitialRules[n] = -1;
            this.mRulesChanged = true;
        }

        public void addRule(int n, int n2) {
            this.mRules[n] = n2;
            this.mInitialRules[n] = n2;
            this.mRulesChanged = true;
        }

        @Override
        public String debug(String string2) {
            return string2 + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        public int[] getRules() {
            return this.mRules;
        }

        public int[] getRules(int n) {
            if (this.hasRelativeRules() && (this.mRulesChanged || n != this.getLayoutDirection())) {
                this.resolveRules(n);
                if (n != this.getLayoutDirection()) {
                    this.setLayoutDirection(n);
                }
            }
            return this.mRules;
        }

        public void removeRule(int n) {
            this.mRules[n] = 0;
            this.mInitialRules[n] = 0;
            this.mRulesChanged = true;
        }

        @Override
        public void resolveLayoutDirection(int n) {
            this.isLayoutRtl();
            if (this.hasRelativeRules() && n != this.getLayoutDirection()) {
                this.resolveRules(n);
            }
            super.resolveLayoutDirection(n);
        }
    }

    private class TopToBottomLeftToRightComparator
    implements Comparator<View> {
        private TopToBottomLeftToRightComparator() {
        }

        @Override
        public int compare(View view, View view2) {
            int n = view.getTop() - view2.getTop();
            if (n != 0) {
                return n;
            }
            int n2 = view.getLeft() - view2.getLeft();
            if (n2 != 0) {
                return n2;
            }
            int n3 = view.getHeight() - view2.getHeight();
            if (n3 != 0) {
                return n3;
            }
            int n4 = view.getWidth() - view2.getWidth();
            if (n4 != 0) {
                return n4;
            }
            return 0;
        }
    }
}

