/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.QwertyKeyListener;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AutoCompleteTextView;
import android.widget.Filter;

public class MultiAutoCompleteTextView
extends AutoCompleteTextView {
    private Tokenizer mTokenizer;

    public MultiAutoCompleteTextView(Context context) {
        this(context, null);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842859);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean enoughToFilter() {
        Editable editable = this.getText();
        int n = this.getSelectionEnd();
        return n >= 0 && this.mTokenizer != null && n - this.mTokenizer.findTokenStart(editable, n) >= this.getThreshold();
    }

    void finishInit() {
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(MultiAutoCompleteTextView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(MultiAutoCompleteTextView.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void performFiltering(CharSequence charSequence, int n) {
        if (this.enoughToFilter()) {
            int n2 = this.getSelectionEnd();
            this.performFiltering(charSequence, this.mTokenizer.findTokenStart(charSequence, n2), n2, n);
            return;
        } else {
            this.dismissDropDown();
            Filter filter = this.getFilter();
            if (filter == null) return;
            filter.filter(null);
            return;
        }
    }

    protected void performFiltering(CharSequence charSequence, int n, int n2, int n3) {
        this.getFilter().filter(charSequence.subSequence(n, n2), this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void performValidation() {
        AutoCompleteTextView.Validator validator = this.getValidator();
        if (validator != null && this.mTokenizer != null) {
            Editable editable = this.getText();
            int n = this.getText().length();
            while (n > 0) {
                int n2 = this.mTokenizer.findTokenStart(editable, n);
                CharSequence charSequence = editable.subSequence(n2, this.mTokenizer.findTokenEnd(editable, n2));
                if (TextUtils.isEmpty(charSequence)) {
                    editable.replace(n2, n, "");
                } else if (!validator.isValid(charSequence)) {
                    editable.replace(n2, n, this.mTokenizer.terminateToken(validator.fixText(charSequence)));
                }
                n = n2;
            }
        }
    }

    @Override
    protected void replaceText(CharSequence charSequence) {
        this.clearComposingText();
        int n = this.getSelectionEnd();
        int n2 = this.mTokenizer.findTokenStart(this.getText(), n);
        Editable editable = this.getText();
        QwertyKeyListener.markAsReplaced(editable, n2, n, TextUtils.substring(editable, n2, n));
        editable.replace(n2, n, this.mTokenizer.terminateToken(charSequence));
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.mTokenizer = tokenizer;
    }

    public static class CommaTokenizer
    implements Tokenizer {
        @Override
        public int findTokenEnd(CharSequence charSequence, int n) {
            int n2 = charSequence.length();
            for (int i = n; i < n2; ++i) {
                if (charSequence.charAt(i) != ',') continue;
                return i;
            }
            return n2;
        }

        @Override
        public int findTokenStart(CharSequence charSequence, int n) {
            int n2;
            for (n2 = n; n2 > 0 && charSequence.charAt(n2 - 1) != ','; --n2) {
            }
            while (n2 < n && charSequence.charAt(n2) == ' ') {
                ++n2;
            }
            return n2;
        }

        @Override
        public CharSequence terminateToken(CharSequence charSequence) {
            int n;
            for (n = charSequence.length(); n > 0 && charSequence.charAt(n - 1) == ' '; --n) {
            }
            if (n > 0 && charSequence.charAt(n - 1) == ',') {
                return charSequence;
            }
            if (charSequence instanceof Spanned) {
                SpannableString spannableString = new SpannableString(charSequence + ", ");
                TextUtils.copySpansFrom((Spanned)charSequence, 0, charSequence.length(), Object.class, spannableString, 0);
                return spannableString;
            }
            return charSequence + ", ";
        }
    }

    public static interface Tokenizer {
        public int findTokenEnd(CharSequence var1, int var2);

        public int findTokenStart(CharSequence var1, int var2);

        public CharSequence terminateToken(CharSequence var1);
    }
}

