/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.android.internal.policy.PolicyManager;
import java.util.Formatter;
import java.util.Locale;

public class MediaController
extends FrameLayout {
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private static final int sDefaultTimeout = 3000;
    private View mAnchor;
    private Context mContext;
    private TextView mCurrentTime;
    private View mDecor;
    private WindowManager.LayoutParams mDecorLayoutParams;
    private boolean mDragging;
    private TextView mEndTime;
    private ImageButton mFfwdButton;
    private View.OnClickListener mFfwdListener;
    StringBuilder mFormatBuilder;
    Formatter mFormatter;
    private boolean mFromXml;
    private Handler mHandler;
    private View.OnLayoutChangeListener mLayoutChangeListener = new View.OnLayoutChangeListener(){

        @Override
        public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            MediaController.this.updateFloatingWindowLayout();
            if (MediaController.this.mShowing) {
                MediaController.this.mWindowManager.updateViewLayout(MediaController.this.mDecor, MediaController.this.mDecorLayoutParams);
            }
        }
    };
    private boolean mListenersSet;
    private ImageButton mNextButton;
    private View.OnClickListener mNextListener;
    private ImageButton mPauseButton;
    private CharSequence mPauseDescription;
    private View.OnClickListener mPauseListener;
    private CharSequence mPlayDescription;
    private MediaPlayerControl mPlayer;
    private ImageButton mPrevButton;
    private View.OnClickListener mPrevListener;
    private ProgressBar mProgress;
    private ImageButton mRewButton;
    private View.OnClickListener mRewListener;
    private View mRoot;
    private SeekBar.OnSeekBarChangeListener mSeekListener;
    private boolean mShowing;
    private View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0 && MediaController.this.mShowing) {
                MediaController.this.hide();
            }
            return false;
        }
    };
    private boolean mUseFastForward;
    private Window mWindow;
    private WindowManager mWindowManager;

    public MediaController(Context context) {
        this(context, true);
    }

    public MediaController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        MediaController.this.hide();
                        return;
                    }
                    case 2: {
                        int n = MediaController.this.setProgress();
                        if (MediaController.this.mDragging || !MediaController.this.mShowing || !MediaController.this.mPlayer.isPlaying()) return;
                        this.sendMessageDelayed(this.obtainMessage(2), 1000 - n % 1000);
                        return;
                    }
                }
            }
        };
        this.mPauseListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                MediaController.this.doPauseResume();
                MediaController.this.show(3000);
            }
        };
        this.mSeekListener = new SeekBar.OnSeekBarChangeListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                long l;
                block3: {
                    block2: {
                        if (!bl) break block2;
                        l = (long)MediaController.this.mPlayer.getDuration() * (long)n / 1000L;
                        MediaController.this.mPlayer.seekTo((int)l);
                        if (MediaController.this.mCurrentTime != null) break block3;
                    }
                    return;
                }
                MediaController.this.mCurrentTime.setText(MediaController.this.stringForTime((int)l));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                MediaController.this.show(3600000);
                MediaController.access$602(MediaController.this, true);
                MediaController.this.mHandler.removeMessages(2);
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                MediaController.access$602(MediaController.this, false);
                MediaController.this.setProgress();
                MediaController.this.updatePausePlay();
                MediaController.this.show(3000);
                MediaController.this.mHandler.sendEmptyMessage(2);
            }
        };
        this.mRewListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                int n = -5000 + MediaController.this.mPlayer.getCurrentPosition();
                MediaController.this.mPlayer.seekTo(n);
                MediaController.this.setProgress();
                MediaController.this.show(3000);
            }
        };
        this.mFfwdListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                int n = 15000 + MediaController.this.mPlayer.getCurrentPosition();
                MediaController.this.mPlayer.seekTo(n);
                MediaController.this.setProgress();
                MediaController.this.show(3000);
            }
        };
        this.mRoot = this;
        this.mContext = context;
        this.mUseFastForward = true;
        this.mFromXml = true;
    }

    public MediaController(Context context, boolean bl) {
        super(context);
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mPauseListener = new /* invalid duplicate definition of identical inner class */;
        this.mSeekListener = new /* invalid duplicate definition of identical inner class */;
        this.mRewListener = new /* invalid duplicate definition of identical inner class */;
        this.mFfwdListener = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mUseFastForward = bl;
        this.initFloatingWindowLayout();
        this.initFloatingWindow();
    }

    static /* synthetic */ boolean access$602(MediaController mediaController, boolean bl) {
        mediaController.mDragging = bl;
        return bl;
    }

    private void disableUnsupportedButtons() {
        try {
            if (this.mPauseButton != null && !this.mPlayer.canPause()) {
                this.mPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.mPlayer.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton != null && !this.mPlayer.canSeekForward()) {
                this.mFfwdButton.setEnabled(false);
            }
            return;
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doPauseResume() {
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else {
            this.mPlayer.start();
        }
        this.updatePausePlay();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initControllerView(View view) {
        Resources resources = this.mContext.getResources();
        this.mPlayDescription = resources.getText(17040264);
        this.mPauseDescription = resources.getText(17040263);
        this.mPauseButton = (ImageButton)view.findViewById(16909157);
        if (this.mPauseButton != null) {
            this.mPauseButton.requestFocus();
            this.mPauseButton.setOnClickListener(this.mPauseListener);
        }
        this.mFfwdButton = (ImageButton)view.findViewById(16909158);
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setOnClickListener(this.mFfwdListener);
            if (!this.mFromXml) {
                ImageButton imageButton = this.mFfwdButton;
                int n = this.mUseFastForward ? 0 : 8;
                imageButton.setVisibility(n);
            }
        }
        this.mRewButton = (ImageButton)view.findViewById(16909156);
        if (this.mRewButton != null) {
            this.mRewButton.setOnClickListener(this.mRewListener);
            if (!this.mFromXml) {
                ImageButton imageButton = this.mRewButton;
                boolean bl = this.mUseFastForward;
                int n = 0;
                if (!bl) {
                    n = 8;
                }
                imageButton.setVisibility(n);
            }
        }
        this.mNextButton = (ImageButton)view.findViewById(16909159);
        if (this.mNextButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mNextButton.setVisibility(8);
        }
        this.mPrevButton = (ImageButton)view.findViewById(16909155);
        if (this.mPrevButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mPrevButton.setVisibility(8);
        }
        this.mProgress = (ProgressBar)view.findViewById(16909161);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                ((SeekBar)this.mProgress).setOnSeekBarChangeListener(this.mSeekListener);
            }
            this.mProgress.setMax(1000);
        }
        this.mEndTime = (TextView)view.findViewById(16908417);
        this.mCurrentTime = (TextView)view.findViewById(16909160);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.installPrevNextListeners();
    }

    private void initFloatingWindow() {
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        this.mWindow = PolicyManager.makeNewWindow(this.mContext);
        this.mWindow.setWindowManager(this.mWindowManager, null, null);
        this.mWindow.requestFeature(1);
        this.mDecor = this.mWindow.getDecorView();
        this.mDecor.setOnTouchListener(this.mTouchListener);
        this.mWindow.setContentView(this);
        this.mWindow.setBackgroundDrawableResource(17170445);
        this.mWindow.setVolumeControlStream(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.requestFocus();
    }

    private void initFloatingWindowLayout() {
        WindowManager.LayoutParams layoutParams = this.mDecorLayoutParams = new WindowManager.LayoutParams();
        layoutParams.gravity = 51;
        layoutParams.height = -2;
        layoutParams.x = 0;
        layoutParams.format = -3;
        layoutParams.type = 1000;
        layoutParams.flags = 0x820020 | layoutParams.flags;
        layoutParams.token = null;
        layoutParams.windowAnimations = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void installPrevNextListeners() {
        boolean bl = true;
        if (this.mNextButton != null) {
            this.mNextButton.setOnClickListener(this.mNextListener);
            ImageButton imageButton = this.mNextButton;
            boolean bl2 = this.mNextListener != null ? bl : false;
            imageButton.setEnabled(bl2);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setOnClickListener(this.mPrevListener);
            ImageButton imageButton = this.mPrevButton;
            if (this.mPrevListener == null) {
                bl = false;
            }
            imageButton.setEnabled(bl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int setProgress() {
        if (this.mPlayer == null) return 0;
        if (this.mDragging) {
            return 0;
        }
        int n = this.mPlayer.getCurrentPosition();
        int n2 = this.mPlayer.getDuration();
        if (this.mProgress != null) {
            if (n2 > 0) {
                long l = 1000L * (long)n / (long)n2;
                this.mProgress.setProgress((int)l);
            }
            int n3 = this.mPlayer.getBufferPercentage();
            this.mProgress.setSecondaryProgress(n3 * 10);
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText(this.stringForTime(n2));
        }
        if (this.mCurrentTime == null) return n;
        this.mCurrentTime.setText(this.stringForTime(n));
        return n;
    }

    private String stringForTime(int n) {
        int n2 = n / 1000;
        int n3 = n2 % 60;
        int n4 = n2 / 60 % 60;
        int n5 = n2 / 3600;
        this.mFormatBuilder.setLength(0);
        if (n5 > 0) {
            Formatter formatter = this.mFormatter;
            Object[] objectArray = new Object[]{n5, n4, n3};
            return formatter.format("%d:%02d:%02d", objectArray).toString();
        }
        Formatter formatter = this.mFormatter;
        Object[] objectArray = new Object[]{n4, n3};
        return formatter.format("%02d:%02d", objectArray).toString();
    }

    private void updateFloatingWindowLayout() {
        int[] nArray = new int[2];
        this.mAnchor.getLocationOnScreen(nArray);
        this.mDecor.measure(View.MeasureSpec.makeMeasureSpec(this.mAnchor.getWidth(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(this.mAnchor.getHeight(), Integer.MIN_VALUE));
        WindowManager.LayoutParams layoutParams = this.mDecorLayoutParams;
        layoutParams.width = this.mAnchor.getWidth();
        layoutParams.x = nArray[0] + (this.mAnchor.getWidth() - layoutParams.width) / 2;
        layoutParams.y = nArray[1] + this.mAnchor.getHeight() - this.mDecor.getMeasuredHeight();
    }

    private void updatePausePlay() {
        if (this.mRoot == null || this.mPauseButton == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPauseButton.setImageResource(17301539);
            this.mPauseButton.setContentDescription(this.mPauseDescription);
            return;
        }
        this.mPauseButton.setImageResource(17301540);
        this.mPauseButton.setContentDescription(this.mPlayDescription);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.getRepeatCount() == 0 && keyEvent.getAction() == 0;
        if (n == 79 || n == 85 || n == 62) {
            if (!bl) return true;
            this.doPauseResume();
            this.show(3000);
            if (this.mPauseButton == null) return true;
            this.mPauseButton.requestFocus();
            return true;
        }
        if (n == 126) {
            if (!bl || this.mPlayer.isPlaying()) return true;
            this.mPlayer.start();
            this.updatePausePlay();
            this.show(3000);
            return true;
        } else if (n == 86 || n == 127) {
            if (!bl || !this.mPlayer.isPlaying()) return true;
            this.mPlayer.pause();
            this.updatePausePlay();
            this.show(3000);
            return true;
        } else {
            if (n == 25 || n == 24 || n == 164 || n == 27) {
                return super.dispatchKeyEvent(keyEvent);
            }
            if (n != 4 && n != 82) {
                this.show(3000);
                return super.dispatchKeyEvent(keyEvent);
            }
            if (!bl) return true;
            this.hide();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hide() {
        if (this.mAnchor == null || !this.mShowing) {
            return;
        }
        try {
            this.mHandler.removeMessages(2);
            this.mWindowManager.removeView(this.mDecor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w("MediaController", "already removed");
        }
        this.mShowing = false;
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    protected View makeControllerView() {
        this.mRoot = ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367175, null);
        this.initControllerView(this.mRoot);
        return this.mRoot;
    }

    @Override
    public void onFinishInflate() {
        if (this.mRoot != null) {
            this.initControllerView(this.mRoot);
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(MediaController.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(MediaController.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.show(0);
                return true;
            }
            case 1: {
                this.show(3000);
                return true;
            }
            case 3: {
                this.hide();
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        this.show(3000);
        return false;
    }

    public void setAnchorView(View view) {
        if (this.mAnchor != null) {
            this.mAnchor.removeOnLayoutChangeListener(this.mLayoutChangeListener);
        }
        this.mAnchor = view;
        if (this.mAnchor != null) {
            this.mAnchor.addOnLayoutChangeListener(this.mLayoutChangeListener);
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.removeAllViews();
        this.addView(this.makeControllerView(), layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = true;
        if (this.mPauseButton != null) {
            this.mPauseButton.setEnabled(bl);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(bl);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(bl);
        }
        if (this.mNextButton != null) {
            ImageButton imageButton = this.mNextButton;
            boolean bl3 = bl && this.mNextListener != null ? bl2 : false;
            imageButton.setEnabled(bl3);
        }
        if (this.mPrevButton != null) {
            ImageButton imageButton = this.mPrevButton;
            if (!bl || this.mPrevListener == null) {
                bl2 = false;
            }
            imageButton.setEnabled(bl2);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(bl);
        }
        this.disableUnsupportedButtons();
        super.setEnabled(bl);
    }

    public void setMediaPlayer(MediaPlayerControl mediaPlayerControl) {
        this.mPlayer = mediaPlayerControl;
        this.updatePausePlay();
    }

    public void setPrevNextListeners(View.OnClickListener onClickListener, View.OnClickListener onClickListener2) {
        this.mNextListener = onClickListener;
        this.mPrevListener = onClickListener2;
        this.mListenersSet = true;
        if (this.mRoot != null) {
            this.installPrevNextListeners();
            if (this.mNextButton != null && !this.mFromXml) {
                this.mNextButton.setVisibility(0);
            }
            if (this.mPrevButton != null && !this.mFromXml) {
                this.mPrevButton.setVisibility(0);
            }
        }
    }

    public void show() {
        this.show(3000);
    }

    public void show(int n) {
        if (!this.mShowing && this.mAnchor != null) {
            this.setProgress();
            if (this.mPauseButton != null) {
                this.mPauseButton.requestFocus();
            }
            this.disableUnsupportedButtons();
            this.updateFloatingWindowLayout();
            this.mWindowManager.addView(this.mDecor, this.mDecorLayoutParams);
            this.mShowing = true;
        }
        this.updatePausePlay();
        this.mHandler.sendEmptyMessage(2);
        Message message = this.mHandler.obtainMessage(1);
        if (n != 0) {
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageDelayed(message, n);
        }
    }

    public static interface MediaPlayerControl {
        public boolean canPause();

        public boolean canSeekBackward();

        public boolean canSeekForward();

        public int getAudioSessionId();

        public int getBufferPercentage();

        public int getCurrentPosition();

        public int getDuration();

        public boolean isPlaying();

        public void pause();

        public void seekTo(int var1);

        public void start();
    }
}

