/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.util.SparseBooleanArray;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.RemotableViewMethod;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.ArrayAdapter;
import android.widget.Checkable;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.util.Predicate;
import com.google.android.collect.Lists;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class ListView
extends AbsListView {
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    private static final int MIN_SCROLL_PREVIEW_PIXELS = 2;
    static final int NO_POSITION = -1;
    private boolean mAreAllItemsSelectable = true;
    private final ArrowScrollFocusResult mArrowScrollFocusResult;
    Drawable mDivider;
    int mDividerHeight;
    private boolean mDividerIsOpaque;
    private Paint mDividerPaint;
    private FocusSelector mFocusSelector;
    private boolean mFooterDividersEnabled;
    private ArrayList<FixedViewInfo> mFooterViewInfos;
    private boolean mHeaderDividersEnabled;
    private ArrayList<FixedViewInfo> mHeaderViewInfos = Lists.newArrayList();
    private boolean mIsCacheColorOpaque;
    private boolean mItemsCanFocus = false;
    Drawable mOverScrollFooter;
    Drawable mOverScrollHeader;
    private final Rect mTempRect;

    public ListView(Context context) {
        this(context, null);
    }

    public ListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842868);
    }

    public ListView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ListView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        int n3;
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        this.mFooterViewInfos = Lists.newArrayList();
        this.mTempRect = new Rect();
        this.mArrowScrollFocusResult = new ArrowScrollFocusResult();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ListView, n, n2);
        CharSequence[] charSequenceArray = typedArray.getTextArray(0);
        if (charSequenceArray != null) {
            this.setAdapter(new ArrayAdapter<CharSequence>(context, 17367043, charSequenceArray));
        }
        if ((drawable4 = typedArray.getDrawable(1)) != null) {
            this.setDivider(drawable4);
        }
        if ((drawable3 = typedArray.getDrawable(5)) != null) {
            this.setOverscrollHeader(drawable3);
        }
        if ((drawable2 = typedArray.getDrawable(6)) != null) {
            this.setOverscrollFooter(drawable2);
        }
        if ((n3 = typedArray.getDimensionPixelSize(2, 0)) != 0) {
            this.setDividerHeight(n3);
        }
        this.mHeaderDividersEnabled = typedArray.getBoolean(3, true);
        this.mFooterDividersEnabled = typedArray.getBoolean(4, true);
        typedArray.recycle();
    }

    private View addViewAbove(View view, int n) {
        int n2 = n - 1;
        View view2 = this.obtainView(n2, this.mIsScrap);
        this.setupChild(view2, n2, view.getTop() - this.mDividerHeight, false, this.mListPadding.left, false, this.mIsScrap[0]);
        return view2;
    }

    private View addViewBelow(View view, int n) {
        int n2 = n + 1;
        View view2 = this.obtainView(n2, this.mIsScrap);
        this.setupChild(view2, n2, view.getBottom() + this.mDividerHeight, true, this.mListPadding.left, false, this.mIsScrap[0]);
        return view2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustViewsUpOrDown() {
        int n;
        int n2 = this.getChildCount();
        if (n2 <= 0) return;
        if (!this.mStackFromBottom) {
            n = this.getChildAt(0).getTop() - this.mListPadding.top;
            if (this.mFirstPosition != 0) {
                n -= this.mDividerHeight;
            }
            if (n < 0) {
                return;
            }
        } else {
            n = this.getChildAt(n2 - 1).getBottom() - (this.getHeight() - this.mListPadding.bottom);
            if (n2 + this.mFirstPosition < this.mItemCount) {
                n += this.mDividerHeight;
            }
            if (n > 0) {
                return;
            }
        }
        if (n == 0) return;
        this.offsetChildrenTopAndBottom(-n);
    }

    private int amountToScroll(int n, int n2) {
        int n3 = this.getHeight() - this.mListPadding.bottom;
        int n4 = this.mListPadding.top;
        int n5 = this.getChildCount();
        if (n == 130) {
            int n6 = n5 - 1;
            if (n2 != -1) {
                n6 = n2 - this.mFirstPosition;
            }
            while (n5 <= n6) {
                this.addViewBelow(this.getChildAt(n5 - 1), -1 + (n5 + this.mFirstPosition));
                ++n5;
            }
            int n7 = n6 + this.mFirstPosition;
            View view = this.getChildAt(n6);
            int n8 = n3;
            if (n7 < -1 + this.mItemCount) {
                n8 -= this.getArrowScrollPreviewLength();
            }
            if (view.getBottom() <= n8) {
                return 0;
            }
            if (n2 != -1 && n8 - view.getTop() >= this.getMaxScrollAmount()) {
                return 0;
            }
            int n9 = view.getBottom() - n8;
            if (n5 + this.mFirstPosition == this.mItemCount) {
                n9 = Math.min(n9, this.getChildAt(n5 - 1).getBottom() - n3);
            }
            return Math.min(n9, this.getMaxScrollAmount());
        }
        int n10 = 0;
        if (n2 != -1) {
            n10 = n2 - this.mFirstPosition;
        }
        while (n10 < 0) {
            this.addViewAbove(this.getChildAt(0), this.mFirstPosition);
            this.mFirstPosition = -1 + this.mFirstPosition;
            n10 = n2 - this.mFirstPosition;
        }
        int n11 = n10 + this.mFirstPosition;
        View view = this.getChildAt(n10);
        int n12 = n4;
        if (n11 > 0) {
            n12 += this.getArrowScrollPreviewLength();
        }
        if (view.getTop() >= n12) {
            return 0;
        }
        if (n2 != -1 && view.getBottom() - n12 >= this.getMaxScrollAmount()) {
            return 0;
        }
        int n13 = n12 - view.getTop();
        if (this.mFirstPosition == 0) {
            n13 = Math.min(n13, n4 - this.getChildAt(0).getTop());
        }
        return Math.min(n13, this.getMaxScrollAmount());
    }

    /*
     * Enabled aggressive block sorting
     */
    private int amountToScrollToNewFocus(int n, View view, int n2) {
        int n3;
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        if (n == 33) {
            int n4 = this.mTempRect.top;
            int n5 = this.mListPadding.top;
            n3 = 0;
            if (n4 >= n5) return n3;
            n3 = this.mListPadding.top - this.mTempRect.top;
            if (n2 <= 0) return n3;
            n3 += this.getArrowScrollPreviewLength();
            return n3;
        }
        int n6 = this.getHeight() - this.mListPadding.bottom;
        int n7 = this.mTempRect.bottom;
        n3 = 0;
        if (n7 <= n6) return n3;
        n3 = this.mTempRect.bottom - n6;
        if (n2 >= -1 + this.mItemCount) return n3;
        return n3 + this.getArrowScrollPreviewLength();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrowScrollFocusResult arrowScrollFocused(int n) {
        View view;
        View view2 = this.getSelectedView();
        if (view2 != null && view2.hasFocus()) {
            View view3 = view2.findFocus();
            view = FocusFinder.getInstance().findNextFocus(this, view3, n);
        } else {
            if (n == 130) {
                boolean bl = this.mFirstPosition > 0;
                int n2 = this.mListPadding.top;
                int n3 = bl ? this.getArrowScrollPreviewLength() : 0;
                int n4 = n2 + n3;
                int n5 = view2 != null && view2.getTop() > n4 ? view2.getTop() : n4;
                this.mTempRect.set(0, n5, 0, n5);
            } else {
                boolean bl = -1 + (this.mFirstPosition + this.getChildCount()) < this.mItemCount;
                int n6 = this.getHeight() - this.mListPadding.bottom;
                int n7 = bl ? this.getArrowScrollPreviewLength() : 0;
                int n8 = n6 - n7;
                int n9 = view2 != null && view2.getBottom() < n8 ? view2.getBottom() : n8;
                this.mTempRect.set(0, n9, 0, n9);
            }
            view = FocusFinder.getInstance().findNextFocusFromRect(this, this.mTempRect, n);
        }
        if (view != null) {
            int n10;
            int n11;
            int n12 = this.positionOfNewFocus(view);
            if (this.mSelectedPosition != -1 && n12 != this.mSelectedPosition && (n11 = this.lookForSelectablePositionOnScreen(n)) != -1 && (n == 130 && n11 < n12 || n == 33 && n11 > n12)) {
                return null;
            }
            int n13 = this.amountToScrollToNewFocus(n, view, n12);
            if (n13 < (n10 = this.getMaxScrollAmount())) {
                view.requestFocus(n);
                this.mArrowScrollFocusResult.populate(n12, n13);
                return this.mArrowScrollFocusResult;
            }
            if (this.distanceToView(view) < n10) {
                view.requestFocus(n);
                this.mArrowScrollFocusResult.populate(n12, n10);
                return this.mArrowScrollFocusResult;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean arrowScrollImpl(int n) {
        int n2;
        View view;
        block13: {
            block12: {
                View view2;
                if (this.getChildCount() <= 0) break block12;
                view = this.getSelectedView();
                n2 = this.mSelectedPosition;
                int n3 = this.nextSelectedPositionForDirection(view, n2, n);
                int n4 = this.amountToScroll(n, n3);
                ArrowScrollFocusResult arrowScrollFocusResult = this.mItemsCanFocus ? this.arrowScrollFocused(n) : null;
                if (arrowScrollFocusResult != null) {
                    n3 = arrowScrollFocusResult.getSelectedPosition();
                    n4 = arrowScrollFocusResult.getAmountToScroll();
                }
                boolean bl = arrowScrollFocusResult != null;
                if (n3 != -1) {
                    View view3;
                    boolean bl2 = arrowScrollFocusResult != null;
                    this.handleNewSelectionChange(view, n, n3, bl2);
                    this.setSelectedPositionInt(n3);
                    this.setNextSelectedPositionInt(n3);
                    view = this.getSelectedView();
                    n2 = n3;
                    if (this.mItemsCanFocus && arrowScrollFocusResult == null && (view3 = this.getFocusedChild()) != null) {
                        view3.clearFocus();
                    }
                    bl = true;
                    this.checkSelectionChanged();
                }
                if (n4 > 0) {
                    if (n != 33) {
                        n4 = -n4;
                    }
                    this.scrollListItemsBy(n4);
                    bl = true;
                }
                if (this.mItemsCanFocus && arrowScrollFocusResult == null && view != null && view.hasFocus() && (!this.isViewAncestorOf(view2 = view.findFocus(), this) || this.distanceToView(view2) > 0)) {
                    view2.clearFocus();
                }
                if (n3 == -1 && view != null && !this.isViewAncestorOf(view, this)) {
                    view = null;
                    this.hideSelector();
                    this.mResurrectToPosition = -1;
                }
                if (bl) break block13;
            }
            return false;
        }
        if (view != null) {
            this.positionSelectorLikeFocus(n2, view);
            this.mSelectedTop = view.getTop();
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        this.invokeOnItemScrollListener();
        return true;
    }

    private void clearRecycledState(ArrayList<FixedViewInfo> arrayList) {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)arrayList.get((int)i).view.getLayoutParams();
                if (layoutParams == null) continue;
                layoutParams.recycledHeaderFooter = false;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private boolean commonKey(int var1_1, int var2_2, KeyEvent var3_3) {
        block46: {
            var4_4 = 1;
            if (this.mAdapter == null) return (boolean)0;
            if (!this.isAttachedToWindow()) {
                return (boolean)0;
            }
            if (this.mDataChanged) {
                this.layoutChildren();
            }
            var5_5 = var3_3.getAction();
            var6_6 = 0;
            if (var5_5 == var4_4) break block46;
            var6_6 = 0;
            switch (var1_1) {
                case 19: {
                    if (!var3_3.hasNoModifiers()) ** GOTO lbl25
                    var6_6 = this.resurrectSelectionIfNeeded();
                    if (var6_6 == 0) {
                        var20_7 = var2_2;
                        while (true) {
                            var2_2 = var20_7 - 1;
                            if (var20_7 > 0 && this.arrowScroll(33)) {
                                var6_6 = 1;
                                var20_7 = var2_2;
                                continue;
                            }
                            ** GOTO lbl125
                            break;
                        }
                    }
                    ** GOTO lbl125
lbl25:
                    // 1 sources

                    var19_8 = var3_3.hasModifiers(2);
                    var6_6 = 0;
                    if (var19_8) {
                        if (this.resurrectSelectionIfNeeded() || this.fullScroll(33)) {
                            var6_6 = var4_4;
                            ** break;
                        }
                        var6_6 = 0;
                        ** break;
                    }
                    ** GOTO lbl125
                }
                case 20: {
                    if (!var3_3.hasNoModifiers()) ** GOTO lbl47
                    var6_6 = this.resurrectSelectionIfNeeded();
                    if (var6_6 == 0) {
                        var18_9 = var2_2;
                        while (true) {
                            var2_2 = var18_9 - 1;
                            if (var18_9 > 0 && this.arrowScroll(130)) {
                                var6_6 = 1;
                                var18_9 = var2_2;
                                continue;
                            }
                            ** GOTO lbl125
                            break;
                        }
                    }
                    ** GOTO lbl125
lbl47:
                    // 1 sources

                    var17_10 = var3_3.hasModifiers(2);
                    var6_6 = 0;
                    if (var17_10) {
                        if (this.resurrectSelectionIfNeeded() || this.fullScroll(130)) {
                            var6_6 = var4_4;
                            ** break;
                        }
                        var6_6 = 0;
                        ** break;
                    }
                    ** GOTO lbl125
                }
                case 21: {
                    var16_11 = var3_3.hasNoModifiers();
                    var6_6 = 0;
                    if (var16_11) {
                        var6_6 = (int)this.handleHorizontalFocusWithinListItem(17);
                        ** break;
                    }
                    ** GOTO lbl125
                }
                case 22: {
                    var15_12 = var3_3.hasNoModifiers();
                    var6_6 = 0;
                    if (var15_12) {
                        var6_6 = (int)this.handleHorizontalFocusWithinListItem(66);
                        ** break;
                    }
                    ** GOTO lbl125
                }
                case 23: 
                case 66: {
                    var14_13 = var3_3.hasNoModifiers();
                    var6_6 = 0;
                    if (var14_13 && (var6_6 = (int)this.resurrectSelectionIfNeeded()) == 0 && var3_3.getRepeatCount() == 0 && this.getChildCount() > 0) {
                        this.keyPressed();
                        var6_6 = 1;
                        ** break;
                    }
                    ** GOTO lbl125
                }
                case 62: {
                    if (this.mPopup == null) ** GOTO lbl83
                    var13_14 = this.mPopup.isShowing();
                    var6_6 = 0;
                    if (var13_14) ** GOTO lbl125
lbl83:
                    // 2 sources

                    if (var3_3.hasNoModifiers() != false ? this.resurrectSelectionIfNeeded() == false && this.pageScroll(130) != false : var3_3.hasModifiers(var4_4) != false && this.resurrectSelectionIfNeeded() == false && this.pageScroll(33) != false) {
                    }
                    var6_6 = 1;
                    ** GOTO lbl125
                }
                case 92: {
                    if (var3_3.hasNoModifiers()) {
                        if (this.resurrectSelectionIfNeeded() || this.pageScroll(33)) {
                            var6_6 = var4_4;
                            ** break;
                        }
                        var6_6 = 0;
                        ** break;
                    }
                    var10_15 = var3_3.hasModifiers(2);
                    var6_6 = 0;
                    if (var10_15) {
                        if (this.resurrectSelectionIfNeeded() || this.fullScroll(33)) {
                            var6_6 = var4_4;
                            ** break;
                        }
                        var6_6 = 0;
                        ** break;
                    }
                    ** GOTO lbl125
                }
                case 93: {
                    if (var3_3.hasNoModifiers()) {
                        if (this.resurrectSelectionIfNeeded() || this.pageScroll(130)) {
                            var6_6 = var4_4;
                            ** break;
                        }
                        var6_6 = 0;
                        ** break;
                    }
                    var9_16 = var3_3.hasModifiers(2);
                    var6_6 = 0;
                    if (var9_16) {
                        if (this.resurrectSelectionIfNeeded() || this.fullScroll(130)) {
                            var6_6 = var4_4;
                            ** break;
                        }
                        var6_6 = 0;
                        ** break;
                    }
                    ** GOTO lbl125
                }
                case 122: {
                    var8_17 = var3_3.hasNoModifiers();
                    var6_6 = 0;
                    if (var8_17) {
                        var6_6 = this.resurrectSelectionIfNeeded() != false || this.fullScroll(33) != false ? var4_4 : 0;
                    }
                }
lbl125:
                // 32 sources

                default: {
                    break block46;
                }
                case 123: 
            }
            var7_18 = var3_3.hasNoModifiers();
            var6_6 = 0;
            if (var7_18) {
                var6_6 = this.resurrectSelectionIfNeeded() != false || this.fullScroll(130) != false ? var4_4 : 0;
            }
        }
        if (var6_6 != 0) return (boolean)var4_4;
        if (this.sendToTextFilter(var1_1, var2_2, var3_3) != false) return (boolean)var4_4;
        switch (var5_5) {
            default: {
                return false;
            }
            case 0: {
                return super.onKeyDown(var1_1, var3_3);
            }
            case 1: {
                return super.onKeyUp(var1_1, var3_3);
            }
            case 2: 
        }
        return super.onKeyMultiple(var1_1, var2_2, var3_3);
    }

    private void correctTooHigh(int n) {
        if (-1 + (n + this.mFirstPosition) == -1 + this.mItemCount && n > 0) {
            int n2 = this.getChildAt(n - 1).getBottom();
            int n3 = this.mBottom - this.mTop - this.mListPadding.bottom - n2;
            View view = this.getChildAt(0);
            int n4 = view.getTop();
            if (n3 > 0 && (this.mFirstPosition > 0 || n4 < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    n3 = Math.min(n3, this.mListPadding.top - n4);
                }
                this.offsetChildrenTopAndBottom(n3);
                if (this.mFirstPosition > 0) {
                    this.fillUp(-1 + this.mFirstPosition, view.getTop() - this.mDividerHeight);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void correctTooLow(int n) {
        if (this.mFirstPosition != 0 || n <= 0) return;
        int n2 = this.getChildAt(0).getTop();
        int n3 = this.mListPadding.top;
        int n4 = this.mBottom - this.mTop - this.mListPadding.bottom;
        int n5 = n2 - n3;
        View view = this.getChildAt(n - 1);
        int n6 = view.getBottom();
        int n7 = -1 + (n + this.mFirstPosition);
        if (n5 <= 0) return;
        if (n7 < -1 + this.mItemCount || n6 > n4) {
            if (n7 == -1 + this.mItemCount) {
                n5 = Math.min(n5, n6 - n4);
            }
            this.offsetChildrenTopAndBottom(-n5);
            if (n7 >= -1 + this.mItemCount) return;
            this.fillDown(n7 + 1, view.getBottom() + this.mDividerHeight);
            this.adjustViewsUpOrDown();
            return;
        }
        if (n7 != -1 + this.mItemCount) return;
        this.adjustViewsUpOrDown();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int distanceToView(View view) {
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        int n = this.mBottom - this.mTop - this.mListPadding.bottom;
        if (this.mTempRect.bottom < this.mListPadding.top) {
            return this.mListPadding.top - this.mTempRect.bottom;
        }
        int n2 = this.mTempRect.top;
        int n3 = 0;
        if (n2 <= n) return n3;
        return this.mTempRect.top - n;
    }

    private void fillAboveAndBelow(View view, int n) {
        int n2 = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            this.fillUp(n - 1, view.getTop() - n2);
            this.adjustViewsUpOrDown();
            this.fillDown(n + 1, n2 + view.getBottom());
            return;
        }
        this.fillDown(n + 1, n2 + view.getBottom());
        this.adjustViewsUpOrDown();
        this.fillUp(n - 1, view.getTop() - n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillDown(int n, int n2) {
        int n3 = this.mBottom - this.mTop;
        int n4 = 0x22 & this.mGroupFlags;
        View view = null;
        if (n4 == 34) {
            n3 -= this.mListPadding.bottom;
        }
        while (n2 < n3 && n < this.mItemCount) {
            boolean bl = n == this.mSelectedPosition;
            int n5 = this.mListPadding.left;
            View view2 = this.makeAndAddView(n, n2, true, n5, bl);
            n2 = view2.getBottom() + this.mDividerHeight;
            if (bl) {
                view = view2;
            }
            ++n;
        }
        this.setVisibleRangeHint(this.mFirstPosition, -1 + (this.mFirstPosition + this.getChildCount()));
        return view;
    }

    private View fillFromMiddle(int n, int n2) {
        int n3 = n2 - n;
        int n4 = this.reconcileSelectedPosition();
        View view = this.makeAndAddView(n4, n, true, this.mListPadding.left, true);
        this.mFirstPosition = n4;
        int n5 = view.getMeasuredHeight();
        if (n5 <= n3) {
            view.offsetTopAndBottom((n3 - n5) / 2);
        }
        this.fillAboveAndBelow(view, n4);
        if (!this.mStackFromBottom) {
            this.correctTooHigh(this.getChildCount());
            return view;
        }
        this.correctTooLow(this.getChildCount());
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillFromSelection(int n, int n2, int n3) {
        int n4 = this.getVerticalFadingEdgeLength();
        int n5 = this.mSelectedPosition;
        int n6 = this.getTopSelectionPixel(n2, n4, n5);
        int n7 = this.getBottomSelectionPixel(n3, n4, n5);
        View view = this.makeAndAddView(n5, n, true, this.mListPadding.left, true);
        if (view.getBottom() > n7) {
            view.offsetTopAndBottom(-Math.min(view.getTop() - n6, view.getBottom() - n7));
        } else if (view.getTop() < n6) {
            view.offsetTopAndBottom(Math.min(n6 - view.getTop(), n7 - view.getBottom()));
        }
        this.fillAboveAndBelow(view, n5);
        if (!this.mStackFromBottom) {
            this.correctTooHigh(this.getChildCount());
            return view;
        }
        this.correctTooLow(this.getChildCount());
        return view;
    }

    private View fillFromTop(int n) {
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mSelectedPosition);
        this.mFirstPosition = Math.min(this.mFirstPosition, -1 + this.mItemCount);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        return this.fillDown(this.mFirstPosition, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillSpecific(int n, int n2) {
        View view;
        View view2;
        boolean bl = n == this.mSelectedPosition;
        View view3 = this.makeAndAddView(n, n2, true, this.mListPadding.left, bl);
        this.mFirstPosition = n;
        int n3 = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            view2 = this.fillUp(n - 1, view3.getTop() - n3);
            this.adjustViewsUpOrDown();
            view = this.fillDown(n + 1, n3 + view3.getBottom());
            int n4 = this.getChildCount();
            if (n4 > 0) {
                this.correctTooHigh(n4);
            }
        } else {
            view = this.fillDown(n + 1, n3 + view3.getBottom());
            this.adjustViewsUpOrDown();
            view2 = this.fillUp(n - 1, view3.getTop() - n3);
            int n5 = this.getChildCount();
            if (n5 > 0) {
                this.correctTooLow(n5);
            }
        }
        if (bl) {
            return view3;
        }
        if (view2 != null) {
            return view2;
        }
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private View fillUp(int n, int n2) {
        int n3 = 0x22 & this.mGroupFlags;
        int n4 = 0;
        View view = null;
        if (n3 == 34) {
            n4 = this.mListPadding.top;
        }
        while (n2 > n4 && n >= 0) {
            boolean bl = n == this.mSelectedPosition;
            int n5 = this.mListPadding.left;
            View view2 = this.makeAndAddView(n, n2, false, n5, bl);
            n2 = view2.getTop() - this.mDividerHeight;
            if (bl) {
                view = view2;
            }
            --n;
        }
        this.mFirstPosition = n + 1;
        this.setVisibleRangeHint(this.mFirstPosition, -1 + (this.mFirstPosition + this.getChildCount()));
        return view;
    }

    private int getArrowScrollPreviewLength() {
        return Math.max(2, this.getVerticalFadingEdgeLength());
    }

    private int getBottomSelectionPixel(int n, int n2, int n3) {
        int n4 = n;
        if (n3 != -1 + this.mItemCount) {
            n4 -= n2;
        }
        return n4;
    }

    private int getTopSelectionPixel(int n, int n2, int n3) {
        int n4 = n;
        if (n3 > 0) {
            n4 += n2;
        }
        return n4;
    }

    private boolean handleHorizontalFocusWithinListItem(int n) {
        View view;
        if (n != 17 && n != 66) {
            throw new IllegalArgumentException("direction must be one of {View.FOCUS_LEFT, View.FOCUS_RIGHT}");
        }
        int n2 = this.getChildCount();
        if (this.mItemsCanFocus && n2 > 0 && this.mSelectedPosition != -1 && (view = this.getSelectedView()) != null && view.hasFocus() && view instanceof ViewGroup) {
            View view2;
            View view3 = view.findFocus();
            View view4 = FocusFinder.getInstance().findNextFocus((ViewGroup)view, view3, n);
            if (view4 != null) {
                view3.getFocusedRect(this.mTempRect);
                this.offsetDescendantRectToMyCoords(view3, this.mTempRect);
                this.offsetRectIntoDescendantCoords(view4, this.mTempRect);
                if (view4.requestFocus(n, this.mTempRect)) {
                    return true;
                }
            }
            if ((view2 = FocusFinder.getInstance().findNextFocus((ViewGroup)this.getRootView(), view3, n)) != null) {
                return this.isViewAncestorOf(view2, this);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleNewSelectionChange(View view, int n, int n2, boolean bl) {
        boolean bl2;
        View view2;
        View view3;
        int n3;
        int n4;
        if (n2 == -1) {
            throw new IllegalArgumentException("newSelectedPosition needs to be valid");
        }
        int n5 = this.mSelectedPosition - this.mFirstPosition;
        int n6 = n2 - this.mFirstPosition;
        if (n == 33) {
            n4 = n6;
            n3 = n5;
            view3 = this.getChildAt(n4);
            view2 = view;
            bl2 = true;
        } else {
            n4 = n5;
            n3 = n6;
            view3 = view;
            view2 = this.getChildAt(n3);
            bl2 = false;
        }
        int n7 = this.getChildCount();
        if (view3 != null) {
            boolean bl3 = !bl && bl2;
            view3.setSelected(bl3);
            this.measureAndAdjustDown(view3, n4, n7);
        }
        if (view2 != null) {
            boolean bl4 = !bl && !bl2;
            view2.setSelected(bl4);
            this.measureAndAdjustDown(view2, n3, n7);
        }
    }

    private boolean isDirectChildHeaderOrFooter(View view) {
        ArrayList<FixedViewInfo> arrayList = this.mHeaderViewInfos;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (view != arrayList.get((int)i).view) continue;
            return true;
        }
        ArrayList<FixedViewInfo> arrayList2 = this.mFooterViewInfos;
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            if (view != arrayList2.get((int)i).view) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isViewAncestorOf(View view, View view2) {
        ViewParent viewParent;
        return view == view2 || (viewParent = view.getParent()) instanceof ViewGroup && this.isViewAncestorOf((View)((Object)viewParent), view2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int lookForSelectablePositionOnScreen(int n) {
        int n2;
        int n3 = this.mFirstPosition;
        if (n == 130) {
            int n4 = this.mSelectedPosition != -1 ? 1 + this.mSelectedPosition : n3;
            if (n4 >= this.mAdapter.getCount()) {
                return -1;
            }
            if (n4 < n3) {
                n4 = n3;
            }
            int n5 = this.getLastVisiblePosition();
            Adapter adapter = this.getAdapter();
            n2 = n4;
            while (n2 <= n5) {
                if (adapter.isEnabled(n2)) {
                    if (this.getChildAt(n2 - n3).getVisibility() == 0) return n2;
                }
                ++n2;
            }
            return -1;
        }
        int n6 = -1 + (n3 + this.getChildCount());
        int n7 = this.mSelectedPosition != -1 ? -1 + this.mSelectedPosition : -1 + (n3 + this.getChildCount());
        if (n7 < 0) return -1;
        if (n7 >= this.mAdapter.getCount()) {
            return -1;
        }
        if (n7 > n6) {
            n7 = n6;
        }
        Adapter adapter = this.getAdapter();
        n2 = n7;
        while (n2 >= n3) {
            if (adapter.isEnabled(n2)) {
                if (this.getChildAt(n2 - n3).getVisibility() == 0) return n2;
            }
            --n2;
        }
        return -1;
    }

    private View makeAndAddView(int n, int n2, boolean bl, int n3, boolean bl2) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.getActiveView(n)) != null) {
            this.setupChild(view, n, n2, bl, n3, bl2, true);
            return view;
        }
        View view2 = this.obtainView(n, this.mIsScrap);
        this.setupChild(view2, n, n2, bl, n3, bl2, this.mIsScrap[0]);
        return view2;
    }

    private void measureAndAdjustDown(View view, int n, int n2) {
        int n3 = view.getHeight();
        this.measureItem(view);
        if (view.getMeasuredHeight() != n3) {
            this.relayoutMeasuredItem(view);
            int n4 = view.getMeasuredHeight() - n3;
            for (int i = n + 1; i < n2; ++i) {
                this.getChildAt(i).offsetTopAndBottom(n4);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureItem(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, -2);
        }
        int n = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mListPadding.left + this.mListPadding.right, layoutParams.width);
        int n2 = layoutParams.height;
        int n3 = n2 > 0 ? View.MeasureSpec.makeMeasureSpec(n2, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
        view.measure(n, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureScrapChild(View view, int n, int n2) {
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = (AbsListView.LayoutParams)this.generateDefaultLayoutParams();
            view.setLayoutParams(layoutParams);
        }
        layoutParams.viewType = this.mAdapter.getItemViewType(n);
        layoutParams.forceAdd = true;
        int n3 = ViewGroup.getChildMeasureSpec(n2, this.mListPadding.left + this.mListPadding.right, layoutParams.width);
        int n4 = layoutParams.height;
        int n5 = n4 > 0 ? View.MeasureSpec.makeMeasureSpec(n4, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
        view.measure(n3, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View moveSelection(View view, View view2, int n, int n2, int n3) {
        int n4 = this.getVerticalFadingEdgeLength();
        int n5 = this.mSelectedPosition;
        int n6 = this.getTopSelectionPixel(n2, n4, n5);
        int n7 = this.getBottomSelectionPixel(n2, n4, n5);
        if (n > 0) {
            int n8 = this.mDividerHeight;
            View view3 = this.makeAndAddView(n5 - 1, view.getTop(), true, this.mListPadding.left, false);
            View view4 = this.makeAndAddView(n5, n8 + view3.getBottom(), true, this.mListPadding.left, true);
            if (view4.getBottom() > n7) {
                int n9 = view4.getTop() - n6;
                int n10 = view4.getBottom() - n7;
                int n11 = (n3 - n2) / 2;
                int n12 = Math.min(Math.min(n9, n10), n11);
                view3.offsetTopAndBottom(-n12);
                view4.offsetTopAndBottom(-n12);
            }
            if (!this.mStackFromBottom) {
                this.fillUp(-2 + this.mSelectedPosition, view4.getTop() - n8);
                this.adjustViewsUpOrDown();
                this.fillDown(1 + this.mSelectedPosition, n8 + view4.getBottom());
                return view4;
            }
            this.fillDown(1 + this.mSelectedPosition, n8 + view4.getBottom());
            this.adjustViewsUpOrDown();
            this.fillUp(-2 + this.mSelectedPosition, view4.getTop() - n8);
            return view4;
        }
        if (n < 0) {
            View view5 = view2 != null ? this.makeAndAddView(n5, view2.getTop(), true, this.mListPadding.left, true) : this.makeAndAddView(n5, view.getTop(), false, this.mListPadding.left, true);
            if (view5.getTop() < n6) {
                int n13 = n6 - view5.getTop();
                int n14 = n7 - view5.getBottom();
                int n15 = (n3 - n2) / 2;
                view5.offsetTopAndBottom(Math.min(Math.min(n13, n14), n15));
            }
            this.fillAboveAndBelow(view5, n5);
            return view5;
        }
        int n16 = view.getTop();
        View view6 = this.makeAndAddView(n5, n16, true, this.mListPadding.left, true);
        if (n16 < n2 && view6.getBottom() < n2 + 20) {
            view6.offsetTopAndBottom(n2 - view6.getTop());
        }
        this.fillAboveAndBelow(view6, n5);
        return view6;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int nextSelectedPositionForDirection(View view, int n, int n2) {
        boolean bl;
        int n3;
        if (n2 == 130) {
            int n4 = this.getHeight() - this.mListPadding.bottom;
            if (view == null) return -1;
            if (view.getBottom() > n4) return -1;
            n3 = n != -1 && n >= this.mFirstPosition ? n + 1 : this.mFirstPosition;
        } else {
            int n5 = this.mListPadding.top;
            if (view == null) return -1;
            if (view.getTop() < n5) return -1;
            int n6 = -1 + (this.mFirstPosition + this.getChildCount());
            n3 = n != -1 && n <= n6 ? n - 1 : n6;
        }
        if (n3 < 0) return -1;
        if (n3 >= this.mAdapter.getCount()) {
            return -1;
        }
        if (n2 == 130) {
            bl = true;
            return this.lookForSelectablePosition(n3, bl);
        }
        bl = false;
        return this.lookForSelectablePosition(n3, bl);
    }

    private int positionOfNewFocus(View view) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isViewAncestorOf(view, this.getChildAt(i))) continue;
            return i + this.mFirstPosition;
        }
        throw new IllegalArgumentException("newFocus is not a child of any of the children of the list!");
    }

    private void relayoutMeasuredItem(View view) {
        int n = view.getMeasuredWidth();
        int n2 = view.getMeasuredHeight();
        int n3 = this.mListPadding.left;
        int n4 = n3 + n;
        int n5 = view.getTop();
        view.layout(n3, n5, n4, n5 + n2);
    }

    private void removeFixedViewInfo(View view, ArrayList<FixedViewInfo> arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= n) break block3;
                    if (arrayList.get((int)n2).view != view) break block4;
                    arrayList.remove(n2);
                }
                return;
            }
            ++n2;
        }
    }

    private void scrollListItemsBy(int n) {
        this.offsetChildrenTopAndBottom(n);
        int n2 = this.getHeight() - this.mListPadding.bottom;
        int n3 = this.mListPadding.top;
        AbsListView.RecycleBin recycleBin = this.mRecycler;
        if (n < 0) {
            int n4;
            int n5 = this.getChildCount();
            View view = this.getChildAt(n5 - 1);
            while (view.getBottom() < n2 && (n4 = -1 + (n5 + this.mFirstPosition)) < -1 + this.mItemCount) {
                view = this.addViewBelow(view, n4);
                ++n5;
            }
            if (view.getBottom() < n2) {
                this.offsetChildrenTopAndBottom(n2 - view.getBottom());
            }
            View view2 = this.getChildAt(0);
            while (view2.getBottom() < n3) {
                if (recycleBin.shouldRecycleViewType(((AbsListView.LayoutParams)view2.getLayoutParams()).viewType)) {
                    recycleBin.addScrapView(view2, this.mFirstPosition);
                }
                this.detachViewFromParent(view2);
                view2 = this.getChildAt(0);
                this.mFirstPosition = 1 + this.mFirstPosition;
            }
        } else {
            View view = this.getChildAt(0);
            while (view.getTop() > n3 && this.mFirstPosition > 0) {
                view = this.addViewAbove(view, this.mFirstPosition);
                this.mFirstPosition = -1 + this.mFirstPosition;
            }
            if (view.getTop() > n3) {
                this.offsetChildrenTopAndBottom(n3 - view.getTop());
            }
            int n6 = -1 + this.getChildCount();
            View view3 = this.getChildAt(n6);
            while (view3.getTop() > n2) {
                if (recycleBin.shouldRecycleViewType(((AbsListView.LayoutParams)view3.getLayoutParams()).viewType)) {
                    recycleBin.addScrapView(view3, n6 + this.mFirstPosition);
                }
                this.detachViewFromParent(view3);
                view3 = this.getChildAt(--n6);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupChild(View view, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3) {
        Trace.traceBegin(8L, "setupListItem");
        boolean bl4 = bl2 && this.shouldShowSelector();
        boolean bl5 = bl4 != view.isSelected();
        int n4 = this.mTouchMode;
        boolean bl6 = n4 > 0 && n4 < 3 && this.mMotionPosition == n;
        boolean bl7 = bl6 != view.isPressed();
        boolean bl8 = !bl3 || bl5 || view.isLayoutRequested();
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = (AbsListView.LayoutParams)this.generateDefaultLayoutParams();
        }
        layoutParams.viewType = this.mAdapter.getItemViewType(n);
        if (bl3 && !layoutParams.forceAdd || layoutParams.recycledHeaderFooter && layoutParams.viewType == -2) {
            int n5 = bl ? -1 : 0;
            this.attachViewToParent(view, n5, layoutParams);
        } else {
            layoutParams.forceAdd = false;
            if (layoutParams.viewType == -2) {
                layoutParams.recycledHeaderFooter = true;
            }
            int n6 = bl ? -1 : 0;
            this.addViewInLayout(view, n6, layoutParams, true);
        }
        if (bl5) {
            view.setSelected(bl4);
        }
        if (bl7) {
            view.setPressed(bl6);
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            if (view instanceof Checkable) {
                ((Checkable)((Object)view)).setChecked(this.mCheckStates.get(n));
            } else if (this.getContext().getApplicationInfo().targetSdkVersion >= 11) {
                view.setActivated(this.mCheckStates.get(n));
            }
        }
        if (bl8) {
            int n7 = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mListPadding.left + this.mListPadding.right, layoutParams.width);
            int n8 = layoutParams.height;
            int n9 = n8 > 0 ? View.MeasureSpec.makeMeasureSpec(n8, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
            view.measure(n7, n9);
        } else {
            this.cleanupLayoutState(view);
        }
        int n10 = view.getMeasuredWidth();
        int n11 = view.getMeasuredHeight();
        int n12 = bl ? n2 : n2 - n11;
        if (bl8) {
            view.layout(n3, n12, n3 + n10, n12 + n11);
        } else {
            view.offsetLeftAndRight(n3 - view.getLeft());
            view.offsetTopAndBottom(n12 - view.getTop());
        }
        if (this.mCachingStarted && !view.isDrawingCacheEnabled()) {
            view.setDrawingCacheEnabled(true);
        }
        if (bl3 && ((AbsListView.LayoutParams)view.getLayoutParams()).scrappedFromPosition != n) {
            view.jumpDrawablesToCurrentState();
        }
        Trace.traceEnd(8L);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean shouldAdjustHeightForDivider(int n) {
        int n2 = this.mDividerHeight;
        Drawable drawable2 = this.mOverScrollHeader;
        Drawable drawable3 = this.mOverScrollFooter;
        boolean bl = drawable2 != null;
        boolean bl2 = drawable3 != null;
        if (n2 <= 0) return false;
        if (this.mDivider == null) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        boolean bl4 = this.isOpaque() && !super.isOpaque();
        int n3 = this.mItemCount;
        int n4 = this.mHeaderViewInfos.size();
        int n5 = n3 - this.mFooterViewInfos.size();
        boolean bl5 = n < n4;
        boolean bl6 = n >= n5;
        boolean bl7 = this.mHeaderDividersEnabled;
        boolean bl8 = this.mFooterDividersEnabled;
        if (!bl7) {
            if (bl5) return false;
        }
        if (!bl8) {
            if (bl6) return false;
        }
        ListAdapter listAdapter = this.mAdapter;
        if (!this.mStackFromBottom) {
            boolean bl9 = n == n3 - 1;
            if (bl2) {
                if (bl9) return false;
            }
            int n6 = n + 1;
            if (listAdapter.isEnabled(n) && (bl7 || !bl5 && n6 >= n4)) {
                if (bl9) return true;
                if (listAdapter.isEnabled(n6)) {
                    if (bl8) return true;
                    if (!bl6 && n6 < n5) {
                        return true;
                    }
                }
            }
            if (!bl4) return false;
            return true;
        }
        int n7 = bl ? 1 : 0;
        if (n == n7) {
            return false;
        }
        boolean bl10 = false;
        if (bl10) return false;
        int n8 = n - 1;
        if (listAdapter.isEnabled(n) && (bl7 || !bl5 && n8 >= n4)) {
            if (bl10) return true;
            if (listAdapter.isEnabled(n8)) {
                if (bl8) return true;
                if (!bl6 && n8 < n5) {
                    return true;
                }
            }
        }
        if (!bl4) return false;
        return true;
    }

    private boolean showingBottomFadingEdge() {
        int n = this.getChildCount();
        int n2 = this.getChildAt(n - 1).getBottom();
        int n3 = -1 + (n + this.mFirstPosition);
        int n4 = this.mScrollY + this.getHeight() - this.mListPadding.bottom;
        return n3 < -1 + this.mItemCount || n2 < n4;
    }

    private boolean showingTopFadingEdge() {
        boolean bl;
        block3: {
            block2: {
                int n = this.mScrollY + this.mListPadding.top;
                if (this.mFirstPosition > 0) break block2;
                int n2 = this.getChildAt(0).getTop();
                bl = false;
                if (n2 <= n) break block3;
            }
            bl = true;
        }
        return bl;
    }

    public void addFooterView(View view) {
        this.addFooterView(view, null, true);
    }

    public void addFooterView(View view, Object object, boolean bl) {
        FixedViewInfo fixedViewInfo = new FixedViewInfo();
        fixedViewInfo.view = view;
        fixedViewInfo.data = object;
        fixedViewInfo.isSelectable = bl;
        this.mFooterViewInfos.add(fixedViewInfo);
        this.mAreAllItemsSelectable = bl & this.mAreAllItemsSelectable;
        if (this.mAdapter != null) {
            if (!(this.mAdapter instanceof HeaderViewListAdapter)) {
                this.mAdapter = new HeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, this.mAdapter);
            }
            if (this.mDataSetObserver != null) {
                this.mDataSetObserver.onChanged();
            }
        }
    }

    public void addHeaderView(View view) {
        this.addHeaderView(view, null, true);
    }

    public void addHeaderView(View view, Object object, boolean bl) {
        FixedViewInfo fixedViewInfo = new FixedViewInfo();
        fixedViewInfo.view = view;
        fixedViewInfo.data = object;
        fixedViewInfo.isSelectable = bl;
        this.mHeaderViewInfos.add(fixedViewInfo);
        this.mAreAllItemsSelectable = bl & this.mAreAllItemsSelectable;
        if (this.mAdapter != null) {
            if (!(this.mAdapter instanceof HeaderViewListAdapter)) {
                this.mAdapter = new HeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, this.mAdapter);
            }
            if (this.mDataSetObserver != null) {
                this.mDataSetObserver.onChanged();
            }
        }
    }

    public boolean areFooterDividersEnabled() {
        return this.mFooterDividersEnabled;
    }

    public boolean areHeaderDividersEnabled() {
        return this.mHeaderDividersEnabled;
    }

    boolean arrowScroll(int n) {
        boolean bl;
        block4: {
            this.mInLayout = true;
            bl = this.arrowScrollImpl(n);
            if (!bl) break block4;
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(n));
        }
        return bl;
        finally {
            this.mInLayout = false;
        }
    }

    @Override
    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void dispatchDraw(Canvas var1_1) {
        block44: {
            block40: {
                block38: {
                    block37: {
                        block39: {
                            block36: {
                                block43: {
                                    block27: {
                                        block34: {
                                            block33: {
                                                block31: {
                                                    block30: {
                                                        block32: {
                                                            block29: {
                                                                block28: {
                                                                    block26: {
                                                                        block35: {
                                                                            block42: {
                                                                                block41: {
                                                                                    if (this.mCachingStarted) {
                                                                                        this.mCachingActive = true;
                                                                                    }
                                                                                    var2_2 = this.mDividerHeight;
                                                                                    var3_3 = this.mOverScrollHeader;
                                                                                    var4_4 = this.mOverScrollFooter;
                                                                                    if (var3_3 == null) break block41;
                                                                                    var5_5 = true;
lbl8:
                                                                                    // 2 sources

                                                                                    while (var4_4 != null) {
                                                                                        var6_6 = true;
lbl10:
                                                                                        // 2 sources

                                                                                        while (var2_2 > 0 && this.mDivider != null) {
                                                                                            var7_7 = true;
lbl12:
                                                                                            // 2 sources

                                                                                            while (var7_7 || var5_5 || var6_6) {
                                                                                                var8_8 = this.mTempRect;
                                                                                                var8_8.left = this.mPaddingLeft;
                                                                                                var8_8.right = this.mRight - this.mLeft - this.mPaddingRight;
                                                                                                var9_9 = this.getChildCount();
                                                                                                var10_10 = this.mHeaderViewInfos.size();
                                                                                                var11_11 = this.mItemCount;
                                                                                                var12_12 = var11_11 - this.mFooterViewInfos.size();
                                                                                                var13_13 = this.mHeaderDividersEnabled;
                                                                                                var14_14 = this.mFooterDividersEnabled;
                                                                                                var15_15 = this.mFirstPosition;
                                                                                                var17_16 = this.mAdapter;
                                                                                                if (!this.isOpaque() || super.isOpaque()) break block26;
                                                                                                var18_17 = true;
lbl27:
                                                                                                // 2 sources

                                                                                                while (true) {
                                                                                                    if (var18_17 && this.mDividerPaint == null && this.mIsCacheColorOpaque) {
                                                                                                        this.mDividerPaint = new Paint();
                                                                                                        this.mDividerPaint.setColor(this.getCacheColorHint());
                                                                                                    }
                                                                                                    var19_18 = this.mDividerPaint;
                                                                                                    var20_19 = 34 & this.mGroupFlags;
                                                                                                    var21_20 = 0;
                                                                                                    var22_21 = 0;
                                                                                                    if (var20_19 == 34) {
                                                                                                        var22_21 = this.mListPadding.top;
                                                                                                        var21_20 = this.mListPadding.bottom;
                                                                                                    }
                                                                                                    var23_22 = this.mBottom - this.mTop - var21_20 + this.mScrollY;
                                                                                                    if (this.mStackFromBottom) break block27;
                                                                                                    var34_23 = 0;
                                                                                                    var35_24 = this.mScrollY;
                                                                                                    if (var9_9 > 0 && var35_24 < 0) {
                                                                                                        if (!var5_5) break block28;
                                                                                                        var8_8.bottom = 0;
                                                                                                        var8_8.top = var35_24;
                                                                                                        this.drawOverscrollHeader(var1_1, var3_3, var8_8);
                                                                                                    }
lbl47:
                                                                                                    // 5 sources

                                                                                                    while (true) {
                                                                                                        block5: for (var36_25 = 0; var36_25 < var9_9; ++var36_25) {
                                                                                                            var38_26 = var15_15 + var36_25;
                                                                                                            if (var38_26 >= var10_10) break block29;
                                                                                                            var39_27 = true;
lbl52:
                                                                                                            // 2 sources

                                                                                                            while (var38_26 >= var12_12) {
                                                                                                                var40_28 = true;
lbl54:
                                                                                                                // 2 sources

                                                                                                                while (true) {
                                                                                                                    if (!var13_13 && var39_27 || !var14_14 && var40_28) ** GOTO lbl67
                                                                                                                    var34_23 = this.getChildAt(var36_25).getBottom();
                                                                                                                    var41_29 = var9_9 - 1;
                                                                                                                    if (var36_25 != var41_29) break block30;
                                                                                                                    var42_30 = true;
lbl60:
                                                                                                                    // 2 sources

                                                                                                                    while (true) {
                                                                                                                        if (!(!var7_7 || var34_23 >= var23_22 || var6_6 && var42_30)) {
                                                                                                                            var43_31 = var38_26 + 1;
                                                                                                                            if (!var17_16.isEnabled(var38_26) || !var13_13 && (var39_27 || var43_31 < var10_10) || !var42_30 && (!var17_16.isEnabled(var43_31) || !var14_14 && (var40_28 || var43_31 >= var12_12))) break block31;
                                                                                                                            var8_8.top = var34_23;
                                                                                                                            var8_8.bottom = var34_23 + var2_2;
                                                                                                                            this.drawDivider(var1_1, var8_8, var36_25);
                                                                                                                        }
lbl67:
                                                                                                                        // 6 sources

                                                                                                                        continue block5;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            break block32;
                                                                                                        }
                                                                                                        break block33;
                                                                                                        break;
                                                                                                    }
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            break block34;
                                                                                        }
                                                                                        break block35;
                                                                                    }
                                                                                    break block42;
                                                                                }
                                                                                var5_5 = false;
                                                                                ** GOTO lbl8
                                                                            }
                                                                            var6_6 = false;
                                                                            ** GOTO lbl10
                                                                        }
                                                                        var7_7 = false;
                                                                        ** GOTO lbl12
                                                                    }
                                                                    var18_17 = false;
                                                                    ** while (true)
                                                                }
                                                                if (!var7_7) ** GOTO lbl47
                                                                var8_8.bottom = 0;
                                                                var8_8.top = -var2_2;
                                                                this.drawDivider(var1_1, var8_8, -1);
                                                                ** while (true)
                                                            }
                                                            var39_27 = false;
                                                            ** GOTO lbl52
                                                        }
                                                        var40_28 = false;
                                                        ** while (true)
                                                    }
                                                    var42_30 = false;
                                                    ** while (true)
                                                }
                                                if (!var18_17) ** GOTO lbl67
                                                var8_8.top = var34_23;
                                                var8_8.bottom = var34_23 + var2_2;
                                                var1_1.drawRect(var8_8, var19_18);
                                                ** while (true)
                                            }
                                            var37_32 = this.mBottom + this.mScrollY;
                                            if (var6_6 && var15_15 + var9_9 == var11_11 && var37_32 > var34_23) {
                                                var8_8.top = var34_23;
                                                var8_8.bottom = var37_32;
                                                this.drawOverscrollFooter(var1_1, var4_4, var8_8);
                                            }
                                        }
lbl114:
                                        // 5 sources

                                        while (true) {
                                            super.dispatchDraw(var1_1);
                                            return;
                                        }
                                    }
                                    var24_33 = this.mScrollY;
                                    if (var9_9 > 0 && var5_5) {
                                        var8_8.top = var24_33;
                                        var8_8.bottom = this.getChildAt(0).getTop();
                                        this.drawOverscrollHeader(var1_1, var3_3, var8_8);
                                    }
                                    if (!var5_5) break block43;
                                    var25_34 = 1;
lbl125:
                                    // 2 sources

                                    while (true) {
                                        block12: for (var26_35 = var25_34; var26_35 < var9_9; ++var26_35) {
                                            var28_36 = var15_15 + var26_35;
                                            if (var28_36 >= var10_10) break block36;
                                            var29_37 = true;
lbl130:
                                            // 2 sources

                                            while (var28_36 >= var12_12) {
                                                var30_38 = true;
lbl132:
                                                // 2 sources

                                                while (true) {
                                                    if (!var13_13 && var29_37 || !var14_14 && var30_38) ** GOTO lbl144
                                                    var31_39 = this.getChildAt(var26_35).getTop();
                                                    if (!var7_7 || var31_39 <= var22_21) ** GOTO lbl144
                                                    if (var26_35 != var25_34) break block37;
                                                    var32_40 = true;
lbl138:
                                                    // 2 sources

                                                    while (true) {
                                                        var33_41 = var28_36 - 1;
                                                        if (!var17_16.isEnabled(var28_36) || !var13_13 && (var29_37 || var33_41 < var10_10) || !var32_40 && (!var17_16.isEnabled(var33_41) || !var14_14 && (var30_38 || var33_41 >= var12_12))) break block38;
                                                        var8_8.top = var31_39 - var2_2;
                                                        var8_8.bottom = var31_39;
                                                        this.drawDivider(var1_1, var8_8, var26_35 - 1);
lbl144:
                                                        // 5 sources

                                                        continue block12;
                                                        break;
                                                    }
                                                    break;
                                                }
                                            }
                                            break block39;
                                        }
                                        break block40;
                                        break;
                                    }
                                }
                                var25_34 = 0;
                                ** while (true)
                            }
                            var29_37 = false;
                            ** GOTO lbl130
                        }
                        var30_38 = false;
                        ** while (true)
                    }
                    var32_40 = false;
                    ** while (true)
                }
                if (!var18_17) ** GOTO lbl144
                var8_8.top = var31_39 - var2_2;
                var8_8.bottom = var31_39;
                var1_1.drawRect(var8_8, var19_18);
                ** while (true)
            }
            if (var9_9 <= 0 || var24_33 <= 0) ** GOTO lbl114
            if (!var6_6) break block44;
            var8_8.top = var27_42 = this.mBottom;
            var8_8.bottom = var27_42 + var24_33;
            this.drawOverscrollFooter(var1_1, var4_4, var8_8);
            ** GOTO lbl114
        }
        if (!var7_7) ** GOTO lbl114
        var8_8.top = var23_22;
        var8_8.bottom = var23_22 + var2_2;
        this.drawDivider(var1_1, var8_8, -1);
        ** while (true)
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = super.dispatchKeyEvent(keyEvent);
        if (!bl && this.getFocusedChild() != null && keyEvent.getAction() == 0) {
            bl = this.onKeyDown(keyEvent.getKeyCode(), keyEvent);
        }
        return bl;
    }

    @Override
    protected boolean drawChild(Canvas canvas, View view, long l) {
        boolean bl = super.drawChild(canvas, view, l);
        if (this.mCachingActive && view.mCachingFailed) {
            this.mCachingActive = false;
        }
        return bl;
    }

    void drawDivider(Canvas canvas, Rect rect, int n) {
        Drawable drawable2 = this.mDivider;
        drawable2.setBounds(rect);
        drawable2.draw(canvas);
    }

    void drawOverscrollFooter(Canvas canvas, Drawable drawable2, Rect rect) {
        int n = drawable2.getMinimumHeight();
        canvas.save();
        canvas.clipRect(rect);
        if (rect.bottom - rect.top < n) {
            rect.bottom = n + rect.top;
        }
        drawable2.setBounds(rect);
        drawable2.draw(canvas);
        canvas.restore();
    }

    void drawOverscrollHeader(Canvas canvas, Drawable drawable2, Rect rect) {
        int n = drawable2.getMinimumHeight();
        canvas.save();
        canvas.clipRect(rect);
        if (rect.bottom - rect.top < n) {
            rect.top = rect.bottom - n;
        }
        drawable2.setBounds(rect);
        drawable2.draw(canvas);
        canvas.restore();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void fillGap(boolean bl) {
        int n = this.getChildCount();
        if (bl) {
            int n2 = 0x22 & this.mGroupFlags;
            int n3 = 0;
            if (n2 == 34) {
                n3 = this.getListPaddingTop();
            }
            int n4 = n > 0 ? this.getChildAt(n - 1).getBottom() + this.mDividerHeight : n3;
            this.fillDown(n + this.mFirstPosition, n4);
            this.correctTooHigh(this.getChildCount());
            return;
        }
        int n5 = 0x22 & this.mGroupFlags;
        int n6 = 0;
        if (n5 == 34) {
            n6 = this.getListPaddingBottom();
        }
        int n7 = n > 0 ? this.getChildAt(0).getTop() - this.mDividerHeight : this.getHeight() - n6;
        this.fillUp(-1 + this.mFirstPosition, n7);
        this.correctTooLow(this.getChildCount());
    }

    @Override
    int findMotionRow(int n) {
        block4: {
            int n2 = this.getChildCount();
            if (n2 <= 0) break block4;
            if (!this.mStackFromBottom) {
                for (int i = 0; i < n2; ++i) {
                    if (n > this.getChildAt(i).getBottom()) continue;
                    return i + this.mFirstPosition;
                }
            } else {
                for (int i = n2 - 1; i >= 0; --i) {
                    if (n < this.getChildAt(i).getTop()) continue;
                    return i + this.mFirstPosition;
                }
            }
        }
        return -1;
    }

    View findViewByPredicateInHeadersOrFooters(ArrayList<FixedViewInfo> arrayList, Predicate<View> predicate, View view) {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                View view2;
                View view3 = arrayList.get((int)i).view;
                if (view3 == view || view3.isRootNamespace() || (view2 = view3.findViewByPredicate(predicate)) == null) continue;
                return view2;
            }
        }
        return null;
    }

    @Override
    protected View findViewByPredicateTraversal(Predicate<View> predicate, View view) {
        View view2 = super.findViewByPredicateTraversal(predicate, view);
        if (view2 == null) {
            View view3 = this.findViewByPredicateInHeadersOrFooters(this.mHeaderViewInfos, predicate, view);
            if (view3 != null) {
                return view3;
            }
            view2 = this.findViewByPredicateInHeadersOrFooters(this.mFooterViewInfos, predicate, view);
            if (view2 != null) {
                return view2;
            }
        }
        return view2;
    }

    View findViewInHeadersOrFooters(ArrayList<FixedViewInfo> arrayList, int n) {
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                View view;
                View view2 = arrayList.get((int)i).view;
                if (view2.isRootNamespace() || (view = view2.findViewById(n)) == null) continue;
                return view;
            }
        }
        return null;
    }

    @Override
    protected View findViewTraversal(int n) {
        View view = super.findViewTraversal(n);
        if (view == null) {
            View view2 = this.findViewInHeadersOrFooters(this.mHeaderViewInfos, n);
            if (view2 != null) {
                return view2;
            }
            view = this.findViewInHeadersOrFooters(this.mFooterViewInfos, n);
            if (view != null) {
                return view;
            }
        }
        return view;
    }

    View findViewWithTagInHeadersOrFooters(ArrayList<FixedViewInfo> arrayList, Object object) {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                View view;
                View view2 = arrayList.get((int)i).view;
                if (view2.isRootNamespace() || (view = view2.findViewWithTag(object)) == null) continue;
                return view;
            }
        }
        return null;
    }

    @Override
    protected View findViewWithTagTraversal(Object object) {
        View view = super.findViewWithTagTraversal(object);
        if (view == null) {
            View view2 = this.findViewWithTagInHeadersOrFooters(this.mHeaderViewInfos, object);
            if (view2 != null) {
                return view2;
            }
            view = this.findViewWithTagInHeadersOrFooters(this.mFooterViewInfos, object);
            if (view != null) {
                return view;
            }
        }
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean fullScroll(int n) {
        boolean bl;
        if (n == 33) {
            int n2 = this.mSelectedPosition;
            bl = false;
            if (n2 != 0) {
                int n3 = this.lookForSelectablePositionAfter(this.mSelectedPosition, 0, true);
                if (n3 >= 0) {
                    this.mLayoutMode = 1;
                    this.setSelectionInt(n3);
                    this.invokeOnItemScrollListener();
                }
                bl = true;
            }
        } else {
            bl = false;
            if (n == 130) {
                int n4 = -1 + this.mItemCount;
                int n5 = this.mSelectedPosition;
                bl = false;
                if (n5 < n4) {
                    int n6 = this.lookForSelectablePositionAfter(this.mSelectedPosition, n4, false);
                    if (n6 >= 0) {
                        this.mLayoutMode = 3;
                        this.setSelectionInt(n6);
                        this.invokeOnItemScrollListener();
                    }
                    bl = true;
                }
            }
        }
        if (bl && !this.awakenScrollBars()) {
            this.awakenScrollBars();
            this.invalidate();
        }
        return bl;
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public long[] getCheckItemIds() {
        if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
            return this.getCheckedItemIds();
        }
        if (this.mChoiceMode == 0) return new long[0];
        if (this.mCheckStates == null) return new long[0];
        if (this.mAdapter == null) return new long[0];
        SparseBooleanArray sparseBooleanArray = this.mCheckStates;
        int n = sparseBooleanArray.size();
        long[] lArray = new long[n];
        ListAdapter listAdapter = this.mAdapter;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (sparseBooleanArray.valueAt(i)) {
                n3 = n2 + 1;
                lArray[n2] = listAdapter.getItemId(sparseBooleanArray.keyAt(i));
            } else {
                n3 = n2;
            }
            n2 = n3;
        }
        if (n2 == n) return lArray;
        long[] lArray2 = new long[n2];
        System.arraycopy((long[])lArray, (int)0, (long[])lArray2, (int)0, (int)n2);
        return lArray2;
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public int getDividerHeight() {
        return this.mDividerHeight;
    }

    @Override
    public int getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    @Override
    public int getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    @Override
    int getHeightForPosition(int n) {
        int n2 = super.getHeightForPosition(n);
        if (this.shouldAdjustHeightForDivider(n)) {
            n2 += this.mDividerHeight;
        }
        return n2;
    }

    public boolean getItemsCanFocus() {
        return this.mItemsCanFocus;
    }

    public int getMaxScrollAmount() {
        return (int)(0.33f * (float)(this.mBottom - this.mTop));
    }

    public Drawable getOverscrollFooter() {
        return this.mOverScrollFooter;
    }

    public Drawable getOverscrollHeader() {
        return this.mOverScrollHeader;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isOpaque() {
        if (!(this.mCachingActive && this.mIsCacheColorOpaque && this.mDividerIsOpaque && this.hasOpaqueScrollbars())) {
            if (!super.isOpaque()) return false;
        }
        boolean bl = true;
        if (!bl) return bl;
        int n = this.mListPadding != null ? this.mListPadding.top : this.mPaddingTop;
        View view = this.getChildAt(0);
        if (view == null) return false;
        if (view.getTop() > n) {
            return false;
        }
        int n2 = this.getHeight();
        int n3 = this.mListPadding != null ? this.mListPadding.bottom : this.mPaddingBottom;
        int n4 = n2 - n3;
        View view2 = this.getChildAt(-1 + this.getChildCount());
        if (view2 == null) return false;
        if (view2.getBottom() >= n4) return bl;
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void layoutChildren() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 9[TRYBLOCK] [13 : 417->425)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    int lookForSelectablePosition(int n, boolean bl) {
        block10: {
            block9: {
                ListAdapter listAdapter = this.mAdapter;
                if (listAdapter == null || this.isInTouchMode()) break block9;
                int n2 = listAdapter.getCount();
                if (!this.mAreAllItemsSelectable) {
                    if (bl) {
                        for (n = Math.max(0, n); n < n2 && !listAdapter.isEnabled(n); ++n) {
                        }
                    } else {
                        for (n = Math.min(n, n2 - 1); n >= 0 && !listAdapter.isEnabled(n); --n) {
                        }
                    }
                }
                if (n >= 0 && n < n2) break block10;
            }
            return -1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int lookForSelectablePositionAfter(int n, int n2, boolean bl) {
        int n3;
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) return -1;
        if (this.isInTouchMode()) {
            return -1;
        }
        int n4 = this.lookForSelectablePosition(n2, bl);
        if (n4 != -1) return n4;
        int n5 = listAdapter.getCount();
        int n6 = MathUtils.constrain(n, -1, n5 - 1);
        if (bl) {
            for (n3 = Math.min(n2 - 1, n5 - 1); n3 > n6 && !listAdapter.isEnabled(n3); --n3) {
            }
            if (n3 > n6) return n3;
            return -1;
        }
        for (n3 = Math.max(0, n2 + 1); n3 < n6 && !listAdapter.isEnabled(n3); ++n3) {
        }
        if (n3 < n6) return n3;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int measureHeightOfChildren(int n, int n2, int n3, int n4, int n5) {
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) {
            return this.mListPadding.top + this.mListPadding.bottom;
        }
        int n6 = this.mListPadding.top + this.mListPadding.bottom;
        int n7 = this.mDividerHeight > 0 && this.mDivider != null ? this.mDividerHeight : 0;
        int n8 = 0;
        if (n3 == -1) {
            n3 = -1 + listAdapter.getCount();
        }
        AbsListView.RecycleBin recycleBin = this.mRecycler;
        boolean bl = this.recycleOnMeasure();
        boolean[] blArray = this.mIsScrap;
        int n9 = n2;
        while (n9 <= n3) {
            View view = this.obtainView(n9, blArray);
            this.measureScrapChild(view, n9, n);
            if (n9 > 0) {
                n6 += n7;
            }
            if (bl && recycleBin.shouldRecycleViewType(((AbsListView.LayoutParams)view.getLayoutParams()).viewType)) {
                recycleBin.addScrapView(view, -1);
            }
            if ((n6 += view.getMeasuredHeight()) >= n4) {
                if (n5 < 0) return n4;
                if (n9 <= n5) return n4;
                if (n8 <= 0) return n4;
                if (n6 != n4) return n8;
                return n4;
            }
            if (n5 >= 0 && n9 >= n5) {
                n8 = n6;
            }
            ++n9;
        }
        return n6;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        int n = this.getChildCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.addHeaderView(this.getChildAt(i));
            }
            this.removeAllViews();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        ListAdapter listAdapter = this.mAdapter;
        int n2 = -1;
        int n3 = 0;
        if (listAdapter != null) {
            n3 = 0;
            if (bl) {
                n3 = 0;
                if (rect != null) {
                    rect.offset(this.mScrollX, this.mScrollY);
                    if (listAdapter.getCount() < this.getChildCount() + this.mFirstPosition) {
                        this.mLayoutMode = 0;
                        this.layoutChildren();
                    }
                    Rect rect2 = this.mTempRect;
                    int n4 = Integer.MAX_VALUE;
                    int n5 = this.getChildCount();
                    int n6 = this.mFirstPosition;
                    for (int i = 0; i < n5; ++i) {
                        if (!listAdapter.isEnabled(n6 + i)) continue;
                        View view = this.getChildAt(i);
                        view.getDrawingRect(rect2);
                        this.offsetDescendantRectToMyCoords(view, rect2);
                        int n7 = ListView.getDistance(rect, rect2, n);
                        if (n7 >= n4) continue;
                        n4 = n7;
                        n2 = i;
                        n3 = view.getTop();
                    }
                }
            }
        }
        if (n2 >= 0) {
            this.setSelectionFromTop(n2 + this.mFirstPosition, n3);
            return;
        }
        this.requestLayout();
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ListView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ListView.class.getName());
        accessibilityNodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(this.getCount(), 1, false, this.getSelectionModeForAccessibility()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInitializeAccessibilityNodeInfoForItem(View view, int n, AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfoForItem(view, n, accessibilityNodeInfo);
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)view.getLayoutParams();
        boolean bl = layoutParams != null && layoutParams.viewType != -2;
        accessibilityNodeInfo.setCollectionItemInfo(AccessibilityNodeInfo.CollectionItemInfo.obtain(n, 1, 0, 1, bl, this.isItemChecked(n)));
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.commonKey(n, 1, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.commonKey(n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.commonKey(n, 1, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        block6: {
            block7: {
                super.onMeasure(n, n2);
                n9 = View.MeasureSpec.getMode(n);
                n8 = View.MeasureSpec.getMode(n2);
                n7 = View.MeasureSpec.getSize(n);
                n6 = View.MeasureSpec.getSize(n2);
                int n10 = this.mAdapter == null ? 0 : this.mAdapter.getCount();
                int n11 = this.mItemCount = n10;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                if (n11 <= 0) break block6;
                if (n9 == 0) break block7;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                if (n8 != 0) break block6;
            }
            View view = this.obtainView(0, this.mIsScrap);
            this.measureScrapChild(view, 0, n);
            n3 = view.getMeasuredWidth();
            n5 = view.getMeasuredHeight();
            n4 = ListView.combineMeasuredStates(0, view.getMeasuredState());
            if (this.recycleOnMeasure() && this.mRecycler.shouldRecycleViewType(((AbsListView.LayoutParams)view.getLayoutParams()).viewType)) {
                this.mRecycler.addScrapView(view, 0);
            }
        }
        int n12 = n9 == 0 ? n3 + (this.mListPadding.left + this.mListPadding.right) + this.getVerticalScrollbarWidth() : n7 | 0xFF000000 & n4;
        if (n8 == 0) {
            n6 = n5 + (this.mListPadding.top + this.mListPadding.bottom) + 2 * this.getVerticalFadingEdgeLength();
        }
        if (n8 == Integer.MIN_VALUE) {
            n6 = this.measureHeightOfChildren(n, 0, -1, n6, -1);
        }
        this.setMeasuredDimension(n12, n6);
        this.mWidthMeasureSpec = n;
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        View view;
        if (this.getChildCount() > 0 && (view = this.getFocusedChild()) != null) {
            int n5 = this.mFirstPosition + this.indexOfChild(view);
            int n6 = Math.max(0, view.getBottom() - (n2 - this.mPaddingTop));
            int n7 = view.getTop() - n6;
            if (this.mFocusSelector == null) {
                this.mFocusSelector = new FocusSelector();
            }
            this.post(this.mFocusSelector.setup(n5, n7));
        }
        super.onSizeChanged(n, n2, n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean pageScroll(int n) {
        boolean bl;
        boolean bl2;
        int n2;
        if (n == 33) {
            n2 = Math.max(0, -1 + (this.mSelectedPosition - this.getChildCount()));
            bl2 = false;
        } else {
            bl = false;
            if (n != 130) return bl;
            n2 = Math.min(-1 + this.mItemCount, -1 + (this.mSelectedPosition + this.getChildCount()));
            bl2 = true;
        }
        bl = false;
        if (n2 < 0) return bl;
        int n3 = this.lookForSelectablePositionAfter(this.mSelectedPosition, n2, bl2);
        bl = false;
        if (n3 < 0) return bl;
        this.mLayoutMode = 4;
        this.mSpecificTop = this.mPaddingTop + this.getVerticalFadingEdgeLength();
        if (bl2 && n3 > this.mItemCount - this.getChildCount()) {
            this.mLayoutMode = 3;
        }
        if (!bl2 && n3 < this.getChildCount()) {
            this.mLayoutMode = 1;
        }
        this.setSelectionInt(n3);
        this.invokeOnItemScrollListener();
        if (this.awakenScrollBars()) return true;
        this.invalidate();
        return true;
    }

    @ViewDebug.ExportedProperty(category="list")
    protected boolean recycleOnMeasure() {
        return true;
    }

    public boolean removeFooterView(View view) {
        if (this.mFooterViewInfos.size() > 0) {
            ListAdapter listAdapter = this.mAdapter;
            boolean bl = false;
            if (listAdapter != null) {
                boolean bl2 = ((HeaderViewListAdapter)this.mAdapter).removeFooter(view);
                bl = false;
                if (bl2) {
                    if (this.mDataSetObserver != null) {
                        this.mDataSetObserver.onChanged();
                    }
                    bl = true;
                }
            }
            this.removeFixedViewInfo(view, this.mFooterViewInfos);
            return bl;
        }
        return false;
    }

    public boolean removeHeaderView(View view) {
        if (this.mHeaderViewInfos.size() > 0) {
            ListAdapter listAdapter = this.mAdapter;
            boolean bl = false;
            if (listAdapter != null) {
                boolean bl2 = ((HeaderViewListAdapter)this.mAdapter).removeHeader(view);
                bl = false;
                if (bl2) {
                    if (this.mDataSetObserver != null) {
                        this.mDataSetObserver.onChanged();
                    }
                    bl = true;
                }
            }
            this.removeFixedViewInfo(view, this.mHeaderViewInfos);
            return bl;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        int n;
        int n2 = rect.top;
        rect.offset(view.getLeft(), view.getTop());
        rect.offset(-view.getScrollX(), -view.getScrollY());
        int n3 = this.getHeight();
        int n4 = this.getScrollY();
        int n5 = n4 + n3;
        int n6 = this.getVerticalFadingEdgeLength();
        if (this.showingTopFadingEdge() && (this.mSelectedPosition > 0 || n2 > n6)) {
            n4 += n6;
        }
        int n7 = this.getChildAt(-1 + this.getChildCount()).getBottom();
        if (this.showingBottomFadingEdge() && (this.mSelectedPosition < -1 + this.mItemCount || rect.bottom < n7 - n6)) {
            n5 -= n6;
        }
        if (rect.bottom > n5 && rect.top > n4) {
            int n8 = rect.height() > n3 ? 0 + (rect.top - n4) : 0 + (rect.bottom - n5);
            n = Math.min(n8, n7 - n5);
        } else {
            int n9 = rect.top;
            n = 0;
            if (n9 < n4) {
                int n10 = rect.bottom;
                n = 0;
                if (n10 < n5) {
                    int n11 = rect.height() > n3 ? 0 - (n5 - rect.bottom) : 0 - (n4 - rect.top);
                    n = Math.max(n11, this.getChildAt(0).getTop() - n4);
                }
            }
        }
        if (n == 0) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        this.scrollListItemsBy(-n);
        this.positionSelector(-1, view);
        this.mSelectedTop = view.getTop();
        this.invalidate();
        return bl2;
    }

    @Override
    void resetList() {
        this.clearRecycledState(this.mHeaderViewInfos);
        this.clearRecycledState(this.mFooterViewInfos);
        super.resetList();
        this.mLayoutMode = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(ListAdapter listAdapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0 ? new HeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, listAdapter) : listAdapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        super.setAdapter(listAdapter);
        if (this.mAdapter != null) {
            this.mAreAllItemsSelectable = this.mAdapter.areAllItemsEnabled();
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new AbsListView.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
            int n = this.mStackFromBottom ? this.lookForSelectablePosition(-1 + this.mItemCount, false) : this.lookForSelectablePosition(0, true);
            this.setSelectedPositionInt(n);
            this.setNextSelectedPositionInt(n);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.mAreAllItemsSelectable = true;
            this.checkFocus();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCacheColorHint(int n) {
        boolean bl = n >>> 24 == 255;
        this.mIsCacheColorOpaque = bl;
        if (bl) {
            if (this.mDividerPaint == null) {
                this.mDividerPaint = new Paint();
            }
            this.mDividerPaint.setColor(n);
        }
        super.setCacheColorHint(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDivider(Drawable drawable2) {
        boolean bl;
        block3: {
            block2: {
                this.mDividerHeight = drawable2 != null ? drawable2.getIntrinsicHeight() : 0;
                this.mDivider = drawable2;
                if (drawable2 == null) break block2;
                int n = drawable2.getOpacity();
                bl = false;
                if (n != -1) break block3;
            }
            bl = true;
        }
        this.mDividerIsOpaque = bl;
        this.requestLayout();
        this.invalidate();
    }

    public void setDividerHeight(int n) {
        this.mDividerHeight = n;
        this.requestLayout();
        this.invalidate();
    }

    public void setFooterDividersEnabled(boolean bl) {
        this.mFooterDividersEnabled = bl;
        this.invalidate();
    }

    public void setHeaderDividersEnabled(boolean bl) {
        this.mHeaderDividersEnabled = bl;
        this.invalidate();
    }

    public void setItemsCanFocus(boolean bl) {
        this.mItemsCanFocus = bl;
        if (!bl) {
            this.setDescendantFocusability(393216);
        }
    }

    public void setOverscrollFooter(Drawable drawable2) {
        this.mOverScrollFooter = drawable2;
        this.invalidate();
    }

    public void setOverscrollHeader(Drawable drawable2) {
        this.mOverScrollHeader = drawable2;
        if (this.mScrollY < 0) {
            this.invalidate();
        }
    }

    @Override
    @RemotableViewMethod
    public void setRemoteViewsAdapter(Intent intent) {
        super.setRemoteViewsAdapter(intent);
    }

    @Override
    public void setSelection(int n) {
        this.setSelectionFromTop(n, 0);
    }

    public void setSelectionAfterHeaderView() {
        int n = this.mHeaderViewInfos.size();
        if (n > 0) {
            this.mNextSelectedPosition = 0;
            return;
        }
        if (this.mAdapter != null) {
            this.setSelection(n);
            return;
        }
        this.mNextSelectedPosition = n;
        this.mLayoutMode = 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void setSelectionInt(int n) {
        this.setNextSelectedPositionInt(n);
        int n2 = this.mSelectedPosition;
        boolean bl = false;
        if (n2 >= 0) {
            if (n == n2 - 1) {
                bl = true;
            } else {
                int n3 = n2 + 1;
                bl = false;
                if (n == n3) {
                    bl = true;
                }
            }
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.layoutChildren();
        if (bl) {
            this.awakenScrollBars();
        }
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollByOffset(int n) {
        super.smoothScrollByOffset(n);
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollToPosition(int n) {
        super.smoothScrollToPosition(n);
    }

    private static class ArrowScrollFocusResult {
        private int mAmountToScroll;
        private int mSelectedPosition;

        private ArrowScrollFocusResult() {
        }

        public int getAmountToScroll() {
            return this.mAmountToScroll;
        }

        public int getSelectedPosition() {
            return this.mSelectedPosition;
        }

        void populate(int n, int n2) {
            this.mSelectedPosition = n;
            this.mAmountToScroll = n2;
        }
    }

    public class FixedViewInfo {
        public Object data;
        public boolean isSelectable;
        public View view;
    }

    private class FocusSelector
    implements Runnable {
        private int mPosition;
        private int mPositionTop;

        private FocusSelector() {
        }

        @Override
        public void run() {
            ListView.this.setSelectionFromTop(this.mPosition, this.mPositionTop);
        }

        public FocusSelector setup(int n, int n2) {
            this.mPosition = n;
            this.mPositionTop = n2;
            return this;
        }
    }
}

