/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class LinearLayout
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_FILL = 3;
    private static final int INDEX_TOP = 1;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_END = 4;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int VERTICAL = 1;
    private static final int VERTICAL_GRAVITY_COUNT = 4;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mBaselineAligned = true;
    @ViewDebug.ExportedProperty(category="layout")
    private int mBaselineAlignedChildIndex = -1;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mBaselineChildTop = 0;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mDividerWidth;
    @ViewDebug.ExportedProperty(category="measurement", flagMapping={@ViewDebug.FlagToString(equals=-1, mask=-1, name="NONE"), @ViewDebug.FlagToString(equals=0, mask=0, name="NONE"), @ViewDebug.FlagToString(equals=48, mask=48, name="TOP"), @ViewDebug.FlagToString(equals=80, mask=80, name="BOTTOM"), @ViewDebug.FlagToString(equals=3, mask=3, name="LEFT"), @ViewDebug.FlagToString(equals=5, mask=5, name="RIGHT"), @ViewDebug.FlagToString(equals=0x800003, mask=0x800003, name="START"), @ViewDebug.FlagToString(equals=0x800005, mask=0x800005, name="END"), @ViewDebug.FlagToString(equals=16, mask=16, name="CENTER_VERTICAL"), @ViewDebug.FlagToString(equals=112, mask=112, name="FILL_VERTICAL"), @ViewDebug.FlagToString(equals=1, mask=1, name="CENTER_HORIZONTAL"), @ViewDebug.FlagToString(equals=7, mask=7, name="FILL_HORIZONTAL"), @ViewDebug.FlagToString(equals=17, mask=17, name="CENTER"), @ViewDebug.FlagToString(equals=119, mask=119, name="FILL"), @ViewDebug.FlagToString(equals=0x800000, mask=0x800000, name="RELATIVE")}, formatToHexString=true)
    private int mGravity = 0x800033;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mOrientation;
    private int mShowDividers;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mTotalLength;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mUseLargestChild;
    @ViewDebug.ExportedProperty(category="layout")
    private float mWeightSum;

    public LinearLayout(Context context) {
        this(context, null);
    }

    public LinearLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LinearLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public LinearLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        boolean bl;
        int n3;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LinearLayout, n, n2);
        int n4 = typedArray.getInt(1, -1);
        if (n4 >= 0) {
            this.setOrientation(n4);
        }
        if ((n3 = typedArray.getInt(0, -1)) >= 0) {
            this.setGravity(n3);
        }
        if (!(bl = typedArray.getBoolean(2, true))) {
            this.setBaselineAligned(bl);
        }
        this.mWeightSum = typedArray.getFloat(4, -1.0f);
        this.mBaselineAlignedChildIndex = typedArray.getInt(3, -1);
        this.mUseLargestChild = typedArray.getBoolean(6, false);
        this.setDividerDrawable(typedArray.getDrawable(5));
        this.mShowDividers = typedArray.getInt(7, 0);
        this.mDividerPadding = typedArray.getDimensionPixelSize(8, 0);
        typedArray.recycle();
    }

    private void forceUniformHeight(int n, int n2) {
        int n3 = View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000);
        for (int i = 0; i < n; ++i) {
            View view = this.getVirtualChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.height != -1) continue;
            int n4 = layoutParams.width;
            layoutParams.width = view.getMeasuredWidth();
            this.measureChildWithMargins(view, n2, 0, n3, 0);
            layoutParams.width = n4;
        }
    }

    private void forceUniformWidth(int n, int n2) {
        int n3 = View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        for (int i = 0; i < n; ++i) {
            View view = this.getVirtualChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.width != -1) continue;
            int n4 = layoutParams.height;
            layoutParams.height = view.getMeasuredHeight();
            this.measureChildWithMargins(view, n3, 0, n2, 0);
            layoutParams.height = n4;
        }
    }

    private void setChildFrame(View view, int n, int n2, int n3, int n4) {
        view.layout(n, n2, n + n3, n2 + n4);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawDividersHorizontal(Canvas canvas) {
        int n = this.getVirtualChildCount();
        boolean bl = this.isLayoutRtl();
        for (int i = 0; i < n; ++i) {
            View view = this.getVirtualChildAt(i);
            if (view == null || view.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n2 = bl ? view.getRight() + layoutParams.rightMargin : view.getLeft() - layoutParams.leftMargin - this.mDividerWidth;
            this.drawVerticalDivider(canvas, n2);
        }
        if (this.hasDividerBeforeChildAt(n)) {
            int n3;
            View view = this.getVirtualChildAt(n - 1);
            if (view == null) {
                n3 = bl ? this.getPaddingLeft() : this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
            } else {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                n3 = bl ? view.getLeft() - layoutParams.leftMargin - this.mDividerWidth : view.getRight() + layoutParams.rightMargin;
            }
            this.drawVerticalDivider(canvas, n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawDividersVertical(Canvas canvas) {
        int n = this.getVirtualChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getVirtualChildAt(i);
            if (view == null || view.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            this.drawHorizontalDivider(canvas, view.getTop() - layoutParams.topMargin - this.mDividerHeight);
        }
        if (this.hasDividerBeforeChildAt(n)) {
            int n2;
            View view = this.getVirtualChildAt(n - 1);
            if (view == null) {
                n2 = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                n2 = view.getBottom() + layoutParams.bottomMargin;
            }
            this.drawHorizontalDivider(canvas, n2);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int n) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, n, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, n + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int n) {
        this.mDivider.setBounds(n, this.getPaddingTop() + this.mDividerPadding, n + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -2);
        }
        if (this.mOrientation == 1) {
            return new LayoutParams(-1, -2);
        }
        return null;
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getBaseline() {
        int n = -1;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        if (this.getChildCount() <= this.mBaselineAlignedChildIndex) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        View view = this.getChildAt(this.mBaselineAlignedChildIndex);
        int n2 = view.getBaseline();
        if (n2 == n) {
            if (this.mBaselineAlignedChildIndex == 0) return n;
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
        }
        int n3 = this.mBaselineChildTop;
        if (this.mOrientation != 1) return n2 + (n3 + ((LayoutParams)view.getLayoutParams()).topMargin);
        int n4 = 0x70 & this.mGravity;
        if (n4 == 48) return n2 + (n3 + ((LayoutParams)view.getLayoutParams()).topMargin);
        switch (n4) {
            case 80: {
                n3 = this.mBottom - this.mTop - this.mPaddingBottom - this.mTotalLength;
            }
            default: {
                return n2 + (n3 + ((LayoutParams)view.getLayoutParams()).topMargin);
            }
            case 16: 
        }
        return n2 + ((n3 += (this.mBottom - this.mTop - this.mPaddingTop - this.mPaddingBottom - this.mTotalLength) / 2) + ((LayoutParams)view.getLayoutParams()).topMargin);
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    int getChildrenSkipCount(View view, int n) {
        return 0;
    }

    public Drawable getDividerDrawable() {
        return this.mDivider;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    int getLocationOffset(View view) {
        return 0;
    }

    int getNextLocationOffset(View view) {
        return 0;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    View getVirtualChildAt(int n) {
        return this.getChildAt(n);
    }

    int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasDividerBeforeChildAt(int n) {
        if (n == 0) {
            if ((1 & this.mShowDividers) == 0) return false;
            return true;
        }
        if (n == this.getChildCount()) {
            if ((4 & this.mShowDividers) != 0) return true;
            return false;
        }
        if ((2 & this.mShowDividers) == 0) return false;
        int n2 = n - 1;
        while (true) {
            boolean bl = false;
            if (n2 < 0) return bl;
            if (this.getChildAt(n2).getVisibility() != 8) {
                return true;
            }
            --n2;
        }
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    /*
     * Enabled aggressive block sorting
     */
    void layoutHorizontal(int n, int n2, int n3, int n4) {
        int n5;
        boolean bl = this.isLayoutRtl();
        int n6 = this.mPaddingTop;
        int n7 = n4 - n2;
        int n8 = n7 - this.mPaddingBottom;
        int n9 = n7 - n6 - this.mPaddingBottom;
        int n10 = this.getVirtualChildCount();
        int n11 = 0x800007 & this.mGravity;
        int n12 = 0x70 & this.mGravity;
        boolean bl2 = this.mBaselineAligned;
        int[] nArray = this.mMaxAscent;
        int[] nArray2 = this.mMaxDescent;
        switch (Gravity.getAbsoluteGravity(n11, this.getLayoutDirection())) {
            default: {
                n5 = this.mPaddingLeft;
                break;
            }
            case 5: {
                n5 = n3 + this.mPaddingLeft - n - this.mTotalLength;
                break;
            }
            case 1: {
                n5 = this.mPaddingLeft + (n3 - n - this.mTotalLength) / 2;
            }
        }
        int n13 = 1;
        int n14 = 0;
        if (bl) {
            n14 = n10 - 1;
            n13 = -1;
        }
        for (int i = 0; i < n10; ++i) {
            int n15;
            int n16;
            int n17 = n14 + n13 * i;
            View view = this.getVirtualChildAt(n17);
            if (view == null) {
                n5 += this.measureNullChild(n17);
                continue;
            }
            if (view.getVisibility() == 8) continue;
            int n18 = view.getMeasuredWidth();
            int n19 = view.getMeasuredHeight();
            int n20 = -1;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (bl2 && layoutParams.height != -1) {
                n20 = view.getBaseline();
            }
            if ((n16 = layoutParams.gravity) < 0) {
                n16 = n12;
            }
            switch (n16 & 0x70) {
                default: {
                    n15 = n6;
                    break;
                }
                case 48: {
                    n15 = n6 + layoutParams.topMargin;
                    if (n20 == -1) break;
                    n15 += nArray[1] - n20;
                    break;
                }
                case 16: {
                    n15 = n6 + (n9 - n19) / 2 + layoutParams.topMargin - layoutParams.bottomMargin;
                    break;
                }
                case 80: {
                    n15 = n8 - n19 - layoutParams.bottomMargin;
                    if (n20 == -1) break;
                    int n21 = view.getMeasuredHeight() - n20;
                    n15 -= nArray2[2] - n21;
                }
            }
            if (this.hasDividerBeforeChildAt(n17)) {
                n5 += this.mDividerWidth;
            }
            int n22 = n5 + layoutParams.leftMargin;
            this.setChildFrame(view, n22 + this.getLocationOffset(view), n15, n18, n19);
            n5 = n22 + (n18 + layoutParams.rightMargin + this.getNextLocationOffset(view));
            i += this.getChildrenSkipCount(view, n17);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void layoutVertical(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.mPaddingLeft;
        int n7 = n3 - n;
        int n8 = n7 - this.mPaddingRight;
        int n9 = n7 - n6 - this.mPaddingRight;
        int n10 = this.getVirtualChildCount();
        int n11 = 0x70 & this.mGravity;
        int n12 = 0x800007 & this.mGravity;
        switch (n11) {
            default: {
                n5 = this.mPaddingTop;
                break;
            }
            case 80: {
                n5 = n4 + this.mPaddingTop - n2 - this.mTotalLength;
                break;
            }
            case 16: {
                n5 = this.mPaddingTop + (n4 - n2 - this.mTotalLength) / 2;
            }
        }
        for (int i = 0; i < n10; ++i) {
            int n13;
            View view = this.getVirtualChildAt(i);
            if (view == null) {
                n5 += this.measureNullChild(i);
                continue;
            }
            if (view.getVisibility() == 8) continue;
            int n14 = view.getMeasuredWidth();
            int n15 = view.getMeasuredHeight();
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n16 = layoutParams.gravity;
            if (n16 < 0) {
                n16 = n12;
            }
            switch (7 & Gravity.getAbsoluteGravity(n16, this.getLayoutDirection())) {
                default: {
                    n13 = n6 + layoutParams.leftMargin;
                    break;
                }
                case 1: {
                    n13 = n6 + (n9 - n14) / 2 + layoutParams.leftMargin - layoutParams.rightMargin;
                    break;
                }
                case 5: {
                    n13 = n8 - n14 - layoutParams.rightMargin;
                }
            }
            if (this.hasDividerBeforeChildAt(i)) {
                n5 += this.mDividerHeight;
            }
            int n17 = n5 + layoutParams.topMargin;
            this.setChildFrame(view, n13, n17 + this.getLocationOffset(view), n14, n15);
            n5 = n17 + (n15 + layoutParams.bottomMargin + this.getNextLocationOffset(view));
            i += this.getChildrenSkipCount(view, i);
        }
    }

    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        this.measureChildWithMargins(view, n2, n3, n4, n5);
    }

    /*
     * Unable to fully structure code
     */
    void measureHorizontal(int var1_1, int var2_2) {
        block69: {
            block55: {
                block59: {
                    block58: {
                        block57: {
                            block60: {
                                block56: {
                                    block70: {
                                        block54: {
                                            block66: {
                                                block48: {
                                                    block52: {
                                                        block51: {
                                                            block50: {
                                                                block49: {
                                                                    block53: {
                                                                        block65: {
                                                                            block62: {
                                                                                block64: {
                                                                                    block63: {
                                                                                        block61: {
                                                                                            block47: {
                                                                                                this.mTotalLength = 0;
                                                                                                var3_3 = 0;
                                                                                                var4_4 = 0;
                                                                                                var5_5 = 0;
                                                                                                var6_6 = 0;
                                                                                                var7_7 = true;
                                                                                                var8_8 = 0.0f;
                                                                                                var9_9 = this.getVirtualChildCount();
                                                                                                var10_10 = View.MeasureSpec.getMode(var1_1);
                                                                                                var11_11 = View.MeasureSpec.getMode(var2_2);
                                                                                                var12_12 = false;
                                                                                                var13_13 = false;
                                                                                                if (this.mMaxAscent == null || this.mMaxDescent == null) {
                                                                                                    this.mMaxAscent = new int[4];
                                                                                                    this.mMaxDescent = new int[4];
                                                                                                }
                                                                                                var14_14 = this.mMaxAscent;
                                                                                                var15_15 = this.mMaxDescent;
                                                                                                var14_14[3] = -1;
                                                                                                var14_14[2] = -1;
                                                                                                var14_14[1] = -1;
                                                                                                var14_14[0] = -1;
                                                                                                var15_15[3] = -1;
                                                                                                var15_15[2] = -1;
                                                                                                var15_15[1] = -1;
                                                                                                var15_15[0] = -1;
                                                                                                var16_16 = this.mBaselineAligned;
                                                                                                var17_17 = this.mUseLargestChild;
                                                                                                if (var10_10 == 0x40000000) {
                                                                                                    var18_18 = true;
lbl30:
                                                                                                    // 2 sources

                                                                                                    while (true) {
                                                                                                        var19_19 = -2147483648;
                                                                                                        block1: for (var20_20 = 0; var20_20 < var9_9; ++var20_20) {
                                                                                                            var48_21 = this.getVirtualChildAt(var20_20);
                                                                                                            if (var48_21 == null) {
                                                                                                                this.mTotalLength += this.measureNullChild(var20_20);
lbl36:
                                                                                                                // 3 sources

                                                                                                                continue block1;
                                                                                                            }
                                                                                                            break block47;
                                                                                                        }
                                                                                                        break block48;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                var18_18 = false;
                                                                                                ** while (true)
                                                                                            }
                                                                                            if (var48_21.getVisibility() != 8) break block61;
                                                                                            var20_20 += this.getChildrenSkipCount(var48_21, var20_20);
                                                                                            ** GOTO lbl36
                                                                                        }
                                                                                        if (this.hasDividerBeforeChildAt(var20_20)) {
                                                                                            this.mTotalLength += this.mDividerWidth;
                                                                                        }
                                                                                        var49_22 = (LayoutParams)var48_21.getLayoutParams();
                                                                                        var8_8 += var49_22.weight;
                                                                                        if (var10_10 != 0x40000000 || var49_22.width != 0 || !(var49_22.weight > 0.0f)) break block62;
                                                                                        if (!var18_18) break block63;
                                                                                        this.mTotalLength += var49_22.leftMargin + var49_22.rightMargin;
lbl54:
                                                                                        // 2 sources

                                                                                        while (var16_16) {
                                                                                            var63_36 = View.MeasureSpec.makeMeasureSpec(0, 0);
                                                                                            var48_21.measure(var63_36, var63_36);
lbl57:
                                                                                            // 4 sources

                                                                                            block4: while (true) {
                                                                                                var54_27 = false;
                                                                                                if (var11_11 != 0x40000000) {
                                                                                                    var61_34 = var49_22.height;
                                                                                                    var54_27 = false;
                                                                                                    if (var61_34 == -1) {
                                                                                                        var12_12 = true;
                                                                                                        var54_27 = true;
                                                                                                    }
                                                                                                }
                                                                                                var55_28 = var49_22.topMargin + var49_22.bottomMargin;
                                                                                                var56_29 = var55_28 + var48_21.getMeasuredHeight();
                                                                                                var57_30 = var48_21.getMeasuredState();
                                                                                                var4_4 = LinearLayout.combineMeasuredStates(var4_4, var57_30);
                                                                                                if (!var16_16 || (var58_31 = var48_21.getBaseline()) == -1) ** GOTO lbl76
                                                                                                if (var49_22.gravity >= 0) break block49;
                                                                                                var59_32 = this.mGravity;
lbl72:
                                                                                                // 2 sources

                                                                                                while (true) {
                                                                                                    var60_33 = (-2 & (var59_32 & 112) >> 4) >> 1;
                                                                                                    var14_14[var60_33] = Math.max(var14_14[var60_33], var58_31);
                                                                                                    var15_15[var60_33] = Math.max(var15_15[var60_33], var56_29 - var58_31);
lbl76:
                                                                                                    // 2 sources

                                                                                                    var3_3 = Math.max(var3_3, var56_29);
                                                                                                    if (!var7_7 || var49_22.height != -1) break block50;
                                                                                                    var7_7 = true;
lbl79:
                                                                                                    // 2 sources

                                                                                                    while (var49_22.weight > 0.0f) {
                                                                                                        if (var54_27) lbl-1000:
                                                                                                        // 2 sources

                                                                                                        {
                                                                                                            while (true) {
                                                                                                                var6_6 = Math.max(var6_6, var55_28);
lbl83:
                                                                                                                // 2 sources

                                                                                                                while (true) {
                                                                                                                    var20_20 += this.getChildrenSkipCount(var48_21, var20_20);
                                                                                                                    ** continue;
                                                                                                                    break;
                                                                                                                }
                                                                                                                break;
                                                                                                            }
lbl86:
                                                                                                            // 1 sources

                                                                                                            break block4;
                                                                                                        }
                                                                                                        break block51;
                                                                                                    }
                                                                                                    break block52;
                                                                                                    break;
                                                                                                }
                                                                                                break;
                                                                                            }
                                                                                            ** GOTO lbl36
                                                                                        }
                                                                                        break block64;
                                                                                    }
                                                                                    var62_35 = this.mTotalLength;
                                                                                    this.mTotalLength = Math.max(var62_35, var62_35 + var49_22.leftMargin + var49_22.rightMargin);
                                                                                    ** GOTO lbl54
                                                                                }
                                                                                var13_13 = true;
                                                                                ** GOTO lbl57
                                                                            }
                                                                            var50_23 = -2147483648;
                                                                            if (var49_22.width == 0 && var49_22.weight > 0.0f) {
                                                                                var50_23 = 0;
                                                                                var49_22.width = -2;
                                                                            }
                                                                            if (var8_8 != 0.0f) break block65;
                                                                            var51_24 = this.mTotalLength;
lbl105:
                                                                            // 2 sources

                                                                            while (true) {
                                                                                this.measureChildBeforeLayout(var48_21, var20_20, var1_1, var51_24, var2_2, 0);
                                                                                if (var50_23 != -2147483648) {
                                                                                    var49_22.width = var50_23;
                                                                                }
                                                                                var52_25 = var48_21.getMeasuredWidth();
                                                                                if (!var18_18) break block53;
                                                                                this.mTotalLength += var52_25 + var49_22.leftMargin + var49_22.rightMargin + this.getNextLocationOffset(var48_21);
lbl112:
                                                                                // 2 sources

                                                                                while (true) {
                                                                                    if (!var17_17) ** GOTO lbl57
                                                                                    var19_19 = Math.max(var52_25, var19_19);
                                                                                    ** continue;
                                                                                    break;
                                                                                }
                                                                                break;
                                                                            }
                                                                        }
                                                                        var51_24 = 0;
                                                                        ** while (true)
                                                                    }
                                                                    var53_26 = this.mTotalLength;
                                                                    this.mTotalLength = Math.max(var53_26, var53_26 + var52_25 + var49_22.leftMargin + var49_22.rightMargin + this.getNextLocationOffset(var48_21));
                                                                    ** while (true)
                                                                }
                                                                var59_32 = var49_22.gravity;
                                                                ** while (true)
                                                            }
                                                            var7_7 = false;
                                                            ** GOTO lbl79
                                                        }
                                                        var55_28 = var56_29;
                                                        ** while (true)
                                                    }
                                                    if (var54_27) lbl-1000:
                                                    // 2 sources

                                                    {
                                                        while (true) {
                                                            var5_5 = Math.max(var5_5, var55_28);
                                                            ** continue;
                                                            break;
                                                        }
                                                    }
                                                    var55_28 = var56_29;
                                                    ** while (true)
                                                }
                                                if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(var9_9)) {
                                                    this.mTotalLength += this.mDividerWidth;
                                                }
                                                if (var14_14[1] != -1 || var14_14[0] != -1 || var14_14[2] != -1 || var14_14[3] != -1) {
                                                    var21_37 = Math.max(var14_14[3], Math.max(var14_14[0], Math.max(var14_14[1], var14_14[2]))) + Math.max(var15_15[3], Math.max(var15_15[0], Math.max(var15_15[1], var15_15[2])));
                                                    var3_3 = Math.max(var3_3, var21_37);
                                                }
                                                if (!var17_17 || var10_10 != -2147483648 && var10_10 != 0) break block66;
                                                this.mTotalLength = 0;
                                                block12: for (var44_38 = 0; var44_38 < var9_9; ++var44_38) {
                                                    block68: {
                                                        block67: {
                                                            var45_39 = this.getVirtualChildAt(var44_38);
                                                            if (var45_39 == null) {
                                                                this.mTotalLength += this.measureNullChild(var44_38);
lbl151:
                                                                // 4 sources

                                                                continue block12;
                                                            }
                                                            if (var45_39.getVisibility() != 8) break block67;
                                                            var44_38 += this.getChildrenSkipCount(var45_39, var44_38);
                                                            ** GOTO lbl151
                                                        }
                                                        var46_40 = (LayoutParams)var45_39.getLayoutParams();
                                                        if (!var18_18) break block68;
                                                        this.mTotalLength += var19_19 + var46_40.leftMargin + var46_40.rightMargin + this.getNextLocationOffset(var45_39);
                                                        ** GOTO lbl151
                                                    }
                                                    var47_41 = this.mTotalLength;
                                                    this.mTotalLength = Math.max(var47_41, var47_41 + var19_19 + var46_40.leftMargin + var46_40.rightMargin + this.getNextLocationOffset(var45_39));
                                                    ** continue;
                                                }
                                            }
                                            this.mTotalLength += this.mPaddingLeft + this.mPaddingRight;
                                            var22_42 = LinearLayout.resolveSizeAndState(Math.max(this.mTotalLength, this.getSuggestedMinimumWidth()), var1_1, 0);
                                            var23_43 = (var22_42 & 0xFFFFFF) - this.mTotalLength;
                                            if (!var13_13 && (var23_43 == 0 || !(var8_8 > 0.0f))) break block69;
                                            if (this.mWeightSum > 0.0f) {
                                                var24_44 = this.mWeightSum;
lbl172:
                                                // 2 sources

                                                while (true) {
                                                    var14_14[3] = -1;
                                                    var14_14[2] = -1;
                                                    var14_14[1] = -1;
                                                    var14_14[0] = -1;
                                                    var15_15[3] = -1;
                                                    var15_15[2] = -1;
                                                    var15_15[1] = -1;
                                                    var15_15[0] = -1;
                                                    var3_3 = -1;
                                                    this.mTotalLength = 0;
                                                    block15: for (var25_45 = 0; var25_45 < var9_9; ++var25_45) {
                                                        var28_46 = this.getVirtualChildAt(var25_45);
                                                        if (var28_46 == null || var28_46.getVisibility() == 8) lbl-1000:
                                                        // 3 sources

                                                        {
                                                            continue block15;
                                                        }
                                                        break block54;
                                                    }
                                                    break block55;
                                                    break;
                                                }
                                            }
                                            var24_44 = var8_8;
                                            ** while (true)
                                        }
                                        var29_47 = (LayoutParams)var28_46.getLayoutParams();
                                        var30_48 = var29_47.weight;
                                        if (!(var30_48 > 0.0f)) ** GOTO lbl208
                                        var38_56 = (int)(var30_48 * (float)var23_43 / var24_44);
                                        var24_44 -= var30_48;
                                        var23_43 -= var38_56;
                                        var39_57 = LinearLayout.getChildMeasureSpec(var2_2, this.mPaddingTop + this.mPaddingBottom + var29_47.topMargin + var29_47.bottomMargin, var29_47.height);
                                        if (var29_47.width == 0 && var10_10 == 0x40000000) break block70;
                                        var40_58 = var38_56 + var28_46.getMeasuredWidth();
                                        if (var40_58 < 0) {
                                            var40_58 = 0;
                                        }
                                        var28_46.measure(View.MeasureSpec.makeMeasureSpec(var40_58, 0x40000000), var39_57);
lbl205:
                                        // 2 sources

                                        while (true) {
                                            var41_59 = -16777216 & var28_46.getMeasuredState();
                                            var4_4 = LinearLayout.combineMeasuredStates(var4_4, var41_59);
lbl208:
                                            // 2 sources

                                            if (!var18_18) break block56;
                                            this.mTotalLength += var28_46.getMeasuredWidth() + var29_47.leftMargin + var29_47.rightMargin + this.getNextLocationOffset(var28_46);
lbl210:
                                            // 2 sources

                                            while (var11_11 != 0x40000000 && var29_47.height == -1) {
                                                var32_50 = true;
lbl212:
                                                // 2 sources

                                                while (true) {
                                                    var33_51 = var29_47.topMargin + var29_47.bottomMargin;
                                                    var34_52 = var33_51 + var28_46.getMeasuredHeight();
                                                    var3_3 = Math.max(var3_3, var34_52);
                                                    if (!var32_50) break block57;
lbl217:
                                                    // 2 sources

                                                    while (true) {
                                                        var5_5 = Math.max(var5_5, var33_51);
                                                        if (!var7_7 || var29_47.height != -1) break block58;
                                                        var7_7 = true;
lbl221:
                                                        // 2 sources

                                                        while (true) {
                                                            if (!var16_16 || (var35_53 = var28_46.getBaseline()) == -1) ** GOTO lbl-1000
                                                            if (var29_47.gravity >= 0) break block59;
                                                            var36_54 = this.mGravity;
lbl225:
                                                            // 2 sources

                                                            while (true) {
                                                                var37_55 = (-2 & (var36_54 & 112) >> 4) >> 1;
                                                                var14_14[var37_55] = Math.max(var14_14[var37_55], var35_53);
                                                                var15_15[var37_55] = Math.max(var15_15[var37_55], var34_52 - var35_53);
                                                                ** continue;
                                                                break;
                                                            }
                                                            break;
                                                        }
                                                        break;
                                                    }
                                                    break;
                                                }
lbl230:
                                                // 1 sources

                                                ** GOTO lbl-1000
                                            }
                                            break block60;
                                            break;
                                        }
                                    }
                                    if (var38_56 > 0) lbl-1000:
                                    // 2 sources

                                    {
                                        while (true) {
                                            var28_46.measure(View.MeasureSpec.makeMeasureSpec(var38_56, 0x40000000), var39_57);
                                            ** continue;
                                            break;
                                        }
                                    }
                                    var38_56 = 0;
                                    ** while (true)
                                }
                                var31_49 = this.mTotalLength;
                                this.mTotalLength = Math.max(var31_49, var31_49 + var28_46.getMeasuredWidth() + var29_47.leftMargin + var29_47.rightMargin + this.getNextLocationOffset(var28_46));
                                ** GOTO lbl210
                            }
                            var32_50 = false;
                            ** while (true)
                        }
                        var33_51 = var34_52;
                        ** while (true)
                    }
                    var7_7 = false;
                    ** while (true)
                }
                var36_54 = var29_47.gravity;
                ** while (true)
            }
            this.mTotalLength += this.mPaddingLeft + this.mPaddingRight;
            if (var14_14[1] != -1 || var14_14[0] != -1 || var14_14[2] != -1 || var14_14[3] != -1) {
                var26_60 = Math.max(var14_14[3], Math.max(var14_14[0], Math.max(var14_14[1], var14_14[2]))) + Math.max(var15_15[3], Math.max(var15_15[0], Math.max(var15_15[1], var15_15[2])));
                var3_3 = Math.max(var3_3, var26_60);
            }
lbl260:
            // 5 sources

            while (true) {
                if (!var7_7 && var11_11 != 0x40000000) {
                    var3_3 = var5_5;
                }
                var27_61 = Math.max(var3_3 + (this.mPaddingTop + this.mPaddingBottom), this.getSuggestedMinimumHeight());
                this.setMeasuredDimension(var22_42 | -16777216 & var4_4, LinearLayout.resolveSizeAndState(var27_61, var2_2, var4_4 << 16));
                if (var12_12) {
                    this.forceUniformHeight(var9_9, var1_1);
                }
                return;
            }
        }
        var5_5 = Math.max(var5_5, var6_6);
        if (!var17_17 || var10_10 == 0x40000000) ** GOTO lbl260
        var42_62 = 0;
        block25: while (true) {
            if (var42_62 < var9_9) ** break;
            ** continue;
            var43_63 = this.getVirtualChildAt(var42_62);
            if (var43_63 != null && var43_63.getVisibility() != 8) break;
lbl277:
            // 3 sources

            while (true) {
                ++var42_62;
                continue block25;
                break;
            }
            break;
        }
        if (!(((LayoutParams)var43_63.getLayoutParams()).weight > 0.0f)) ** GOTO lbl277
        var43_63.measure(View.MeasureSpec.makeMeasureSpec(var19_19, 0x40000000), View.MeasureSpec.makeMeasureSpec(var43_63.getMeasuredHeight(), 0x40000000));
        ** while (true)
    }

    int measureNullChild(int n) {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    void measureVertical(int var1_1, int var2_2) {
        block52: {
            block42: {
                block44: {
                    block45: {
                        block43: {
                            block53: {
                                block41: {
                                    block50: {
                                        this.mTotalLength = 0;
                                        var3_3 = 0;
                                        var4_4 = 0;
                                        var5_5 = 0;
                                        var6_6 = 0;
                                        var7_7 = true;
                                        var8_8 = 0.0f;
                                        var9_9 = this.getVirtualChildCount();
                                        var10_10 = View.MeasureSpec.getMode(var1_1);
                                        var11_11 = View.MeasureSpec.getMode(var2_2);
                                        var12_12 = false;
                                        var13_13 = false;
                                        var14_14 = this.mBaselineAlignedChildIndex;
                                        var15_15 = this.mUseLargestChild;
                                        var16_16 = -2147483648;
                                        block0: for (var17_17 = 0; var17_17 < var9_9; ++var17_17) {
                                            block49: {
                                                block40: {
                                                    block48: {
                                                        block39: {
                                                            block47: {
                                                                block46: {
                                                                    var38_18 = this.getVirtualChildAt(var17_17);
                                                                    if (var38_18 == null) {
                                                                        this.mTotalLength += this.measureNullChild(var17_17);
lbl20:
                                                                        // 3 sources

                                                                        continue block0;
                                                                    }
                                                                    if (var38_18.getVisibility() != 8) break block46;
                                                                    var17_17 += this.getChildrenSkipCount(var38_18, var17_17);
                                                                    ** GOTO lbl20
                                                                }
                                                                if (this.hasDividerBeforeChildAt(var17_17)) {
                                                                    this.mTotalLength += this.mDividerHeight;
                                                                }
                                                                var39_19 = (LayoutParams)var38_18.getLayoutParams();
                                                                var8_8 += var39_19.weight;
                                                                if (var11_11 == 0x40000000 && var39_19.height == 0 && var39_19.weight > 0.0f) {
                                                                    var48_28 = this.mTotalLength;
                                                                    this.mTotalLength = Math.max(var48_28, var48_28 + var39_19.topMargin + var39_19.bottomMargin);
                                                                    var13_13 = true;
lbl34:
                                                                    // 3 sources

                                                                    while (true) {
                                                                        if (var14_14 >= 0 && var14_14 == var17_17 + 1) {
                                                                            this.mBaselineChildTop = this.mTotalLength;
                                                                        }
                                                                        if (var17_17 < var14_14 && var39_19.weight > 0.0f) {
                                                                            throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
                                                                        }
                                                                        break block39;
                                                                        break;
                                                                    }
                                                                }
                                                                var40_20 = -2147483648;
                                                                if (var39_19.height == 0 && var39_19.weight > 0.0f) {
                                                                    var40_20 = 0;
                                                                    var39_19.height = -2;
                                                                }
                                                                if (var8_8 != 0.0f) break block47;
                                                                var41_21 = this.mTotalLength;
lbl46:
                                                                // 2 sources

                                                                while (true) {
                                                                    this.measureChildBeforeLayout(var38_18, var17_17, var1_1, 0, var2_2, var41_21);
                                                                    if (var40_20 != -2147483648) {
                                                                        var39_19.height = var40_20;
                                                                    }
                                                                    var42_22 = var38_18.getMeasuredHeight();
                                                                    var43_23 = this.mTotalLength;
                                                                    this.mTotalLength = Math.max(var43_23, var43_23 + var42_22 + var39_19.topMargin + var39_19.bottomMargin + this.getNextLocationOffset(var38_18));
                                                                    if (!var15_15) ** GOTO lbl34
                                                                    var16_16 = Math.max(var42_22, var16_16);
                                                                    ** continue;
                                                                    break;
                                                                }
                                                            }
                                                            var41_21 = 0;
                                                            ** continue;
                                                        }
                                                        var44_24 = false;
                                                        if (var10_10 != 0x40000000) {
                                                            var47_27 = var39_19.width;
                                                            var44_24 = false;
                                                            if (var47_27 == -1) {
                                                                var12_12 = true;
                                                                var44_24 = true;
                                                            }
                                                        }
                                                        var45_25 = var39_19.leftMargin + var39_19.rightMargin;
                                                        var46_26 = var45_25 + var38_18.getMeasuredWidth();
                                                        var3_3 = Math.max(var3_3, var46_26);
                                                        var4_4 = LinearLayout.combineMeasuredStates(var4_4, var38_18.getMeasuredState());
                                                        if (!var7_7 || var39_19.width != -1) break block48;
                                                        var7_7 = true;
lbl73:
                                                        // 2 sources

                                                        while (var39_19.weight > 0.0f) {
                                                            if (!var44_24) break block40;
lbl75:
                                                            // 2 sources

                                                            while (true) {
                                                                var6_6 = Math.max(var6_6, var45_25);
lbl77:
                                                                // 2 sources

                                                                while (true) {
                                                                    var17_17 += this.getChildrenSkipCount(var38_18, var17_17);
                                                                    ** continue;
                                                                    break;
                                                                }
                                                                break;
                                                            }
lbl80:
                                                            // 1 sources

                                                            ** GOTO lbl20
                                                        }
                                                        break block49;
                                                    }
                                                    var7_7 = false;
                                                    ** GOTO lbl73
                                                }
                                                var45_25 = var46_26;
                                                ** continue;
                                            }
                                            if (var44_24) lbl-1000:
                                            // 2 sources

                                            {
                                                while (true) {
                                                    var5_5 = Math.max(var5_5, var45_25);
                                                    ** continue;
                                                    break;
                                                }
                                            }
                                            var45_25 = var46_26;
                                            ** continue;
                                        }
                                        if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(var9_9)) {
                                            this.mTotalLength += this.mDividerHeight;
                                        }
                                        if (!var15_15 || var11_11 != -2147483648 && var11_11 != 0) break block50;
                                        this.mTotalLength = 0;
                                        block8: for (var34_29 = 0; var34_29 < var9_9; ++var34_29) {
                                            block51: {
                                                var35_30 = this.getVirtualChildAt(var34_29);
                                                if (var35_30 == null) {
                                                    this.mTotalLength += this.measureNullChild(var34_29);
lbl103:
                                                    // 3 sources

                                                    continue block8;
                                                }
                                                if (var35_30.getVisibility() != 8) break block51;
                                                var34_29 += this.getChildrenSkipCount(var35_30, var34_29);
                                                ** GOTO lbl103
                                            }
                                            var36_31 = (LayoutParams)var35_30.getLayoutParams();
                                            var37_32 = this.mTotalLength;
                                            this.mTotalLength = Math.max(var37_32, var37_32 + var16_16 + var36_31.topMargin + var36_31.bottomMargin + this.getNextLocationOffset(var35_30));
                                            ** continue;
                                        }
                                    }
                                    this.mTotalLength += this.mPaddingTop + this.mPaddingBottom;
                                    var18_33 = LinearLayout.resolveSizeAndState(Math.max(this.mTotalLength, this.getSuggestedMinimumHeight()), var2_2, 0);
                                    var19_34 = (var18_33 & 0xFFFFFF) - this.mTotalLength;
                                    if (!var13_13 && (var19_34 == 0 || !(var8_8 > 0.0f))) break block52;
                                    if (this.mWeightSum > 0.0f) {
                                        var20_35 = this.mWeightSum;
lbl120:
                                        // 2 sources

                                        while (true) {
                                            this.mTotalLength = 0;
                                            block11: for (var21_36 = 0; var21_36 < var9_9; ++var21_36) {
                                                var22_37 = this.getVirtualChildAt(var21_36);
                                                if (var22_37.getVisibility() == 8) lbl-1000:
                                                // 2 sources

                                                {
                                                    continue block11;
                                                }
                                                break block41;
                                            }
                                            break block42;
                                            break;
                                        }
                                    }
                                    var20_35 = var8_8;
                                    ** while (true)
                                }
                                var23_38 = (LayoutParams)var22_37.getLayoutParams();
                                var24_39 = var23_38.weight;
                                if (!(var24_39 > 0.0f)) ** GOTO lbl146
                                var29_44 = (int)(var24_39 * (float)var19_34 / var20_35);
                                var20_35 -= var24_39;
                                var19_34 -= var29_44;
                                var30_45 = LinearLayout.getChildMeasureSpec(var1_1, this.mPaddingLeft + this.mPaddingRight + var23_38.leftMargin + var23_38.rightMargin, var23_38.width);
                                if (var23_38.height == 0 && var11_11 == 0x40000000) break block53;
                                var31_46 = var29_44 + var22_37.getMeasuredHeight();
                                if (var31_46 < 0) {
                                    var31_46 = 0;
                                }
                                var22_37.measure(var30_45, View.MeasureSpec.makeMeasureSpec(var31_46, 0x40000000));
lbl144:
                                // 2 sources

                                while (true) {
                                    var4_4 = LinearLayout.combineMeasuredStates(var4_4, -256 & var22_37.getMeasuredState());
lbl146:
                                    // 2 sources

                                    var25_40 = var23_38.leftMargin + var23_38.rightMargin;
                                    var26_41 = var25_40 + var22_37.getMeasuredWidth();
                                    var3_3 = Math.max(var3_3, var26_41);
                                    if (var10_10 == 0x40000000 || var23_38.width != -1) break block43;
                                    var27_42 = true;
lbl151:
                                    // 2 sources

                                    while (var27_42) lbl-1000:
                                    // 2 sources

                                    {
                                        while (true) {
                                            var5_5 = Math.max(var5_5, var25_40);
                                            if (!var7_7 || var23_38.width != -1) break block44;
                                            var7_7 = true;
lbl156:
                                            // 2 sources

                                            while (true) {
                                                var28_43 = this.mTotalLength;
                                                this.mTotalLength = Math.max(var28_43, var28_43 + var22_37.getMeasuredHeight() + var23_38.topMargin + var23_38.bottomMargin + this.getNextLocationOffset(var22_37));
                                                ** continue;
                                                break;
                                            }
                                            break;
                                        }
lbl160:
                                        // 1 sources

                                        ** GOTO lbl-1000
                                    }
                                    break block45;
                                    break;
                                }
                            }
                            if (var29_44 > 0) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    var22_37.measure(var30_45, View.MeasureSpec.makeMeasureSpec(var29_44, 0x40000000));
                                    ** continue;
                                    break;
                                }
                            }
                            var29_44 = 0;
                            ** while (true)
                        }
                        var27_42 = false;
                        ** GOTO lbl151
                    }
                    var25_40 = var26_41;
                    ** while (true)
                }
                var7_7 = false;
                ** while (true)
            }
            this.mTotalLength += this.mPaddingTop + this.mPaddingBottom;
lbl180:
            // 3 sources

            while (true) {
                if (!var7_7 && var10_10 != 0x40000000) {
                    var3_3 = var5_5;
                }
                this.setMeasuredDimension(LinearLayout.resolveSizeAndState(Math.max(var3_3 + (this.mPaddingLeft + this.mPaddingRight), this.getSuggestedMinimumWidth()), var1_1, var4_4), var18_33);
                if (var12_12) {
                    this.forceUniformWidth(var9_9, var2_2);
                }
                return;
            }
        }
        var5_5 = Math.max(var5_5, var6_6);
        if (!var15_15 || var11_11 == 0x40000000) ** GOTO lbl180
        var32_47 = 0;
        block19: while (true) {
            if (var32_47 < var9_9) ** break;
            ** continue;
            var33_48 = this.getVirtualChildAt(var32_47);
            if (var33_48 != null && var33_48.getVisibility() != 8) break;
lbl196:
            // 3 sources

            while (true) {
                ++var32_47;
                continue block19;
                break;
            }
            break;
        }
        if (!(((LayoutParams)var33_48.getLayoutParams()).weight > 0.0f)) ** GOTO lbl196
        var33_48.measure(View.MeasureSpec.makeMeasureSpec(var33_48.getMeasuredWidth(), 0x40000000), View.MeasureSpec.makeMeasureSpec(var16_16, 0x40000000));
        ** while (true)
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawDividersVertical(canvas);
            return;
        }
        this.drawDividersHorizontal(canvas);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(LinearLayout.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(LinearLayout.class.getName());
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.mOrientation == 1) {
            this.layoutVertical(n, n2, n3, n4);
            return;
        }
        this.layoutHorizontal(n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        if (this.mOrientation == 1) {
            this.measureVertical(n, n2);
            return;
        }
        this.measureHorizontal(n, n2);
    }

    @RemotableViewMethod
    public void setBaselineAligned(boolean bl) {
        this.mBaselineAligned = bl;
    }

    @RemotableViewMethod
    public void setBaselineAlignedChildIndex(int n) {
        if (n < 0 || n >= this.getChildCount()) {
            throw new IllegalArgumentException("base aligned child index out of range (0, " + this.getChildCount() + ")");
        }
        this.mBaselineAlignedChildIndex = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDividerDrawable(Drawable drawable2) {
        if (drawable2 == this.mDivider) {
            return;
        }
        this.mDivider = drawable2;
        if (drawable2 != null) {
            this.mDividerWidth = drawable2.getIntrinsicWidth();
            this.mDividerHeight = drawable2.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        boolean bl = false;
        if (drawable2 == null) {
            bl = true;
        }
        this.setWillNotDraw(bl);
        this.requestLayout();
    }

    public void setDividerPadding(int n) {
        this.mDividerPadding = n;
    }

    @RemotableViewMethod
    public void setGravity(int n) {
        if (this.mGravity != n) {
            if ((0x800007 & n) == 0) {
                n |= 0x800003;
            }
            if ((n & 0x70) == 0) {
                n |= 0x30;
            }
            this.mGravity = n;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int n) {
        int n2 = n & 0x800007;
        if ((0x800007 & this.mGravity) != n2) {
            this.mGravity = n2 | 0xFF7FFFF8 & this.mGravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setMeasureWithLargestChildEnabled(boolean bl) {
        this.mUseLargestChild = bl;
    }

    public void setOrientation(int n) {
        if (this.mOrientation != n) {
            this.mOrientation = n;
            this.requestLayout();
        }
    }

    public void setShowDividers(int n) {
        if (n != this.mShowDividers) {
            this.requestLayout();
        }
        this.mShowDividers = n;
    }

    @RemotableViewMethod
    public void setVerticalGravity(int n) {
        int n2 = n & 0x70;
        if ((0x70 & this.mGravity) != n2) {
            this.mGravity = n2 | 0xFFFFFF8F & this.mGravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setWeightSum(float f) {
        this.mWeightSum = Math.max(0.0f, f);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="NONE"), @ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=48, to="TOP"), @ViewDebug.IntToString(from=80, to="BOTTOM"), @ViewDebug.IntToString(from=3, to="LEFT"), @ViewDebug.IntToString(from=5, to="RIGHT"), @ViewDebug.IntToString(from=0x800003, to="START"), @ViewDebug.IntToString(from=0x800005, to="END"), @ViewDebug.IntToString(from=16, to="CENTER_VERTICAL"), @ViewDebug.IntToString(from=112, to="FILL_VERTICAL"), @ViewDebug.IntToString(from=1, to="CENTER_HORIZONTAL"), @ViewDebug.IntToString(from=7, to="FILL_HORIZONTAL"), @ViewDebug.IntToString(from=17, to="CENTER"), @ViewDebug.IntToString(from=119, to="FILL")})
        public int gravity = -1;
        @ViewDebug.ExportedProperty(category="layout")
        public float weight;

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.weight = 0.0f;
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2);
            this.weight = f;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LinearLayout_Layout);
            this.weight = typedArray.getFloat(3, 0.0f);
            this.gravity = typedArray.getInt(0, -1);
            typedArray.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.weight = layoutParams.weight;
            this.gravity = layoutParams.gravity;
        }

        @Override
        public String debug(String string2) {
            return string2 + "LinearLayout.LayoutParams={width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " weight=" + this.weight + "}";
        }
    }
}

