/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsListView;
import android.widget.DatePickerController;
import android.widget.ListView;
import android.widget.OnDateChangedListener;
import android.widget.SimpleMonthAdapter;
import android.widget.SimpleMonthView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

class DayPickerView
extends ListView
implements AbsListView.OnScrollListener,
OnDateChangedListener {
    private static final int GOTO_SCROLL_DURATION = 250;
    private static int LIST_TOP_OFFSET = 0;
    private static final int SCROLL_CHANGE_DELAY = 40;
    private static final String TAG = "DayPickerView";
    private SimpleMonthAdapter mAdapter;
    private DatePickerController mController;
    private int mCurrentMonthDisplayed;
    private int mCurrentScrollState = 0;
    private float mFriction = 1.0f;
    private boolean mPerformingScroll;
    private int mPreviousScrollState = 0;
    private ScrollStateRunnable mScrollStateChangedRunnable;
    private Calendar mSelectedDay;
    private Calendar mTempDay;
    private SimpleDateFormat mYearFormat = new SimpleDateFormat("yyyy", Locale.getDefault());

    static {
        LIST_TOP_OFFSET = -1;
    }

    public DayPickerView(Context context, DatePickerController datePickerController) {
        super(context);
        this.mSelectedDay = Calendar.getInstance();
        this.mTempDay = Calendar.getInstance();
        this.mScrollStateChangedRunnable = new ScrollStateRunnable(this);
        this.init();
        this.setController(datePickerController);
    }

    static /* synthetic */ int access$002(DayPickerView dayPickerView, int n) {
        dayPickerView.mCurrentScrollState = n;
        return n;
    }

    static /* synthetic */ int access$102(DayPickerView dayPickerView, int n) {
        dayPickerView.mPreviousScrollState = n;
        return n;
    }

    private Calendar findAccessibilityFocus() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            Calendar calendar;
            View view = this.getChildAt(i);
            if (!(view instanceof SimpleMonthView) || (calendar = ((SimpleMonthView)view).getAccessibilityFocus()) == null) continue;
            return calendar;
        }
        return null;
    }

    private int getDiffMonths(Calendar calendar, Calendar calendar2) {
        int n = calendar2.get(1) - calendar.get(1);
        return calendar2.get(2) - calendar.get(2) + n * 12;
    }

    private String getMonthAndYearString(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(calendar.getDisplayName(2, 2, Locale.getDefault()));
        stringBuffer.append(" ");
        stringBuffer.append(this.mYearFormat.format(calendar.getTime()));
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getPositionFromDay(Calendar calendar) {
        int n = this.getDiffMonths(this.mController.getMinDate(), this.mController.getMaxDate());
        int n2 = this.getDiffMonths(this.mController.getMinDate(), calendar);
        if (n2 < 0) {
            return 0;
        }
        if (n2 <= n) return n2;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean restoreAccessibilityFocus(Calendar calendar) {
        if (calendar != null) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!(view instanceof SimpleMonthView) || !((SimpleMonthView)view).restoreAccessibilityFocus(calendar)) continue;
                return true;
            }
        }
        return false;
    }

    public int getMostVisiblePosition() {
        int n = this.getFirstVisiblePosition();
        int n2 = this.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        View view;
        while (n6 < n2 && (view = this.getChildAt(n5)) != null) {
            n6 = view.getBottom();
            int n7 = Math.min(n6, n2) - Math.max(0, view.getTop());
            if (n7 > n3) {
                n4 = n5;
                n3 = n7;
            }
            ++n5;
        }
        return n + n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean goTo(Calendar calendar, boolean bl, boolean bl2, boolean bl3) {
        View view;
        if (bl2) {
            this.mSelectedDay.setTimeInMillis(calendar.getTimeInMillis());
        }
        this.mTempDay.setTimeInMillis(calendar.getTimeInMillis());
        int n = this.getPositionFromDay(calendar);
        int n2 = 0;
        while (true) {
            int n3 = n2 + 1;
            view = this.getChildAt(n2);
            if (view == null || view.getTop() >= 0) break;
            n2 = n3;
        }
        int n4 = view != null ? this.getPositionForView(view) : 0;
        if (bl2) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (n == n4 && !bl3) {
            if (!bl2) return false;
            this.setMonthDisplayed(this.mSelectedDay);
            return false;
        }
        this.setMonthDisplayed(this.mTempDay);
        this.mPreviousScrollState = 2;
        if (bl) {
            this.smoothScrollToPositionFromTop(n, LIST_TOP_OFFSET, 250);
            return true;
        }
        this.postSetSelection(n);
        return false;
    }

    public void init() {
        this.setLayoutParams(new AbsListView.LayoutParams(-1, -1));
        this.setDrawSelectorOnTop(false);
        this.setUpListView();
    }

    @Override
    protected void layoutChildren() {
        Calendar calendar = this.findAccessibilityFocus();
        super.layoutChildren();
        if (this.mPerformingScroll) {
            this.mPerformingScroll = false;
            return;
        }
        this.restoreAccessibilityFocus(calendar);
    }

    public void onChange() {
        this.setUpAdapter();
        this.setAdapter(this.mAdapter);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        this.mYearFormat = new SimpleDateFormat("yyyy", Locale.getDefault());
    }

    @Override
    public void onDateChanged() {
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setItemCount(-1);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.addAction(4096);
        accessibilityNodeInfo.addAction(8192);
    }

    @Override
    public void onScroll(AbsListView absListView, int n, int n2, int n3) {
        if ((SimpleMonthView)absListView.getChildAt(0) == null) {
            return;
        }
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    @Override
    public void onScrollStateChanged(AbsListView absListView, int n) {
        this.mScrollStateChangedRunnable.doScrollStateChange(absListView, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        View view;
        if (n != 4096 && n != 8192) {
            return super.performAccessibilityAction(n, bundle);
        }
        int n2 = this.getFirstVisiblePosition();
        int n3 = n2 % 12;
        int n4 = n2 / 12 + this.mController.getMinYear();
        Calendar calendar = Calendar.getInstance();
        calendar.set(n4, n3, 1);
        if (n == 4096) {
            calendar.add(2, 1);
            if (calendar.get(2) == 12) {
                calendar.set(2, 0);
                calendar.add(1, 1);
            }
        } else if (n == 8192 && (view = this.getChildAt(0)) != null && view.getTop() >= -1) {
            calendar.add(2, -1);
            if (calendar.get(2) == -1) {
                calendar.set(2, 11);
                calendar.add(1, -1);
            }
        }
        this.announceForAccessibility(this.getMonthAndYearString(calendar));
        this.goTo(calendar, true, false, true);
        this.mPerformingScroll = true;
        return true;
    }

    public void postSetSelection(final int n) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                DayPickerView.this.setSelection(n);
            }
        });
        this.onScrollStateChanged(this, 0);
    }

    void setCalendarTextColor(ColorStateList colorStateList) {
        this.mAdapter.setCalendarTextColor(colorStateList);
    }

    public void setController(DatePickerController datePickerController) {
        if (this.mController != null) {
            this.mController.unregisterOnDateChangedListener(this);
        }
        this.mController = datePickerController;
        this.mController.registerOnDateChangedListener(this);
        this.setUpAdapter();
        this.setAdapter(this.mAdapter);
        this.onDateChanged();
    }

    protected void setMonthDisplayed(Calendar calendar) {
        if (this.mCurrentMonthDisplayed != calendar.get(2)) {
            this.mCurrentMonthDisplayed = calendar.get(2);
            this.invalidateViews();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new SimpleMonthAdapter(this.getContext(), this.mController);
        } else {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
            this.mAdapter.notifyDataSetChanged();
        }
        this.mAdapter.notifyDataSetChanged();
    }

    protected void setUpListView() {
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFriction(ViewConfiguration.getScrollFriction() * this.mFriction);
    }

    protected class ScrollStateRunnable
    implements Runnable {
        private int mNewState;
        private View mParent;

        ScrollStateRunnable(View view) {
            this.mParent = view;
        }

        public void doScrollStateChange(AbsListView absListView, int n) {
            this.mParent.removeCallbacks(this);
            this.mNewState = n;
            this.mParent.postDelayed(this, 40L);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            block7: {
                int n;
                int n2;
                int n3;
                block9: {
                    block8: {
                        int n4 = 1;
                        DayPickerView.access$002(DayPickerView.this, this.mNewState);
                        if (Log.isLoggable(DayPickerView.TAG, 3)) {
                            Log.d(DayPickerView.TAG, "new scroll state: " + this.mNewState + " old state: " + DayPickerView.this.mPreviousScrollState);
                        }
                        if (this.mNewState != 0 || DayPickerView.this.mPreviousScrollState == 0 || DayPickerView.this.mPreviousScrollState == n4) break block7;
                        DayPickerView.access$102(DayPickerView.this, this.mNewState);
                        int n5 = 0;
                        View view = DayPickerView.this.getChildAt(0);
                        while (view != null && view.getBottom() <= 0) {
                            DayPickerView dayPickerView = DayPickerView.this;
                            view = dayPickerView.getChildAt(++n5);
                        }
                        if (view == null) break block8;
                        int n6 = DayPickerView.this.getFirstVisiblePosition();
                        int n7 = DayPickerView.this.getLastVisiblePosition();
                        if (n6 == 0 || n7 == -1 + DayPickerView.this.getCount()) {
                            n4 = 0;
                        }
                        n3 = view.getTop();
                        n2 = view.getBottom();
                        n = DayPickerView.this.getHeight() / 2;
                        if (n4 != 0 && n3 < LIST_TOP_OFFSET) break block9;
                    }
                    return;
                }
                if (n2 > n) {
                    DayPickerView.this.smoothScrollBy(n3, 250);
                    return;
                }
                DayPickerView.this.smoothScrollBy(n2, 250);
                return;
            }
            DayPickerView.access$102(DayPickerView.this, this.mNewState);
        }
    }
}

