/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.CalendarView;
import android.widget.DatePickerCalendarDelegate;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import com.android.internal.R;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.ICU;

public class DatePicker
extends FrameLayout {
    private static final String LOG_TAG = DatePicker.class.getSimpleName();
    private static final int MODE_CALENDAR = 2;
    private static final int MODE_SPINNER = 1;
    private final DatePickerDelegate mDelegate;

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843612);
    }

    public DatePicker(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DatePicker(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.DatePicker, n, n2);
        int n3 = typedArray.getInt(16, 1);
        int n4 = typedArray.getInt(3, 0);
        typedArray.recycle();
        switch (n3) {
            default: {
                this.mDelegate = this.createSpinnerUIDelegate(context, attributeSet, n, n2);
                break;
            }
            case 2: {
                this.mDelegate = this.createCalendarUIDelegate(context, attributeSet, n, n2);
            }
        }
        if (n4 != 0) {
            this.setFirstDayOfWeek(n4);
        }
    }

    private DatePickerDelegate createCalendarUIDelegate(Context context, AttributeSet attributeSet, int n, int n2) {
        return new DatePickerCalendarDelegate(this, context, attributeSet, n, n2);
    }

    private DatePickerDelegate createSpinnerUIDelegate(Context context, AttributeSet attributeSet, int n, int n2) {
        return new DatePickerSpinnerDelegate(this, context, attributeSet, n, n2);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return this.mDelegate.dispatchPopulateAccessibilityEvent(accessibilityEvent);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchThawSelfOnly(sparseArray);
    }

    public CalendarView getCalendarView() {
        return this.mDelegate.getCalendarView();
    }

    public boolean getCalendarViewShown() {
        return this.mDelegate.getCalendarViewShown();
    }

    public int getDayOfMonth() {
        return this.mDelegate.getDayOfMonth();
    }

    public int getFirstDayOfWeek() {
        return this.mDelegate.getFirstDayOfWeek();
    }

    public long getMaxDate() {
        return this.mDelegate.getMaxDate().getTimeInMillis();
    }

    public long getMinDate() {
        return this.mDelegate.getMinDate().getTimeInMillis();
    }

    public int getMonth() {
        return this.mDelegate.getMonth();
    }

    public boolean getSpinnersShown() {
        return this.mDelegate.getSpinnersShown();
    }

    public int getYear() {
        return this.mDelegate.getYear();
    }

    public void init(int n, int n2, int n3, OnDateChangedListener onDateChangedListener) {
        this.mDelegate.init(n, n2, n3, onDateChangedListener);
    }

    @Override
    public boolean isEnabled() {
        return this.mDelegate.isEnabled();
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mDelegate.onConfigurationChanged(configuration);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        this.mDelegate.onInitializeAccessibilityEvent(accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        this.mDelegate.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onPopulateAccessibilityEvent(accessibilityEvent);
        this.mDelegate.onPopulateAccessibilityEvent(accessibilityEvent);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        View.BaseSavedState baseSavedState = (View.BaseSavedState)parcelable;
        super.onRestoreInstanceState(baseSavedState.getSuperState());
        this.mDelegate.onRestoreInstanceState(baseSavedState);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        return this.mDelegate.onSaveInstanceState(parcelable);
    }

    public void setCalendarViewShown(boolean bl) {
        this.mDelegate.setCalendarViewShown(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.mDelegate.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        this.mDelegate.setEnabled(bl);
    }

    public void setFirstDayOfWeek(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("firstDayOfWeek must be between 1 and 7");
        }
        this.mDelegate.setFirstDayOfWeek(n);
    }

    public void setMaxDate(long l) {
        this.mDelegate.setMaxDate(l);
    }

    public void setMinDate(long l) {
        this.mDelegate.setMinDate(l);
    }

    public void setSpinnersShown(boolean bl) {
        this.mDelegate.setSpinnersShown(bl);
    }

    public void setValidationCallback(ValidationCallback validationCallback) {
        this.mDelegate.setValidationCallback(validationCallback);
    }

    public void updateDate(int n, int n2, int n3) {
        this.mDelegate.updateDate(n, n2, n3);
    }

    static abstract class AbstractDatePickerDelegate
    implements DatePickerDelegate {
        protected Context mContext;
        protected Locale mCurrentLocale;
        protected DatePicker mDelegator;
        protected OnDateChangedListener mOnDateChangedListener;
        protected ValidationCallback mValidationCallback;

        public AbstractDatePickerDelegate(DatePicker datePicker, Context context) {
            this.mDelegator = datePicker;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        protected void onValidationChanged(boolean bl) {
            if (this.mValidationCallback != null) {
                this.mValidationCallback.onValidationChanged(bl);
            }
        }

        protected void setCurrentLocale(Locale locale) {
            if (locale.equals(this.mCurrentLocale)) {
                return;
            }
            this.mCurrentLocale = locale;
        }

        @Override
        public void setValidationCallback(ValidationCallback validationCallback) {
            this.mValidationCallback = validationCallback;
        }
    }

    static interface DatePickerDelegate {
        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public CalendarView getCalendarView();

        public boolean getCalendarViewShown();

        public int getDayOfMonth();

        public int getFirstDayOfWeek();

        public Calendar getMaxDate();

        public Calendar getMinDate();

        public int getMonth();

        public boolean getSpinnersShown();

        public int getYear();

        public void init(int var1, int var2, int var3, OnDateChangedListener var4);

        public boolean isEnabled();

        public void onConfigurationChanged(Configuration var1);

        public void onInitializeAccessibilityEvent(AccessibilityEvent var1);

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo var1);

        public void onPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onRestoreInstanceState(Parcelable var1);

        public Parcelable onSaveInstanceState(Parcelable var1);

        public void setCalendarViewShown(boolean var1);

        public void setEnabled(boolean var1);

        public void setFirstDayOfWeek(int var1);

        public void setMaxDate(long var1);

        public void setMinDate(long var1);

        public void setSpinnersShown(boolean var1);

        public void setValidationCallback(ValidationCallback var1);

        public void updateDate(int var1, int var2, int var3);
    }

    private static class DatePickerSpinnerDelegate
    extends AbstractDatePickerDelegate {
        private static final String DATE_FORMAT = "MM/dd/yyyy";
        private static final boolean DEFAULT_CALENDAR_VIEW_SHOWN = true;
        private static final boolean DEFAULT_ENABLED_STATE = true;
        private static final int DEFAULT_END_YEAR = 2100;
        private static final boolean DEFAULT_SPINNERS_SHOWN = true;
        private static final int DEFAULT_START_YEAR = 1900;
        private final CalendarView mCalendarView;
        private Calendar mCurrentDate;
        private final java.text.DateFormat mDateFormat = new SimpleDateFormat("MM/dd/yyyy");
        private final NumberPicker mDaySpinner;
        private final EditText mDaySpinnerInput;
        private boolean mIsEnabled = true;
        private Calendar mMaxDate;
        private Calendar mMinDate;
        private final NumberPicker mMonthSpinner;
        private final EditText mMonthSpinnerInput;
        private int mNumberOfMonths;
        private String[] mShortMonths;
        private final LinearLayout mSpinners;
        private Calendar mTempDate;
        private final NumberPicker mYearSpinner;
        private final EditText mYearSpinnerInput;

        /*
         * Enabled aggressive block sorting
         */
        DatePickerSpinnerDelegate(DatePicker datePicker, Context context, AttributeSet attributeSet, int n, int n2) {
            super(datePicker, context);
            this.mDelegator = datePicker;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.DatePicker, n, n2);
            boolean bl = typedArray.getBoolean(6, true);
            boolean bl2 = typedArray.getBoolean(7, true);
            int n3 = typedArray.getInt(1, 1900);
            int n4 = typedArray.getInt(2, 2100);
            String string2 = typedArray.getString(4);
            String string3 = typedArray.getString(5);
            int n5 = typedArray.getResourceId(19, 17367133);
            typedArray.recycle();
            ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(n5, (ViewGroup)this.mDelegator, true);
            NumberPicker.OnValueChangeListener onValueChangeListener = new NumberPicker.OnValueChangeListener(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                    block9: {
                        block11: {
                            block10: {
                                DatePickerSpinnerDelegate.this.updateInputState();
                                DatePickerSpinnerDelegate.this.mTempDate.setTimeInMillis(DatePickerSpinnerDelegate.this.mCurrentDate.getTimeInMillis());
                                if (numberPicker != DatePickerSpinnerDelegate.this.mDaySpinner) break block10;
                                int n3 = DatePickerSpinnerDelegate.this.mTempDate.getActualMaximum(5);
                                if (n == n3 && n2 == 1) {
                                    DatePickerSpinnerDelegate.this.mTempDate.add(5, 1);
                                    break block9;
                                } else if (n == 1 && n2 == n3) {
                                    DatePickerSpinnerDelegate.this.mTempDate.add(5, -1);
                                    break block9;
                                } else {
                                    DatePickerSpinnerDelegate.this.mTempDate.add(5, n2 - n);
                                }
                                break block9;
                            }
                            if (numberPicker != DatePickerSpinnerDelegate.this.mMonthSpinner) break block11;
                            if (n == 11 && n2 == 0) {
                                DatePickerSpinnerDelegate.this.mTempDate.add(2, 1);
                                break block9;
                            } else if (n == 0 && n2 == 11) {
                                DatePickerSpinnerDelegate.this.mTempDate.add(2, -1);
                                break block9;
                            } else {
                                DatePickerSpinnerDelegate.this.mTempDate.add(2, n2 - n);
                            }
                            break block9;
                        }
                        if (numberPicker != DatePickerSpinnerDelegate.this.mYearSpinner) {
                            throw new IllegalArgumentException();
                        }
                        DatePickerSpinnerDelegate.this.mTempDate.set(1, n2);
                    }
                    DatePickerSpinnerDelegate.this.setDate(DatePickerSpinnerDelegate.this.mTempDate.get(1), DatePickerSpinnerDelegate.this.mTempDate.get(2), DatePickerSpinnerDelegate.this.mTempDate.get(5));
                    DatePickerSpinnerDelegate.this.updateSpinners();
                    DatePickerSpinnerDelegate.this.updateCalendarView();
                    DatePickerSpinnerDelegate.this.notifyDateChanged();
                }
            };
            this.mSpinners = (LinearLayout)this.mDelegator.findViewById(16909097);
            this.mCalendarView = (CalendarView)this.mDelegator.findViewById(16909101);
            this.mCalendarView.setOnDateChangeListener(new CalendarView.OnDateChangeListener(){

                @Override
                public void onSelectedDayChange(CalendarView calendarView, int n, int n2, int n3) {
                    DatePickerSpinnerDelegate.this.setDate(n, n2, n3);
                    DatePickerSpinnerDelegate.this.updateSpinners();
                    DatePickerSpinnerDelegate.this.notifyDateChanged();
                }
            });
            this.mDaySpinner = (NumberPicker)this.mDelegator.findViewById(16909099);
            this.mDaySpinner.setFormatter(NumberPicker.getTwoDigitFormatter());
            this.mDaySpinner.setOnLongPressUpdateInterval(100L);
            this.mDaySpinner.setOnValueChangedListener(onValueChangeListener);
            this.mDaySpinnerInput = (EditText)this.mDaySpinner.findViewById(16909198);
            this.mMonthSpinner = (NumberPicker)this.mDelegator.findViewById(16909098);
            this.mMonthSpinner.setMinValue(0);
            this.mMonthSpinner.setMaxValue(-1 + this.mNumberOfMonths);
            this.mMonthSpinner.setDisplayedValues(this.mShortMonths);
            this.mMonthSpinner.setOnLongPressUpdateInterval(200L);
            this.mMonthSpinner.setOnValueChangedListener(onValueChangeListener);
            this.mMonthSpinnerInput = (EditText)this.mMonthSpinner.findViewById(16909198);
            this.mYearSpinner = (NumberPicker)this.mDelegator.findViewById(16909100);
            this.mYearSpinner.setOnLongPressUpdateInterval(100L);
            this.mYearSpinner.setOnValueChangedListener(onValueChangeListener);
            this.mYearSpinnerInput = (EditText)this.mYearSpinner.findViewById(16909198);
            if (!bl && !bl2) {
                this.setSpinnersShown(true);
            } else {
                this.setSpinnersShown(bl);
                this.setCalendarViewShown(bl2);
            }
            this.mTempDate.clear();
            if (!TextUtils.isEmpty(string2)) {
                if (!this.parseDate(string2, this.mTempDate)) {
                    this.mTempDate.set(n3, 0, 1);
                }
            } else {
                this.mTempDate.set(n3, 0, 1);
            }
            this.setMinDate(this.mTempDate.getTimeInMillis());
            this.mTempDate.clear();
            if (!TextUtils.isEmpty(string3)) {
                if (!this.parseDate(string3, this.mTempDate)) {
                    this.mTempDate.set(n4, 11, 31);
                }
            } else {
                this.mTempDate.set(n4, 11, 31);
            }
            this.setMaxDate(this.mTempDate.getTimeInMillis());
            this.mCurrentDate.setTimeInMillis(System.currentTimeMillis());
            this.init(this.mCurrentDate.get(1), this.mCurrentDate.get(2), this.mCurrentDate.get(5), null);
            this.reorderSpinners();
            this.setContentDescriptions();
            if (this.mDelegator.getImportantForAccessibility() == 0) {
                this.mDelegator.setImportantForAccessibility(1);
            }
        }

        private Calendar getCalendarForLocale(Calendar calendar, Locale locale) {
            if (calendar == null) {
                return Calendar.getInstance(locale);
            }
            long l = calendar.getTimeInMillis();
            Calendar calendar2 = Calendar.getInstance(locale);
            calendar2.setTimeInMillis(l);
            return calendar2;
        }

        private boolean isNewDate(int n, int n2, int n3) {
            return this.mCurrentDate.get(1) != n || this.mCurrentDate.get(2) != n3 || this.mCurrentDate.get(5) != n2;
        }

        private void notifyDateChanged() {
            this.mDelegator.sendAccessibilityEvent(4);
            if (this.mOnDateChangedListener != null) {
                this.mOnDateChangedListener.onDateChanged(this.mDelegator, this.getYear(), this.getMonth(), this.getDayOfMonth());
            }
        }

        private boolean parseDate(String string2, Calendar calendar) {
            try {
                calendar.setTime(this.mDateFormat.parse(string2));
                return true;
            }
            catch (ParseException parseException) {
                Log.w(LOG_TAG, "Date: " + string2 + " not in format: " + DATE_FORMAT);
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void reorderSpinners() {
            this.mSpinners.removeAllViews();
            char[] cArray = ICU.getDateFormatOrder((String)DateFormat.getBestDateTimePattern(Locale.getDefault(), "yyyyMMMdd"));
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                switch (cArray[n2]) {
                    default: {
                        throw new IllegalArgumentException(Arrays.toString(cArray));
                    }
                    case 'd': {
                        this.mSpinners.addView(this.mDaySpinner);
                        this.setImeOptions(this.mDaySpinner, n, n2);
                        break;
                    }
                    case 'M': {
                        this.mSpinners.addView(this.mMonthSpinner);
                        this.setImeOptions(this.mMonthSpinner, n, n2);
                        break;
                    }
                    case 'y': {
                        this.mSpinners.addView(this.mYearSpinner);
                        this.setImeOptions(this.mYearSpinner, n, n2);
                    }
                }
                ++n2;
            }
            return;
        }

        private void setContentDescriptions() {
            this.trySetContentDescription(this.mDaySpinner, 16909197, 17040762);
            this.trySetContentDescription(this.mDaySpinner, 16909199, 17040763);
            this.trySetContentDescription(this.mMonthSpinner, 16909197, 17040760);
            this.trySetContentDescription(this.mMonthSpinner, 16909199, 17040761);
            this.trySetContentDescription(this.mYearSpinner, 16909197, 17040764);
            this.trySetContentDescription(this.mYearSpinner, 16909199, 17040765);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setDate(int n, int n2, int n3) {
            this.mCurrentDate.set(n, n2, n3);
            if (this.mCurrentDate.before(this.mMinDate)) {
                this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
                return;
            } else {
                if (!this.mCurrentDate.after(this.mMaxDate)) return;
                this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setImeOptions(NumberPicker numberPicker, int n, int n2) {
            int n3 = n2 < n - 1 ? 5 : 6;
            ((TextView)numberPicker.findViewById(16909198)).setImeOptions(n3);
        }

        private void trySetContentDescription(View view, int n, int n2) {
            View view2 = view.findViewById(n);
            if (view2 != null) {
                view2.setContentDescription(this.mContext.getString(n2));
            }
        }

        private void updateCalendarView() {
            this.mCalendarView.setDate(this.mCurrentDate.getTimeInMillis(), false, false);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void updateInputState() {
            InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
            if (inputMethodManager == null) return;
            if (inputMethodManager.isActive(this.mYearSpinnerInput)) {
                this.mYearSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
                return;
            } else {
                if (inputMethodManager.isActive(this.mMonthSpinnerInput)) {
                    this.mMonthSpinnerInput.clearFocus();
                    inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
                    return;
                }
                if (!inputMethodManager.isActive(this.mDaySpinnerInput)) return;
                this.mDaySpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void updateSpinners() {
            if (this.mCurrentDate.equals(this.mMinDate)) {
                this.mDaySpinner.setMinValue(this.mCurrentDate.get(5));
                this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
                this.mDaySpinner.setWrapSelectorWheel(false);
                this.mMonthSpinner.setDisplayedValues(null);
                this.mMonthSpinner.setMinValue(this.mCurrentDate.get(2));
                this.mMonthSpinner.setMaxValue(this.mCurrentDate.getActualMaximum(2));
                this.mMonthSpinner.setWrapSelectorWheel(false);
            } else if (this.mCurrentDate.equals(this.mMaxDate)) {
                this.mDaySpinner.setMinValue(this.mCurrentDate.getActualMinimum(5));
                this.mDaySpinner.setMaxValue(this.mCurrentDate.get(5));
                this.mDaySpinner.setWrapSelectorWheel(false);
                this.mMonthSpinner.setDisplayedValues(null);
                this.mMonthSpinner.setMinValue(this.mCurrentDate.getActualMinimum(2));
                this.mMonthSpinner.setMaxValue(this.mCurrentDate.get(2));
                this.mMonthSpinner.setWrapSelectorWheel(false);
            } else {
                this.mDaySpinner.setMinValue(1);
                this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
                this.mDaySpinner.setWrapSelectorWheel(true);
                this.mMonthSpinner.setDisplayedValues(null);
                this.mMonthSpinner.setMinValue(0);
                this.mMonthSpinner.setMaxValue(11);
                this.mMonthSpinner.setWrapSelectorWheel(true);
            }
            String[] stringArray = Arrays.copyOfRange(this.mShortMonths, this.mMonthSpinner.getMinValue(), 1 + this.mMonthSpinner.getMaxValue());
            this.mMonthSpinner.setDisplayedValues(stringArray);
            this.mYearSpinner.setMinValue(this.mMinDate.get(1));
            this.mYearSpinner.setMaxValue(this.mMaxDate.get(1));
            this.mYearSpinner.setWrapSelectorWheel(false);
            this.mYearSpinner.setValue(this.mCurrentDate.get(1));
            this.mMonthSpinner.setValue(this.mCurrentDate.get(2));
            this.mDaySpinner.setValue(this.mCurrentDate.get(5));
            if (this.usingNumericMonths()) {
                this.mMonthSpinnerInput.setRawInputType(2);
            }
        }

        private boolean usingNumericMonths() {
            return Character.isDigit(this.mShortMonths[0].charAt(0));
        }

        @Override
        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            this.onPopulateAccessibilityEvent(accessibilityEvent);
            return true;
        }

        @Override
        public CalendarView getCalendarView() {
            return this.mCalendarView;
        }

        @Override
        public boolean getCalendarViewShown() {
            return this.mCalendarView.getVisibility() == 0;
        }

        @Override
        public int getDayOfMonth() {
            return this.mCurrentDate.get(5);
        }

        @Override
        public int getFirstDayOfWeek() {
            return this.mCalendarView.getFirstDayOfWeek();
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.mCalendarView.getMaxDate());
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.mCalendarView.getMinDate());
            return calendar;
        }

        @Override
        public int getMonth() {
            return this.mCurrentDate.get(2);
        }

        @Override
        public boolean getSpinnersShown() {
            return this.mSpinners.isShown();
        }

        @Override
        public int getYear() {
            return this.mCurrentDate.get(1);
        }

        @Override
        public void init(int n, int n2, int n3, OnDateChangedListener onDateChangedListener) {
            this.setDate(n, n2, n3);
            this.updateSpinners();
            this.updateCalendarView();
            this.mOnDateChangedListener = onDateChangedListener;
        }

        @Override
        public boolean isEnabled() {
            return this.mIsEnabled;
        }

        @Override
        public void onConfigurationChanged(Configuration configuration) {
            this.setCurrentLocale(configuration.locale);
        }

        @Override
        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            accessibilityEvent.setClassName(DatePicker.class.getName());
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            accessibilityNodeInfo.setClassName(DatePicker.class.getName());
        }

        @Override
        public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            String string2 = DateUtils.formatDateTime(this.mContext, this.mCurrentDate.getTimeInMillis(), 20);
            accessibilityEvent.getText().add(string2);
        }

        @Override
        public void onRestoreInstanceState(Parcelable parcelable) {
            SavedState savedState = (SavedState)parcelable;
            this.setDate(savedState.mYear, savedState.mMonth, savedState.mDay);
            this.updateSpinners();
            this.updateCalendarView();
        }

        @Override
        public Parcelable onSaveInstanceState(Parcelable parcelable) {
            return new SavedState(parcelable, this.getYear(), this.getMonth(), this.getDayOfMonth());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setCalendarViewShown(boolean bl) {
            CalendarView calendarView = this.mCalendarView;
            int n = bl ? 0 : 8;
            calendarView.setVisibility(n);
        }

        @Override
        protected void setCurrentLocale(Locale locale) {
            super.setCurrentLocale(locale);
            this.mTempDate = this.getCalendarForLocale(this.mTempDate, locale);
            this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
            this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
            this.mCurrentDate = this.getCalendarForLocale(this.mCurrentDate, locale);
            this.mNumberOfMonths = 1 + this.mTempDate.getActualMaximum(2);
            this.mShortMonths = new DateFormatSymbols().getShortMonths();
            if (this.usingNumericMonths()) {
                this.mShortMonths = new String[this.mNumberOfMonths];
                for (int i = 0; i < this.mNumberOfMonths; ++i) {
                    String[] stringArray = this.mShortMonths;
                    Object[] objectArray = new Object[]{i + 1};
                    stringArray[i] = String.format("%d", objectArray);
                }
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.mDaySpinner.setEnabled(bl);
            this.mMonthSpinner.setEnabled(bl);
            this.mYearSpinner.setEnabled(bl);
            this.mCalendarView.setEnabled(bl);
            this.mIsEnabled = bl;
        }

        @Override
        public void setFirstDayOfWeek(int n) {
            this.mCalendarView.setFirstDayOfWeek(n);
        }

        @Override
        public void setMaxDate(long l) {
            this.mTempDate.setTimeInMillis(l);
            if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
                return;
            }
            this.mMaxDate.setTimeInMillis(l);
            this.mCalendarView.setMaxDate(l);
            if (this.mCurrentDate.after(this.mMaxDate)) {
                this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
                this.updateCalendarView();
            }
            this.updateSpinners();
        }

        @Override
        public void setMinDate(long l) {
            this.mTempDate.setTimeInMillis(l);
            if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
                return;
            }
            this.mMinDate.setTimeInMillis(l);
            this.mCalendarView.setMinDate(l);
            if (this.mCurrentDate.before(this.mMinDate)) {
                this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
                this.updateCalendarView();
            }
            this.updateSpinners();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setSpinnersShown(boolean bl) {
            LinearLayout linearLayout = this.mSpinners;
            int n = bl ? 0 : 8;
            linearLayout.setVisibility(n);
        }

        @Override
        public void updateDate(int n, int n2, int n3) {
            if (!this.isNewDate(n, n2, n3)) {
                return;
            }
            this.setDate(n, n2, n3);
            this.updateSpinners();
            this.updateCalendarView();
            this.notifyDateChanged();
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(DatePicker var1, int var2, int var3, int var4);
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private final int mDay;
        private final int mMonth;
        private final int mYear;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.mYear = parcel.readInt();
            this.mMonth = parcel.readInt();
            this.mDay = parcel.readInt();
        }

        private SavedState(Parcelable parcelable, int n, int n2, int n3) {
            super(parcelable);
            this.mYear = n;
            this.mMonth = n2;
            this.mDay = n3;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.mYear);
            parcel.writeInt(this.mMonth);
            parcel.writeInt(this.mDay);
        }
    }

    public static interface ValidationCallback {
        public void onValidationChanged(boolean var1);
    }
}

