/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.Checkable;
import com.android.internal.R;

public abstract class CompoundButton
extends Button
implements Checkable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private boolean mBroadcasting;
    private Drawable mButtonDrawable;
    private int mButtonResource;
    private ColorStateList mButtonTintList = null;
    private PorterDuff.Mode mButtonTintMode = null;
    private boolean mChecked;
    private boolean mHasButtonTint = false;
    private boolean mHasButtonTintMode = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private OnCheckedChangeListener mOnCheckedChangeWidgetListener;

    public CompoundButton(Context context) {
        this(context, null);
    }

    public CompoundButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CompoundButton(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public CompoundButton(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CompoundButton, n, n2);
        Drawable drawable2 = typedArray.getDrawable(1);
        if (drawable2 != null) {
            this.setButtonDrawable(drawable2);
        }
        if (typedArray.hasValue(3)) {
            this.mButtonTintMode = Drawable.parseTintMode(typedArray.getInt(3, -1), this.mButtonTintMode);
            this.mHasButtonTintMode = true;
        }
        if (typedArray.hasValue(2)) {
            this.mButtonTintList = typedArray.getColorStateList(2);
            this.mHasButtonTint = true;
        }
        this.setChecked(typedArray.getBoolean(0, false));
        typedArray.recycle();
        this.applyButtonTint();
    }

    private void applyButtonTint() {
        if (this.mButtonDrawable != null && (this.mHasButtonTint || this.mHasButtonTintMode)) {
            this.mButtonDrawable = this.mButtonDrawable.mutate();
            if (this.mHasButtonTint) {
                this.mButtonDrawable.setTintList(this.mButtonTintList);
            }
            if (this.mHasButtonTintMode) {
                this.mButtonDrawable.setTintMode(this.mButtonTintMode);
            }
        }
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if (this.mButtonDrawable != null) {
            this.mButtonDrawable.setHotspot(f, f2);
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mButtonDrawable != null) {
            int[] nArray = this.getDrawableState();
            this.mButtonDrawable.setState(nArray);
            this.invalidate();
        }
    }

    public ColorStateList getButtonTintList() {
        return this.mButtonTintList;
    }

    public PorterDuff.Mode getButtonTintMode() {
        return this.mButtonTintMode;
    }

    @Override
    public int getCompoundPaddingLeft() {
        Drawable drawable2;
        int n = super.getCompoundPaddingLeft();
        if (!this.isLayoutRtl() && (drawable2 = this.mButtonDrawable) != null) {
            n += drawable2.getIntrinsicWidth();
        }
        return n;
    }

    @Override
    public int getCompoundPaddingRight() {
        Drawable drawable2;
        int n = super.getCompoundPaddingRight();
        if (this.isLayoutRtl() && (drawable2 = this.mButtonDrawable) != null) {
            n += drawable2.getIntrinsicWidth();
        }
        return n;
    }

    @Override
    public int getHorizontalOffsetForDrawables() {
        Drawable drawable2 = this.mButtonDrawable;
        if (drawable2 != null) {
            return drawable2.getIntrinsicWidth();
        }
        return 0;
    }

    @Override
    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return this.mChecked;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mButtonDrawable != null) {
            this.mButtonDrawable.jumpToCurrentState();
        }
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.isChecked()) {
            CompoundButton.mergeDrawableStates(nArray, CHECKED_STATE_SET);
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        int n;
        int n2;
        Drawable drawable2;
        block10: {
            block9: {
                drawable2 = this.mButtonDrawable;
                if (drawable2 != null) {
                    int n3;
                    int n4 = 0x70 & this.getGravity();
                    int n5 = drawable2.getIntrinsicHeight();
                    int n6 = drawable2.getIntrinsicWidth();
                    switch (n4) {
                        default: {
                            n3 = 0;
                            break;
                        }
                        case 80: {
                            n3 = this.getHeight() - n5;
                            break;
                        }
                        case 16: {
                            n3 = (this.getHeight() - n5) / 2;
                        }
                    }
                    int n7 = n3 + n5;
                    int n8 = this.isLayoutRtl() ? this.getWidth() - n6 : 0;
                    int n9 = this.isLayoutRtl() ? this.getWidth() : n6;
                    drawable2.setBounds(n8, n3, n9, n7);
                    Drawable drawable3 = this.getBackground();
                    if (drawable3 != null) {
                        drawable3.setHotspotBounds(n8, n3, n9, n7);
                    }
                }
                super.onDraw(canvas);
                if (drawable2 == null) break block9;
                n2 = this.mScrollX;
                n = this.mScrollY;
                if (n2 != 0 || n != 0) break block10;
                drawable2.draw(canvas);
            }
            return;
        }
        canvas.translate(n2, n);
        drawable2.draw(canvas);
        canvas.translate(-n2, -n);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(CompoundButton.class.getName());
        accessibilityEvent.setChecked(this.mChecked);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(CompoundButton.class.getName());
        accessibilityNodeInfo.setCheckable(true);
        accessibilityNodeInfo.setChecked(this.mChecked);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setChecked(savedState.checked);
        this.requestLayout();
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.checked = this.isChecked();
        return savedState;
    }

    @Override
    public boolean performClick() {
        this.toggle();
        return super.performClick();
    }

    public void setButtonDrawable(int n) {
        if (n != 0 && n == this.mButtonResource) {
            return;
        }
        int n2 = this.mButtonResource = n;
        Drawable drawable2 = null;
        if (n2 != 0) {
            drawable2 = this.getContext().getDrawable(this.mButtonResource);
        }
        this.setButtonDrawable(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setButtonDrawable(Drawable drawable2) {
        if (this.mButtonDrawable != drawable2) {
            if (this.mButtonDrawable != null) {
                this.mButtonDrawable.setCallback(null);
                this.unscheduleDrawable(this.mButtonDrawable);
            }
            this.mButtonDrawable = drawable2;
            if (drawable2 != null) {
                drawable2.setCallback(this);
                drawable2.setLayoutDirection(this.getLayoutDirection());
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getDrawableState());
                }
                boolean bl = this.getVisibility() == 0;
                drawable2.setVisible(bl, false);
                this.setMinHeight(drawable2.getIntrinsicHeight());
                this.applyButtonTint();
            }
        }
    }

    public void setButtonTintList(ColorStateList colorStateList) {
        this.mButtonTintList = colorStateList;
        this.mHasButtonTint = true;
        this.applyButtonTint();
    }

    public void setButtonTintMode(PorterDuff.Mode mode) {
        this.mButtonTintMode = mode;
        this.mHasButtonTintMode = true;
        this.applyButtonTint();
    }

    @Override
    public void setChecked(boolean bl) {
        block6: {
            block5: {
                if (this.mChecked == bl) break block5;
                this.mChecked = bl;
                this.refreshDrawableState();
                this.notifyViewAccessibilityStateChangedIfNeeded(0);
                if (!this.mBroadcasting) break block6;
            }
            return;
        }
        this.mBroadcasting = true;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
        }
        if (this.mOnCheckedChangeWidgetListener != null) {
            this.mOnCheckedChangeWidgetListener.onCheckedChanged(this, this.mChecked);
        }
        this.mBroadcasting = false;
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeListener = onCheckedChangeListener;
    }

    void setOnCheckedChangeWidgetListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeWidgetListener = onCheckedChangeListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void toggle() {
        boolean bl = !this.mChecked;
        this.setChecked(bl);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return super.verifyDrawable(drawable2) || drawable2 == this.mButtonDrawable;
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean checked;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.checked = (Boolean)parcel.readValue(null);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "CompoundButton.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " checked=" + this.checked + "}";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeValue(this.checked);
        }
    }
}

