/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.Cursor;
import android.database.DataSetObserver;
import android.util.SparseIntArray;
import android.widget.SectionIndexer;
import java.text.Collator;

public class AlphabetIndexer
extends DataSetObserver
implements SectionIndexer {
    private SparseIntArray mAlphaMap;
    protected CharSequence mAlphabet;
    private String[] mAlphabetArray;
    private int mAlphabetLength;
    private Collator mCollator;
    protected int mColumnIndex;
    protected Cursor mDataCursor;

    public AlphabetIndexer(Cursor cursor, int n, CharSequence charSequence) {
        this.mDataCursor = cursor;
        this.mColumnIndex = n;
        this.mAlphabet = charSequence;
        this.mAlphabetLength = charSequence.length();
        this.mAlphabetArray = new String[this.mAlphabetLength];
        for (int i = 0; i < this.mAlphabetLength; ++i) {
            this.mAlphabetArray[i] = Character.toString(this.mAlphabet.charAt(i));
        }
        this.mAlphaMap = new SparseIntArray(this.mAlphabetLength);
        if (cursor != null) {
            cursor.registerDataSetObserver(this);
        }
        this.mCollator = Collator.getInstance();
        this.mCollator.setStrength(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int compare(String string2, String string3) {
        String string4;
        if (string2.length() == 0) {
            string4 = " ";
            return this.mCollator.compare(string4, string3);
        }
        string4 = string2.substring(0, 1);
        return this.mCollator.compare(string4, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getPositionForSection(int n) {
        int n2;
        SparseIntArray sparseIntArray = this.mAlphaMap;
        Cursor cursor = this.mDataCursor;
        if (cursor == null) return 0;
        if (this.mAlphabet == null) {
            return 0;
        }
        if (n <= 0) {
            return 0;
        }
        int n3 = this.mAlphabetLength;
        if (n >= n3) {
            n = -1 + this.mAlphabetLength;
        }
        int n4 = cursor.getPosition();
        int n5 = n2 = cursor.getCount();
        char c = this.mAlphabet.charAt(n);
        String string2 = Character.toString(c);
        int n6 = sparseIntArray.get(c, Integer.MIN_VALUE);
        if (Integer.MIN_VALUE != n6) {
            if (n6 >= 0) return n6;
            n5 = -n6;
        }
        int n7 = 0;
        if (n > 0) {
            int n8 = sparseIntArray.get(this.mAlphabet.charAt(n - 1), Integer.MIN_VALUE);
            n7 = 0;
            if (n8 != Integer.MIN_VALUE) {
                n7 = Math.abs(n8);
            }
        }
        int n9 = (n5 + n7) / 2;
        while (n9 < n5) {
            cursor.moveToPosition(n9);
            String string3 = cursor.getString(this.mColumnIndex);
            if (string3 == null) {
                if (n9 == 0) break;
                --n9;
                continue;
            }
            int n10 = this.compare(string3, string2);
            if (n10 != 0) {
                if (n10 < 0) {
                    n7 = n9 + 1;
                    if (n7 >= n2) {
                        n9 = n2;
                        break;
                    }
                } else {
                    n5 = n9;
                }
            } else {
                if (n7 == n9) break;
                n5 = n9;
            }
            n9 = (n7 + n5) / 2;
        }
        sparseIntArray.put(c, n9);
        cursor.moveToPosition(n4);
        return n9;
    }

    @Override
    public int getSectionForPosition(int n) {
        int n2 = this.mDataCursor.getPosition();
        this.mDataCursor.moveToPosition(n);
        String string2 = this.mDataCursor.getString(this.mColumnIndex);
        this.mDataCursor.moveToPosition(n2);
        for (int i = 0; i < this.mAlphabetLength; ++i) {
            if (this.compare(string2, Character.toString(this.mAlphabet.charAt(i))) != 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public Object[] getSections() {
        return this.mAlphabetArray;
    }

    @Override
    public void onChanged() {
        super.onChanged();
        this.mAlphaMap.clear();
    }

    @Override
    public void onInvalidated() {
        super.onInvalidated();
        this.mAlphaMap.clear();
    }

    public void setCursor(Cursor cursor) {
        if (this.mDataCursor != null) {
            this.mDataCursor.unregisterDataSetObserver(this);
        }
        this.mDataCursor = cursor;
        if (cursor != null) {
            this.mDataCursor.registerDataSetObserver(this);
        }
        this.mAlphaMap.clear();
    }
}

