/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.res.Resources;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.LocaleData;

public class DateSorter {
    public static final int DAY_COUNT = 5;
    private static final String LOGTAG = "webkit";
    private static final int NUM_DAYS_AGO = 7;
    private long[] mBins = new long[4];
    private String[] mLabels = new String[5];

    public DateSorter(Context context) {
        Resources resources = context.getResources();
        Calendar calendar = Calendar.getInstance();
        this.beginningOfDay(calendar);
        this.mBins[0] = calendar.getTimeInMillis();
        calendar.add(6, -1);
        this.mBins[1] = calendar.getTimeInMillis();
        calendar.add(6, -6);
        this.mBins[2] = calendar.getTimeInMillis();
        calendar.add(6, 7);
        calendar.add(2, -1);
        this.mBins[3] = calendar.getTimeInMillis();
        Locale locale = resources.getConfiguration().locale;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        LocaleData localeData = LocaleData.get((Locale)locale);
        this.mLabels[0] = localeData.today;
        this.mLabels[1] = localeData.yesterday;
        String string2 = resources.getQuantityString(0x1140004, 7);
        String[] stringArray = this.mLabels;
        Object[] objectArray = new Object[]{7};
        stringArray[2] = String.format(string2, objectArray);
        this.mLabels[3] = context.getString(17040445);
        this.mLabels[4] = context.getString(17040446);
    }

    private void beginningOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public long getBoundary(int n) {
        if (n < 0 || n > 4) {
            n = 0;
        }
        if (n == 4) {
            return Long.MIN_VALUE;
        }
        return this.mBins[n];
    }

    public int getIndex(long l) {
        for (int i = 0; i < 4; ++i) {
            if (l <= this.mBins[i]) continue;
            return i;
        }
        return 4;
    }

    public String getLabel(int n) {
        if (n < 0 || n >= 5) {
            return "";
        }
        return this.mLabels[n];
    }
}

