/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.Trace;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.Pools;
import android.util.PrintWriterPrinter;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputConnectionWrapper;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputBindResult;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class InputMethodManager {
    public static final int CONTROL_START_INITIAL = 256;
    public static final int CONTROL_WINDOW_FIRST = 4;
    public static final int CONTROL_WINDOW_IS_TEXT_EDITOR = 2;
    public static final int CONTROL_WINDOW_VIEW_HAS_FOCUS = 1;
    static final boolean DEBUG = false;
    public static final int DISPATCH_HANDLED = 1;
    public static final int DISPATCH_IN_PROGRESS = -1;
    public static final int DISPATCH_NOT_HANDLED = 0;
    public static final int HIDE_IMPLICIT_ONLY = 1;
    public static final int HIDE_NOT_ALWAYS = 2;
    static final long INPUT_METHOD_NOT_RESPONDING_TIMEOUT = 2500L;
    static final int MSG_BIND = 2;
    static final int MSG_DUMP = 1;
    static final int MSG_FLUSH_INPUT_EVENT = 7;
    static final int MSG_SEND_INPUT_EVENT = 5;
    static final int MSG_SET_ACTIVE = 4;
    static final int MSG_SET_USER_ACTION_NOTIFICATION_SEQUENCE_NUMBER = 9;
    static final int MSG_TIMEOUT_INPUT_EVENT = 6;
    static final int MSG_UNBIND = 3;
    private static final int NOT_AN_ACTION_NOTIFICATION_SEQUENCE_NUMBER = -1;
    static final String PENDING_EVENT_COUNTER = "aq:imm";
    private static final int REQUEST_UPDATE_CURSOR_ANCHOR_INFO_NONE = 0;
    public static final int RESULT_HIDDEN = 3;
    public static final int RESULT_SHOWN = 2;
    public static final int RESULT_UNCHANGED_HIDDEN = 1;
    public static final int RESULT_UNCHANGED_SHOWN = 0;
    public static final int SHOW_FORCED = 2;
    public static final int SHOW_IMPLICIT = 1;
    static final String TAG = "InputMethodManager";
    static InputMethodManager sInstance;
    boolean mActive = false;
    int mBindSequence = -1;
    final IInputMethodClient.Stub mClient;
    CompletionInfo[] mCompletions;
    InputChannel mCurChannel;
    String mCurId;
    IInputMethodSession mCurMethod;
    View mCurRootView;
    ImeInputEventSender mCurSender;
    EditorInfo mCurrentTextBoxAttribute;
    private CursorAnchorInfo mCursorAnchorInfo = null;
    int mCursorCandEnd;
    int mCursorCandStart;
    Rect mCursorRect;
    int mCursorSelEnd;
    int mCursorSelStart;
    final InputConnection mDummyInputConnection;
    boolean mFullscreenMode;
    final H mH;
    boolean mHasBeenInactive = true;
    final IInputContext mIInputContext;
    private int mLastSentUserActionNotificationSequenceNumber = -1;
    final Looper mMainLooper;
    View mNextServedView;
    private int mNextUserActionNotificationSequenceNumber = -1;
    final Pools.Pool<PendingEvent> mPendingEventPool;
    final SparseArray<PendingEvent> mPendingEvents;
    private int mRequestUpdateCursorAnchorInfoMonitorMode = 0;
    boolean mServedConnecting;
    InputConnection mServedInputConnection;
    ControlledInputConnectionWrapper mServedInputConnectionWrapper;
    View mServedView;
    final IInputMethodManager mService;
    Rect mTmpCursorRect = new Rect();
    private final Matrix mViewToScreenMatrix;
    private final int[] mViewTopLeft;

    InputMethodManager(IInputMethodManager iInputMethodManager, Looper looper) {
        this.mCursorRect = new Rect();
        this.mViewTopLeft = new int[2];
        this.mViewToScreenMatrix = new Matrix();
        this.mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
        this.mPendingEvents = new SparseArray(20);
        this.mClient = new IInputMethodClient.Stub(){

            @Override
            protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = fileDescriptor;
                someArgs.arg2 = printWriter;
                someArgs.arg3 = stringArray;
                someArgs.arg4 = countDownLatch;
                InputMethodManager.this.mH.sendMessage(InputMethodManager.this.mH.obtainMessage(1, someArgs));
                try {
                    if (!countDownLatch.await(5L, TimeUnit.SECONDS)) {
                        printWriter.println("Timeout waiting for dump");
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    printWriter.println("Interrupted waiting for dump");
                    return;
                }
            }

            @Override
            public void onBindMethod(InputBindResult inputBindResult) {
                InputMethodManager.this.mH.sendMessage(InputMethodManager.this.mH.obtainMessage(2, inputBindResult));
            }

            @Override
            public void onUnbindMethod(int n) {
                InputMethodManager.this.mH.sendMessage(InputMethodManager.this.mH.obtainMessage(3, n, 0));
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void setActive(boolean bl) {
                H h = InputMethodManager.this.mH;
                H h2 = InputMethodManager.this.mH;
                int n = bl ? 1 : 0;
                h.sendMessage(h2.obtainMessage(4, n, 0));
            }

            @Override
            public void setUserActionNotificationSequenceNumber(int n) {
                InputMethodManager.this.mH.sendMessage(InputMethodManager.this.mH.obtainMessage(9, n, 0));
            }

            @Override
            public void setUsingInputMethod(boolean bl) {
            }
        };
        this.mDummyInputConnection = new BaseInputConnection(this, false);
        this.mService = iInputMethodManager;
        this.mMainLooper = looper;
        this.mH = new H(looper);
        this.mIInputContext = new ControlledInputConnectionWrapper(looper, this.mDummyInputConnection, this);
    }

    static /* synthetic */ int access$002(InputMethodManager inputMethodManager, int n) {
        inputMethodManager.mRequestUpdateCursorAnchorInfoMonitorMode = n;
        return n;
    }

    static /* synthetic */ int access$202(InputMethodManager inputMethodManager, int n) {
        inputMethodManager.mNextUserActionNotificationSequenceNumber = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean checkFocusNoStartInput(boolean bl, boolean bl2) {
        if (this.mServedView == this.mNextServedView && !bl) {
            return false;
        }
        H h = this.mH;
        // MONITORENTER : h
        if (this.mServedView == this.mNextServedView && !bl) {
            // MONITOREXIT : h
            return false;
        }
        if (this.mNextServedView == null) {
            this.finishInputLocked();
            this.closeCurrentInput();
            // MONITOREXIT : h
            return false;
        }
        InputConnection inputConnection = this.mServedInputConnection;
        this.mServedView = this.mNextServedView;
        this.mCurrentTextBoxAttribute = null;
        this.mCompletions = null;
        this.mServedConnecting = true;
        // MONITOREXIT : h
        if (!bl2) return true;
        if (inputConnection == null) return true;
        inputConnection.finishComposingText();
        return true;
    }

    private void flushPendingEventsLocked() {
        this.mH.removeMessages(7);
        int n = this.mPendingEvents.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.mPendingEvents.keyAt(i);
            Message message = this.mH.obtainMessage(7, n2, 0);
            message.setAsynchronous(true);
            message.sendToTarget();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputMethodManager getInstance() {
        synchronized (InputMethodManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new InputMethodManager(IInputMethodManager.Stub.asInterface(ServiceManager.getService("input_method")), Looper.getMainLooper());
            return sInstance;
        }
    }

    private void notifyInputConnectionFinished() {
        ViewRootImpl viewRootImpl;
        if (this.mServedView != null && this.mServedInputConnection != null && (viewRootImpl = this.mServedView.getViewRootImpl()) != null) {
            viewRootImpl.dispatchFinishInputConnection(this.mServedInputConnection);
        }
    }

    private PendingEvent obtainPendingEventLocked(InputEvent inputEvent, Object object, String string2, FinishedInputEventCallback finishedInputEventCallback, Handler handler) {
        PendingEvent pendingEvent = this.mPendingEventPool.acquire();
        if (pendingEvent == null) {
            pendingEvent = new PendingEvent();
        }
        pendingEvent.mEvent = inputEvent;
        pendingEvent.mToken = object;
        pendingEvent.mInputMethodId = string2;
        pendingEvent.mCallback = finishedInputEventCallback;
        pendingEvent.mHandler = handler;
        return pendingEvent;
    }

    public static InputMethodManager peekInstance() {
        return sInstance;
    }

    private void recyclePendingEventLocked(PendingEvent pendingEvent) {
        pendingEvent.recycle();
        this.mPendingEventPool.release(pendingEvent);
    }

    static void scheduleCheckFocusLocked(View view) {
        ViewRootImpl viewRootImpl = view.getViewRootImpl();
        if (viewRootImpl != null) {
            viewRootImpl.dispatchCheckFocus();
        }
    }

    private void showInputMethodPickerLocked() {
        try {
            this.mService.showInputMethodPickerFromClient(this.mClient);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "IME died: " + this.mCurId, remoteException);
            return;
        }
    }

    public void checkFocus() {
        if (this.checkFocusNoStartInput(false, true)) {
            this.startInputInner(null, 0, 0, 0);
        }
    }

    void clearBindingLocked() {
        this.clearConnectionLocked();
        this.setInputChannelLocked(null);
        this.mBindSequence = -1;
        this.mCurId = null;
        this.mCurMethod = null;
    }

    void clearConnectionLocked() {
        this.mCurrentTextBoxAttribute = null;
        this.mServedInputConnection = null;
        if (this.mServedInputConnectionWrapper != null) {
            this.mServedInputConnectionWrapper.deactivate();
            this.mServedInputConnectionWrapper = null;
        }
    }

    void closeCurrentInput() {
        try {
            this.mService.hideSoftInput(this.mClient, 2, null);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int dispatchInputEvent(InputEvent inputEvent, Object object, FinishedInputEventCallback finishedInputEventCallback, Handler handler) {
        H h = this.mH;
        synchronized (h) {
            KeyEvent keyEvent;
            if (this.mCurMethod == null) {
                return 0;
            }
            if (inputEvent instanceof KeyEvent && (keyEvent = (KeyEvent)inputEvent).getAction() == 0 && keyEvent.getKeyCode() == 63 && keyEvent.getRepeatCount() == 0) {
                this.showInputMethodPickerLocked();
                return 1;
            }
            PendingEvent pendingEvent = this.obtainPendingEventLocked(inputEvent, object, this.mCurId, finishedInputEventCallback, handler);
            if (this.mMainLooper.isCurrentThread()) {
                return this.sendInputEventOnMainLooperLocked(pendingEvent);
            }
            Message message = this.mH.obtainMessage(5, pendingEvent);
            message.setAsynchronous(true);
            this.mH.sendMessage(message);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void displayCompletions(View view, CompletionInfo[] completionInfoArray) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            this.mCompletions = completionInfoArray;
            IInputMethodSession iInputMethodSession = this.mCurMethod;
            if (iInputMethodSession != null) {
                try {
                    this.mCurMethod.displayCompletions(this.mCompletions);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void doDump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        PrintWriterPrinter printWriterPrinter = new PrintWriterPrinter(printWriter);
        printWriterPrinter.println("Input method client state for " + this + ":");
        printWriterPrinter.println("  mService=" + this.mService);
        printWriterPrinter.println("  mMainLooper=" + this.mMainLooper);
        printWriterPrinter.println("  mIInputContext=" + this.mIInputContext);
        printWriterPrinter.println("  mActive=" + this.mActive + " mHasBeenInactive=" + this.mHasBeenInactive + " mBindSequence=" + this.mBindSequence + " mCurId=" + this.mCurId);
        printWriterPrinter.println("  mCurMethod=" + this.mCurMethod);
        printWriterPrinter.println("  mCurRootView=" + this.mCurRootView);
        printWriterPrinter.println("  mServedView=" + this.mServedView);
        printWriterPrinter.println("  mNextServedView=" + this.mNextServedView);
        printWriterPrinter.println("  mServedConnecting=" + this.mServedConnecting);
        if (this.mCurrentTextBoxAttribute != null) {
            printWriterPrinter.println("  mCurrentTextBoxAttribute:");
            this.mCurrentTextBoxAttribute.dump(printWriterPrinter, "    ");
        } else {
            printWriterPrinter.println("  mCurrentTextBoxAttribute: null");
        }
        printWriterPrinter.println("  mServedInputConnection=" + this.mServedInputConnection);
        printWriterPrinter.println("  mCompletions=" + this.mCompletions);
        printWriterPrinter.println("  mCursorRect=" + this.mCursorRect);
        printWriterPrinter.println("  mCursorSelStart=" + this.mCursorSelStart + " mCursorSelEnd=" + this.mCursorSelEnd + " mCursorCandStart=" + this.mCursorCandStart + " mCursorCandEnd=" + this.mCursorCandEnd);
        printWriterPrinter.println("  mNextUserActionNotificationSequenceNumber=" + this.mNextUserActionNotificationSequenceNumber + " mLastSentUserActionNotificationSequenceNumber=" + this.mLastSentUserActionNotificationSequenceNumber);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void finishInputLocked() {
        this.mCurRootView = null;
        this.mNextServedView = null;
        if (this.mServedView != null) {
            if (this.mCurrentTextBoxAttribute != null) {
                try {
                    this.mService.finishInput(this.mClient);
                }
                catch (RemoteException remoteException) {}
            }
            this.notifyInputConnectionFinished();
            this.mServedView = null;
            this.mCompletions = null;
            this.mServedConnecting = false;
            this.clearConnectionLocked();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void finishedInputEvent(int n, boolean bl, boolean bl2) {
        PendingEvent pendingEvent;
        H h = this.mH;
        synchronized (h) {
            int n2 = this.mPendingEvents.indexOfKey(n);
            if (n2 < 0) {
                return;
            }
            pendingEvent = this.mPendingEvents.valueAt(n2);
            this.mPendingEvents.removeAt(n2);
            Trace.traceCounter(4L, PENDING_EVENT_COUNTER, this.mPendingEvents.size());
            if (bl2) {
                Log.w(TAG, "Timeout waiting for IME to handle input event after 2500 ms: " + pendingEvent.mInputMethodId);
            } else {
                this.mH.removeMessages(6, pendingEvent);
            }
        }
        this.invokeFinishedInputEventCallback(pendingEvent, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void focusIn(View view) {
        H h = this.mH;
        synchronized (h) {
            this.focusInLocked(view);
            return;
        }
    }

    void focusInLocked(View view) {
        if (this.mCurRootView != view.getRootView()) {
            return;
        }
        this.mNextServedView = view;
        InputMethodManager.scheduleCheckFocusLocked(view);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void focusOut(View view) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view) {
                // empty if block
            }
            return;
        }
    }

    public IInputMethodClient getClient() {
        return this.mClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputMethodSubtype getCurrentInputMethodSubtype() {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.getCurrentInputMethodSubtype();
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                return null;
            }
        }
    }

    public List<InputMethodInfo> getEnabledInputMethodList() {
        try {
            List<InputMethodInfo> list = this.mService.getEnabledInputMethodList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(InputMethodInfo inputMethodInfo, boolean bl) {
        try {
            String string2;
            String string3;
            IInputMethodManager iInputMethodManager = this.mService;
            if (inputMethodInfo == null) {
                string3 = null;
                return iInputMethodManager.getEnabledInputMethodSubtypeList(string3, bl);
            }
            string3 = string2 = inputMethodInfo.getId();
            return iInputMethodManager.getEnabledInputMethodSubtypeList(string3, bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public IInputContext getInputContext() {
        return this.mIInputContext;
    }

    public List<InputMethodInfo> getInputMethodList() {
        try {
            List<InputMethodInfo> list = this.mService.getInputMethodList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInputMethodWindowVisibleHeight() {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.getInputMethodWindowVisibleHeight();
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                return 0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputMethodSubtype getLastInputMethodSubtype() {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.getLastInputMethodSubtype();
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<InputMethodInfo, List<InputMethodSubtype>> getShortcutInputMethodsAndSubtypes() {
        H h = this.mH;
        synchronized (h) {
            HashMap<InputMethodInfo, List<InputMethodSubtype>> hashMap;
            block7: {
                int n;
                ArrayList<InputMethodSubtype> arrayList;
                List list;
                hashMap = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
                try {
                    list = this.mService.getShortcutInputMethodsAndSubtypes();
                    arrayList = null;
                    n = list.size();
                    if (list == null || n <= 0) break block7;
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                    break block7;
                }
                for (int i = 0; i < n; ++i) {
                    Object e = list.get(i);
                    if (e instanceof InputMethodInfo) {
                        if (hashMap.containsKey(e)) {
                            Log.e(TAG, "IMI list already contains the same InputMethod.");
                            break;
                        }
                        arrayList = new ArrayList<InputMethodSubtype>();
                        hashMap.put((InputMethodInfo)e, arrayList);
                        continue;
                    }
                    if (arrayList == null || !(e instanceof InputMethodSubtype)) continue;
                    arrayList.add((InputMethodSubtype)e);
                }
            }
            return hashMap;
        }
    }

    public void hideSoftInputFromInputMethod(IBinder iBinder, int n) {
        try {
            this.mService.hideMySoftInput(iBinder, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean hideSoftInputFromWindow(IBinder iBinder, int n) {
        return this.hideSoftInputFromWindow(iBinder, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hideSoftInputFromWindow(IBinder iBinder, int n, ResultReceiver resultReceiver) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null) return false;
            if (this.mServedView.getWindowToken() != iBinder) {
                return false;
            }
            try {
                return this.mService.hideSoftInput(this.mClient, n, resultReceiver);
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
    }

    public void hideStatusIcon(IBinder iBinder) {
        try {
            this.mService.updateStatusIcon(iBinder, null, 0);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    void invokeFinishedInputEventCallback(PendingEvent pendingEvent, boolean bl) {
        pendingEvent.mHandled = bl;
        if (pendingEvent.mHandler.getLooper().isCurrentThread()) {
            pendingEvent.run();
            return;
        }
        Message message = Message.obtain(pendingEvent.mHandler, pendingEvent);
        message.setAsynchronous(true);
        message.sendToTarget();
    }

    public boolean isAcceptingText() {
        this.checkFocus();
        return this.mServedInputConnection != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive() {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null) return false;
            if (this.mCurrentTextBoxAttribute == null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive(View view) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view) {
                if (this.mServedView == null) return false;
                if (!this.mServedView.checkInputConnectionProxy(view)) return false;
            }
            if (this.mCurrentTextBoxAttribute == null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCursorAnchorInfoEnabled() {
        H h = this.mH;
        synchronized (h) {
            boolean bl = (1 & this.mRequestUpdateCursorAnchorInfoMonitorMode) != 0;
            boolean bl2 = (2 & this.mRequestUpdateCursorAnchorInfoMonitorMode) != 0;
            if (bl) return true;
            boolean bl3 = false;
            if (!bl2) return bl3;
            return true;
        }
    }

    public boolean isFullscreenMode() {
        return this.mFullscreenMode;
    }

    @Deprecated
    public boolean isWatchingCursor(View view) {
        return false;
    }

    public void notifySuggestionPicked(SuggestionSpan suggestionSpan, String string2, int n) {
        try {
            this.mService.notifySuggestionPicked(suggestionSpan, string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyUserAction() {
        H h = this.mH;
        synchronized (h) {
            if (this.mLastSentUserActionNotificationSequenceNumber == this.mNextUserActionNotificationSequenceNumber) {
                return;
            }
            try {
                this.mService.notifyUserAction(this.mNextUserActionNotificationSequenceNumber);
                this.mLastSentUserActionNotificationSequenceNumber = this.mNextUserActionNotificationSequenceNumber;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onWindowFocus(View view, View view2, int n, boolean bl, int n2) {
        boolean bl2;
        H h = this.mH;
        synchronized (h) {
            boolean bl3 = this.mHasBeenInactive;
            bl2 = false;
            if (bl3) {
                this.mHasBeenInactive = false;
                bl2 = true;
            }
            View view3 = view2 != null ? view2 : view;
            this.focusInLocked(view3);
        }
        int n3 = 0;
        if (view2 != null) {
            n3 = 0 | 1;
            if (view2.onCheckIsTextEditor()) {
                n3 |= 2;
            }
        }
        if (bl) {
            n3 |= 4;
        }
        if (this.checkFocusNoStartInput(bl2, true) && this.startInputInner(view.getWindowToken(), n3, n, n2)) {
            return;
        }
        H h2 = this.mH;
        synchronized (h2) {
            try {
                this.mService.windowGainedFocus(this.mClient, view.getWindowToken(), n3, n, n2, null, null);
            }
            catch (RemoteException remoteException) {}
            return;
        }
    }

    public void registerSuggestionSpansForNotification(SuggestionSpan[] suggestionSpanArray) {
        try {
            this.mService.registerSuggestionSpansForNotification(suggestionSpanArray);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void reportFinishInputConnection(InputConnection inputConnection) {
        if (this.mServedInputConnection != inputConnection) {
            inputConnection.finishComposingText();
            if (inputConnection instanceof BaseInputConnection) {
                ((BaseInputConnection)inputConnection).reportFinish();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restartInput(View view) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            this.mServedConnecting = true;
        }
        this.startInputInner(null, 0, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendAppPrivateCommand(View view, String string2, Bundle bundle) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            try {
                this.mCurMethod.appPrivateCommand(string2, bundle);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendInputEventAndReportResultOnMainLooper(PendingEvent pendingEvent) {
        boolean bl = true;
        H h = this.mH;
        synchronized (h) {
            boolean bl2 = this.sendInputEventOnMainLooperLocked(pendingEvent);
            if (bl2) {
                return;
            }
            if (bl2 != bl) {
                bl = false;
            }
        }
        this.invokeFinishedInputEventCallback(pendingEvent, bl);
    }

    int sendInputEventOnMainLooperLocked(PendingEvent pendingEvent) {
        if (this.mCurChannel != null) {
            InputEvent inputEvent;
            int n;
            if (this.mCurSender == null) {
                this.mCurSender = new ImeInputEventSender(this.mCurChannel, this.mH.getLooper());
            }
            if (this.mCurSender.sendInputEvent(n = (inputEvent = pendingEvent.mEvent).getSequenceNumber(), inputEvent)) {
                this.mPendingEvents.put(n, pendingEvent);
                Trace.traceCounter(4L, PENDING_EVENT_COUNTER, this.mPendingEvents.size());
                Message message = this.mH.obtainMessage(6, pendingEvent);
                message.setAsynchronous(true);
                this.mH.sendMessageDelayed(message, 2500L);
                return -1;
            }
            Log.w(TAG, "Unable to send input event to IME: " + this.mCurId + " dropping: " + inputEvent);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAdditionalInputMethodSubtypes(String string2, InputMethodSubtype[] inputMethodSubtypeArray) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.setAdditionalInputMethodSubtypes(string2, inputMethodSubtypeArray);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setCurrentInputMethodSubtype(InputMethodSubtype inputMethodSubtype) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.setCurrentInputMethodSubtype(inputMethodSubtype);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                return false;
            }
        }
    }

    public void setFullscreenMode(boolean bl) {
        this.mFullscreenMode = bl;
    }

    public void setImeWindowStatus(IBinder iBinder, int n, int n2) {
        try {
            this.mService.setImeWindowStatus(iBinder, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    void setInputChannelLocked(InputChannel inputChannel) {
        if (this.mCurChannel != inputChannel) {
            if (this.mCurSender != null) {
                this.flushPendingEventsLocked();
                this.mCurSender.dispose();
                this.mCurSender = null;
            }
            if (this.mCurChannel != null) {
                this.mCurChannel.dispose();
            }
            this.mCurChannel = inputChannel;
        }
    }

    public void setInputMethod(IBinder iBinder, String string2) {
        try {
            this.mService.setInputMethod(iBinder, string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setInputMethodAndSubtype(IBinder iBinder, String string2, InputMethodSubtype inputMethodSubtype) {
        try {
            this.mService.setInputMethodAndSubtype(iBinder, string2, inputMethodSubtype);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUpdateCursorAnchorInfoMode(int n) {
        H h = this.mH;
        synchronized (h) {
            this.mRequestUpdateCursorAnchorInfoMonitorMode = n;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldOfferSwitchingToNextInputMethod(IBinder iBinder) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.shouldOfferSwitchingToNextInputMethod(iBinder);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showInputMethodAndSubtypeEnabler(String string2) {
        H h = this.mH;
        synchronized (h) {
            try {
                this.mService.showInputMethodAndSubtypeEnablerFromClient(this.mClient, string2);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showInputMethodPicker() {
        H h = this.mH;
        synchronized (h) {
            this.showInputMethodPickerLocked();
            return;
        }
    }

    public boolean showSoftInput(View view, int n) {
        return this.showSoftInput(view, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean showSoftInput(View view, int n, ResultReceiver resultReceiver) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view) {
                if (this.mServedView == null) return false;
                if (!this.mServedView.checkInputConnectionProxy(view)) {
                    return false;
                }
            }
            try {
                return this.mService.showSoftInput(this.mClient, n, resultReceiver);
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
    }

    public void showSoftInputFromInputMethod(IBinder iBinder, int n) {
        try {
            this.mService.showMySoftInput(iBinder, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void showSoftInputUnchecked(int n, ResultReceiver resultReceiver) {
        try {
            this.mService.showSoftInput(this.mClient, n, resultReceiver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void showStatusIcon(IBinder iBinder, String string2, int n) {
        try {
            this.mService.updateStatusIcon(iBinder, string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startGettingWindowFocus(View view) {
        H h = this.mH;
        synchronized (h) {
            this.mCurRootView = view;
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean startInputInner(IBinder var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 = this.mH;
        synchronized (var5_5) {
            var7_6 = this.mServedView;
            if (var7_6 == null) {
                return false;
            }
        }
        var8_7 = var7_6.getHandler();
        if (var8_7 == null) {
            this.closeCurrentInput();
            return false;
        }
        if (var8_7.getLooper() != Looper.myLooper()) {
            var8_7.post(new Runnable(){

                @Override
                public void run() {
                    InputMethodManager.this.startInputInner(null, 0, 0, 0);
                }
            });
            return false;
        }
        var9_8 = new EditorInfo();
        var9_8.packageName = var7_6.getContext().getPackageName();
        var9_8.fieldId = var7_6.getId();
        var10_9 = var7_6.onCreateInputConnection(var9_8);
        var11_10 = this.mH;
        synchronized (var11_10) {
            block24: {
                block23: {
                    block25: {
                        if (this.mServedView != var7_6 || !this.mServedConnecting) {
                            return false;
                        }
                        if (this.mCurrentTextBoxAttribute == null) {
                            var2_2 = 256 | var2_2;
                        }
                        this.mCurrentTextBoxAttribute = var9_8;
                        this.mServedConnecting = false;
                        this.notifyInputConnectionFinished();
                        this.mServedInputConnection = var10_9;
                        if (var10_9 != null) {
                            this.mCursorSelStart = var9_8.initialSelStart;
                            this.mCursorSelEnd = var9_8.initialSelEnd;
                            this.mCursorCandStart = -1;
                            this.mCursorCandEnd = -1;
                            this.mCursorRect.setEmpty();
                            this.mCursorAnchorInfo = null;
                            var13_11 = new ControlledInputConnectionWrapper(var8_7.getLooper(), var10_9, this);
                        } else {
                            var13_11 = null;
                        }
                        if (this.mServedInputConnectionWrapper != null) {
                            this.mServedInputConnectionWrapper.deactivate();
                        }
                        this.mServedInputConnectionWrapper = var13_11;
                        if (var1_1 == null) ** GOTO lbl45
                        var16_12 = this.mService.windowGainedFocus(this.mClient, var1_1, var2_2, var3_3, var4_4, var9_8, var13_11);
                        break block25;
lbl45:
                        // 1 sources

                        var16_12 = this.mService.startInput(this.mClient, var13_11, var9_8, var2_2);
                    }
                    if (var16_12 != null) {
                        if (var16_12.id != null) {
                            this.setInputChannelLocked(var16_12.channel);
                            this.mBindSequence = var16_12.sequence;
                            this.mCurMethod = var16_12.method;
                            this.mCurId = var16_12.id;
                            this.mNextUserActionNotificationSequenceNumber = var16_12.userActionNotificationSequenceNumber;
                        } else {
                            if (var16_12.channel != null && var16_12.channel != this.mCurChannel) {
                                var16_12.channel.dispose();
                            }
                            if ((var17_14 = this.mCurMethod) == null) break block23;
                        }
                    }
                    if (this.mCurMethod == null || (var18_13 = this.mCompletions) == null) ** GOTO lbl69
                    try {
                        this.mCurMethod.displayCompletions(this.mCompletions);
                        break block24;
                    }
                    catch (RemoteException var19_16) {}
                }
                return true;
                catch (RemoteException var14_15) {
                    Log.w("InputMethodManager", "IME died: " + this.mCurId, var14_15);
                }
            }
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean switchToLastInputMethod(IBinder iBinder) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.switchToLastInputMethod(iBinder);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean switchToNextInputMethod(IBinder iBinder, boolean bl) {
        H h = this.mH;
        synchronized (h) {
            try {
                return this.mService.switchToNextInputMethod(iBinder, bl);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                return false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toggleSoftInput(int n, int n2) {
        if (this.mCurMethod == null) return;
        try {
            this.mCurMethod.toggleSoftInput(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toggleSoftInputFromWindow(IBinder iBinder, int n, int n2) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null || this.mServedView.getWindowToken() != iBinder) {
                return;
            }
            IInputMethodSession iInputMethodSession = this.mCurMethod;
            if (iInputMethodSession != null) {
                try {
                    this.mCurMethod.toggleSoftInput(n, n2);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void updateCursor(View view, int n, int n2, int n3, int n4) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            this.mTmpCursorRect.set(n, n2, n3, n4);
            boolean bl = this.mCursorRect.equals(this.mTmpCursorRect);
            if (!bl) {
                try {
                    this.mCurMethod.updateCursor(this.mTmpCursorRect);
                    this.mCursorRect.set(this.mTmpCursorRect);
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateCursorAnchorInfo(View view, CursorAnchorInfo cursorAnchorInfo) {
        if (view == null || cursorAnchorInfo == null) {
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            boolean bl = (1 & this.mRequestUpdateCursorAnchorInfoMonitorMode) != 0;
            if (!bl && Objects.equals(this.mCursorAnchorInfo, cursorAnchorInfo)) {
                return;
            }
            try {
                this.mCurMethod.updateCursorAnchorInfo(cursorAnchorInfo);
                this.mCursorAnchorInfo = cursorAnchorInfo;
                this.mRequestUpdateCursorAnchorInfoMonitorMode = 0xFFFFFFFE & this.mRequestUpdateCursorAnchorInfoMonitorMode;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateExtractedText(View view, int n, ExtractedText extractedText) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            IInputMethodSession iInputMethodSession = this.mCurMethod;
            if (iInputMethodSession != null) {
                try {
                    this.mCurMethod.updateExtractedText(n, extractedText);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateSelection(View view, int n, int n2, int n3, int n4) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            int n5;
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            if (this.mCursorSelStart != n || this.mCursorSelEnd != n2 || this.mCursorCandStart != n3 || (n5 = this.mCursorCandEnd) != n4) {
                try {
                    int n6 = this.mCursorSelStart;
                    int n7 = this.mCursorSelEnd;
                    this.mCursorSelStart = n;
                    this.mCursorSelEnd = n2;
                    this.mCursorCandStart = n3;
                    this.mCursorCandEnd = n4;
                    this.mCurMethod.updateSelection(n6, n7, n, n2, n3, n4);
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "IME died: " + this.mCurId, remoteException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void viewClicked(View view) {
        boolean bl = this.mServedView != this.mNextServedView;
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            try {
                this.mCurMethod.viewClicked(bl);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "IME died: " + this.mCurId, remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void windowDismissed(IBinder iBinder) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != null && this.mServedView.getWindowToken() == iBinder) {
                this.finishInputLocked();
            }
            return;
        }
    }

    private static class ControlledInputConnectionWrapper
    extends IInputConnectionWrapper {
        private boolean mActive;
        private final InputMethodManager mParentInputMethodManager;

        public ControlledInputConnectionWrapper(Looper looper, InputConnection inputConnection, InputMethodManager inputMethodManager) {
            super(looper, inputConnection);
            this.mParentInputMethodManager = inputMethodManager;
            this.mActive = true;
        }

        void deactivate() {
            this.mActive = false;
        }

        @Override
        public boolean isActive() {
            return this.mParentInputMethodManager.mActive && this.mActive;
        }
    }

    public static interface FinishedInputEventCallback {
        public void onFinishedInputEvent(Object var1, boolean var2);
    }

    class H
    extends Handler {
        H(Looper looper) {
            super(looper, null, true);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message message) {
            block35: {
                block34: {
                    boolean bl = true;
                    switch (message.what) {
                        default: {
                            return;
                        }
                        case 1: {
                            SomeArgs someArgs = (SomeArgs)message.obj;
                            try {
                                InputMethodManager.this.doDump((FileDescriptor)someArgs.arg1, (PrintWriter)someArgs.arg2, (String[])someArgs.arg3);
                            }
                            catch (RuntimeException runtimeException) {
                                ((PrintWriter)someArgs.arg2).println("Exception: " + runtimeException);
                            }
                            Object object = someArgs.arg4;
                            // MONITORENTER : object
                            ((CountDownLatch)someArgs.arg4).countDown();
                            // MONITOREXIT : object
                            someArgs.recycle();
                            return;
                        }
                        case 2: {
                            InputBindResult inputBindResult = (InputBindResult)message.obj;
                            H h = InputMethodManager.this.mH;
                            // MONITORENTER : h
                            if (InputMethodManager.this.mBindSequence >= 0 && InputMethodManager.this.mBindSequence == inputBindResult.sequence) {
                                InputMethodManager.access$002(InputMethodManager.this, 0);
                                InputMethodManager.this.setInputChannelLocked(inputBindResult.channel);
                                InputMethodManager.this.mCurMethod = inputBindResult.method;
                                InputMethodManager.this.mCurId = inputBindResult.id;
                                InputMethodManager.this.mBindSequence = inputBindResult.sequence;
                                // MONITOREXIT : h
                                InputMethodManager.this.startInputInner(null, 0, 0, 0);
                                return;
                            }
                            Log.w(InputMethodManager.TAG, "Ignoring onBind: cur seq=" + InputMethodManager.this.mBindSequence + ", given seq=" + inputBindResult.sequence);
                            if (inputBindResult.channel != null && inputBindResult.channel != InputMethodManager.this.mCurChannel) {
                                inputBindResult.channel.dispose();
                            }
                            // MONITOREXIT : h
                            return;
                        }
                        case 3: {
                            int n = message.arg1;
                            H h = InputMethodManager.this.mH;
                            // MONITORENTER : h
                            int n2 = InputMethodManager.this.mBindSequence;
                            boolean bl2 = false;
                            if (n2 == n) {
                                InputMethodManager.this.clearBindingLocked();
                                if (InputMethodManager.this.mServedView != null && InputMethodManager.this.mServedView.isFocused()) {
                                    InputMethodManager.this.mServedConnecting = true;
                                }
                                boolean bl3 = InputMethodManager.this.mActive;
                                bl2 = false;
                                if (bl3) {
                                    bl2 = true;
                                }
                            }
                            // MONITOREXIT : h
                            if (!bl2) return;
                            InputMethodManager.this.startInputInner(null, 0, 0, 0);
                            return;
                        }
                        case 4: {
                            if (message.arg1 == 0) {
                                bl = false;
                            }
                            H h = InputMethodManager.this.mH;
                            // MONITORENTER : h
                            InputMethodManager.this.mActive = bl;
                            InputMethodManager.this.mFullscreenMode = false;
                            if (bl) break block35;
                            InputMethodManager.this.mHasBeenInactive = true;
                            InputMethodManager.this.mIInputContext.finishComposingText();
                            break block34;
                        }
                        case 5: {
                            InputMethodManager.this.sendInputEventAndReportResultOnMainLooper((PendingEvent)message.obj);
                            return;
                        }
                        case 6: {
                            InputMethodManager.this.finishedInputEvent(message.arg1, false, bl);
                            return;
                        }
                        case 7: {
                            InputMethodManager.this.finishedInputEvent(message.arg1, false, false);
                            return;
                        }
                        case 9: {
                            H h = InputMethodManager.this.mH;
                            // MONITORENTER : h
                            InputMethodManager.access$202(InputMethodManager.this, message.arg1);
                            // MONITOREXIT : h
                            return;
                        }
                    }
                    catch (RemoteException remoteException) {}
                }
                if (InputMethodManager.this.mServedView != null && InputMethodManager.this.mServedView.hasWindowFocus() && InputMethodManager.this.checkFocusNoStartInput(InputMethodManager.this.mHasBeenInactive, false)) {
                    InputMethodManager.this.startInputInner(null, 0, 0, 0);
                }
            }
            // MONITOREXIT : h
        }
    }

    private final class ImeInputEventSender
    extends InputEventSender {
        public ImeInputEventSender(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        @Override
        public void onInputEventFinished(int n, boolean bl) {
            InputMethodManager.this.finishedInputEvent(n, bl, false);
        }
    }

    private final class PendingEvent
    implements Runnable {
        public FinishedInputEventCallback mCallback;
        public InputEvent mEvent;
        public boolean mHandled;
        public Handler mHandler;
        public String mInputMethodId;
        public Object mToken;

        private PendingEvent() {
        }

        public void recycle() {
            this.mEvent = null;
            this.mToken = null;
            this.mInputMethodId = null;
            this.mCallback = null;
            this.mHandler = null;
            this.mHandled = false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.mCallback.onFinishedInputEvent(this.mToken, this.mHandled);
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.recyclePendingEventLocked(this);
                return;
            }
        }
    }
}

