/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Printer;
import android.util.Slog;
import android.util.Xml;
import android.view.inputmethod.InputMethodSubtype;
import android.view.inputmethod.InputMethodSubtypeArray;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public final class InputMethodInfo
implements Parcelable {
    public static final Parcelable.Creator<InputMethodInfo> CREATOR = new Parcelable.Creator<InputMethodInfo>(){

        @Override
        public InputMethodInfo createFromParcel(Parcel parcel) {
            return new InputMethodInfo(parcel);
        }

        public InputMethodInfo[] newArray(int n) {
            return new InputMethodInfo[n];
        }
    };
    static final String TAG = "InputMethodInfo";
    private final boolean mForceDefault;
    final String mId;
    private final boolean mIsAuxIme;
    final int mIsDefaultResId;
    final ResolveInfo mService;
    final String mSettingsActivityName;
    private final InputMethodSubtypeArray mSubtypes;
    private final boolean mSupportsSwitchingToNextInputMethod;

    public InputMethodInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this(context, resolveInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputMethodInfo(Context context, ResolveInfo resolveInfo, Map<String, List<InputMethodSubtype>> map) throws XmlPullParserException, IOException {
        InputMethodSubtypeArray inputMethodSubtypeArray;
        boolean bl;
        int n;
        String string2;
        ArrayList<InputMethodSubtype> arrayList;
        boolean bl2;
        block16: {
            int n2;
            int n3;
            AttributeSet attributeSet;
            Resources resources;
            XmlResourceParser xmlResourceParser;
            block17: {
                int n4;
                this.mService = resolveInfo;
                ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                this.mId = new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString();
                bl2 = true;
                this.mForceDefault = false;
                PackageManager packageManager = context.getPackageManager();
                xmlResourceParser = null;
                arrayList = new ArrayList<InputMethodSubtype>();
                try {
                    xmlResourceParser = serviceInfo.loadXmlMetaData(packageManager, "android.view.im");
                    if (xmlResourceParser == null) {
                        throw new XmlPullParserException("No android.view.im meta-data");
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    throw new XmlPullParserException("Unable to create context for: " + serviceInfo.packageName);
                }
                resources = packageManager.getResourcesForApplication(serviceInfo.applicationInfo);
                attributeSet = Xml.asAttributeSet(xmlResourceParser);
                while ((n4 = xmlResourceParser.next()) != 1 && n4 != 2) {
                }
                if (!"input-method".equals(xmlResourceParser.getName())) {
                    throw new XmlPullParserException("Meta-data does not start with input-method tag");
                }
                TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.InputMethod);
                string2 = typedArray.getString(1);
                n = typedArray.getResourceId(0, 0);
                bl = typedArray.getBoolean(2, false);
                typedArray.recycle();
                n3 = xmlResourceParser.getDepth();
                break block17;
                finally {
                    if (xmlResourceParser != null) {
                        xmlResourceParser.close();
                    }
                }
            }
            while (((n2 = xmlResourceParser.next()) != 3 || xmlResourceParser.getDepth() > n3) && n2 != 1) {
                if (n2 != 2) continue;
                if (!"subtype".equals(xmlResourceParser.getName())) {
                    throw new XmlPullParserException("Meta-data in input-method does not start with subtype tag");
                }
                TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.InputMethod_Subtype);
                InputMethodSubtype inputMethodSubtype = new InputMethodSubtype.InputMethodSubtypeBuilder().setSubtypeNameResId(typedArray.getResourceId(0, 0)).setSubtypeIconResId(typedArray.getResourceId(1, 0)).setSubtypeLocale(typedArray.getString(2)).setSubtypeMode(typedArray.getString(3)).setSubtypeExtraValue(typedArray.getString(4)).setIsAuxiliary(typedArray.getBoolean(5, false)).setOverridesImplicitlyEnabledSubtype(typedArray.getBoolean(6, false)).setSubtypeId(typedArray.getInt(7, 0)).setIsAsciiCapable(typedArray.getBoolean(8, false)).build();
                if (!inputMethodSubtype.isAuxiliary()) {
                    bl2 = false;
                }
                arrayList.add(inputMethodSubtype);
            }
            if (arrayList.size() == 0) {
                bl2 = false;
            }
            if (map == null || !map.containsKey(this.mId)) break block16;
            List<InputMethodSubtype> list = map.get(this.mId);
            int n5 = list.size();
            for (int i = 0; i < n5; ++i) {
                InputMethodSubtype inputMethodSubtype = list.get(i);
                if (!arrayList.contains(inputMethodSubtype)) {
                    arrayList.add(inputMethodSubtype);
                    continue;
                }
                Slog.w(TAG, "Duplicated subtype definition found: " + inputMethodSubtype.getLocale() + ", " + inputMethodSubtype.getMode());
            }
        }
        this.mSubtypes = inputMethodSubtypeArray = new InputMethodSubtypeArray(arrayList);
        this.mSettingsActivityName = string2;
        this.mIsDefaultResId = n;
        this.mIsAuxIme = bl2;
        this.mSupportsSwitchingToNextInputMethod = bl;
    }

    public InputMethodInfo(ResolveInfo resolveInfo, boolean bl, String string2, List<InputMethodSubtype> list, int n, boolean bl2) {
        this(resolveInfo, bl, string2, list, n, bl2, true);
    }

    public InputMethodInfo(ResolveInfo resolveInfo, boolean bl, String string2, List<InputMethodSubtype> list, int n, boolean bl2, boolean bl3) {
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        this.mService = resolveInfo;
        this.mId = new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString();
        this.mSettingsActivityName = string2;
        this.mIsDefaultResId = n;
        this.mIsAuxIme = bl;
        this.mSubtypes = new InputMethodSubtypeArray(list);
        this.mForceDefault = bl2;
        this.mSupportsSwitchingToNextInputMethod = bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    InputMethodInfo(Parcel parcel) {
        int n = 1;
        this.mId = parcel.readString();
        this.mSettingsActivityName = parcel.readString();
        this.mIsDefaultResId = parcel.readInt();
        int n2 = parcel.readInt() == n ? n : 0;
        this.mIsAuxIme = n2;
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.mSupportsSwitchingToNextInputMethod = n;
        this.mService = ResolveInfo.CREATOR.createFromParcel(parcel);
        this.mSubtypes = new InputMethodSubtypeArray(parcel);
        this.mForceDefault = false;
    }

    public InputMethodInfo(String string2, String string3, CharSequence charSequence, String string4) {
        this(InputMethodInfo.buildDummyResolveInfo(string2, string3, charSequence), false, string4, null, 0, false, true);
    }

    private static ResolveInfo buildDummyResolveInfo(String string2, String string3, CharSequence charSequence) {
        ResolveInfo resolveInfo = new ResolveInfo();
        ServiceInfo serviceInfo = new ServiceInfo();
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.packageName = string2;
        applicationInfo.enabled = true;
        serviceInfo.applicationInfo = applicationInfo;
        serviceInfo.enabled = true;
        serviceInfo.packageName = string2;
        serviceInfo.name = string3;
        serviceInfo.exported = true;
        serviceInfo.nonLocalizedLabel = charSequence;
        resolveInfo.serviceInfo = serviceInfo;
        return resolveInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        printer.println(string2 + "mId=" + this.mId + " mSettingsActivityName=" + this.mSettingsActivityName);
        printer.println(string2 + "mIsDefaultResId=0x" + Integer.toHexString(this.mIsDefaultResId));
        printer.println(string2 + "Service:");
        this.mService.dump(printer, string2 + "  ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        boolean bl = false;
        if (object == null) return bl;
        boolean bl2 = object instanceof InputMethodInfo;
        bl = false;
        if (!bl2) return bl;
        InputMethodInfo inputMethodInfo = (InputMethodInfo)object;
        return this.mId.equals(inputMethodInfo.mId);
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public String getId() {
        return this.mId;
    }

    public int getIsDefaultResourceId() {
        return this.mIsDefaultResId;
    }

    public String getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public String getServiceName() {
        return this.mService.serviceInfo.name;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    public InputMethodSubtype getSubtypeAt(int n) {
        return this.mSubtypes.get(n);
    }

    public int getSubtypeCount() {
        return this.mSubtypes.getCount();
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public boolean isAuxiliaryIme() {
        return this.mIsAuxIme;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDefault(Context context) {
        if (this.mForceDefault) {
            return true;
        }
        int n = this.getIsDefaultResourceId();
        boolean bl = false;
        if (n == 0) return bl;
        try {
            return context.createPackageContext(this.getPackageName(), 0).getResources().getBoolean(this.getIsDefaultResourceId());
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
        catch (Resources.NotFoundException notFoundException) {
            return false;
        }
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return this.mService.loadIcon(packageManager);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return this.mService.loadLabel(packageManager);
    }

    public boolean supportsSwitchingToNextInputMethod() {
        return this.mSupportsSwitchingToNextInputMethod;
    }

    public String toString() {
        return "InputMethodInfo{" + this.mId + ", settings: " + this.mSettingsActivityName + "}";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeString(this.mId);
        parcel.writeString(this.mSettingsActivityName);
        parcel.writeInt(this.mIsDefaultResId);
        int n3 = this.mIsAuxIme ? n2 : 0;
        parcel.writeInt(n3);
        if (!this.mSupportsSwitchingToNextInputMethod) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        this.mService.writeToParcel(parcel, n);
        this.mSubtypes.writeToParcel(parcel);
    }
}

