/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MetaKeyKeyListener;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ComposingText;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;

public class BaseInputConnection
implements InputConnection {
    static final Object COMPOSING = new ComposingText();
    private static final boolean DEBUG = false;
    private static final String TAG = "BaseInputConnection";
    private Object[] mDefaultComposingSpans;
    final boolean mDummyMode;
    Editable mEditable;
    protected final InputMethodManager mIMM;
    KeyCharacterMap mKeyCharacterMap;
    final View mTargetView;

    /*
     * Enabled aggressive block sorting
     */
    public BaseInputConnection(View view, boolean bl) {
        this.mIMM = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.mTargetView = view;
        boolean bl2 = !bl;
        this.mDummyMode = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    BaseInputConnection(InputMethodManager inputMethodManager, boolean bl) {
        this.mIMM = inputMethodManager;
        this.mTargetView = null;
        boolean bl2 = !bl;
        this.mDummyMode = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ensureDefaultComposingSpans() {
        Context context;
        if (this.mDefaultComposingSpans != null) return;
        if (this.mTargetView != null) {
            context = this.mTargetView.getContext();
        } else {
            if (this.mIMM.mServedView == null) return;
            context = this.mIMM.mServedView.getContext();
        }
        if (context == null) return;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{16843312});
        CharSequence charSequence = typedArray.getText(0);
        typedArray.recycle();
        if (charSequence == null) return;
        if (!(charSequence instanceof Spanned)) return;
        this.mDefaultComposingSpans = ((Spanned)charSequence).getSpans(0, charSequence.length(), Object.class);
    }

    public static int getComposingSpanEnd(Spannable spannable) {
        return spannable.getSpanEnd(COMPOSING);
    }

    public static int getComposingSpanStart(Spannable spannable) {
        return spannable.getSpanStart(COMPOSING);
    }

    public static final void removeComposingSpans(Spannable spannable) {
        spannable.removeSpan(COMPOSING);
        Object[] objectArray = spannable.getSpans(0, spannable.length(), Object.class);
        if (objectArray != null) {
            for (int i = -1 + objectArray.length; i >= 0; --i) {
                Object object = objectArray[i];
                if ((0x100 & spannable.getSpanFlags(object)) == 0) continue;
                spannable.removeSpan(object);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void replaceText(CharSequence charSequence, int n, boolean bl) {
        int n2;
        Editable editable = this.getEditable();
        if (editable == null) {
            return;
        }
        this.beginBatchEdit();
        int n3 = BaseInputConnection.getComposingSpanStart(editable);
        int n4 = BaseInputConnection.getComposingSpanEnd(editable);
        if (n4 < n3) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (n3 != -1 && n4 != -1) {
            BaseInputConnection.removeComposingSpans(editable);
        } else {
            n3 = Selection.getSelectionStart(editable);
            n4 = Selection.getSelectionEnd(editable);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 < n3) {
                int n6 = n3;
                n3 = n4;
                n4 = n6;
            }
        }
        if (bl) {
            Spannable spannable;
            if (!(charSequence instanceof Spannable)) {
                spannable = new SpannableStringBuilder(charSequence);
                charSequence = spannable;
                this.ensureDefaultComposingSpans();
                if (this.mDefaultComposingSpans != null) {
                    for (int i = 0; i < this.mDefaultComposingSpans.length; ++i) {
                        spannable.setSpan(this.mDefaultComposingSpans[i], 0, spannable.length(), 289);
                    }
                }
            } else {
                spannable = (Spannable)charSequence;
            }
            BaseInputConnection.setComposingSpans(spannable);
        }
        if ((n2 = n > 0 ? n + (n4 - 1) : n + n3) < 0) {
            n2 = 0;
        }
        if (n2 > editable.length()) {
            n2 = editable.length();
        }
        Selection.setSelection(editable, n2);
        editable.replace(n3, n4, charSequence);
        this.endBatchEdit();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendCurrentText() {
        int n;
        Editable editable;
        if (!this.mDummyMode || (editable = this.getEditable()) == null || (n = editable.length()) == 0) {
            return;
        }
        if (n == 1) {
            if (this.mKeyCharacterMap == null) {
                this.mKeyCharacterMap = KeyCharacterMap.load(-1);
            }
            char[] cArray = new char[1];
            editable.getChars(0, 1, cArray, 0);
            KeyEvent[] keyEventArray = this.mKeyCharacterMap.getEvents(cArray);
            if (keyEventArray != null) {
                int n2 = 0;
                while (true) {
                    if (n2 >= keyEventArray.length) {
                        editable.clear();
                        return;
                    }
                    this.sendKeyEvent(keyEventArray[n2]);
                    ++n2;
                }
            }
        }
        this.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), editable.toString(), -1, 0));
        editable.clear();
    }

    public static void setComposingSpans(Spannable spannable) {
        BaseInputConnection.setComposingSpans(spannable, 0, spannable.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setComposingSpans(Spannable spannable, int n, int n2) {
        Object[] objectArray = spannable.getSpans(n, n2, Object.class);
        if (objectArray != null) {
            for (int i = -1 + objectArray.length; i >= 0; --i) {
                Object object = objectArray[i];
                if (object == COMPOSING) {
                    spannable.removeSpan(object);
                    continue;
                }
                int n3 = spannable.getSpanFlags(object);
                if ((n3 & 0x133) == 289) continue;
                spannable.setSpan(object, spannable.getSpanStart(object), spannable.getSpanEnd(object), 0x21 | (0x100 | n3 & 0xFFFFFFCC));
            }
        }
        spannable.setSpan(COMPOSING, n, n2, 289);
    }

    @Override
    public boolean beginBatchEdit() {
        return false;
    }

    @Override
    public boolean clearMetaKeyStates(int n) {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        MetaKeyKeyListener.clearMetaKeyState(editable, n);
        return true;
    }

    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        return false;
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        return false;
    }

    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        this.replaceText(charSequence, n, false);
        this.mIMM.notifyUserAction();
        this.sendCurrentText();
        return true;
    }

    @Override
    public boolean deleteSurroundingText(int n, int n2) {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        this.beginBatchEdit();
        int n3 = Selection.getSelectionStart(editable);
        int n4 = Selection.getSelectionEnd(editable);
        if (n3 > n4) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        int n6 = BaseInputConnection.getComposingSpanStart(editable);
        int n7 = BaseInputConnection.getComposingSpanEnd(editable);
        if (n7 < n6) {
            int n8 = n6;
            n6 = n7;
            n7 = n8;
        }
        if (n6 != -1 && n7 != -1) {
            if (n6 < n3) {
                n3 = n6;
            }
            if (n7 > n4) {
                n4 = n7;
            }
        }
        int n9 = 0;
        if (n > 0) {
            int n10 = n3 - n;
            if (n10 < 0) {
                n10 = 0;
            }
            editable.delete(n10, n3);
            n9 = n3 - n10;
        }
        if (n2 > 0) {
            int n11 = n4 - n9;
            int n12 = n11 + n2;
            if (n12 > editable.length()) {
                n12 = editable.length();
            }
            editable.delete(n11, n12);
        }
        this.endBatchEdit();
        return true;
    }

    @Override
    public boolean endBatchEdit() {
        return false;
    }

    @Override
    public boolean finishComposingText() {
        Editable editable = this.getEditable();
        if (editable != null) {
            this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(editable);
            this.sendCurrentText();
            this.endBatchEdit();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getCursorCapsMode(int n) {
        int n2;
        Editable editable;
        if (this.mDummyMode || (editable = this.getEditable()) == null) {
            return 0;
        }
        int n3 = Selection.getSelectionStart(editable);
        if (n3 > (n2 = Selection.getSelectionEnd(editable))) {
            n3 = n2;
        }
        return TextUtils.getCapsMode(editable, n3, n);
    }

    public Editable getEditable() {
        if (this.mEditable == null) {
            this.mEditable = Editable.Factory.getInstance().newEditable("");
            Selection.setSelection(this.mEditable, 0);
        }
        return this.mEditable;
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharSequence getSelectedText(int n) {
        int n2;
        int n3;
        Editable editable;
        block6: {
            block5: {
                editable = this.getEditable();
                if (editable == null) break block5;
                n3 = Selection.getSelectionStart(editable);
                if (n3 > (n2 = Selection.getSelectionEnd(editable))) {
                    int n4 = n3;
                    n3 = n2;
                    n2 = n4;
                }
                if (n3 != n2) break block6;
            }
            return null;
        }
        if ((n & 1) != 0) {
            return editable.subSequence(n3, n2);
        }
        return TextUtils.substring(editable, n3, n2);
    }

    @Override
    public CharSequence getTextAfterCursor(int n, int n2) {
        int n3;
        Editable editable = this.getEditable();
        if (editable == null) {
            return null;
        }
        int n4 = Selection.getSelectionStart(editable);
        if (n4 > (n3 = Selection.getSelectionEnd(editable))) {
            n3 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 + n > editable.length()) {
            n = editable.length() - n3;
        }
        if ((n2 & 1) != 0) {
            return editable.subSequence(n3, n3 + n);
        }
        return TextUtils.substring(editable, n3, n3 + n);
    }

    @Override
    public CharSequence getTextBeforeCursor(int n, int n2) {
        int n3;
        Editable editable = this.getEditable();
        if (editable == null) {
            return null;
        }
        int n4 = Selection.getSelectionStart(editable);
        if (n4 > (n3 = Selection.getSelectionEnd(editable))) {
            n4 = n3;
        }
        if (n4 <= 0) {
            return "";
        }
        if (n > n4) {
            n = n4;
        }
        if ((n2 & 1) != 0) {
            return editable.subSequence(n4 - n, n4);
        }
        return TextUtils.substring(editable, n4 - n, n4);
    }

    @Override
    public boolean performContextMenuAction(int n) {
        return false;
    }

    @Override
    public boolean performEditorAction(int n) {
        long l = SystemClock.uptimeMillis();
        this.sendKeyEvent(new KeyEvent(l, l, 0, 66, 0, 0, -1, 0, 22));
        this.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), l, 1, 66, 0, 0, -1, 0, 22));
        return true;
    }

    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        return false;
    }

    protected void reportFinish() {
    }

    @Override
    public boolean reportFullscreenMode(boolean bl) {
        this.mIMM.setFullscreenMode(bl);
        return true;
    }

    @Override
    public boolean requestCursorUpdates(int n) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean sendKeyEvent(KeyEvent keyEvent) {
        InputMethodManager.H h = this.mIMM.mH;
        synchronized (h) {
            ViewRootImpl viewRootImpl = this.mTargetView != null ? this.mTargetView.getViewRootImpl() : null;
            if (viewRootImpl == null && this.mIMM.mServedView != null) {
                viewRootImpl = this.mIMM.mServedView.getViewRootImpl();
            }
            if (viewRootImpl != null) {
                viewRootImpl.dispatchKeyFromIme(keyEvent);
            }
        }
        this.mIMM.notifyUserAction();
        return false;
    }

    @Override
    public boolean setComposingRegion(int n, int n2) {
        Editable editable = this.getEditable();
        if (editable != null) {
            this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(editable);
            int n3 = n;
            int n4 = n2;
            if (n3 > n4) {
                int n5 = n3;
                n3 = n4;
                n4 = n5;
            }
            int n6 = editable.length();
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 > n6) {
                n3 = n6;
            }
            if (n4 > n6) {
                n4 = n6;
            }
            this.ensureDefaultComposingSpans();
            if (this.mDefaultComposingSpans != null) {
                for (int i = 0; i < this.mDefaultComposingSpans.length; ++i) {
                    editable.setSpan(this.mDefaultComposingSpans[i], n3, n4, 289);
                }
            }
            editable.setSpan(COMPOSING, n3, n4, 289);
            this.sendCurrentText();
            this.endBatchEdit();
        }
        return true;
    }

    @Override
    public boolean setComposingText(CharSequence charSequence, int n) {
        this.replaceText(charSequence, n, true);
        this.mIMM.notifyUserAction();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSelection(int n, int n2) {
        boolean bl = true;
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        int n3 = editable.length();
        if (n > n3) return bl;
        if (n2 > n3) return bl;
        if (n < 0) return bl;
        if (n2 < 0) return bl;
        if (n == n2 && MetaKeyKeyListener.getMetaState((CharSequence)editable, 2048) != 0) {
            Selection.extendSelection(editable, n);
            return bl;
        }
        Selection.setSelection(editable, n, n2);
        return bl;
    }
}

