/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper;

@HasNativeInterpolator
public class OvershootInterpolator
implements Interpolator,
NativeInterpolatorFactory {
    private final float mTension;

    public OvershootInterpolator() {
        this.mTension = 2.0f;
    }

    public OvershootInterpolator(float f) {
        this.mTension = f;
    }

    public OvershootInterpolator(Context context, AttributeSet attributeSet) {
        this(context.getResources(), context.getTheme(), attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public OvershootInterpolator(Resources resources, Resources.Theme theme, AttributeSet attributeSet) {
        TypedArray typedArray = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.OvershootInterpolator, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.OvershootInterpolator);
        this.mTension = typedArray.getFloat(0, 2.0f);
        typedArray.recycle();
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactoryHelper.createOvershootInterpolator(this.mTension);
    }

    @Override
    public float getInterpolation(float f) {
        float f2 = f - 1.0f;
        return 1.0f + f2 * f2 * (f2 * (1.0f + this.mTension) + this.mTension);
    }
}

