/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import com.android.internal.R;
import java.util.Random;

public class GridLayoutAnimationController
extends LayoutAnimationController {
    public static final int DIRECTION_BOTTOM_TO_TOP = 2;
    public static final int DIRECTION_HORIZONTAL_MASK = 1;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_TOP_TO_BOTTOM = 0;
    public static final int DIRECTION_VERTICAL_MASK = 2;
    public static final int PRIORITY_COLUMN = 1;
    public static final int PRIORITY_NONE = 0;
    public static final int PRIORITY_ROW = 2;
    private float mColumnDelay;
    private int mDirection;
    private int mDirectionPriority;
    private float mRowDelay;

    public GridLayoutAnimationController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayoutAnimation);
        this.mColumnDelay = Animation.Description.parseValue((TypedValue)typedArray.peekValue((int)0)).value;
        this.mRowDelay = Animation.Description.parseValue((TypedValue)typedArray.peekValue((int)1)).value;
        this.mDirection = typedArray.getInt(2, 0);
        this.mDirectionPriority = typedArray.getInt(3, 0);
        typedArray.recycle();
    }

    public GridLayoutAnimationController(Animation animation) {
        this(animation, 0.5f, 0.5f);
    }

    public GridLayoutAnimationController(Animation animation, float f, float f2) {
        super(animation);
        this.mColumnDelay = f;
        this.mRowDelay = f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getTransformedColumnIndex(AnimationParameters animationParameters) {
        int n;
        switch (this.getOrder()) {
            default: {
                n = animationParameters.column;
                break;
            }
            case 1: {
                n = -1 + animationParameters.columnsCount - animationParameters.column;
                break;
            }
            case 2: {
                if (this.mRandomizer == null) {
                    this.mRandomizer = new Random();
                }
                n = (int)((float)animationParameters.columnsCount * this.mRandomizer.nextFloat());
            }
        }
        if ((1 & this.mDirection) != 1) return n;
        return -1 + animationParameters.columnsCount - n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getTransformedRowIndex(AnimationParameters animationParameters) {
        int n;
        switch (this.getOrder()) {
            default: {
                n = animationParameters.row;
                break;
            }
            case 1: {
                n = -1 + animationParameters.rowsCount - animationParameters.row;
                break;
            }
            case 2: {
                if (this.mRandomizer == null) {
                    this.mRandomizer = new Random();
                }
                n = (int)((float)animationParameters.rowsCount * this.mRandomizer.nextFloat());
            }
        }
        if ((2 & this.mDirection) != 2) return n;
        return -1 + animationParameters.rowsCount - n;
    }

    public float getColumnDelay() {
        return this.mColumnDelay;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected long getDelayForView(View view) {
        float f;
        long l;
        AnimationParameters animationParameters = (AnimationParameters)view.getLayoutParams().layoutAnimationParameters;
        if (animationParameters == null) {
            return 0L;
        }
        int n = this.getTransformedColumnIndex(animationParameters);
        int n2 = this.getTransformedRowIndex(animationParameters);
        int n3 = animationParameters.rowsCount;
        int n4 = animationParameters.columnsCount;
        long l2 = this.mAnimation.getDuration();
        float f2 = this.mColumnDelay * (float)l2;
        float f3 = this.mRowDelay * (float)l2;
        if (this.mInterpolator == null) {
            this.mInterpolator = new LinearInterpolator();
        }
        switch (this.mDirectionPriority) {
            default: {
                l = (long)(f2 * (float)n + f3 * (float)n2);
                f = f2 * (float)n4 + f3 * (float)n3;
                break;
            }
            case 1: {
                l = (long)(f3 * (float)n2 + f3 * (float)(n * n3));
                f = f3 * (float)n3 + f3 * (float)(n4 * n3);
                break;
            }
            case 2: {
                l = (long)(f2 * (float)n + f2 * (float)(n2 * n4));
                f = f2 * (float)n4 + f2 * (float)(n3 * n4);
            }
        }
        float f4 = (float)l / f;
        return (long)(f * this.mInterpolator.getInterpolation(f4));
    }

    public int getDirection() {
        return this.mDirection;
    }

    public int getDirectionPriority() {
        return this.mDirectionPriority;
    }

    public float getRowDelay() {
        return this.mRowDelay;
    }

    public void setColumnDelay(float f) {
        this.mColumnDelay = f;
    }

    public void setDirection(int n) {
        this.mDirection = n;
    }

    public void setDirectionPriority(int n) {
        this.mDirectionPriority = n;
    }

    public void setRowDelay(float f) {
        this.mRowDelay = f;
    }

    @Override
    public boolean willOverlap() {
        return this.mColumnDelay < 1.0f || this.mRowDelay < 1.0f;
    }

    public static class AnimationParameters
    extends LayoutAnimationController.AnimationParameters {
        public int column;
        public int columnsCount;
        public int row;
        public int rowsCount;
    }
}

