/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.graphics.Rect;
import android.view.animation.Animation;
import android.view.animation.Transformation;

public class ClipRectAnimation
extends Animation {
    private Rect mFromRect = new Rect();
    private Rect mToRect = new Rect();

    public ClipRectAnimation(Rect rect, Rect rect2) {
        if (rect == null || rect2 == null) {
            throw new RuntimeException("Expected non-null animation clip rects");
        }
        this.mFromRect.set(rect);
        this.mToRect.set(rect2);
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        transformation.setClipRect(this.mFromRect.left + (int)(f * (float)(this.mToRect.left - this.mFromRect.left)), this.mFromRect.top + (int)(f * (float)(this.mToRect.top - this.mFromRect.top)), this.mFromRect.right + (int)(f * (float)(this.mToRect.right - this.mFromRect.right)), this.mFromRect.bottom + (int)(f * (float)(this.mToRect.bottom - this.mFromRect.bottom)));
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return false;
    }
}

