/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.GridLayoutAnimationController;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.PathInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationUtils {
    private static final int SEQUENTIALLY = 1;
    private static final int TOGETHER;

    private static Animation createAnimationFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return AnimationUtils.createAnimationFromXml(context, xmlPullParser, null, Xml.asAttributeSet(xmlPullParser));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Animation createAnimationFromXml(Context context, XmlPullParser xmlPullParser, AnimationSet animationSet, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        void var4_5;
        int n;
        Object var4_4 = null;
        int n2 = xmlPullParser.getDepth();
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            void var4_7;
            if (n != 2) continue;
            String string2 = xmlPullParser.getName();
            if (string2.equals("set")) {
                AnimationSet animationSet2 = new AnimationSet(context, attributeSet);
                AnimationUtils.createAnimationFromXml(context, xmlPullParser, animationSet2, attributeSet);
            } else if (string2.equals("alpha")) {
                AlphaAnimation alphaAnimation = new AlphaAnimation(context, attributeSet);
            } else if (string2.equals("scale")) {
                ScaleAnimation scaleAnimation = new ScaleAnimation(context, attributeSet);
            } else if (string2.equals("rotate")) {
                RotateAnimation rotateAnimation = new RotateAnimation(context, attributeSet);
            } else {
                if (!string2.equals("translate")) {
                    throw new RuntimeException("Unknown animation name: " + xmlPullParser.getName());
                }
                TranslateAnimation translateAnimation = new TranslateAnimation(context, attributeSet);
            }
            if (animationSet == null) continue;
            animationSet.addAnimation((Animation)var4_7);
        }
        return var4_5;
    }

    private static Interpolator createInterpolatorFromXml(Resources resources, Resources.Theme theme, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        Interpolator interpolator2 = null;
        int n2 = xmlPullParser.getDepth();
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            if (n != 2) continue;
            AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
            String string2 = xmlPullParser.getName();
            if (string2.equals("linearInterpolator")) {
                interpolator2 = new LinearInterpolator();
                continue;
            }
            if (string2.equals("accelerateInterpolator")) {
                interpolator2 = new AccelerateInterpolator(resources, theme, attributeSet);
                continue;
            }
            if (string2.equals("decelerateInterpolator")) {
                interpolator2 = new DecelerateInterpolator(resources, theme, attributeSet);
                continue;
            }
            if (string2.equals("accelerateDecelerateInterpolator")) {
                interpolator2 = new AccelerateDecelerateInterpolator();
                continue;
            }
            if (string2.equals("cycleInterpolator")) {
                interpolator2 = new CycleInterpolator(resources, theme, attributeSet);
                continue;
            }
            if (string2.equals("anticipateInterpolator")) {
                interpolator2 = new AnticipateInterpolator(resources, theme, attributeSet);
                continue;
            }
            if (string2.equals("overshootInterpolator")) {
                interpolator2 = new OvershootInterpolator(resources, theme, attributeSet);
                continue;
            }
            if (string2.equals("anticipateOvershootInterpolator")) {
                interpolator2 = new AnticipateOvershootInterpolator(resources, theme, attributeSet);
                continue;
            }
            if (string2.equals("bounceInterpolator")) {
                interpolator2 = new BounceInterpolator();
                continue;
            }
            if (string2.equals("pathInterpolator")) {
                interpolator2 = new PathInterpolator(resources, theme, attributeSet);
                continue;
            }
            throw new RuntimeException("Unknown interpolator name: " + xmlPullParser.getName());
        }
        return interpolator2;
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return AnimationUtils.createLayoutAnimationFromXml(context, xmlPullParser, Xml.asAttributeSet(xmlPullParser));
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        LayoutAnimationController layoutAnimationController = null;
        int n2 = xmlPullParser.getDepth();
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            if (n != 2) continue;
            String string2 = xmlPullParser.getName();
            if ("layoutAnimation".equals(string2)) {
                layoutAnimationController = new LayoutAnimationController(context, attributeSet);
                continue;
            }
            if ("gridLayoutAnimation".equals(string2)) {
                layoutAnimationController = new GridLayoutAnimationController(context, attributeSet);
                continue;
            }
            throw new RuntimeException("Unknown layout animation name: " + string2);
        }
        return layoutAnimationController;
    }

    public static long currentAnimationTimeMillis() {
        return SystemClock.uptimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Animation loadAnimation(Context context, int n) throws Resources.NotFoundException {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = context.getResources().getAnimation(n);
            Animation animation = AnimationUtils.createAnimationFromXml(context, xmlResourceParser);
            return animation;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(xmlPullParserException);
            throw notFoundException;
        }
        catch (IOException iOException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(iOException);
            throw notFoundException;
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Interpolator loadInterpolator(Context context, int n) throws Resources.NotFoundException {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = context.getResources().getAnimation(n);
            Interpolator interpolator2 = AnimationUtils.createInterpolatorFromXml(context.getResources(), context.getTheme(), xmlResourceParser);
            return interpolator2;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(xmlPullParserException);
            throw notFoundException;
        }
        catch (IOException iOException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(iOException);
            throw notFoundException;
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Interpolator loadInterpolator(Resources resources, Resources.Theme theme, int n) throws Resources.NotFoundException {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = resources.getAnimation(n);
            Interpolator interpolator2 = AnimationUtils.createInterpolatorFromXml(resources, theme, xmlResourceParser);
            return interpolator2;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(xmlPullParserException);
            throw notFoundException;
        }
        catch (IOException iOException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(iOException);
            throw notFoundException;
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LayoutAnimationController loadLayoutAnimation(Context context, int n) throws Resources.NotFoundException {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = context.getResources().getAnimation(n);
            LayoutAnimationController layoutAnimationController = AnimationUtils.createLayoutAnimationFromXml(context, xmlResourceParser);
            return layoutAnimationController;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(xmlPullParserException);
            throw notFoundException;
        }
        catch (IOException iOException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(iOException);
            throw notFoundException;
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Animation makeInAnimation(Context context, boolean bl) {
        Animation animation = bl ? AnimationUtils.loadAnimation(context, 17432578) : AnimationUtils.loadAnimation(context, 17432676);
        animation.setInterpolator(new DecelerateInterpolator());
        animation.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return animation;
    }

    public static Animation makeInChildBottomAnimation(Context context) {
        Animation animation = AnimationUtils.loadAnimation(context, 17432674);
        animation.setInterpolator(new AccelerateInterpolator());
        animation.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return animation;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Animation makeOutAnimation(Context context, boolean bl) {
        Animation animation = bl ? AnimationUtils.loadAnimation(context, 17432579) : AnimationUtils.loadAnimation(context, 17432679);
        animation.setInterpolator(new AccelerateInterpolator());
        animation.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return animation;
    }
}

