/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.Handler;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;
import dalvik.system.CloseGuard;

public abstract class Animation
implements Cloneable {
    public static final int ABSOLUTE = 0;
    public static final int INFINITE = -1;
    public static final int RELATIVE_TO_PARENT = 2;
    public static final int RELATIVE_TO_SELF = 1;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int START_ON_FIRST_FRAME = -1;
    private static final boolean USE_CLOSEGUARD = false;
    public static final int ZORDER_BOTTOM = -1;
    public static final int ZORDER_NORMAL = 0;
    public static final int ZORDER_TOP = 1;
    private final CloseGuard guard;
    private int mBackgroundColor;
    boolean mCycleFlip = false;
    private boolean mDetachWallpaper = false;
    long mDuration;
    boolean mEnded = false;
    boolean mFillAfter = false;
    boolean mFillBefore = true;
    boolean mFillEnabled = false;
    boolean mInitialized = false;
    Interpolator mInterpolator;
    AnimationListener mListener;
    private Handler mListenerHandler;
    private boolean mMore = true;
    private Runnable mOnEnd;
    private Runnable mOnRepeat;
    private Runnable mOnStart;
    private boolean mOneMoreTime = true;
    RectF mPreviousRegion = new RectF();
    Transformation mPreviousTransformation;
    RectF mRegion = new RectF();
    int mRepeatCount = 0;
    int mRepeatMode = 1;
    int mRepeated = 0;
    private float mScaleFactor = 1.0f;
    long mStartOffset;
    long mStartTime = -1L;
    boolean mStarted = false;
    Transformation mTransformation = new Transformation();
    private int mZAdjustment;

    static {
        USE_CLOSEGUARD = SystemProperties.getBoolean("log.closeguard.Animation", false);
    }

    public Animation() {
        this.mPreviousTransformation = new Transformation();
        this.guard = CloseGuard.get();
        this.ensureInterpolator();
    }

    public Animation(Context context, AttributeSet attributeSet) {
        this.mPreviousTransformation = new Transformation();
        this.guard = CloseGuard.get();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Animation);
        this.setDuration(typedArray.getInt(2, 0));
        this.setStartOffset(typedArray.getInt(5, 0));
        this.setFillEnabled(typedArray.getBoolean(9, this.mFillEnabled));
        this.setFillBefore(typedArray.getBoolean(3, this.mFillBefore));
        this.setFillAfter(typedArray.getBoolean(4, this.mFillAfter));
        this.setRepeatCount(typedArray.getInt(6, this.mRepeatCount));
        this.setRepeatMode(typedArray.getInt(7, 1));
        this.setZAdjustment(typedArray.getInt(8, 0));
        this.setBackgroundColor(typedArray.getInt(0, 0));
        this.setDetachWallpaper(typedArray.getBoolean(10, false));
        int n = typedArray.getResourceId(1, 0);
        typedArray.recycle();
        if (n > 0) {
            this.setInterpolator(context, n);
        }
        this.ensureInterpolator();
    }

    private void fireAnimationEnd() {
        block3: {
            block2: {
                if (this.mListener == null) break block2;
                if (this.mListenerHandler != null) break block3;
                this.mListener.onAnimationEnd(this);
            }
            return;
        }
        this.mListenerHandler.postAtFrontOfQueue(this.mOnEnd);
    }

    private void fireAnimationRepeat() {
        block3: {
            block2: {
                if (this.mListener == null) break block2;
                if (this.mListenerHandler != null) break block3;
                this.mListener.onAnimationRepeat(this);
            }
            return;
        }
        this.mListenerHandler.postAtFrontOfQueue(this.mOnRepeat);
    }

    private void fireAnimationStart() {
        block3: {
            block2: {
                if (this.mListener == null) break block2;
                if (this.mListenerHandler != null) break block3;
                this.mListener.onAnimationStart(this);
            }
            return;
        }
        this.mListenerHandler.postAtFrontOfQueue(this.mOnStart);
    }

    protected void applyTransformation(float f, Transformation transformation) {
    }

    public void cancel() {
        if (this.mStarted && !this.mEnded) {
            this.fireAnimationEnd();
            this.mEnded = true;
            this.guard.close();
        }
        this.mStartTime = Long.MIN_VALUE;
        this.mOneMoreTime = false;
        this.mMore = false;
    }

    protected Animation clone() throws CloneNotSupportedException {
        Animation animation = (Animation)super.clone();
        animation.mPreviousRegion = new RectF();
        animation.mRegion = new RectF();
        animation.mTransformation = new Transformation();
        animation.mPreviousTransformation = new Transformation();
        return animation;
    }

    public long computeDurationHint() {
        return (this.getStartOffset() + this.getDuration()) * (long)(1 + this.getRepeatCount());
    }

    public void detach() {
        if (this.mStarted && !this.mEnded) {
            this.mEnded = true;
            this.guard.close();
            this.fireAnimationEnd();
        }
    }

    protected void ensureInterpolator() {
        if (this.mInterpolator == null) {
            this.mInterpolator = new AccelerateDecelerateInterpolator();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public boolean getDetachWallpaper() {
        return this.mDetachWallpaper;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public boolean getFillAfter() {
        return this.mFillAfter;
    }

    public boolean getFillBefore() {
        return this.mFillBefore;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void getInvalidateRegion(int n, int n2, int n3, int n4, RectF rectF, Transformation transformation) {
        RectF rectF2 = this.mRegion;
        RectF rectF3 = this.mPreviousRegion;
        rectF.set(n, n2, n3, n4);
        transformation.getMatrix().mapRect(rectF);
        rectF.inset(-1.0f, -1.0f);
        rectF2.set(rectF);
        rectF.union(rectF3);
        rectF3.set(rectF2);
        Transformation transformation2 = this.mTransformation;
        Transformation transformation3 = this.mPreviousTransformation;
        transformation2.set(transformation);
        transformation.set(transformation3);
        transformation3.set(transformation2);
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    protected float getScaleFactor() {
        return this.mScaleFactor;
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean getTransformation(long l, Transformation transformation) {
        if (this.mStartTime == -1L) {
            this.mStartTime = l;
        }
        long l2 = this.getStartOffset();
        long l3 = this.mDuration;
        float f = l3 != 0L ? (float)(l - (l2 + this.mStartTime)) / (float)l3 : (l < this.mStartTime ? 0.0f : 1.0f);
        boolean bl = f >= 1.0f;
        boolean bl2 = !bl;
        this.mMore = bl2;
        if (!this.mFillEnabled) {
            f = Math.max(Math.min(f, 1.0f), 0.0f);
        }
        if ((f >= 0.0f || this.mFillBefore) && (f <= 1.0f || this.mFillAfter)) {
            if (!this.mStarted) {
                this.fireAnimationStart();
                this.mStarted = true;
                if (USE_CLOSEGUARD) {
                    this.guard.open("cancel or detach or getTransformation");
                }
            }
            if (this.mFillEnabled) {
                f = Math.max(Math.min(f, 1.0f), 0.0f);
            }
            if (this.mCycleFlip) {
                f = 1.0f - f;
            }
            this.applyTransformation(this.mInterpolator.getInterpolation(f), transformation);
        }
        if (bl) {
            if (this.mRepeatCount == this.mRepeated) {
                if (!this.mEnded) {
                    this.mEnded = true;
                    this.guard.close();
                    this.fireAnimationEnd();
                }
            } else {
                if (this.mRepeatCount > 0) {
                    this.mRepeated = 1 + this.mRepeated;
                }
                if (this.mRepeatMode == 2) {
                    boolean bl3 = !this.mCycleFlip;
                    this.mCycleFlip = bl3;
                }
                this.mStartTime = -1L;
                this.mMore = true;
                this.fireAnimationRepeat();
            }
        }
        if (!this.mMore && this.mOneMoreTime) {
            this.mOneMoreTime = false;
            return true;
        }
        return this.mMore;
    }

    public boolean getTransformation(long l, Transformation transformation, float f) {
        this.mScaleFactor = f;
        return this.getTransformation(l, transformation);
    }

    public int getZAdjustment() {
        return this.mZAdjustment;
    }

    public boolean hasAlpha() {
        return false;
    }

    public boolean hasEnded() {
        return this.mEnded;
    }

    public boolean hasStarted() {
        return this.mStarted;
    }

    public void initialize(int n, int n2, int n3, int n4) {
        this.reset();
        this.mInitialized = true;
    }

    public void initializeInvalidateRegion(int n, int n2, int n3, int n4) {
        RectF rectF = this.mPreviousRegion;
        rectF.set(n, n2, n3, n4);
        rectF.inset(-1.0f, -1.0f);
        if (this.mFillBefore) {
            Transformation transformation = this.mPreviousTransformation;
            this.applyTransformation(this.mInterpolator.getInterpolation(0.0f), transformation);
        }
    }

    public boolean isFillEnabled() {
        return this.mFillEnabled;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void reset() {
        this.mPreviousRegion.setEmpty();
        this.mPreviousTransformation.clear();
        this.mInitialized = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
        this.mOneMoreTime = true;
        this.mListenerHandler = null;
    }

    protected float resolveSize(int n, float f, int n2, int n3) {
        switch (n) {
            default: {
                return f;
            }
            case 1: {
                return f * (float)n2;
            }
            case 2: 
        }
        return f * (float)n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void restrictDuration(long l) {
        if (this.mStartOffset > l) {
            this.mStartOffset = l;
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        } else {
            long l2 = this.mDuration + this.mStartOffset;
            if (l2 > l) {
                this.mDuration = l - this.mStartOffset;
                l2 = l;
            }
            if (this.mDuration <= 0L) {
                this.mDuration = 0L;
                this.mRepeatCount = 0;
                return;
            }
            if (this.mRepeatCount >= 0 && (long)this.mRepeatCount <= l && l2 * (long)this.mRepeatCount <= l) return;
            this.mRepeatCount = -1 + (int)(l / l2);
            if (this.mRepeatCount >= 0) return;
            this.mRepeatCount = 0;
            return;
        }
    }

    public void scaleCurrentDuration(float f) {
        this.mDuration = (long)(f * (float)this.mDuration);
        this.mStartOffset = (long)(f * (float)this.mStartOffset);
    }

    public void setAnimationListener(AnimationListener animationListener) {
        this.mListener = animationListener;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public void setDetachWallpaper(boolean bl) {
        this.mDetachWallpaper = bl;
    }

    public void setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animation duration cannot be negative");
        }
        this.mDuration = l;
    }

    public void setFillAfter(boolean bl) {
        this.mFillAfter = bl;
    }

    public void setFillBefore(boolean bl) {
        this.mFillBefore = bl;
    }

    public void setFillEnabled(boolean bl) {
        this.mFillEnabled = bl;
    }

    public void setInterpolator(Context context, int n) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, n));
    }

    public void setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    public void setListenerHandler(Handler handler) {
        if (this.mListenerHandler == null) {
            this.mOnStart = new Runnable(){

                @Override
                public void run() {
                    if (Animation.this.mListener != null) {
                        Animation.this.mListener.onAnimationStart(Animation.this);
                    }
                }
            };
            this.mOnRepeat = new Runnable(){

                @Override
                public void run() {
                    if (Animation.this.mListener != null) {
                        Animation.this.mListener.onAnimationRepeat(Animation.this);
                    }
                }
            };
            this.mOnEnd = new Runnable(){

                @Override
                public void run() {
                    if (Animation.this.mListener != null) {
                        Animation.this.mListener.onAnimationEnd(Animation.this);
                    }
                }
            };
        }
        this.mListenerHandler = handler;
    }

    public void setRepeatCount(int n) {
        if (n < 0) {
            n = -1;
        }
        this.mRepeatCount = n;
    }

    public void setRepeatMode(int n) {
        this.mRepeatMode = n;
    }

    public void setStartOffset(long l) {
        this.mStartOffset = l;
    }

    public void setStartTime(long l) {
        this.mStartTime = l;
        this.mEnded = false;
        this.mStarted = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
    }

    public void setZAdjustment(int n) {
        this.mZAdjustment = n;
    }

    public void start() {
        this.setStartTime(-1L);
    }

    public void startNow() {
        this.setStartTime(AnimationUtils.currentAnimationTimeMillis());
    }

    public boolean willChangeBounds() {
        return true;
    }

    public boolean willChangeTransformationMatrix() {
        return true;
    }

    public static interface AnimationListener {
        public void onAnimationEnd(Animation var1);

        public void onAnimationRepeat(Animation var1);

        public void onAnimationStart(Animation var1);
    }

    protected static class Description {
        public int type;
        public float value;

        protected Description() {
        }

        /*
         * Enabled aggressive block sorting
         */
        static Description parseValue(TypedValue typedValue) {
            int n = 1;
            Description description = new Description();
            if (typedValue == null) {
                description.type = 0;
                description.value = 0.0f;
            } else {
                if (typedValue.type == 6) {
                    if ((0xF & typedValue.data) == n) {
                        n = 2;
                    }
                    description.type = n;
                    description.value = TypedValue.complexToFloat(typedValue.data);
                    return description;
                }
                if (typedValue.type == 4) {
                    description.type = 0;
                    description.value = typedValue.getFloat();
                    return description;
                }
                if (typedValue.type >= 16 && typedValue.type <= 31) {
                    description.type = 0;
                    description.value = typedValue.data;
                    return description;
                }
            }
            description.type = 0;
            description.value = 0.0f;
            return description;
        }
    }
}

