/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.graphics.Point;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityCache;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class AccessibilityInteractionClient
extends IAccessibilityInteractionConnectionCallback.Stub {
    private static final boolean CHECK_INTEGRITY = true;
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityInteractionClient";
    public static final int NO_ID = -1;
    private static final long TIMEOUT_INTERACTION_MILLIS = 5000L;
    private static final AccessibilityCache sAccessibilityCache;
    private static final LongSparseArray<AccessibilityInteractionClient> sClients;
    private static final SparseArray<IAccessibilityServiceConnection> sConnectionCache;
    private static final Object sStaticLock;
    private Point mComputeClickPointResult;
    private AccessibilityNodeInfo mFindAccessibilityNodeInfoResult;
    private List<AccessibilityNodeInfo> mFindAccessibilityNodeInfosResult;
    private final Object mInstanceLock;
    private volatile int mInteractionId = -1;
    private final AtomicInteger mInteractionIdCounter = new AtomicInteger();
    private boolean mPerformAccessibilityActionResult;
    private Message mSameThreadMessage;

    static {
        sStaticLock = new Object();
        sClients = new LongSparseArray();
        sConnectionCache = new SparseArray();
        sAccessibilityCache = new AccessibilityCache();
    }

    private AccessibilityInteractionClient() {
        this.mInstanceLock = new Object();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkFindAccessibilityNodeInfoResultIntegrity(List<AccessibilityNodeInfo> list) {
        block15: {
            if (list.size() == 0) break block15;
            AccessibilityNodeInfo accessibilityNodeInfo = list.get(0);
            int n = list.size();
            int n2 = 1;
            block0: while (true) {
                if (n2 >= n) {
                    if (accessibilityNodeInfo == null) {
                        Log.e(LOG_TAG, "No root.");
                    }
                    break;
                }
                int n3 = n2;
                while (true) {
                    block17: {
                        block16: {
                            if (n3 >= n) break block16;
                            AccessibilityNodeInfo accessibilityNodeInfo2 = list.get(n3);
                            if (accessibilityNodeInfo.getParentNodeId() != accessibilityNodeInfo2.getSourceNodeId()) break block17;
                            accessibilityNodeInfo = accessibilityNodeInfo2;
                        }
                        ++n2;
                        continue block0;
                    }
                    ++n3;
                }
                break;
            }
            HashSet<AccessibilityNodeInfo> hashSet = new HashSet<AccessibilityNodeInfo>();
            LinkedList<AccessibilityNodeInfo> linkedList = new LinkedList<AccessibilityNodeInfo>();
            linkedList.add(accessibilityNodeInfo);
            block2: while (true) {
                AccessibilityNodeInfo accessibilityNodeInfo3;
                if (!linkedList.isEmpty()) {
                    accessibilityNodeInfo3 = (AccessibilityNodeInfo)linkedList.poll();
                    if (!hashSet.add(accessibilityNodeInfo3)) {
                        Log.e(LOG_TAG, "Duplicate node.");
                        return;
                    }
                } else {
                    int n4 = list.size() - hashSet.size();
                    if (n4 <= 0) break;
                    Log.e(LOG_TAG, n4 + " Disconnected nodes.");
                    return;
                }
                int n5 = accessibilityNodeInfo3.getChildCount();
                int n6 = 0;
                while (true) {
                    if (n6 >= n5) continue block2;
                    long l = accessibilityNodeInfo3.getChildId(n6);
                    for (int i = 0; i < n; ++i) {
                        AccessibilityNodeInfo accessibilityNodeInfo4 = list.get(i);
                        if (accessibilityNodeInfo4.getSourceNodeId() != l) continue;
                        linkedList.add(accessibilityNodeInfo4);
                    }
                    ++n6;
                }
                break;
            }
        }
    }

    private void clearResultLocked() {
        this.mInteractionId = -1;
        this.mFindAccessibilityNodeInfoResult = null;
        this.mFindAccessibilityNodeInfosResult = null;
        this.mPerformAccessibilityActionResult = false;
        this.mComputeClickPointResult = null;
    }

    private void finalizeAndCacheAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n) {
        if (accessibilityNodeInfo != null) {
            accessibilityNodeInfo.setConnectionId(n);
            accessibilityNodeInfo.setSealed(true);
            sAccessibilityCache.add(accessibilityNodeInfo);
        }
    }

    private void finalizeAndCacheAccessibilityNodeInfos(List<AccessibilityNodeInfo> list, int n) {
        if (list != null) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                this.finalizeAndCacheAccessibilityNodeInfo(list.get(i), n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Point getComputeClickPointInScreenResultAndClear(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Point point = this.waitForResultTimedLocked(n) ? this.mComputeClickPointResult : null;
            this.clearResultLocked();
            return point;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AccessibilityNodeInfo getFindAccessibilityNodeInfoResultAndClear(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            AccessibilityNodeInfo accessibilityNodeInfo = this.waitForResultTimedLocked(n) ? this.mFindAccessibilityNodeInfoResult : null;
            this.clearResultLocked();
            return accessibilityNodeInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AccessibilityNodeInfo> getFindAccessibilityNodeInfosResultAndClear(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            List<AccessibilityNodeInfo> list = this.waitForResultTimedLocked(n) ? this.mFindAccessibilityNodeInfosResult : Collections.emptyList();
            this.clearResultLocked();
            if (Build.IS_DEBUGGABLE) {
                this.checkFindAccessibilityNodeInfoResultIntegrity(list);
            }
            return list;
        }
    }

    public static AccessibilityInteractionClient getInstance() {
        return AccessibilityInteractionClient.getInstanceForThread(Thread.currentThread().getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccessibilityInteractionClient getInstanceForThread(long l) {
        Object object = sStaticLock;
        synchronized (object) {
            AccessibilityInteractionClient accessibilityInteractionClient = sClients.get(l);
            if (accessibilityInteractionClient == null) {
                accessibilityInteractionClient = new AccessibilityInteractionClient();
                sClients.put(l, accessibilityInteractionClient);
            }
            return accessibilityInteractionClient;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getPerformAccessibilityActionResultAndClear(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean bl = this.waitForResultTimedLocked(n) ? this.mPerformAccessibilityActionResult : false;
            this.clearResultLocked();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message getSameProcessMessageAndClear() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Message message = this.mSameThreadMessage;
            this.mSameThreadMessage = null;
            return message;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForResultTimedLocked(int n) {
        long l = SystemClock.uptimeMillis();
        block2: while (true) {
            try {
                while (true) {
                    long l2;
                    Message message;
                    if ((message = this.getSameProcessMessageAndClear()) != null) {
                        message.getTarget().handleMessage(message);
                    }
                    if (this.mInteractionId == n) {
                        return true;
                    }
                    if (this.mInteractionId > n || (l2 = 5000L - (SystemClock.uptimeMillis() - l)) <= 0L) break block2;
                    this.mInstanceLock.wait(l2);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addConnection(int n, IAccessibilityServiceConnection iAccessibilityServiceConnection) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.put(n, iAccessibilityServiceConnection);
            return;
        }
    }

    public void clearCache() {
        sAccessibilityCache.clear();
    }

    public Point computeClickPointInScreen(int n, int n2, long l) {
        block4: {
            IAccessibilityServiceConnection iAccessibilityServiceConnection = this.getConnection(n);
            if (iAccessibilityServiceConnection == null) break block4;
            try {
                int n3 = this.mInteractionIdCounter.getAndIncrement();
                if (iAccessibilityServiceConnection.computeClickPointInScreen(n2, l, n3, this, Thread.currentThread().getId())) {
                    Point point = this.getComputeClickPointInScreenResultAndClear(n3);
                    return point;
                }
            }
            catch (RemoteException remoteException) {
                Log.w(LOG_TAG, "Error while calling remote computeClickPointInScreen", remoteException);
            }
        }
        return null;
    }

    public AccessibilityNodeInfo findAccessibilityNodeInfoByAccessibilityId(int n, int n2, long l, boolean bl, int n3) {
        block7: {
            IAccessibilityServiceConnection iAccessibilityServiceConnection;
            block8: {
                if ((n3 & 2) != 0 && (n3 & 1) == 0) {
                    throw new IllegalArgumentException("FLAG_PREFETCH_SIBLINGS requires FLAG_PREFETCH_PREDECESSORS");
                }
                iAccessibilityServiceConnection = this.getConnection(n);
                if (iAccessibilityServiceConnection == null) break block7;
                if (bl) break block8;
                AccessibilityNodeInfo accessibilityNodeInfo = sAccessibilityCache.getNode(n2, l);
                if (accessibilityNodeInfo == null) break block8;
                return accessibilityNodeInfo;
            }
            int n4 = this.mInteractionIdCounter.getAndIncrement();
            if (!iAccessibilityServiceConnection.findAccessibilityNodeInfoByAccessibilityId(n2, l, n4, this, n3, Thread.currentThread().getId())) break block7;
            List<AccessibilityNodeInfo> list = this.getFindAccessibilityNodeInfosResultAndClear(n4);
            this.finalizeAndCacheAccessibilityNodeInfos(list, n);
            if (list == null) break block7;
            try {
                if (!list.isEmpty()) {
                    AccessibilityNodeInfo accessibilityNodeInfo = list.get(0);
                    return accessibilityNodeInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error while calling remote findAccessibilityNodeInfoByAccessibilityId", remoteException);
            }
        }
        return null;
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(int n, int n2, long l, String string2) {
        block4: {
            List<AccessibilityNodeInfo> list;
            IAccessibilityServiceConnection iAccessibilityServiceConnection = this.getConnection(n);
            if (iAccessibilityServiceConnection == null) break block4;
            int n3 = this.mInteractionIdCounter.getAndIncrement();
            if (!iAccessibilityServiceConnection.findAccessibilityNodeInfosByText(n2, l, string2, n3, this, Thread.currentThread().getId()) || (list = this.getFindAccessibilityNodeInfosResultAndClear(n3)) == null) break block4;
            try {
                this.finalizeAndCacheAccessibilityNodeInfos(list, n);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.w(LOG_TAG, "Error while calling remote findAccessibilityNodeInfosByViewText", remoteException);
            }
        }
        return Collections.emptyList();
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(int n, int n2, long l, String string2) {
        block4: {
            List<AccessibilityNodeInfo> list;
            IAccessibilityServiceConnection iAccessibilityServiceConnection = this.getConnection(n);
            if (iAccessibilityServiceConnection == null) break block4;
            int n3 = this.mInteractionIdCounter.getAndIncrement();
            if (!iAccessibilityServiceConnection.findAccessibilityNodeInfosByViewId(n2, l, string2, n3, this, Thread.currentThread().getId()) || (list = this.getFindAccessibilityNodeInfosResultAndClear(n3)) == null) break block4;
            try {
                this.finalizeAndCacheAccessibilityNodeInfos(list, n);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.w(LOG_TAG, "Error while calling remote findAccessibilityNodeInfoByViewIdInActiveWindow", remoteException);
            }
        }
        return Collections.emptyList();
    }

    public AccessibilityNodeInfo findFocus(int n, int n2, long l, int n3) {
        block4: {
            IAccessibilityServiceConnection iAccessibilityServiceConnection = this.getConnection(n);
            if (iAccessibilityServiceConnection == null) break block4;
            try {
                int n4 = this.mInteractionIdCounter.getAndIncrement();
                if (iAccessibilityServiceConnection.findFocus(n2, l, n3, n4, this, Thread.currentThread().getId())) {
                    AccessibilityNodeInfo accessibilityNodeInfo = this.getFindAccessibilityNodeInfoResultAndClear(n4);
                    this.finalizeAndCacheAccessibilityNodeInfo(accessibilityNodeInfo, n);
                    return accessibilityNodeInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.w(LOG_TAG, "Error while calling remote findFocus", remoteException);
            }
        }
        return null;
    }

    public AccessibilityNodeInfo focusSearch(int n, int n2, long l, int n3) {
        block4: {
            IAccessibilityServiceConnection iAccessibilityServiceConnection = this.getConnection(n);
            if (iAccessibilityServiceConnection == null) break block4;
            try {
                int n4 = this.mInteractionIdCounter.getAndIncrement();
                if (iAccessibilityServiceConnection.focusSearch(n2, l, n3, n4, this, Thread.currentThread().getId())) {
                    AccessibilityNodeInfo accessibilityNodeInfo = this.getFindAccessibilityNodeInfoResultAndClear(n4);
                    this.finalizeAndCacheAccessibilityNodeInfo(accessibilityNodeInfo, n);
                    return accessibilityNodeInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.w(LOG_TAG, "Error while calling remote accessibilityFocusSearch", remoteException);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IAccessibilityServiceConnection getConnection(int n) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            return sConnectionCache.get(n);
        }
    }

    public AccessibilityNodeInfo getRootInActiveWindow(int n) {
        return this.findAccessibilityNodeInfoByAccessibilityId(n, Integer.MAX_VALUE, AccessibilityNodeInfo.ROOT_NODE_ID, false, 4);
    }

    public AccessibilityWindowInfo getWindow(int n, int n2) {
        block5: {
            IAccessibilityServiceConnection iAccessibilityServiceConnection;
            block6: {
                iAccessibilityServiceConnection = this.getConnection(n);
                if (iAccessibilityServiceConnection == null) break block5;
                AccessibilityWindowInfo accessibilityWindowInfo = sAccessibilityCache.getWindow(n2);
                if (accessibilityWindowInfo == null) break block6;
                return accessibilityWindowInfo;
            }
            AccessibilityWindowInfo accessibilityWindowInfo = iAccessibilityServiceConnection.getWindow(n2);
            if (accessibilityWindowInfo == null) break block5;
            try {
                sAccessibilityCache.addWindow(accessibilityWindowInfo);
                return accessibilityWindowInfo;
            }
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error while calling remote getWindow", remoteException);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AccessibilityWindowInfo> getWindows(int n) {
        try {
            IAccessibilityServiceConnection iAccessibilityServiceConnection = this.getConnection(n);
            if (iAccessibilityServiceConnection == null) return Collections.emptyList();
            List<AccessibilityWindowInfo> list = sAccessibilityCache.getWindows();
            if (list != null) {
                return list;
            }
            list = iAccessibilityServiceConnection.getWindows();
            if (list == null) return Collections.emptyList();
            int n3 = list.size();
            int n2 = 0;
            while (n2 < n3) {
                AccessibilityWindowInfo accessibilityWindowInfo = list.get(n2);
                sAccessibilityCache.addWindow(accessibilityWindowInfo);
                ++n2;
            }
            return list;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while calling remote getWindows", remoteException);
        }
        return Collections.emptyList();
    }

    public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        sAccessibilityCache.onAccessibilityEvent(accessibilityEvent);
    }

    public boolean performAccessibilityAction(int n, int n2, long l, int n3, Bundle bundle) {
        block4: {
            IAccessibilityServiceConnection iAccessibilityServiceConnection = this.getConnection(n);
            if (iAccessibilityServiceConnection == null) break block4;
            try {
                int n4 = this.mInteractionIdCounter.getAndIncrement();
                if (iAccessibilityServiceConnection.performAccessibilityAction(n2, l, n3, bundle, n4, this, Thread.currentThread().getId())) {
                    boolean bl = this.getPerformAccessibilityActionResultAndClear(n4);
                    return bl;
                }
            }
            catch (RemoteException remoteException) {
                Log.w(LOG_TAG, "Error while calling remote performAccessibilityAction", remoteException);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeConnection(int n) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.remove(n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setComputeClickPointInScreenActionResult(Point point, int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (n > this.mInteractionId) {
                this.mComputeClickPointResult = point;
                this.mInteractionId = n;
            }
            this.mInstanceLock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setFindAccessibilityNodeInfoResult(AccessibilityNodeInfo accessibilityNodeInfo, int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (n > this.mInteractionId) {
                this.mFindAccessibilityNodeInfoResult = accessibilityNodeInfo;
                this.mInteractionId = n;
            }
            this.mInstanceLock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setFindAccessibilityNodeInfosResult(List<AccessibilityNodeInfo> list, int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (n > this.mInteractionId) {
                boolean bl;
                this.mFindAccessibilityNodeInfosResult = list != null ? (!(bl = Binder.getCallingPid() != Process.myPid()) ? new ArrayList<AccessibilityNodeInfo>(list) : list) : Collections.emptyList();
                this.mInteractionId = n;
            }
            this.mInstanceLock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setPerformAccessibilityActionResult(boolean bl, int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (n > this.mInteractionId) {
                this.mPerformAccessibilityActionResult = bl;
                this.mInteractionId = n;
            }
            this.mInstanceLock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSameThreadMessage(Message message) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mSameThreadMessage = message;
            this.mInstanceLock.notifyAll();
            return;
        }
    }
}

