/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.RenderNode;
import android.view.View;
import android.view.ViewPropertyAnimatorRT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ViewPropertyAnimator {
    static final int ALPHA = 2048;
    static final int NONE = 0;
    static final int ROTATION = 32;
    static final int ROTATION_X = 64;
    static final int ROTATION_Y = 128;
    static final int SCALE_X = 8;
    static final int SCALE_Y = 16;
    private static final int TRANSFORM_MASK = 2047;
    static final int TRANSLATION_X = 1;
    static final int TRANSLATION_Y = 2;
    static final int TRANSLATION_Z = 4;
    static final int X = 256;
    static final int Y = 512;
    static final int Z = 1024;
    private Runnable mAnimationStarter;
    private HashMap<Animator, Runnable> mAnimatorCleanupMap;
    private AnimatorEventListener mAnimatorEventListener = new AnimatorEventListener();
    private HashMap<Animator, PropertyBundle> mAnimatorMap;
    private HashMap<Animator, Runnable> mAnimatorOnEndMap;
    private HashMap<Animator, Runnable> mAnimatorOnStartMap;
    private HashMap<Animator, Runnable> mAnimatorSetupMap;
    private long mDuration;
    private boolean mDurationSet = false;
    private TimeInterpolator mInterpolator;
    private boolean mInterpolatorSet = false;
    private Animator.AnimatorListener mListener = null;
    ArrayList<NameValuesHolder> mPendingAnimations = new ArrayList();
    private Runnable mPendingCleanupAction;
    private Runnable mPendingOnEndAction;
    private Runnable mPendingOnStartAction;
    private Runnable mPendingSetupAction;
    private ViewPropertyAnimatorRT mRTBackend;
    private long mStartDelay = 0L;
    private boolean mStartDelaySet = false;
    private ValueAnimator mTempValueAnimator;
    private ValueAnimator.AnimatorUpdateListener mUpdateListener = null;
    final View mView;

    ViewPropertyAnimator(View view) {
        this.mAnimationStarter = new Runnable(){

            @Override
            public void run() {
                ViewPropertyAnimator.this.startAnimation();
            }
        };
        this.mAnimatorMap = new HashMap();
        this.mView = view;
        view.ensureTransformationInfo();
    }

    private void animateProperty(int n, float f) {
        float f2 = this.getValue(n);
        this.animatePropertyBy(n, f2, f - f2);
    }

    private void animatePropertyBy(int n, float f) {
        this.animatePropertyBy(n, this.getValue(n), f);
    }

    private void animatePropertyBy(int n, float f, float f2) {
        if (this.mAnimatorMap.size() > 0) {
            Animator animator2;
            block3: {
                Animator animator3;
                PropertyBundle propertyBundle;
                Iterator<Animator> iterator = this.mAnimatorMap.keySet().iterator();
                do {
                    boolean bl = iterator.hasNext();
                    animator2 = null;
                    if (!bl) break block3;
                } while (!(propertyBundle = this.mAnimatorMap.get(animator3 = iterator.next())).cancel(n) || propertyBundle.mPropertyMask != 0);
                animator2 = animator3;
            }
            if (animator2 != null) {
                animator2.cancel();
            }
        }
        NameValuesHolder nameValuesHolder = new NameValuesHolder(n, f, f2);
        this.mPendingAnimations.add(nameValuesHolder);
        this.mView.removeCallbacks(this.mAnimationStarter);
        this.mView.postOnAnimation(this.mAnimationStarter);
    }

    private float getValue(int n) {
        RenderNode renderNode = this.mView.mRenderNode;
        switch (n) {
            default: {
                return 0.0f;
            }
            case 1: {
                return renderNode.getTranslationX();
            }
            case 2: {
                return renderNode.getTranslationY();
            }
            case 4: {
                return renderNode.getTranslationZ();
            }
            case 32: {
                return renderNode.getRotation();
            }
            case 64: {
                return renderNode.getRotationX();
            }
            case 128: {
                return renderNode.getRotationY();
            }
            case 8: {
                return renderNode.getScaleX();
            }
            case 16: {
                return renderNode.getScaleY();
            }
            case 256: {
                return (float)this.mView.mLeft + renderNode.getTranslationX();
            }
            case 512: {
                return (float)this.mView.mTop + renderNode.getTranslationY();
            }
            case 1024: {
                return renderNode.getElevation() + renderNode.getTranslationZ();
            }
            case 2048: 
        }
        return this.mView.mTransformationInfo.mAlpha;
    }

    private void setValue(int n, float f) {
        View.TransformationInfo transformationInfo = this.mView.mTransformationInfo;
        RenderNode renderNode = this.mView.mRenderNode;
        switch (n) {
            default: {
                return;
            }
            case 1: {
                renderNode.setTranslationX(f);
                return;
            }
            case 2: {
                renderNode.setTranslationY(f);
                return;
            }
            case 4: {
                renderNode.setTranslationZ(f);
                return;
            }
            case 32: {
                renderNode.setRotation(f);
                return;
            }
            case 64: {
                renderNode.setRotationX(f);
                return;
            }
            case 128: {
                renderNode.setRotationY(f);
                return;
            }
            case 8: {
                renderNode.setScaleX(f);
                return;
            }
            case 16: {
                renderNode.setScaleY(f);
                return;
            }
            case 256: {
                renderNode.setTranslationX(f - (float)this.mView.mLeft);
                return;
            }
            case 512: {
                renderNode.setTranslationY(f - (float)this.mView.mTop);
                return;
            }
            case 1024: {
                renderNode.setTranslationZ(f - renderNode.getElevation());
                return;
            }
            case 2048: 
        }
        transformationInfo.mAlpha = f;
        renderNode.setAlpha(f);
    }

    private void startAnimation() {
        if (this.mRTBackend != null && this.mRTBackend.startAnimation(this)) {
            return;
        }
        this.mView.setHasTransientState(true);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(1.0f);
        ArrayList arrayList = (ArrayList)this.mPendingAnimations.clone();
        this.mPendingAnimations.clear();
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            n |= ((NameValuesHolder)arrayList.get((int)i)).mNameConstant;
        }
        this.mAnimatorMap.put(valueAnimator, new PropertyBundle(n, arrayList));
        if (this.mPendingSetupAction != null) {
            this.mAnimatorSetupMap.put(valueAnimator, this.mPendingSetupAction);
            this.mPendingSetupAction = null;
        }
        if (this.mPendingCleanupAction != null) {
            this.mAnimatorCleanupMap.put(valueAnimator, this.mPendingCleanupAction);
            this.mPendingCleanupAction = null;
        }
        if (this.mPendingOnStartAction != null) {
            this.mAnimatorOnStartMap.put(valueAnimator, this.mPendingOnStartAction);
            this.mPendingOnStartAction = null;
        }
        if (this.mPendingOnEndAction != null) {
            this.mAnimatorOnEndMap.put(valueAnimator, this.mPendingOnEndAction);
            this.mPendingOnEndAction = null;
        }
        valueAnimator.addUpdateListener(this.mAnimatorEventListener);
        valueAnimator.addListener(this.mAnimatorEventListener);
        if (this.mStartDelaySet) {
            valueAnimator.setStartDelay(this.mStartDelay);
        }
        if (this.mDurationSet) {
            valueAnimator.setDuration(this.mDuration);
        }
        if (this.mInterpolatorSet) {
            valueAnimator.setInterpolator(this.mInterpolator);
        }
        valueAnimator.start();
    }

    public ViewPropertyAnimator alpha(float f) {
        this.animateProperty(2048, f);
        return this;
    }

    public ViewPropertyAnimator alphaBy(float f) {
        this.animatePropertyBy(2048, f);
        return this;
    }

    public void cancel() {
        if (this.mAnimatorMap.size() > 0) {
            Iterator iterator = ((HashMap)this.mAnimatorMap.clone()).keySet().iterator();
            while (iterator.hasNext()) {
                ((Animator)iterator.next()).cancel();
            }
        }
        this.mPendingAnimations.clear();
        this.mPendingSetupAction = null;
        this.mPendingCleanupAction = null;
        this.mPendingOnStartAction = null;
        this.mPendingOnEndAction = null;
        this.mView.removeCallbacks(this.mAnimationStarter);
        if (this.mRTBackend != null) {
            this.mRTBackend.cancelAll();
        }
    }

    public long getDuration() {
        if (this.mDurationSet) {
            return this.mDuration;
        }
        if (this.mTempValueAnimator == null) {
            this.mTempValueAnimator = new ValueAnimator();
        }
        return this.mTempValueAnimator.getDuration();
    }

    public TimeInterpolator getInterpolator() {
        if (this.mInterpolatorSet) {
            return this.mInterpolator;
        }
        if (this.mTempValueAnimator == null) {
            this.mTempValueAnimator = new ValueAnimator();
        }
        return this.mTempValueAnimator.getInterpolator();
    }

    Animator.AnimatorListener getListener() {
        return this.mListener;
    }

    public long getStartDelay() {
        if (this.mStartDelaySet) {
            return this.mStartDelay;
        }
        return 0L;
    }

    ValueAnimator.AnimatorUpdateListener getUpdateListener() {
        return this.mUpdateListener;
    }

    boolean hasActions() {
        return this.mPendingSetupAction != null || this.mPendingCleanupAction != null || this.mPendingOnStartAction != null || this.mPendingOnEndAction != null;
    }

    public ViewPropertyAnimator rotation(float f) {
        this.animateProperty(32, f);
        return this;
    }

    public ViewPropertyAnimator rotationBy(float f) {
        this.animatePropertyBy(32, f);
        return this;
    }

    public ViewPropertyAnimator rotationX(float f) {
        this.animateProperty(64, f);
        return this;
    }

    public ViewPropertyAnimator rotationXBy(float f) {
        this.animatePropertyBy(64, f);
        return this;
    }

    public ViewPropertyAnimator rotationY(float f) {
        this.animateProperty(128, f);
        return this;
    }

    public ViewPropertyAnimator rotationYBy(float f) {
        this.animatePropertyBy(128, f);
        return this;
    }

    public ViewPropertyAnimator scaleX(float f) {
        this.animateProperty(8, f);
        return this;
    }

    public ViewPropertyAnimator scaleXBy(float f) {
        this.animatePropertyBy(8, f);
        return this;
    }

    public ViewPropertyAnimator scaleY(float f) {
        this.animateProperty(16, f);
        return this;
    }

    public ViewPropertyAnimator scaleYBy(float f) {
        this.animatePropertyBy(16, f);
        return this;
    }

    public ViewPropertyAnimator setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + l);
        }
        this.mDurationSet = true;
        this.mDuration = l;
        return this;
    }

    public ViewPropertyAnimator setInterpolator(TimeInterpolator timeInterpolator) {
        this.mInterpolatorSet = true;
        this.mInterpolator = timeInterpolator;
        return this;
    }

    public ViewPropertyAnimator setListener(Animator.AnimatorListener animatorListener) {
        this.mListener = animatorListener;
        return this;
    }

    public ViewPropertyAnimator setStartDelay(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative start delay: " + l);
        }
        this.mStartDelaySet = true;
        this.mStartDelay = l;
        return this;
    }

    public ViewPropertyAnimator setUpdateListener(ValueAnimator.AnimatorUpdateListener animatorUpdateListener) {
        this.mUpdateListener = animatorUpdateListener;
        return this;
    }

    public void start() {
        this.mView.removeCallbacks(this.mAnimationStarter);
        this.startAnimation();
    }

    public ViewPropertyAnimator translationX(float f) {
        this.animateProperty(1, f);
        return this;
    }

    public ViewPropertyAnimator translationXBy(float f) {
        this.animatePropertyBy(1, f);
        return this;
    }

    public ViewPropertyAnimator translationY(float f) {
        this.animateProperty(2, f);
        return this;
    }

    public ViewPropertyAnimator translationYBy(float f) {
        this.animatePropertyBy(2, f);
        return this;
    }

    public ViewPropertyAnimator translationZ(float f) {
        this.animateProperty(4, f);
        return this;
    }

    public ViewPropertyAnimator translationZBy(float f) {
        this.animatePropertyBy(4, f);
        return this;
    }

    public ViewPropertyAnimator withEndAction(Runnable runnable) {
        this.mPendingOnEndAction = runnable;
        if (runnable != null && this.mAnimatorOnEndMap == null) {
            this.mAnimatorOnEndMap = new HashMap();
        }
        return this;
    }

    public ViewPropertyAnimator withLayer() {
        this.mPendingSetupAction = new Runnable(){

            @Override
            public void run() {
                ViewPropertyAnimator.this.mView.setLayerType(2, null);
                if (ViewPropertyAnimator.this.mView.isAttachedToWindow()) {
                    ViewPropertyAnimator.this.mView.buildLayer();
                }
            }
        };
        this.mPendingCleanupAction = new Runnable(this.mView.getLayerType()){
            final /* synthetic */ int val$currentLayerType;
            {
                this.val$currentLayerType = n;
            }

            @Override
            public void run() {
                ViewPropertyAnimator.this.mView.setLayerType(this.val$currentLayerType, null);
            }
        };
        if (this.mAnimatorSetupMap == null) {
            this.mAnimatorSetupMap = new HashMap();
        }
        if (this.mAnimatorCleanupMap == null) {
            this.mAnimatorCleanupMap = new HashMap();
        }
        return this;
    }

    public ViewPropertyAnimator withStartAction(Runnable runnable) {
        this.mPendingOnStartAction = runnable;
        if (runnable != null && this.mAnimatorOnStartMap == null) {
            this.mAnimatorOnStartMap = new HashMap();
        }
        return this;
    }

    public ViewPropertyAnimator x(float f) {
        this.animateProperty(256, f);
        return this;
    }

    public ViewPropertyAnimator xBy(float f) {
        this.animatePropertyBy(256, f);
        return this;
    }

    public ViewPropertyAnimator y(float f) {
        this.animateProperty(512, f);
        return this;
    }

    public ViewPropertyAnimator yBy(float f) {
        this.animatePropertyBy(512, f);
        return this;
    }

    public ViewPropertyAnimator z(float f) {
        this.animateProperty(1024, f);
        return this;
    }

    public ViewPropertyAnimator zBy(float f) {
        this.animatePropertyBy(1024, f);
        return this;
    }

    private class AnimatorEventListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private AnimatorEventListener() {
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationCancel(animator2);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnEndMap != null) {
                ViewPropertyAnimator.this.mAnimatorOnEndMap.remove(animator2);
            }
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            ViewPropertyAnimator.this.mView.setHasTransientState(false);
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationEnd(animator2);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnEndMap != null) {
                Runnable runnable = (Runnable)ViewPropertyAnimator.this.mAnimatorOnEndMap.get(animator2);
                if (runnable != null) {
                    runnable.run();
                }
                ViewPropertyAnimator.this.mAnimatorOnEndMap.remove(animator2);
            }
            if (ViewPropertyAnimator.this.mAnimatorCleanupMap != null) {
                Runnable runnable = (Runnable)ViewPropertyAnimator.this.mAnimatorCleanupMap.get(animator2);
                if (runnable != null) {
                    runnable.run();
                }
                ViewPropertyAnimator.this.mAnimatorCleanupMap.remove(animator2);
            }
            ViewPropertyAnimator.this.mAnimatorMap.remove(animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationRepeat(animator2);
            }
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            if (ViewPropertyAnimator.this.mAnimatorSetupMap != null) {
                Runnable runnable = (Runnable)ViewPropertyAnimator.this.mAnimatorSetupMap.get(animator2);
                if (runnable != null) {
                    runnable.run();
                }
                ViewPropertyAnimator.this.mAnimatorSetupMap.remove(animator2);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnStartMap != null) {
                Runnable runnable = (Runnable)ViewPropertyAnimator.this.mAnimatorOnStartMap.get(animator2);
                if (runnable != null) {
                    runnable.run();
                }
                ViewPropertyAnimator.this.mAnimatorOnStartMap.remove(animator2);
            }
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationStart(animator2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            block12: {
                block11: {
                    PropertyBundle propertyBundle = (PropertyBundle)ViewPropertyAnimator.this.mAnimatorMap.get(valueAnimator);
                    if (propertyBundle == null) break block11;
                    boolean bl = ViewPropertyAnimator.this.mView.isHardwareAccelerated();
                    if (!bl) {
                        ViewPropertyAnimator.this.mView.invalidateParentCaches();
                    }
                    float f = valueAnimator.getAnimatedFraction();
                    int n = propertyBundle.mPropertyMask;
                    if ((n & 0x7FF) != 0) {
                        ViewPropertyAnimator.this.mView.invalidateViewProperty(bl, false);
                    }
                    ArrayList<NameValuesHolder> arrayList = propertyBundle.mNameValuesHolder;
                    boolean bl2 = false;
                    if (arrayList != null) {
                        int n2 = arrayList.size();
                        for (int i = 0; i < n2; ++i) {
                            NameValuesHolder nameValuesHolder = arrayList.get(i);
                            float f2 = nameValuesHolder.mFromValue + f * nameValuesHolder.mDeltaValue;
                            if (nameValuesHolder.mNameConstant == 2048) {
                                bl2 = ViewPropertyAnimator.this.mView.setAlphaNoInvalidation(f2);
                                continue;
                            }
                            ViewPropertyAnimator.this.setValue(nameValuesHolder.mNameConstant, f2);
                        }
                    }
                    if ((n & 0x7FF) != 0 && !bl) {
                        View view = ViewPropertyAnimator.this.mView;
                        view.mPrivateFlags = 0x20 | view.mPrivateFlags;
                    }
                    if (bl2) {
                        ViewPropertyAnimator.this.mView.invalidate(true);
                    } else {
                        ViewPropertyAnimator.this.mView.invalidateViewProperty(false, false);
                    }
                    if (ViewPropertyAnimator.this.mUpdateListener != null) break block12;
                }
                return;
            }
            ViewPropertyAnimator.this.mUpdateListener.onAnimationUpdate(valueAnimator);
        }
    }

    static class NameValuesHolder {
        float mDeltaValue;
        float mFromValue;
        int mNameConstant;

        NameValuesHolder(int n, float f, float f2) {
            this.mNameConstant = n;
            this.mFromValue = f;
            this.mDeltaValue = f2;
        }
    }

    private static class PropertyBundle {
        ArrayList<NameValuesHolder> mNameValuesHolder;
        int mPropertyMask;

        PropertyBundle(int n, ArrayList<NameValuesHolder> arrayList) {
            this.mPropertyMask = n;
            this.mNameValuesHolder = arrayList;
        }

        boolean cancel(int n) {
            if ((n & this.mPropertyMask) != 0 && this.mNameValuesHolder != null) {
                int n2 = this.mNameValuesHolder.size();
                for (int i = 0; i < n2; ++i) {
                    if (this.mNameValuesHolder.get((int)i).mNameConstant != n) continue;
                    this.mNameValuesHolder.remove(i);
                    this.mPropertyMask &= ~n;
                    return true;
                }
            }
            return false;
        }
    }
}

